/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.DockToolWindowAction;
import com.intellij.openapi.wm.impl.InternalDecoratorImpl;
import com.intellij.openapi.wm.impl.ToolWindowEventSource;
import com.intellij.openapi.wm.impl.ToolWindowHeaderKt;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.layout.migLayout.MigLayoutUtilKt;
import com.intellij.ui.layout.migLayout.patched.MigLayout;
import com.intellij.ui.popup.PopupState;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.PanelUI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.LC;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002ABB%\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010 \u001a\u00020\u001fJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0014J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u0004\u0018\u00010\u001bJ\b\u0010+\u001a\u0004\u0018\u00010\u000bJ\b\u0010,\u001a\u0004\u0018\u00010\u000bJ\b\u0010-\u001a\u00020\u001fH$J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\"H\u0014J\u0010\u0010/\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\"H\u0014J\u0012\u00100\u001a\u00020\u001f2\b\u00101\u001a\u0004\u0018\u000102H\u0016J\b\u00103\u001a\u00020\u001fH\u0016J\u0014\u00104\u001a\u00020\u001f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020706J\u0019\u00108\u001a\u00020\u001f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020709\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020@H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u0013X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowHeader;", "Ljavax/swing/JPanel;", "Lcom/intellij/ide/ui/UISettingsListener;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Ljava/beans/PropertyChangeListener;", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "contentUi", "Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;", "gearProducer", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "(Lcom/intellij/openapi/wm/impl/ToolWindowImpl;Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;Ljava/util/function/Supplier;)V", "actionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "actionGroupWest", "activeImage", "Ljava/awt/image/BufferedImage;", "drawBottomLine", "", "Ljava/lang/Boolean;", "image", "imageType", "Lcom/intellij/openapi/wm/ToolWindowType;", "isActive", "()Z", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "toolbarWest", "westPanel", "addNotify", "", "clearCaches", "getComponentGraphics", "Ljava/awt/Graphics;", "g", "getData", "", "dataId", "", "getPreferredSize", "Ljava/awt/Dimension;", "getToolbar", "getToolbarActions", "getToolbarWestActions", "hideToolWindow", "paintChildren", "paintComponent", "propertyChange", "evt", "Ljava/beans/PropertyChangeEvent;", "removeNotify", "setAdditionalTitleActions", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "setTabActions", "", "([Lcom/intellij/openapi/actionSystem/AnAction;)V", "setUI", "ui", "Ljavax/swing/plaf/PanelUI;", "uiSettingsChanged", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "HideAction", "ShowOptionsAction", "intellij.platform.ide.impl"})
public abstract class ToolWindowHeader
extends JPanel
implements UISettingsListener,
DataProvider,
PropertyChangeListener {
    private BufferedImage image;
    private BufferedImage activeImage;
    private ToolWindowType imageType;
    private Boolean drawBottomLine;
    private final DefaultActionGroup actionGroup;
    private final DefaultActionGroup actionGroupWest;
    private final ActionToolbar toolbar;
    private ActionToolbar toolbarWest;
    private final JPanel westPanel;
    private final ToolWindowImpl toolWindow;
    private final ToolWindowContentUi contentUi;
    private final Supplier<ActionGroup> gearProducer;

    @Override
    public void propertyChange(@Nullable PropertyChangeEvent evt) {
        if (UIUtil.isClientPropertyTrue((Object)this.toolWindow.getComponent(), ToolWindowContentUi.ALLOW_DND_FOR_TABS)) {
            this.westPanel.add((Component)this.contentUi.getTabComponent(), new CC().grow().pushX());
        } else {
            this.westPanel.add((Component)this.contentUi.getTabComponent(), new CC().growY());
        }
        ActionToolbar toolbar = this.toolbarWest;
        if (toolbar != null) {
            this.westPanel.add((Component)toolbar.getComponent(), new CC().pushX());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.toolWindow.getComponent().addPropertyChangeListener(ToolWindowContentUi.ALLOW_DND_FOR_TABS.toString(), this);
        this.propertyChange(null);
    }

    @Override
    public void removeNotify() {
        this.toolWindow.getComponent().removePropertyChangeListener(ToolWindowContentUi.ALLOW_DND_FOR_TABS.toString(), this);
        super.removeNotify();
    }

    @Nullable
    public final ActionToolbar getToolbar() {
        return this.toolbar;
    }

    @Nullable
    public final ActionGroup getToolbarActions() {
        return (ActionGroup)this.actionGroup;
    }

    @Nullable
    public final ActionGroup getToolbarWestActions() {
        return (ActionGroup)this.actionGroupWest;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (MorePopupAware.KEY.is(dataId)) {
            return this.contentUi.getData(dataId);
        }
        return null;
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        Intrinsics.checkNotNullParameter((Object)uiSettings, (String)"uiSettings");
        this.clearCaches();
    }

    public final void setTabActions(@NotNull AnAction[] actions2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)actions2, (String)"actions");
            if (this.toolbarWest == null) {
                ActionToolbar actionToolbar = this.toolbarWest = ActionManager.getInstance().createActionToolbar("ToolwindowTitle", (ActionGroup)new DefaultActionGroup(new AnAction[]{(AnAction)this.actionGroupWest}), true);
                if (actionToolbar == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.impl.ActionToolbarImpl");
                }
                ActionToolbarImpl actionToolbarImpl = (ActionToolbarImpl)actionToolbar;
                boolean bl = false;
                boolean bl2 = false;
                ActionToolbarImpl $this$with = actionToolbarImpl;
                boolean bl3 = false;
                $this$with.setTargetComponent($this$with);
                $this$with.setForceMinimumSize(true);
                $this$with.setLayoutPolicy(0);
                $this$with.setReservePlaceAutoPopupIcon(false);
                $this$with.setOpaque(false);
                $this$with.setBorder((Border)JBUI.Borders.empty());
                this.westPanel.add((Component)$this$with, new CC().pushX());
            }
            this.actionGroupWest.removeAll();
            this.actionGroupWest.addSeparator();
            this.actionGroupWest.addAll(Arrays.copyOf(actions2, actions2.length));
            ActionToolbar actionToolbar = this.toolbarWest;
            if (actionToolbar == null) break block2;
            actionToolbar.updateActionsImmediately();
        }
    }

    public final void setAdditionalTitleActions(@NotNull List<? extends AnAction> actions2) {
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        this.actionGroup.removeAll();
        this.actionGroup.addAll((Collection)actions2);
        Collection collection = actions2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.actionGroup.addSeparator();
        }
        this.toolbar.updateActionsImmediately();
    }

    @Override
    @NotNull
    protected Graphics getComponentGraphics(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D graphics2D = JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(g));
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"JBSwingUtilities.runGlob\u2026.getComponentGraphics(g))");
        return graphics2D;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle r = this.getBounds();
        Graphics2D g2d = (Graphics2D)g;
        Shape clip = g2d.getClip();
        ToolWindowType type = this.toolWindow.getType();
        Image image = null;
        InternalDecoratorImpl nearestDecorator = InternalDecoratorImpl.findNearestDecorator(this);
        boolean drawTopLine = type != ToolWindowType.FLOATING && !UIUtil.isClientPropertyTrue((Object)nearestDecorator, InternalDecoratorImpl.INACTIVE_LOOK);
        boolean drawBottomLine = true;
        if (ExperimentalUI.isNewUI()) {
            boolean bl = drawBottomLine = Intrinsics.areEqual((Object)this.toolWindow.getLargeStripeAnchor(), (Object)ToolWindowAnchor.BOTTOM) || Intrinsics.areEqual((Object)this.toolWindow.getWindowInfo().getContentUiType(), (Object)ToolWindowContentUiType.TABBED) && this.toolWindow.getContentManager().getContentCount() > 1 || ToggleToolbarAction.hasVisibleToolwindowToolbars(this.toolWindow);
            if (Intrinsics.areEqual((Object)this.drawBottomLine, (Object)drawBottomLine) ^ true) {
                this.activeImage = ToolWindowHeaderKt.access$drawToBuffer(g2d, true, r.height, drawTopLine, drawBottomLine);
                this.image = ToolWindowHeaderKt.access$drawToBuffer(g2d, false, r.height, drawTopLine, drawBottomLine);
                this.drawBottomLine = drawBottomLine;
            }
        }
        if (this.isActive()) {
            if (this.activeImage == null || type != this.imageType) {
                this.activeImage = ToolWindowHeaderKt.access$drawToBuffer(g2d, true, r.height, drawTopLine, drawBottomLine);
            }
            image = this.activeImage;
        } else {
            if (this.image == null || type != this.imageType) {
                this.image = ToolWindowHeaderKt.access$drawToBuffer(g2d, false, r.height, drawTopLine, drawBottomLine);
            }
            image = this.image;
        }
        this.imageType = type;
        Shape shape = clip;
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"clip");
        Rectangle clipBounds = shape.getBounds();
        for (int x = clipBounds.x; x < clipBounds.x + clipBounds.width; x += 150) {
            Image image2 = image;
            Intrinsics.checkNotNull((Object)image2);
            StartupUiUtil.drawImage((Graphics)g, (Image)image2, (int)x, (int)0, null);
        }
    }

    @Override
    public void setUI(@NotNull PanelUI ui2) {
        Intrinsics.checkNotNullParameter((Object)ui2, (String)"ui");
        this.clearCaches();
        super.setUI(ui2);
    }

    public final void clearCaches() {
        this.image = null;
        this.activeImage = null;
    }

    @Override
    protected void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D graphics2 = (Graphics2D)graphics;
        UISettings.Companion.setupAntialiasing((Graphics)graphics2);
        super.paintChildren(graphics2);
        Rectangle r = this.getBounds();
        if (!this.isActive() && !StartupUiUtil.isUnderDarcula()) {
            graphics2.setColor(new Color(255, 255, 255, 30));
            graphics2.fill(r);
        }
        graphics2.dispose();
    }

    protected abstract boolean isActive();

    protected abstract void hideToolWindow();

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Insets insets = this.getInsets();
        int height = JBUI.scale((int)28) - insets.top - insets.bottom;
        return new Dimension(size.width, height);
    }

    public ToolWindowHeader(@NotNull ToolWindowImpl toolWindow2, @NotNull ToolWindowContentUi contentUi, @NotNull Supplier<ActionGroup> gearProducer) {
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)contentUi, (String)"contentUi");
        Intrinsics.checkNotNullParameter(gearProducer, (String)"gearProducer");
        LC lC = MigLayoutUtilKt.createLayoutConstraints(0, 0).noVisualPadding().fill();
        Intrinsics.checkNotNullExpressionValue((Object)lC, (String)"createLayoutConstraints(\u2026.noVisualPadding().fill()");
        AC aC = ConstraintParser.parseColumnConstraints((String)"[grow][pref!]");
        Intrinsics.checkNotNullExpressionValue((Object)aC, (String)"ConstraintParser.parseCo\u2026straints(\"[grow][pref!]\")");
        super(new MigLayout(lC, aC, null, 4, null));
        this.toolWindow = toolWindow2;
        this.contentUi = contentUi;
        this.gearProducer = gearProducer;
        this.actionGroup = new DefaultActionGroup();
        this.actionGroupWest = new DefaultActionGroup();
        AccessibleContextUtil.setName((Component)this, (String)IdeBundle.message((String)"toolwindow.header.accessible.name", (Object[])new Object[0]));
        LC lC2 = MigLayoutUtilKt.createLayoutConstraints(0, 0).noVisualPadding().fillY();
        Intrinsics.checkNotNullExpressionValue((Object)lC2, (String)"createLayoutConstraints(\u2026noVisualPadding().fillY()");
        this.westPanel = new JPanel(new MigLayout(lC2, null, null, 6, null));
        this.westPanel.setOpaque(false);
        this.westPanel.add((Component)this.contentUi.getTabComponent(), new CC().growY());
        MouseDragHelper.setComponentDraggable((JComponent)this.westPanel, (boolean)true);
        this.add((Component)this.westPanel, new CC().grow());
        ToolWindowContentUi.initMouseListeners(this.westPanel, this.contentUi, true, true);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ToolwindowTitle", (ActionGroup)new DumbAware(){
            private final Lazy children$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AnAction[]>(this){
                final /* synthetic */ 1 this$0;

                @NotNull
                public final AnAction[] invoke() {
                    AnAction tabListAction = ActionManager.getInstance().getAction("TabList");
                    AnAction[] anActionArray = new AnAction[5];
                    AnAction anAction2 = tabListAction;
                    Intrinsics.checkNotNullExpressionValue((Object)anAction2, (String)"tabListAction");
                    anActionArray[0] = anAction2;
                    anActionArray[1] = (AnAction)ToolWindowHeader.access$getActionGroup$p(this.this$0.this);
                    anActionArray[2] = (AnAction)new DockToolWindowAction();
                    anActionArray[3] = (AnAction)new ShowOptionsAction();
                    anActionArray[4] = (AnAction)new HideAction();
                    return anActionArray;
                }
                {
                    this.this$0 = var1_1;
                    super(0);
                }
            }));

            private final AnAction[] getChildren() {
                Lazy lazy = this.children$delegate;
                1 var2_2 = this;
                Object var3_3 = null;
                boolean bl = false;
                return (AnAction[])lazy.getValue();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AnActionEvent anActionEvent = e;
                InternalDecoratorImpl nearestDecorator = InternalDecoratorImpl.findNearestDecorator(anActionEvent != null ? (Component)anActionEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT) : null);
                Boolean b = (Boolean)UIUtil.getClientProperty((Object)nearestDecorator, InternalDecoratorImpl.HIDE_COMMON_TOOLWINDOW_BUTTONS);
                if (Intrinsics.areEqual((Object)b, (Object)true)) {
                    void $this$toTypedArray$iv;
                    void $this$filterTo$iv$iv;
                    Object $this$filter$iv = this.getChildren();
                    boolean $i$f$filter = false;
                    AnAction[] anActionArray = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    void var9_9 = $this$filterTo$iv$iv;
                    int n = ((void)var9_9).length;
                    for (int j = 0; j < n; ++j) {
                        void element$iv$iv;
                        void it = element$iv$iv = var9_9[j];
                        boolean bl = false;
                        if (!(!(it instanceof DockToolWindowAction) && !(it instanceof ShowOptionsAction) && !(it instanceof HideAction))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    AnAction[] anActionArray2 = thisCollection$iv.toArray(new AnAction[0]);
                    if (anActionArray2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    return anActionArray2;
                }
                return this.getChildren();
            }

            public boolean isDumbAware() {
                return true;
            }
        }, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026      },\n      true\n    )");
        this.toolbar = actionToolbar;
        this.toolbar.setTargetComponent((JComponent)this);
        this.toolbar.setLayoutPolicy(0);
        this.toolbar.setReservePlaceAutoPopupIcon(false);
        JComponent jComponent = this.toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"toolbar.component");
        JComponent component2 = jComponent;
        component2.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        component2.setOpaque(false);
        this.add(component2);
        this.westPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                toolWindow.fireActivated(ToolWindowEventSource.ToolWindowHeader);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.isPopupTrigger()) {
                    return;
                }
                if (UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                    if (e.isAltDown()) {
                        toolWindow.fireHidden(ToolWindowEventSource.ToolWindowHeaderAltClick);
                    } else {
                        toolWindow.fireHiddenSide(ToolWindowEventSource.ToolWindowHeader);
                    }
                } else {
                    toolWindow.fireActivated(ToolWindowEventSource.ToolWindowHeader);
                }
            }
        });
        this.setOpaque(true);
        this.setBorder(JBUI.Borders.empty((int)0));
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ToolWindowManagerImpl manager2 = toolWindow.getToolWindowManager();
                manager2.setMaximized(toolWindow, !manager2.isMaximized(toolWindow));
                return true;
            }
        }.installOn((Component)this.westPanel);
        this.westPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Runnable runnable2 = new Runnable(this, e){
                    final /* synthetic */ 5 this$0;
                    final /* synthetic */ MouseEvent $e;

                    public final void run() {
                        this.this$0.this.dispatchEvent(SwingUtilities.convertMouseEvent(this.$e.getComponent(), this.$e, this.this$0.this));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$e = mouseEvent;
                    }
                };
                SwingUtilities.invokeLater(runnable2);
            }
        });
    }

    public static final /* synthetic */ DefaultActionGroup access$getActionGroup$p(ToolWindowHeader $this) {
        return $this.actionGroup;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowHeader$ShowOptionsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/openapi/wm/impl/ToolWindowHeader;)V", "myPopupState", "Lcom/intellij/ui/popup/PopupState;", "Ljavax/swing/JPopupMenu;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getMyPopupState", "()Lcom/intellij/ui/popup/PopupState;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.ide.impl"})
    private final class ShowOptionsAction
    extends DumbAwareAction {
        @NotNull
        private final PopupState<JPopupMenu> myPopupState;

        @NotNull
        public final PopupState<JPopupMenu> getMyPopupState() {
            return this.myPopupState;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            InputEvent inputEvent = e.getInputEvent();
            ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", (ActionGroup)ToolWindowHeader.this.gearProducer.get());
            Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"ActionManager.getInstanc\u2026OPUP, gearProducer.get())");
            ActionPopupMenu popupMenu = actionPopupMenu;
            int x = 0;
            int y = 0;
            if (inputEvent instanceof MouseEvent) {
                x = ((MouseEvent)inputEvent).getX();
                y = ((MouseEvent)inputEvent).getY();
            }
            this.myPopupState.prepareToShow((Object)popupMenu.getComponent());
            JPopupMenu jPopupMenu = popupMenu.getComponent();
            InputEvent inputEvent2 = inputEvent;
            Intrinsics.checkNotNullExpressionValue((Object)inputEvent2, (String)"inputEvent");
            jPopupMenu.show(inputEvent2.getComponent(), x, y);
        }

        public ShowOptionsAction() {
            PopupState popupState = PopupState.forPopupMenu();
            Intrinsics.checkNotNullExpressionValue((Object)popupState, (String)"PopupState.forPopupMenu()");
            this.myPopupState = popupState;
            this.copyFrom((AnAction)ToolWindowHeader.this.gearProducer.get());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowHeader$HideAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/openapi/wm/impl/ToolWindowHeader;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "event", "intellij.platform.ide.impl"})
    private final class HideAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ToolWindowHeader.this.hideToolWindow();
        }

        public void update(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Presentation presentation2 = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"event.presentation");
            presentation2.setEnabled(ToolWindowHeader.this.toolWindow.isVisible());
        }

        public HideAction() {
            ActionUtil.copyFrom((AnAction)((AnAction)this), (String)"HideActiveWindow");
            Presentation presentation2 = this.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
            presentation2.setIcon(AllIcons.General.HideToolWindow);
            this.getTemplatePresentation().setText((Supplier)1.INSTANCE);
        }
    }
}

