/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.InternalDecoratorImpl;
import com.intellij.openapi.wm.impl.ToolWindowDragHelper;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00016B\u001f\u0012\u000b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0002\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0015H\u0014J\b\u0010\"\u001a\u00020\u001aH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020\u001eH\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J \u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u0015H\u0014J\u0018\u0010/\u001a\u00020(2\u0006\u0010,\u001a\u00020*2\u0006\u00100\u001a\u00020\u001aH\u0014J\u0010\u00101\u001a\u00020(2\u0006\u0010,\u001a\u00020*H\u0014J\u0010\u00102\u001a\u00020(2\u0006\u0010,\u001a\u00020*H\u0002J\b\u00103\u001a\u00020(H\u0002J\b\u00104\u001a\u00020(H\u0016J\u0006\u00105\u001a\u00020(J\n\u0010%\u001a\u00020\u000b*\u00020\u0010R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0002\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00067"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowInnerDragHelper;", "Lcom/intellij/ui/MouseDragHelper;", "Lcom/intellij/openapi/wm/impl/ToolWindowsPane;", "parent", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "pane", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/wm/impl/ToolWindowsPane;)V", "myCurrentDecorator", "Lcom/intellij/openapi/wm/impl/InternalDecoratorImpl;", "myCurrentDropIndex", "", "myCurrentDropSide", "myDialog", "Lcom/intellij/openapi/wm/impl/ToolWindowInnerDragHelper$MyDialog;", "myDraggingTab", "Lcom/intellij/openapi/wm/impl/content/ContentTabLabel;", "myHighlighter", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "myInitialIndex", "myInitialOffset", "Ljava/awt/Point;", "mySourceDecorator", "getPane", "()Lcom/intellij/openapi/wm/impl/ToolWindowsPane;", "canFinishDragging", "", "component", "Ljavax/swing/JComponent;", "point", "Lcom/intellij/ui/awt/RelativePoint;", "canStartDragging", "dragComponent", "dragComponentPoint", "cancelDragging", "getDecorator", "relativePoint", "getIndex", "getTab", "mouseReleased", "", "e", "Ljava/awt/event/MouseEvent;", "processDrag", "event", "dragToScreenPoint", "startScreenPoint", "processDragFinish", "willDragOutStart", "processMousePressed", "relocate", "startDrag", "stop", "stopDrag", "MyDialog", "intellij.platform.ide.impl"})
public final class ToolWindowInnerDragHelper
extends MouseDragHelper<ToolWindowsPane> {
    private InternalDecoratorImpl mySourceDecorator;
    private int myInitialIndex;
    private InternalDecoratorImpl myCurrentDecorator;
    private ContentTabLabel myDraggingTab;
    private MyDialog myDialog;
    private int myCurrentDropSide;
    private int myCurrentDropIndex;
    private final NonOpaquePanel myHighlighter;
    private final Point myInitialOffset;
    @NotNull
    private final ToolWindowsPane pane;

    protected boolean canStartDragging(@NotNull JComponent dragComponent, @NotNull Point dragComponentPoint) {
        Intrinsics.checkNotNullParameter((Object)dragComponent, (String)"dragComponent");
        Intrinsics.checkNotNullParameter((Object)dragComponentPoint, (String)"dragComponentPoint");
        return this.getTab(new RelativePoint((Component)dragComponent, dragComponentPoint)) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final ContentTabLabel getTab(@NotNull RelativePoint point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Point point2 = point.getPoint((Component)((Object)this.pane));
        boolean bl = false;
        boolean bl2 = false;
        Point $this$with = point2;
        boolean bl3 = false;
        Component child2 = SwingUtilities.getDeepestComponentAt((Component)((Object)this.pane), $this$with.x, $this$with.y);
        InternalDecoratorImpl decorator = InternalDecoratorImpl.findTopLevelDecorator(child2);
        if (decorator == null) return null;
        ToolWindowImpl toolWindowImpl = decorator.getToolWindow();
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowImpl, (String)"decorator.toolWindow");
        if (!UIUtil.isClientPropertyTrue((Object)toolWindowImpl.getComponent(), ToolWindowContentUi.ALLOW_DND_FOR_TABS)) return null;
        if (!(child2 instanceof ContentTabLabel)) return null;
        if (!(((ContentTabLabel)child2).getParent() instanceof ToolWindowContentUi.TabPanel)) return null;
        ContentTabLabel contentTabLabel = (ContentTabLabel)child2;
        return contentTabLabel;
    }

    protected boolean canFinishDragging(@NotNull JComponent component2, @NotNull RelativePoint point) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (this.myCurrentDecorator == null) {
            return false;
        }
        InternalDecoratorImpl internalDecoratorImpl = this.myCurrentDecorator;
        Intrinsics.checkNotNull((Object)internalDecoratorImpl);
        return internalDecoratorImpl.contains(point.getPoint((Component)this.myCurrentDecorator));
    }

    protected void processMousePressed(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RelativePoint relativePoint = new RelativePoint(event);
        ContentTabLabel contentTabLabel = this.getTab(relativePoint);
        if (contentTabLabel == null) {
            this.mySourceDecorator = null;
            this.myDraggingTab = null;
            return;
        }
        this.myInitialOffset.setLocation(relativePoint.getPoint((Component)contentTabLabel));
        this.myDraggingTab = contentTabLabel;
        this.mySourceDecorator = InternalDecoratorImpl.findNearestDecorator(contentTabLabel);
        this.myInitialIndex = this.getIndex(contentTabLabel);
        this.myCurrentDecorator = this.mySourceDecorator;
        this.myDialog = new MyDialog((JComponent)((Object)this.pane), this, ToolWindowDragHelper.Companion.createDragImage(contentTabLabel, -1));
    }

    public final int getIndex(@NotNull ContentTabLabel $this$getIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getIndex, (String)"$this$getIndex");
        Content content2 = $this$getIndex.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"content");
        ContentManager contentManager2 = content2.getManager();
        Intrinsics.checkNotNull((Object)contentManager2);
        return contentManager2.getIndexOfContent($this$getIndex.getContent());
    }

    private final int getIndex(RelativePoint point) {
        int i2;
        Component child2;
        Point p = point.getPoint((Component)((Object)this.pane));
        Component componentBelowCursor = SwingUtilities.getDeepestComponentAt((Component)((Object)this.pane), p.x, p.y);
        ToolWindowContentUi.TabPanel tabPanel = (ToolWindowContentUi.TabPanel)((Object)ComponentUtil.getParentOfType(ToolWindowContentUi.TabPanel.class, (Component)componentBelowCursor));
        if (tabPanel == null) {
            return -1;
        }
        p = point.getPoint((Component)((Object)tabPanel));
        int placeholderIndex = -1;
        int n = 0;
        int n2 = tabPanel.getComponentCount() - 1;
        if (n <= n2) {
            while (true) {
                if ((child2 = tabPanel.getComponents()[i2]) instanceof JLabel && !(child2 instanceof BaseLabel)) {
                    placeholderIndex = i2;
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
        if ((i2 = 0) <= (n2 = tabPanel.getComponentCount() - 1)) {
            while (true) {
                if (!((child2 = tabPanel.getComponents()[i2]) instanceof BaseLabel) || child2 instanceof ContentTabLabel) {
                    Component component2 = child2;
                    Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"child");
                    Rectangle childBounds = component2.getBounds();
                    if (placeholderIndex != -1 && i2 < placeholderIndex) {
                        double d = p.x;
                        Rectangle rectangle = childBounds;
                        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"childBounds");
                        if (d < rectangle.getMinX()) {
                            return RangesKt.coerceAtLeast((int)i2, (int)1);
                        }
                    }
                    if (placeholderIndex != -1 && i2 > placeholderIndex) {
                        double d = p.x;
                        Rectangle rectangle = childBounds;
                        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"childBounds");
                        if (d > rectangle.getMaxX()) {
                            return RangesKt.coerceAtMost((int)(i2 + 1), (int)(tabPanel.getComponentCount() - 1));
                        }
                        return placeholderIndex;
                    }
                    if (childBounds.contains(p)) {
                        return i2;
                    }
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
        return tabPanel.getComponentCount() - 1;
    }

    public void mouseReleased(@Nullable MouseEvent e) {
        super.mouseReleased(e);
        this.stopDrag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDragFinish(@NotNull MouseEvent event, boolean willDragOutStart) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.mySourceDecorator == null || this.myCurrentDecorator == null) {
            return;
        }
        ContentTabLabel contentTabLabel = this.myDraggingTab;
        Intrinsics.checkNotNull((Object)contentTabLabel);
        Content content2 = contentTabLabel.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"myDraggingTab!!.content");
        Content content3 = content2;
        if (Intrinsics.areEqual((Object)this.mySourceDecorator, (Object)this.myCurrentDecorator)) {
            InternalDecoratorImpl internalDecoratorImpl = this.mySourceDecorator;
            Intrinsics.checkNotNull((Object)internalDecoratorImpl);
            ContentManager contentManager2 = internalDecoratorImpl.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"mySourceDecorator!!.contentManager");
            if (contentManager2.getContentCount() > 0) {
                InternalDecoratorImpl internalDecoratorImpl2 = this.mySourceDecorator;
                Intrinsics.checkNotNull((Object)internalDecoratorImpl2);
                internalDecoratorImpl2.splitWithContent(content3, this.myCurrentDropSide, this.myCurrentDropIndex - 1);
            } else {
                InternalDecoratorImpl internalDecoratorImpl3 = this.mySourceDecorator;
                Intrinsics.checkNotNull((Object)internalDecoratorImpl3);
                ContentManager contentManager3 = internalDecoratorImpl3.getContentManager();
                ContentTabLabel contentTabLabel2 = this.myDraggingTab;
                Intrinsics.checkNotNull((Object)contentTabLabel2);
                contentManager3.addContent(contentTabLabel2.getContent());
            }
            return;
        }
        content3.putUserData(Content.TEMPORARY_REMOVED_KEY, (Object)true);
        try {
            InternalDecoratorImpl internalDecoratorImpl = this.myCurrentDecorator;
            Intrinsics.checkNotNull((Object)internalDecoratorImpl);
            internalDecoratorImpl.splitWithContent(content3, this.myCurrentDropSide, this.myCurrentDropIndex - 1);
        }
        finally {
            content3.putUserData(Content.TEMPORARY_REMOVED_KEY, null);
        }
        InternalDecoratorImpl internalDecoratorImpl = this.mySourceDecorator;
        Intrinsics.checkNotNull((Object)internalDecoratorImpl);
        ContentManager contentManager4 = internalDecoratorImpl.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager4, (String)"mySourceDecorator!!.contentManager");
        if (contentManager4.isEmpty()) {
            InternalDecoratorImpl internalDecoratorImpl4 = this.mySourceDecorator;
            Intrinsics.checkNotNull((Object)internalDecoratorImpl4);
            internalDecoratorImpl4.unsplit(null);
        }
    }

    public boolean cancelDragging() {
        if (super.cancelDragging()) {
            ContentTabLabel contentTabLabel = this.myDraggingTab;
            Intrinsics.checkNotNull((Object)contentTabLabel);
            Content content2 = contentTabLabel.getContent();
            if (content2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.content.impl.ContentImpl");
            }
            ContentImpl contentImpl = (ContentImpl)content2;
            boolean bl = false;
            boolean bl2 = false;
            ContentImpl $this$with = contentImpl;
            boolean bl3 = false;
            InternalDecoratorImpl internalDecoratorImpl = this.mySourceDecorator;
            Intrinsics.checkNotNull((Object)internalDecoratorImpl);
            ContentManager contentManager2 = internalDecoratorImpl.getContentManager();
            Content content3 = $this$with;
            ContentManager contentManager3 = contentManager2;
            Intrinsics.checkNotNullExpressionValue((Object)contentManager3, (String)"contentManager");
            contentManager2.addContent(content3, RangesKt.coerceAtMost((int)this.myInitialIndex, (int)contentManager3.getContentCount()));
            $this$with.putUserData(Content.TEMPORARY_REMOVED_KEY, null);
            this.stopDrag();
            return true;
        }
        return false;
    }

    public void stop() {
        super.stop();
        this.stopDrag();
    }

    protected void processDrag(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
        Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
        if (this.isDragJustStarted()) {
            this.startDrag();
        } else {
            this.relocate(event);
        }
    }

    public final void stopDrag() {
        if (this.myDraggingTab == null) {
            return;
        }
        ContentTabLabel contentTabLabel = this.myDraggingTab;
        Intrinsics.checkNotNull((Object)contentTabLabel);
        Content content2 = contentTabLabel.getContent();
        if (content2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.content.impl.ContentImpl");
        }
        ((ContentImpl)content2).putUserData(Content.TEMPORARY_REMOVED_KEY, null);
        InternalDecoratorImpl internalDecoratorImpl = this.mySourceDecorator;
        if (internalDecoratorImpl != null) {
            internalDecoratorImpl.setSplitUnsplitInProgress(false);
        }
        this.mySourceDecorator = null;
        this.myDraggingTab = null;
        InternalDecoratorImpl internalDecoratorImpl2 = this.myCurrentDecorator;
        if (internalDecoratorImpl2 != null) {
            internalDecoratorImpl2.setDropInfoIndex(-1, 0);
        }
        this.myCurrentDecorator = null;
        Container parent = this.myHighlighter.getParent();
        if (parent instanceof JComponent) {
            parent.remove((Component)this.myHighlighter);
            parent.revalidate();
            parent.repaint();
        }
        MyDialog myDialog = this.myDialog;
        if (myDialog != null) {
            myDialog.dispose();
        }
        this.myDialog = null;
    }

    private final void startDrag() {
        Object $this$with;
        boolean bl;
        boolean bl2;
        Object object;
        block7: {
            block6: {
                InternalDecoratorImpl internalDecoratorImpl;
                if (this.mySourceDecorator == null || (internalDecoratorImpl = this.mySourceDecorator) != null && (internalDecoratorImpl = internalDecoratorImpl.getContentManager()) != null && internalDecoratorImpl.getContentCount() == 0) break block6;
                if (this.myDialog != null) break block7;
            }
            return;
        }
        ContentTabLabel contentTabLabel = this.myDraggingTab;
        Intrinsics.checkNotNull((Object)contentTabLabel);
        Content content2 = contentTabLabel.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"myDraggingTab!!.content");
        ContentManager manager2 = content2.getManager();
        if (manager2 != null) {
            ContentTabLabel contentTabLabel2 = this.myDraggingTab;
            Intrinsics.checkNotNull((Object)contentTabLabel2);
            Content content3 = contentTabLabel2.getContent();
            if (content3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.content.impl.ContentImpl");
            }
            object = (ContentImpl)content3;
            bl2 = false;
            bl = false;
            $this$with = object;
            boolean bl3 = false;
            $this$with.putUserData(Content.TEMPORARY_REMOVED_KEY, (Object)true);
            int index2 = manager2.getIndexOfContent((Content)$this$with) + 1;
            SwingUtilities.invokeLater(new Runnable((ContentImpl)((Object)$this$with), index2, this, manager2){
                final /* synthetic */ ContentImpl $this_with;
                final /* synthetic */ int $index;
                final /* synthetic */ ToolWindowInnerDragHelper this$0;
                final /* synthetic */ ContentManager $manager$inlined;
                {
                    this.$this_with = contentImpl;
                    this.$index = n;
                    this.this$0 = toolWindowInnerDragHelper;
                    this.$manager$inlined = contentManager2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    try {
                        InternalDecoratorImpl internalDecoratorImpl = ToolWindowInnerDragHelper.access$getMySourceDecorator$p(this.this$0);
                        Intrinsics.checkNotNull((Object)internalDecoratorImpl);
                        internalDecoratorImpl.setSplitUnsplitInProgress(true);
                        this.$manager$inlined.removeContent((Content)this.$this_with, false);
                        InternalDecoratorImpl internalDecoratorImpl2 = ToolWindowInnerDragHelper.access$getMySourceDecorator$p(this.this$0);
                        Intrinsics.checkNotNull((Object)internalDecoratorImpl2);
                        ContentTabLabel contentTabLabel = ToolWindowInnerDragHelper.access$getMyDraggingTab$p(this.this$0);
                        Intrinsics.checkNotNull((Object)contentTabLabel);
                        internalDecoratorImpl2.setDropInfoIndex(this.$index, contentTabLabel.getWidth());
                    }
                    finally {
                        InternalDecoratorImpl internalDecoratorImpl = ToolWindowInnerDragHelper.access$getMySourceDecorator$p(this.this$0);
                        Intrinsics.checkNotNull((Object)internalDecoratorImpl);
                        internalDecoratorImpl.setSplitUnsplitInProgress(false);
                    }
                }
            });
        }
        IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)((Component)((Object)this.pane)));
        if (ideGlassPane == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
        }
        object = (JComponent)ideGlassPane;
        bl2 = false;
        bl = false;
        $this$with = object;
        boolean bl4 = false;
        ((Container)$this$with).add((Component)this.myHighlighter);
        ((JComponent)$this$with).revalidate();
        ((Component)$this$with).repaint();
    }

    private final void relocate(MouseEvent event) {
        RelativePoint relativePoint = new RelativePoint(event);
        InternalDecoratorImpl tmp = this.getDecorator(relativePoint);
        if (Intrinsics.areEqual((Object)this.myCurrentDecorator, (Object)tmp) ^ true) {
            InternalDecoratorImpl internalDecoratorImpl = this.myCurrentDecorator;
            if (internalDecoratorImpl != null) {
                internalDecoratorImpl.setDropInfoIndex(-1, 0);
            }
        }
        this.myCurrentDecorator = tmp;
        Point screenPoint = event.getLocationOnScreen();
        MyDialog myDialog = this.myDialog;
        Intrinsics.checkNotNull((Object)myDialog);
        myDialog.setLocation(screenPoint.x - this.myInitialOffset.x, screenPoint.y - this.myInitialOffset.y);
        MyDialog myDialog2 = this.myDialog;
        if (myDialog2 != null) {
            myDialog2.setVisible(true);
        }
        if (this.myCurrentDecorator != null) {
            this.myCurrentDropSide = TabsUtil.getDropSideFor((Point)relativePoint.getPoint((Component)this.myCurrentDecorator), (JComponent)this.myCurrentDecorator);
            InternalDecoratorImpl internalDecoratorImpl = this.myCurrentDecorator;
            Intrinsics.checkNotNull((Object)internalDecoratorImpl);
            Rectangle dropArea = new Rectangle(internalDecoratorImpl.getSize());
            TabsUtil.updateBoundsWithDropSide((Rectangle)dropArea, (int)this.myCurrentDropSide);
            InternalDecoratorImpl internalDecoratorImpl2 = this.myCurrentDecorator;
            Intrinsics.checkNotNull((Object)internalDecoratorImpl2);
            Component component2 = internalDecoratorImpl2;
            JRootPane jRootPane = this.pane.getRootPane();
            Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"pane.rootPane");
            dropArea.setBounds(SwingUtilities.convertRectangle(component2, dropArea, jRootPane.getGlassPane()));
            this.myCurrentDropIndex = this.getIndex(relativePoint);
            if (this.myCurrentDropIndex != -1) {
                InternalDecoratorImpl internalDecoratorImpl3 = this.myCurrentDecorator;
                Intrinsics.checkNotNull((Object)internalDecoratorImpl3);
                MyDialog myDialog3 = this.myDialog;
                Intrinsics.checkNotNull((Object)myDialog3);
                internalDecoratorImpl3.setDropInfoIndex(this.myCurrentDropIndex, myDialog3.getWidth());
                this.myHighlighter.setBounds(new Rectangle());
            } else {
                InternalDecoratorImpl internalDecoratorImpl4 = this.myCurrentDecorator;
                if (internalDecoratorImpl4 != null) {
                    internalDecoratorImpl4.setDropInfoIndex(-1, 0);
                }
                this.myHighlighter.setBounds(dropArea);
            }
        } else {
            this.myCurrentDropIndex = -1;
            this.myHighlighter.setBounds(new Rectangle());
        }
    }

    private final InternalDecoratorImpl getDecorator(RelativePoint relativePoint) {
        JRootPane rootPane = this.pane.getRootPane();
        if (rootPane instanceof IdeRootPane) {
            Point point = relativePoint.getPoint((Component)((Object)((IdeRootPane)rootPane).getToolWindowPane()));
            Component component2 = SwingUtilities.getDeepestComponentAt((Component)((Object)((IdeRootPane)rootPane).getToolWindowPane()), point.x, point.y);
            return InternalDecoratorImpl.findNearestDecorator(component2);
        }
        return null;
    }

    @NotNull
    public final ToolWindowsPane getPane() {
        return this.pane;
    }

    public ToolWindowInnerDragHelper(@NotNull Disposable parent, @NotNull ToolWindowsPane pane2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)pane2), (String)"pane");
        super(parent, (JComponent)((Object)pane2));
        this.pane = pane2;
        this.mySourceDecorator = null;
        this.myInitialIndex = -1;
        this.myCurrentDecorator = null;
        this.myDraggingTab = null;
        this.myDialog = null;
        this.myCurrentDropSide = -1;
        this.myCurrentDropIndex = -1;
        this.myHighlighter = ToolWindowDragHelper.Companion.createHighlighterComponent();
        this.myInitialOffset = new Point();
    }

    public static final /* synthetic */ InternalDecoratorImpl access$getMySourceDecorator$p(ToolWindowInnerDragHelper $this) {
        return $this.mySourceDecorator;
    }

    public static final /* synthetic */ void access$setMySourceDecorator$p(ToolWindowInnerDragHelper $this, InternalDecoratorImpl internalDecoratorImpl) {
        $this.mySourceDecorator = internalDecoratorImpl;
    }

    public static final /* synthetic */ ContentTabLabel access$getMyDraggingTab$p(ToolWindowInnerDragHelper $this) {
        return $this.myDraggingTab;
    }

    public static final /* synthetic */ void access$setMyDraggingTab$p(ToolWindowInnerDragHelper $this, ContentTabLabel contentTabLabel) {
        $this.myDraggingTab = contentTabLabel;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowInnerDragHelper$MyDialog;", "Ljavax/swing/JDialog;", "owner", "Ljavax/swing/JComponent;", "helper", "Lcom/intellij/openapi/wm/impl/ToolWindowInnerDragHelper;", "tabImage", "Ljava/awt/image/BufferedImage;", "(Ljavax/swing/JComponent;Lcom/intellij/openapi/wm/impl/ToolWindowInnerDragHelper;Ljava/awt/image/BufferedImage;)V", "getHelper", "()Lcom/intellij/openapi/wm/impl/ToolWindowInnerDragHelper;", "myDragOut", "", "getMyDragOut", "()Ljava/lang/Boolean;", "setMyDragOut", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getTabImage", "()Ljava/awt/image/BufferedImage;", "intellij.platform.ide.impl"})
    public static final class MyDialog
    extends JDialog {
        @Nullable
        private Boolean myDragOut;
        @NotNull
        private final ToolWindowInnerDragHelper helper;
        @NotNull
        private final BufferedImage tabImage;

        @Nullable
        public final Boolean getMyDragOut() {
            return this.myDragOut;
        }

        public final void setMyDragOut(@Nullable Boolean bl) {
            this.myDragOut = bl;
        }

        @NotNull
        public final ToolWindowInnerDragHelper getHelper() {
            return this.helper;
        }

        @NotNull
        public final BufferedImage getTabImage() {
            return this.tabImage;
        }

        public MyDialog(@NotNull JComponent owner, @NotNull ToolWindowInnerDragHelper helper2, @NotNull BufferedImage tabImage) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)((Object)helper2), (String)"helper");
            Intrinsics.checkNotNullParameter((Object)tabImage, (String)"tabImage");
            super(UIUtil.getWindow((Component)owner), null, Dialog.ModalityType.MODELESS);
            this.helper = helper2;
            this.tabImage = tabImage;
            this.myDragOut = null;
            this.setUndecorated(true);
            try {
                this.setOpacity(0.85f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setAlwaysOnTop(true);
            BufferedImage bufferedImage = this.tabImage;
            if (bufferedImage == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.Image");
            }
            this.setContentPane(new JLabel((Icon)IconUtil.createImageIcon((Image)bufferedImage)));
            this.getContentPane().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(@Nullable MouseEvent e) {
                    this.getHelper().mouseReleased(e);
                }

                @Override
                public void mouseDragged(@Nullable MouseEvent e) {
                    ToolWindowInnerDragHelper toolWindowInnerDragHelper = this.getHelper();
                    MouseEvent mouseEvent = e;
                    Intrinsics.checkNotNull((Object)mouseEvent);
                    toolWindowInnerDragHelper.relocate(mouseEvent);
                }
            });
            this.pack();
        }
    }
}

