/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.util.containers.CollectionFactory;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WindowWatcher
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getInstance(WindowWatcher.class);
    private final Object myLock = new Object();
    private final Map<Window, WindowInfo> windowToInfo = CollectionFactory.createWeakMap();
    private Window myFocusedWindow;
    private final Set<Window> myFocusedWindows = new HashSet<Window>();
    @NonNls
    private static final String FOCUSED_WINDOW_PROPERTY = "focusedWindow";

    WindowWatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(@NotNull PropertyChangeEvent e) {
        if (e == null) {
            WindowWatcher.$$$reportNull$$$0(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: propertyChange(" + e + ")");
        }
        if (!FOCUSED_WINDOW_PROPERTY.equals(e.getPropertyName())) {
            throw new IllegalArgumentException("unknown property name: " + e.getPropertyName());
        }
        Object object = this.myLock;
        synchronized (object) {
            Window window = (Window)e.getNewValue();
            if (window == null || ApplicationManager.getApplication().isDisposed()) {
                return;
            }
            if (!this.windowToInfo.containsKey(window)) {
                this.windowToInfo.put(window, new WindowInfo(window, true));
            }
            this.myFocusedWindow = window;
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myFocusedWindow));
            Iterator<Window> i2 = this.myFocusedWindows.iterator();
            while (i2.hasNext()) {
                Window w = i2.next();
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)w);
                if (project != CommonDataKeys.PROJECT.getData(dataContext)) continue;
                i2.remove();
            }
            this.myFocusedWindows.add(this.myFocusedWindow);
            JFrame frame = window instanceof JFrame ? (JFrame)window : (JFrame)SwingUtilities.getAncestorOfClass(IdeFrameImpl.class, window);
            if (frame != null) {
                JOptionPane.setRootFrame(frame);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("exit: propertyChange()");
        }
    }

    void dispatchComponentEvent(ComponentEvent e) {
        int id2 = e.getID();
        if (202 == id2 || 103 == id2 && e.getSource() instanceof Window) {
            this.dispatchHiddenOrClosed((Window)e.getSource());
        }
        if (202 == id2) {
            Window window = (Window)e.getSource();
            if (JOptionPane.getRootFrame() == window) {
                JOptionPane.setRootFrame(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchHiddenOrClosed(Window window) {
        WindowInfo info2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: dispatchClosed(" + window + ")");
        }
        Object object = this.myLock;
        synchronized (object) {
            info2 = this.windowToInfo.get(window);
            if (info2 != null) {
                FocusWatcher focusWatcher = (FocusWatcher)info2.myFocusWatcherRef.get();
                if (focusWatcher != null) {
                    focusWatcher.deinstall((Component)window);
                }
                this.windowToInfo.remove(window);
            }
        }
        if (this.myFocusedWindow == window) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("currently active window should be closed");
            }
            this.myFocusedWindow = this.myFocusedWindow.getOwner();
            if (LOG.isDebugEnabled()) {
                LOG.debug("new active window is " + this.myFocusedWindow);
            }
        }
        Iterator<Object> i2 = this.myFocusedWindows.iterator();
        while (i2.hasNext()) {
            Window activeWindow = i2.next();
            if (activeWindow != window) continue;
            Window newActiveWindow = activeWindow.getOwner();
            i2.remove();
            if (newActiveWindow == null) break;
            this.myFocusedWindows.add(newActiveWindow);
            break;
        }
        i2 = this.windowToInfo.values().iterator();
        while (i2.hasNext()) {
            info2 = (WindowInfo)i2.next();
            if (info2.myFocusWatcherRef.get() != null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("remove collected info");
            }
            i2.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Window getFocusedWindow() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFocusedWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Component getFocusedComponent(@Nullable Project project) {
        Object object = this.myLock;
        synchronized (object) {
            Window window = this.getFocusedWindowForProject(project);
            if (window == null) {
                return null;
            }
            return this.getFocusedComponent(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Component getFocusedComponent(@NotNull Window window) {
        if (window == null) {
            WindowWatcher.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            WindowInfo info2 = this.windowToInfo.get(window);
            if (info2 == null) {
                return window.getMostRecentFocusOwner();
            }
            FocusWatcher focusWatcher = (FocusWatcher)info2.myFocusWatcherRef.get();
            if (focusWatcher != null) {
                Component focusedComponent = focusWatcher.getFocusedComponent();
                if (focusedComponent != null && focusedComponent.isShowing()) {
                    return focusedComponent;
                }
                return window == KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() ? window : null;
            }
            this.windowToInfo.remove(window);
            return null;
        }
    }

    @Nullable
    public FocusWatcher getFocusWatcherFor(Component c) {
        Window window = SwingUtilities.getWindowAncestor(c);
        WindowInfo info2 = this.windowToInfo.get(window);
        return info2 == null ? null : (FocusWatcher)info2.myFocusWatcherRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Window suggestParentWindow(@Nullable Project project, @NotNull WindowManagerEx windowManager) {
        if (windowManager == null) {
            WindowWatcher.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            Window window = this.getFocusedWindowForProject(project);
            if (window == null) {
                Project[] projects;
                if (project == null && (projects = ProjectUtil.getOpenProjects()).length == 1) {
                    project = projects[0];
                }
                if (project == null) {
                    return null;
                }
                IdeFrame frame = windowManager.findFrameFor(project);
                if (frame == null) {
                    return null;
                }
                if (frame instanceof Window) {
                    return (Window)frame;
                }
                return ((ProjectFrameHelper)frame).getFrame();
            }
            LOG.assertTrue(window.isDisplayable());
            LOG.assertTrue(window.isShowing());
            while (window != null) {
                if (!window.isDisplayable() || !window.isShowing()) {
                    window = window.getOwner();
                    continue;
                }
                WindowInfo info2 = this.windowToInfo.get(window);
                if (info2 == null) {
                    window = window.getOwner();
                    continue;
                }
                if (info2.mySuggestAsParent) {
                    return window;
                }
                window = window.getOwner();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotSuggestAsParent(@NotNull Window window) {
        if (window == null) {
            WindowWatcher.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            WindowInfo info2 = this.windowToInfo.get(window);
            return info2 != null && !info2.mySuggestAsParent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotSuggestAsParent(Window window) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: doNotSuggestAsParent(" + window + ")");
        }
        Object object = this.myLock;
        synchronized (object) {
            WindowInfo info2 = this.windowToInfo.get(window);
            if (info2 == null) {
                this.windowToInfo.put(window, new WindowInfo(window, false));
            } else {
                info2.mySuggestAsParent = false;
            }
        }
    }

    @Nullable
    private Window getFocusedWindowForProject(@Nullable Project project) {
        block0: for (Window window : this.myFocusedWindows) {
            while (!window.isDisplayable() || !window.isShowing()) {
                if ((window = window.getOwner()) != null) continue;
                continue block0;
            }
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)window);
            if (project != CommonDataKeys.PROJECT.getData(dataContext)) continue;
            return window;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowManager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/WindowWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFocusedComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestParentWindow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotSuggestAsParent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class WindowInfo {
        public final WeakReference<FocusWatcher> myFocusWatcherRef;
        public boolean mySuggestAsParent;

        WindowInfo(Window window, boolean suggestAsParent) {
            FocusWatcher focusWatcher = new FocusWatcher();
            focusWatcher.install((Component)window);
            this.myFocusWatcherRef = new WeakReference<FocusWatcher>(focusWatcher);
            this.mySuggestAsParent = suggestAsParent;
        }
    }
}

