/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextPanel
extends NonOpaquePanel
implements Accessible {
    @Nullable
    @Nls
    private String myText;
    private Integer myPrefHeight;
    private Dimension myExplicitSize;
    protected float myAlignment;

    protected TextPanel() {
        this.updateUI();
    }

    public void updateUI() {
        GraphicsUtil.setAntialiasingType((JComponent)((Object)this), (Object)AntialiasingType.getAAHintForSwingComponent());
        Object value2 = UIManager.getDefaults().get(RenderingHints.KEY_FRACTIONALMETRICS);
        if (value2 == null) {
            value2 = RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        }
        this.putClientProperty(RenderingHints.KEY_FRACTIONALMETRICS, value2);
    }

    public Font getFont() {
        return SystemInfo.isMac ? JBUI.Fonts.label((float)11.0f) : JBFont.label();
    }

    public void recomputeSize() {
        JLabel label2 = new JLabel("XXX");
        label2.setFont(this.getFont());
        this.myPrefHeight = label2.getPreferredSize().height;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void resetColor() {
    }

    protected void paintComponent(Graphics g) {
        @Nls String s = this.getText();
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        if (s == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.getFont());
        UISettings.setupAntialiasing((Graphics)g);
        Rectangle bounds2 = new Rectangle(panelWidth, panelHeight);
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(s);
        int x = textWidth > panelWidth ? this.getInsets().left : this.getTextX(g2);
        int maxWidth = panelWidth - x - this.getInsets().right;
        if (textWidth > maxWidth) {
            s = this.truncateText(s, bounds2, fm, new Rectangle(), new Rectangle(), maxWidth);
        }
        int y = UIUtil.getStringY((String)s, (Rectangle)bounds2, (Graphics2D)g2);
        Color foreground = this.isEnabled() ? this.getForeground() : UIUtil.getInactiveTextColor();
        g2.setColor(foreground);
        g2.drawString(s, x, y);
    }

    protected int getTextX(Graphics g) {
        String text2 = this.getText();
        Insets insets = this.getInsets();
        if (text2 == null || this.myAlignment == 0.0f) {
            return insets.left;
        }
        if (this.myAlignment == 1.0f) {
            FontMetrics fm = g.getFontMetrics();
            int textWidth = fm.stringWidth(text2);
            return this.getWidth() - insets.right - textWidth;
        }
        if (this.myAlignment == 0.5f) {
            FontMetrics fm = g.getFontMetrics();
            int textWidth = fm.stringWidth(text2);
            return (this.getWidth() - insets.left - insets.right - textWidth) / 2 + insets.left;
        }
        return insets.left;
    }

    @Nls
    protected String truncateText(@Nls String text2, Rectangle bounds2, FontMetrics fm, Rectangle textR, Rectangle iconR, int maxWidth) {
        return SwingUtilities.layoutCompoundLabel((JComponent)((Object)this), fm, text2, null, 0, 0, 0, 11, bounds2, iconR, textR, 0);
    }

    public void setTextAlignment(float alignment) {
        this.myAlignment = alignment;
    }

    public final void setText(@Nullable @NlsContexts.StatusBarText String text2) {
        if ((text2 = StringUtil.notNullize((String)text2)).equals(this.myText)) {
            return;
        }
        String oldAccessibleName = null;
        if (this.accessibleContext != null) {
            oldAccessibleName = this.accessibleContext.getAccessibleName();
        }
        this.myText = text2;
        if (this.accessibleContext != null && !StringUtil.equals((CharSequence)this.accessibleContext.getAccessibleName(), (CharSequence)oldAccessibleName)) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldAccessibleName, this.accessibleContext.getAccessibleName());
        }
        this.setPreferredSize(this.getPanelDimensionFromFontMetrics(this.myText));
        this.revalidate();
        this.repaint();
    }

    @Nullable
    @Nls
    public String getText() {
        return this.myText;
    }

    public Dimension getPreferredSize() {
        if (this.myExplicitSize != null) {
            return this.myExplicitSize;
        }
        String text2 = this.getTextForPreferredSize();
        return this.getPanelDimensionFromFontMetrics(text2);
    }

    private Dimension getPanelDimensionFromFontMetrics(String text2) {
        Insets insets = this.getInsets();
        int width = insets.left + insets.right + (text2 != null ? this.getFontMetrics(this.getFont()).stringWidth(text2) : 0);
        int height = this.myPrefHeight == null ? this.getMinimumSize().height : this.myPrefHeight;
        return new Dimension(width, height);
    }

    @Nullable
    protected String getTextForPreferredSize() {
        return this.myText;
    }

    public void setExplicitSize(@Nullable Dimension explicitSize) {
        this.myExplicitSize = explicitSize;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTextPanel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleTextPanel
    extends JComponent.AccessibleJComponent {
        protected AccessibleTextPanel() {
            super((JComponent)((Object)TextPanel.this));
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        @Override
        public String getAccessibleName() {
            return TextPanel.this.myText;
        }
    }

    public static class ExtraSize
    extends TextPanel {
        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(size.width + 3, size.height);
        }
    }

    public static class WithIconAndArrows
    extends TextPanel {
        private static final int GAP = JBUIScale.scale((int)2);
        @Nullable
        private Icon myIcon;

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            Icon icon2;
            if (g == null) {
                WithIconAndArrows.$$$reportNull$$$0(0);
            }
            super.paintComponent(g);
            Icon icon3 = icon2 = this.myIcon == null || this.isEnabled() ? this.myIcon : IconLoader.getDisabledIcon((Icon)this.myIcon);
            if (icon2 != null) {
                icon2.paintIcon((Component)((Object)this), g, this.getIconX(g), this.getHeight() / 2 - icon2.getIconHeight() / 2);
            }
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
        protected boolean shouldPaintArrows() {
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            if (this.myIcon == null) {
                return preferredSize;
            }
            return new Dimension(Math.max(preferredSize.width + this.myIcon.getIconWidth(), this.getHeight()), preferredSize.height);
        }

        @Override
        protected int getTextX(Graphics g) {
            int x = super.getTextX(g);
            if (this.myIcon == null || this.myAlignment == 1.0f) {
                return x;
            }
            if (this.myAlignment == 0.5f) {
                return x + (this.myIcon.getIconWidth() + GAP) / 2;
            }
            if (this.myAlignment == 0.0f) {
                return x + this.myIcon.getIconWidth() + GAP;
            }
            return x;
        }

        private int getIconX(Graphics g) {
            int x = super.getTextX(g);
            if (this.myIcon == null || this.getText() == null || this.myAlignment == 0.0f) {
                return x;
            }
            if (this.myAlignment == 0.5f) {
                return x - (this.myIcon.getIconWidth() + GAP) / 2;
            }
            if (this.myAlignment == 1.0f) {
                return x - this.myIcon.getIconWidth() - GAP;
            }
            return x;
        }

        public void setIcon(@Nullable Icon icon2) {
            this.myIcon = icon2;
        }

        public boolean hasIcon() {
            return this.myIcon != null;
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/status/TextPanel$WithIconAndArrows", "paintComponent"));
        }
    }
}

