/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.util.scopeChooser.PackageSetChooserCombo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class DependencyConfigurable
implements Configurable {
    private final Project myProject;
    private MyTableModel myDenyRulesModel;
    private MyTableModel myAllowRulesModel;
    private TableView<DependencyRule> myDenyTable;
    private TableView<DependencyRule> myAllowTable;
    private final ColumnInfo<DependencyRule, NamedScope> DENY_USAGES_OF;
    private final ColumnInfo<DependencyRule, NamedScope> DENY_USAGES_IN;
    private final ColumnInfo<DependencyRule, NamedScope> ALLOW_USAGES_OF;
    private final ColumnInfo<DependencyRule, NamedScope> ALLOW_USAGES_ONLY_IN;
    private JPanel myWholePanel;
    private JPanel myDenyPanel;
    private JPanel myAllowPanel;
    private JCheckBox mySkipImports;
    private static final Logger LOG = Logger.getInstance(DependencyConfigurable.class);
    private static final DefaultTableCellRenderer CELL_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row2, column2);
            this.setText(value2 == null ? "" : ((NamedScope)value2).getPresentableName());
            return this;
        }
    };

    public DependencyConfigurable(Project project) {
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.DENY_USAGES_OF = new LeftColumn(CodeInsightBundle.message((String)"dependency.configurable.deny.table.column1", (Object[])objectArray));
        this.DENY_USAGES_IN = new RightColumn(CodeInsightBundle.message((String)"dependency.configurable.deny.table.column2", (Object[])new Object[0]));
        this.ALLOW_USAGES_OF = new LeftColumn(CodeInsightBundle.message((String)"dependency.configurable.allow.table.column1", (Object[])new Object[0]));
        this.ALLOW_USAGES_ONLY_IN = new RightColumn(CodeInsightBundle.message((String)"dependency.configurable.allow.table.column2", (Object[])new Object[0]));
        this.myProject = project;
    }

    public String getDisplayName() {
        return CodeInsightBundle.message((String)"dependency.configurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "editing.analyzeDependencies.validation";
    }

    public JComponent createComponent() {
        this.myDenyRulesModel = new MyTableModel(new ColumnInfo[]{this.DENY_USAGES_OF, this.DENY_USAGES_IN}, true);
        this.myDenyRulesModel.setSortable(false);
        this.myAllowRulesModel = new MyTableModel(new ColumnInfo[]{this.ALLOW_USAGES_OF, this.ALLOW_USAGES_ONLY_IN}, false);
        this.myAllowRulesModel.setSortable(false);
        this.myDenyTable = new TableView((ListTableModel)this.myDenyRulesModel);
        this.myDenyPanel.add((Component)this.createRulesPanel(this.myDenyTable), "Center");
        this.myAllowTable = new TableView((ListTableModel)this.myAllowRulesModel);
        this.myAllowPanel.add((Component)this.createRulesPanel(this.myAllowTable), "Center");
        return this.myWholePanel;
    }

    private JPanel createRulesPanel(TableView<DependencyRule> table) {
        table.setSurrendersFocusOnKeystroke(true);
        table.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)300, (int)150));
        table.setShowGrid(true);
        table.setRowHeight(new PackageSetChooserCombo((Project)this.myProject, null).getPreferredSize().height);
        return ToolbarDecorator.createDecorator(table).createPanel();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myDenyTable;
    }

    public void apply() throws ConfigurationException {
        this.stopTableEditing();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)this.myProject);
        validationManager.removeAllRules();
        HashMap unUsed = new HashMap(validationManager.getUnnamedScopes());
        ArrayList modelItems = new ArrayList();
        modelItems.addAll(this.myDenyRulesModel.getItems());
        modelItems.addAll(this.myAllowRulesModel.getItems());
        for (DependencyRule rule : modelItems) {
            NamedScope toScope;
            validationManager.addRule(rule);
            NamedScope fromScope = rule.getFromScope();
            if (fromScope instanceof NamedScope.UnnamedScope) {
                PackageSet fromPackageSet = fromScope.getValue();
                LOG.assertTrue(fromPackageSet != null);
                unUsed.remove(fromPackageSet.getText());
            }
            if (!((toScope = rule.getToScope()) instanceof NamedScope.UnnamedScope)) continue;
            PackageSet toPackageSet = toScope.getValue();
            LOG.assertTrue(toPackageSet != null);
            unUsed.remove(toPackageSet.getText());
        }
        for (String text2 : unUsed.keySet()) {
            validationManager.getUnnamedScopes().remove(text2);
        }
        validationManager.setSkipImportStatements(this.mySkipImports.isSelected());
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    private void stopTableEditing() {
        this.myDenyTable.stopEditing();
        this.myAllowTable.stopEditing();
    }

    public void reset() {
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)this.myProject);
        DependencyRule[] rules = validationManager.getAllRules();
        ArrayList<DependencyRule> denyList = new ArrayList<DependencyRule>();
        ArrayList<DependencyRule> allowList = new ArrayList<DependencyRule>();
        for (DependencyRule rule : rules) {
            if (rule.isDenyRule()) {
                denyList.add(rule.createCopy());
                continue;
            }
            allowList.add(rule.createCopy());
        }
        this.myDenyRulesModel.setItems(denyList);
        this.myAllowRulesModel.setItems(allowList);
        this.mySkipImports.setSelected(validationManager.skipImportStatements());
    }

    public boolean isModified() {
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)this.myProject);
        if (validationManager.skipImportStatements() != this.mySkipImports.isSelected()) {
            return true;
        }
        ArrayList rules = new ArrayList();
        rules.addAll(this.myDenyRulesModel.getItems());
        rules.addAll(this.myAllowRulesModel.getItems());
        return !Arrays.asList(validationManager.getAllRules()).equals(rules);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        JPanel jPanel3;
        JCheckBox jCheckBox;
        JPanel jPanel4;
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new FormLayout("fill:max(d;4px):grow", "center:max(d;4px):grow,top:7dlu:noGrow,center:max(d;4px):grow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        this.mySkipImports = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", DependencyConfigurable.class).getString("skip.import.statements.checkbox.title"));
        jPanel4.add((Component)jCheckBox, new CellConstraints(1, 5, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myAllowPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.myDenyPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyTableModel
    extends ListTableModel<DependencyRule>
    implements EditableModel {
        private final boolean myDenyRule;

        MyTableModel(ColumnInfo[] columnInfos, boolean isDenyRule) {
            super(columnInfos);
            this.myDenyRule = isDenyRule;
        }

        public void addRow() {
            ArrayList<DependencyRule> newList = new ArrayList<DependencyRule>(this.getItems());
            NamedScope scope2 = CustomScopesProviderEx.getAllScope();
            newList.add(new DependencyRule(scope2, scope2, this.myDenyRule));
            this.setItems(newList);
        }

        public void exchangeRows(int index1, int index2) {
            ArrayList<DependencyRule> newList = new ArrayList<DependencyRule>(this.getItems());
            DependencyRule r1 = (DependencyRule)newList.get(index1);
            DependencyRule r2 = (DependencyRule)newList.get(index2);
            newList.set(index1, r2);
            newList.set(index2, r1);
            this.setItems(newList);
        }
    }

    private class LeftColumn
    extends MyColumnInfo {
        LeftColumn(String name2) {
            super(name2);
        }

        public NamedScope valueOf(DependencyRule rule) {
            return rule.getToScope();
        }

        @Override
        public void setValue(DependencyRule rule, NamedScope set2) {
            rule.setToScope(set2);
        }
    }

    private class RightColumn
    extends MyColumnInfo {
        RightColumn(String name2) {
            super(name2);
        }

        public NamedScope valueOf(DependencyRule rule) {
            return rule.getFromScope();
        }

        @Override
        public void setValue(DependencyRule rule, NamedScope set2) {
            rule.setFromScope(set2);
        }
    }

    public abstract class MyColumnInfo
    extends ColumnInfo<DependencyRule, NamedScope> {
        protected MyColumnInfo(String name2) {
            super(name2);
        }

        public boolean isCellEditable(DependencyRule rule) {
            return true;
        }

        public TableCellRenderer getRenderer(DependencyRule rule) {
            return CELL_RENDERER;
        }

        public TableCellEditor getEditor(DependencyRule packageSetDependencyRule) {
            return new AbstractTableCellEditor(){
                private PackageSetChooserCombo myCombo;

                public Object getCellEditorValue() {
                    return this.myCombo.getSelectedScope();
                }

                public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row2, int column2) {
                    this.myCombo = new PackageSetChooserCombo(DependencyConfigurable.this.myProject, value2 == null ? null : ((NamedScope)value2).getScopeId());
                    return new CellEditorComponentWithBrowseButton<JComponent>(this.myCombo, (TableCellEditor)((Object)this));
                }
            };
        }

        public abstract void setValue(DependencyRule var1, NamedScope var2);
    }
}

