/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.ArchivedTemplatesFactory;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveProjectAsTemplateDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    private JPanel myPanel;
    private JTextField myName;
    private EditorTextField myDescription;
    private JComboBox<String> myModuleCombo;
    private JLabel myModuleLabel;
    private JBCheckBox myReplaceParameters;
    private static final Logger LOG = Logger.getInstance(SaveProjectAsTemplateDialog.class);

    protected SaveProjectAsTemplateDialog(@NotNull Project project, @Nullable VirtualFile descriptionFile) {
        if (project == null) {
            SaveProjectAsTemplateDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(LangBundle.message((String)"dialog.title.save.project.as.template", (Object[])objectArray));
        this.myName.setText(project.getName());
        Object[] modules2 = ModuleManager.getInstance((Project)project).getModules();
        if (modules2.length < 2) {
            this.myModuleLabel.setVisible(false);
            this.myModuleCombo.setVisible(false);
        } else {
            ArrayList<String> items = new ArrayList<String>(ContainerUtil.map((Object[])modules2, module -> module.getName()));
            String wholeProject = LangBundle.message((String)"save.project.combobox.whole.project", (Object[])new Object[0]);
            items.add(wholeProject);
            this.myModuleCombo.setModel((ComboBoxModel<String>)new CollectionComboBoxModel(items, (Object)wholeProject));
        }
        this.myDescription.setFileType(FileTypeManager.getInstance().getFileTypeByExtension("html"));
        if (descriptionFile != null) {
            try {
                String s = VfsUtilCore.loadText((VirtualFile)descriptionFile);
                this.myDescription.setText(s);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        boolean showReplaceParameters = ProjectTemplateParameterFactory.EP_NAME.getExtensionList().size() > 0;
        this.myReplaceParameters.setVisible(showReplaceParameters);
        this.myReplaceParameters.setSelected(showReplaceParameters);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myName;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "save.project.as.template.dialog";
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (StringUtil.isEmpty((String)this.myName.getText())) {
            return new ValidationInfo(LangBundle.message((String)"dialog.message.template.name.should.be.empty", (Object[])new Object[0]));
        }
        return null;
    }

    protected void doOKAction() {
        Path file2 = this.getTemplateFile();
        if (PathKt.exists((Path)file2)) {
            if (Messages.showYesNoDialog((Component)this.myPanel, (String)LangBundle.message((String)"dialog.message.exists.already.do.you.want.to.replace.it.with.new.one", (Object[])new Object[]{FileUtilRt.getNameWithoutExtension((String)file2.getFileName().toString())}), (String)LangBundle.message((String)"dialog.title.template.already.exists", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) == 1) {
                return;
            }
            PathKt.delete((Path)file2);
        }
        super.doOKAction();
    }

    Path getTemplateFile() {
        String name2 = this.myName.getText();
        return ArchivedTemplatesFactory.getTemplateFile(name2);
    }

    String getDescription() {
        return this.myDescription.getText();
    }

    boolean isReplaceParameters() {
        return this.myReplaceParameters.isSelected();
    }

    @Nullable
    Module getModuleToSave() {
        String item = (String)this.myModuleCombo.getSelectedItem();
        if (item == null || item.equals(LangBundle.message((String)"save.project.combobox.whole.project", (Object[])new Object[0]))) {
            return null;
        }
        return ModuleManager.getInstance((Project)this.myProject).findModuleByName(item);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/templates/SaveProjectAsTemplateDialog", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JLabel jLabel;
        EditorTextField editorTextField2;
        JTextField jTextField;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/LangBundle", SaveProjectAsTemplateDialog.class).getString("label.project.as.template.name"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myName = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/LangBundle", SaveProjectAsTemplateDialog.class).getString("label.project.as.template.description"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 10, 0, 0, 0, null, null, null));
        this.myDescription = editorTextField2 = new EditorTextField();
        jPanel2.add((Component)((Object)editorTextField2), new GridConstraints(2, 1, 2, 1, 0, 3, 3, 3, null, new Dimension(-1, 60), null));
        JComboBox jComboBox = new JComboBox();
        this.myModuleCombo = jComboBox;
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myModuleLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/LangBundle", SaveProjectAsTemplateDialog.class).getString("label.project.as.template.save"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myReplaceParameters = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/LangBundle", SaveProjectAsTemplateDialog.class).getString("checkbox.replace.parameters.with.placeholders"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

