/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.application.options.CodeStyle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.projectWizard.ExistingModuleLoader;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.SaveProjectAsTemplateAction;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.apache.velocity.exception.VelocityException;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateModuleBuilder
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance(TemplateModuleBuilder.class);
    private final ModuleType<?> myType;
    private final List<WizardInputField<?>> myAdditionalFields;
    private final ArchivedProjectTemplate myTemplate;
    private boolean myProjectMode;

    public TemplateModuleBuilder(ArchivedProjectTemplate template, ModuleType<?> moduleType, @NotNull List<WizardInputField<?>> additionalFields) {
        if (additionalFields == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(0);
        }
        this.myTemplate = template;
        this.myType = moduleType;
        this.myAdditionalFields = additionalFields;
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(1);
        }
        if (modulesProvider == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(2);
        }
        ModuleBuilder builder2 = this.myType.createModuleBuilder();
        return builder2.createWizardSteps(wizardContext, modulesProvider);
    }

    public ModuleWizardStep[] createFinishingSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(3);
        }
        if (modulesProvider == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(4);
        }
        ModuleBuilder builder2 = this.myType.createModuleBuilder();
        return builder2.createFinishingSteps(wizardContext, modulesProvider);
    }

    @NotNull
    protected List<WizardInputField<?>> getAdditionalFields() {
        List<WizardInputField<?>> list2 = this.myAdditionalFields;
        if (list2 == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public Module commitModule(@NotNull Project project, ModifiableModuleModel model2) {
        if (project == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(6);
        }
        if (this.myProjectMode) {
            Module[] modules2 = ModuleManager.getInstance((Project)project).getModules();
            if (modules2.length > 0) {
                Module module = modules2[0];
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        this.setupModule(module);
                    }
                    catch (ConfigurationException e) {
                        LOG.error((Throwable)e);
                    }
                });
                StartupManager.getInstance((Project)project).registerStartupActivity(() -> ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        ModifiableModuleModel modifiableModuleModel = ModuleManager.getInstance((Project)project).getModifiableModel();
                        modifiableModuleModel.renameModule(module, module.getProject().getName());
                        modifiableModuleModel.commit();
                        this.fixModuleName(module);
                    }
                    catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                        // empty catch block
                    }
                })));
                return module;
            }
            return null;
        }
        return super.commitModule(project, model2);
    }

    @NotNull
    @NonNls
    public String getBuilderId() {
        String string = this.myTemplate.getName();
        if (string == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(7);
        }
        return string;
    }

    public ModuleType<?> getModuleType() {
        return this.myType;
    }

    public Icon getNodeIcon() {
        return this.myTemplate.getIcon();
    }

    public boolean isTemplateBased() {
        return true;
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(8);
        }
        String path2 = this.getContentEntryPath();
        ExistingModuleLoader loader = ExistingModuleLoader.setUpLoader(this.getModuleFilePath());
        this.unzip(loader.getName(), path2, true, null, true);
        Module module = loader.createModule(moduleModel);
        if (this.myProjectMode) {
            moduleModel.renameModule(module, module.getProject().getName());
        }
        this.fixModuleName(module);
        Module module2 = module;
        if (module2 == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(9);
        }
        return module2;
    }

    private void fixModuleName(@NotNull Module module) {
        if (module == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(10);
        }
        ModifiableRootModel model2 = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        for (WizardInputField<?> field : this.myAdditionalFields) {
            ProjectTemplateParameterFactory factory2 = WizardInputField.getFactoryById((String)field.getId());
            if (factory2 == null) continue;
            factory2.applyResult(field.getValue(), model2);
        }
        TemplateModuleBuilder.applyProjectDefaults(module.getProject());
        for (ProjectTemplateParameterFactory factory3 : ProjectTemplateParameterFactory.EP_NAME.getExtensionList()) {
            String value2 = factory3.getImmediateValue();
            if (value2 == null) continue;
            factory3.applyResult(value2, model2);
        }
        model2.commit();
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        for (RunConfiguration configuration2 : runManager.getAllConfigurationsList()) {
            if (!(configuration2 instanceof ModuleBasedConfiguration)) continue;
            ((ModuleBasedConfiguration)configuration2).getConfigurationModule().setModule(module);
        }
    }

    private static void applyProjectDefaults(@NotNull Project project) {
        if (project == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(11);
        }
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        String charset = EncodingProjectManager.getInstance((Project)defaultProject).getDefaultCharsetName();
        EncodingProjectManager.getInstance((Project)project).setDefaultCharsetName(charset);
        RunnerAndConfigurationSettings selectedConfiguration2 = RunManager.getInstance((Project)project).getSelectedConfiguration();
        RunManagerImpl.getInstanceImpl(defaultProject).copyTemplatesToProjectFromTemplate(project);
        RunManager.getInstance((Project)project).setSelectedConfiguration(selectedConfiguration2);
    }

    @Nullable
    private WizardInputField<?> getBasePackageField() {
        for (WizardInputField<?> field : this.getAdditionalFields()) {
            if (!"IJ_BASE_PACKAGE".equals(field.getId())) continue;
            return field;
        }
        return null;
    }

    private void unzip(final @Nullable String projectName, String path2, final boolean isModuleMode, final @Nullable ProgressIndicator pI, final boolean reportFailuresWithDialog) {
        final WizardInputField<?> basePackage = this.getBasePackageField();
        try {
            final Path dir = Paths.get(path2, new String[0]);
            class ExceptionConsumer
            implements Consumer<VelocityException> {
                private String myPath;
                private String myText;
                private final SmartList<Trinity<String, String, VelocityException>> myFailures = new SmartList();

                ExceptionConsumer() {
                }

                public void consume(VelocityException e) {
                    this.myFailures.add((Object)Trinity.create((Object)this.myPath, (Object)this.myText, (Object)((Object)e)));
                }

                private void setCurrentFile(String path2, String text2) {
                    this.myPath = path2;
                    this.myText = text2;
                }

                private void reportFailures() {
                    if (this.myFailures.isEmpty()) {
                        return;
                    }
                    if (reportFailuresWithDialog) {
                        String dialogMessage;
                        if (this.myFailures.size() == 1) {
                            dialogMessage = LangBundle.message((String)"dialog.message.failed.to.decode.file", (Object[])new Object[]{((Trinity)this.myFailures.get(0)).getFirst()});
                        } else {
                            StringBuilder dialogMessageBuilder = new StringBuilder();
                            dialogMessageBuilder.append(LangBundle.message((String)"dialog.message.failed.to.decode.files", (Object[])new Object[0])).append('\n');
                            for (Trinity failure : this.myFailures) {
                                dialogMessageBuilder.append((String)failure.getFirst()).append("\n");
                            }
                            dialogMessage = dialogMessageBuilder.toString();
                        }
                        Messages.showErrorDialog((String)dialogMessage, (String)LangBundle.message((String)"dialog.title.decoding.template", (Object[])new Object[0]));
                    }
                    @NonNls StringBuilder reportBuilder = new StringBuilder();
                    for (Trinity failure : this.myFailures) {
                        reportBuilder.append("File: ").append((String)failure.getFirst()).append("\n");
                        reportBuilder.append("Exception:\n").append(ExceptionUtil.getThrowableText((Throwable)((Throwable)failure.getThird()))).append("\n");
                        reportBuilder.append("File content:\n'").append((String)failure.getSecond()).append("'\n");
                        reportBuilder.append("\n===========================================\n");
                    }
                    LOG.error("Cannot decode files in template", (Throwable)null, new Attachment[]{new Attachment("Files in template", reportBuilder.toString())});
                }
            }
            final ExceptionConsumer consumer2 = new ExceptionConsumer();
            final ArrayList filesToRefresh = new ArrayList();
            this.myTemplate.processStream(new ArchivedProjectTemplate.StreamProcessor<Void>(){
                {
                }

                @Override
                public Void consume(@NotNull ZipInputStream stream) throws IOException {
                    if (stream == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ZipUtil.unzip(ProgressManager.getInstance().getProgressIndicator(), dir, stream, (NullableFunction<? super String, String>)((NullableFunction)path1 -> {
                        if (isModuleMode && path1.contains(".idea")) {
                            return null;
                        }
                        if (basePackage != null) {
                            return path1.replace(TemplateModuleBuilder.getPathFragment(basePackage.getDefaultValue()), TemplateModuleBuilder.getPathFragment(basePackage.getValue()));
                        }
                        return path1;
                    }), new ZipUtil.ContentProcessor(){

                        @Override
                        public byte[] processContent(byte[] content2, File file2) throws IOException {
                            if (pI != null) {
                                pI.checkCanceled();
                            }
                            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
                            String text2 = new String(content2, StandardCharsets.UTF_8);
                            consumer2.setCurrentFile(file2.getName(), text2);
                            return fileType.isBinary() ? content2 : TemplateModuleBuilder.this.processTemplates(projectName, text2, file2, consumer2);
                        }
                    }, true);
                    TemplateModuleBuilder.this.myTemplate.handleUnzippedDirectories(dir.toFile(), filesToRefresh);
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/platform/templates/TemplateModuleBuilder$1", "consume"));
                }
            });
            if (pI != null) {
                pI.setText(LangBundle.message((String)"progress.title.refreshing", (Object[])new Object[0]));
            }
            if (isModuleMode) {
                Path from2;
                try (Stream<Path> list2 = Files.list(dir);){
                    from2 = list2.filter(it -> it.toString().endsWith(".iml")).findFirst().orElse(null);
                }
                Files.move(Objects.requireNonNull(from2), Paths.get(this.getModuleFilePath(), new String[0]), new CopyOption[0]);
            }
            RefreshQueue refreshQueue = RefreshQueue.getInstance();
            LOG.assertTrue(!filesToRefresh.isEmpty());
            for (File file2 : filesToRefresh) {
                VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
                if (virtualFile2 == null) {
                    throw new IOException("Can't find " + file2);
                }
                refreshQueue.refresh(false, true, null, new VirtualFile[]{virtualFile2});
            }
            consumer2.reportFailures();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static String getPathFragment(@NotNull String value2) {
        if (value2 == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(12);
        }
        String string = "/" + value2.replace('.', '/') + "/";
        if (string == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(13);
        }
        return string;
    }

    private byte @Nullable [] processTemplates(@Nullable String projectName, String content2, File file2, Consumer<? super VelocityException> exceptionConsumer) throws IOException {
        Object patchedContent = content2;
        if (!(this.myTemplate instanceof LocalArchivedTemplate) || ((LocalArchivedTemplate)this.myTemplate).isEscaped()) {
            for (WizardInputField<?> wizardInputField : this.myAdditionalFields) {
                if (wizardInputField.acceptFile(file2)) continue;
                return null;
            }
            Properties properties2 = FileTemplateManager.getDefaultInstance().getDefaultProperties();
            for (WizardInputField<?> wizardInputField : this.myAdditionalFields) {
                properties2.putAll((Map<?, ?>)wizardInputField.getValues());
            }
            if (projectName != null) {
                properties2.put("IJ_PROJECT_NAME", projectName);
            }
            String string = FileTemplateUtil.mergeTemplate(properties2, content2, true, exceptionConsumer);
            patchedContent = string.replace("\\$", "$").replace("\\#", "#");
        } else {
            int i2 = content2.indexOf("<IntelliJ_File_Header>");
            if (i2 != -1) {
                FileTemplate fileTemplate = FileTemplateManager.getDefaultInstance().getDefaultTemplate(SaveProjectAsTemplateAction.getFileHeaderTemplateName());
                Properties properties2 = FileTemplateManager.getDefaultInstance().getDefaultProperties();
                String templateText = fileTemplate.getText(properties2);
                patchedContent = ((String)patchedContent).substring(0, i2) + templateText + ((String)patchedContent).substring(i2 + "<IntelliJ_File_Header>".length());
            }
        }
        return StringUtilRt.convertLineSeparators((String)patchedContent, (String)CodeStyle.getDefaultSettings().getLineSeparator()).getBytes(StandardCharsets.UTF_8);
    }

    public boolean isSuitableSdkType(SdkTypeId sdkType) {
        return this.myType.createModuleBuilder().isSuitableSdkType(sdkType);
    }

    @Nullable
    public Project createProject(final String name2, final @NotNull String path2) {
        List children2;
        if (path2 == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(14);
        }
        final Path baseDir = Paths.get(path2, new String[0]);
        LOG.assertTrue(Files.isDirectory(baseDir, new LinkOption[0]));
        try (DirectoryStream<Path> childrenIterator = Files.newDirectoryStream(baseDir);){
            children2 = ContainerUtil.collect(childrenIterator.iterator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final boolean isSomehowOverwriting = children2.size() > 1 || children2.size() == 1 && !".idea".equals(((Path)children2.get(0)).getFileName().toString());
        return (Project)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Project, RuntimeException>(null, LangBundle.message((String)"progress.title.applying.template", (Object[])new Object[0]), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Project compute(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    TemplateModuleBuilder.this.myProjectMode = true;
                    TemplateModuleBuilder.this.unzip(name2, path2, false, indicator2, false);
                    Project project = ProjectManagerEx.getInstanceEx().loadProject(baseDir);
                    return project;
                }
                finally {
                    TemplateModuleBuilder.this.cleanup();
                    if (indicator2.isCanceled() && !isSomehowOverwriting) {
                        try {
                            FileUtil.delete((Path)baseDir);
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/platform/templates/TemplateModuleBuilder$2", "compute"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFields";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/TemplateModuleBuilder";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/TemplateModuleBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalFields";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWizardSteps";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFinishingSteps";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "commitModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fixModuleName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyProjectDefaults";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPathFragment";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

