/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionConfigTreeNode
extends DefaultMutableTreeNode {
    private final ClearableLazyValue<Boolean> myProperSetting = ClearableLazyValue.create(this::calculateIsProperSettings);

    public final boolean isProperSetting() {
        return (Boolean)this.myProperSetting.getValue();
    }

    public final void dropCache() {
        this.myProperSetting.drop();
    }

    protected abstract boolean calculateIsProperSettings();

    @NotNull
    public abstract String getText();

    @Override
    public String toString() {
        Object userObject = this.getUserObject();
        if (userObject instanceof ToolDescriptors) {
            return ((ToolDescriptors)userObject).getDefaultDescriptor().getText();
        }
        if (userObject instanceof Descriptor) {
            return ((Descriptor)userObject).getText();
        }
        return super.toString();
    }

    public static void updateUpHierarchy(@NotNull InspectionConfigTreeNode node2) {
        if (node2 == null) {
            InspectionConfigTreeNode.$$$reportNull$$$0(0);
        }
        InspectionConfigTreeNode.updateUpHierarchy(Collections.singletonList(node2));
    }

    public static void updateUpHierarchy(Collection<? extends InspectionConfigTreeNode> nodes) {
        InspectionConfigTreeNode inspectionConfigTreeNode;
        ArrayDeque<InspectionConfigTreeNode> q = new ArrayDeque<InspectionConfigTreeNode>(nodes.size());
        HashSet<InspectionConfigTreeNode> alreadyUpdated = new HashSet<InspectionConfigTreeNode>();
        for (InspectionConfigTreeNode inspectionConfigTreeNode2 : nodes) {
            q.addLast(inspectionConfigTreeNode2);
        }
        while ((inspectionConfigTreeNode = (InspectionConfigTreeNode)q.pollFirst()) != null) {
            if (!alreadyUpdated.add(inspectionConfigTreeNode)) continue;
            inspectionConfigTreeNode.dropCache();
            TreeNode treeNode2 = inspectionConfigTreeNode.getParent();
            if (treeNode2 == null || treeNode2.getParent() == null) continue;
            q.addLast((InspectionConfigTreeNode)treeNode2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionConfigTreeNode", "updateUpHierarchy"));
    }

    public static class Tool
    extends InspectionConfigTreeNode {
        private final Supplier<ToolDescriptors> myGetter;

        public Tool(Supplier<ToolDescriptors> getter) {
            this.myGetter = getter;
        }

        @Override
        public Object getUserObject() {
            return this.myGetter.get();
        }

        @Override
        protected boolean calculateIsProperSettings() {
            Descriptor defaultDescriptor = this.getDescriptors().getDefaultDescriptor();
            return defaultDescriptor.getInspectionProfile().isProperSetting(defaultDescriptor.getToolWrapper().getShortName());
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.getDefaultDescriptor().getText();
            if (string == null) {
                Tool.$$$reportNull$$$0(0);
            }
            return string;
        }

        public HighlightDisplayKey getKey() {
            return this.getDefaultDescriptor().getKey();
        }

        @NotNull
        public Descriptor getDefaultDescriptor() {
            Descriptor descriptor2 = this.getDescriptors().getDefaultDescriptor();
            if (descriptor2 == null) {
                Tool.$$$reportNull$$$0(1);
            }
            return descriptor2;
        }

        @NotNull
        public ToolDescriptors getDescriptors() {
            ToolDescriptors toolDescriptors = (ToolDescriptors)this.getUserObject();
            if (toolDescriptors == null) {
                Tool.$$$reportNull$$$0(2);
            }
            return toolDescriptors;
        }

        @Nullable
        public String getScopeName() {
            return this.getDescriptors().getDefaultScopeToolState().getScopeName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionConfigTreeNode$Tool";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptors";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Group
    extends InspectionConfigTreeNode {
        public Group(@NotNull String label2) {
            if (label2 == null) {
                Group.$$$reportNull$$$0(0);
            }
            this.setUserObject(label2);
        }

        @Override
        protected boolean calculateIsProperSettings() {
            return IntStream.range(0, this.getChildCount()).mapToObj(i2 -> (InspectionConfigTreeNode)this.getChildAt(i2)).anyMatch(InspectionConfigTreeNode::isProperSetting);
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.getGroupName();
            if (string == null) {
                Group.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getGroupName() {
            String string = (String)this.getUserObject();
            if (string == null) {
                Group.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionConfigTreeNode$Group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionConfigTreeNode$Group";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

