/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectStoreOwner;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t\u001a\u001e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"isDirectoryBased", "", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Z", "stateStore", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "getStateStore", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "getProjectStoreDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "isEqualToProjectFileStorePath", "project", "filePath", "Ljava/nio/file/Path;", "storePath", "", "intellij.platform.projectModel.impl"})
public final class ProjectKt {
    @NotNull
    public static final IProjectStore getStateStore(@NotNull Project $this$stateStore) {
        Intrinsics.checkNotNullParameter((Object)$this$stateStore, (String)"$this$stateStore");
        return ((ProjectStoreOwner)$this$stateStore).getComponentStore();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDirectoryBased(@NotNull Project $this$isDirectoryBased) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectoryBased, (String)"$this$isDirectoryBased");
        if ($this$isDirectoryBased.isDefault()) return false;
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)$this$isDirectoryBased);
        if (!(iComponentStore instanceof IProjectStore)) {
            iComponentStore = null;
        }
        IProjectStore iProjectStore = (IProjectStore)iComponentStore;
        if (StorageScheme.DIRECTORY_BASED != (iProjectStore != null ? iProjectStore.getStorageScheme() : null)) return false;
        return true;
    }

    @Nullable
    public static final VirtualFile getProjectStoreDirectory(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return file2.isDirectory() ? file2.findChild(".idea") : null;
    }

    public static final boolean isEqualToProjectFileStorePath(@NotNull Project project, @NotNull Path filePath, @NotNull String storePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)storePath, (String)"storePath");
        return ProjectKt.isDirectoryBased(project) && Intrinsics.areEqual((Object)filePath, (Object)ServiceKt.getStateStore((ComponentManager)project).getStorageManager().expandMacro(storePath));
    }
}

