/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiReferenceServiceImpl
extends PsiReferenceService {
    private static final Logger LOG = Logger.getInstance(PsiReferenceService.class);
    private static final Set<String> ourReportedReferenceClasses = ContainerUtil.newConcurrentSet();

    @NotNull
    public List<PsiReference> getReferences(@NotNull PsiElement element2, @NotNull PsiReferenceService.Hints hints2) {
        if (element2 == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(0);
        }
        if (hints2 == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(1);
        }
        List<PsiReference> references = PsiReferenceServiceImpl.doGetReferences(element2, hints2);
        PsiReferenceServiceImpl.assertReferencesHaveSameElement(element2, references);
        List<PsiReference> list2 = references;
        if (list2 == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    private static List<PsiReference> doGetReferences(@NotNull PsiElement element2, @NotNull PsiReferenceService.Hints hints2) {
        if (element2 == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(3);
        }
        if (hints2 == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(4);
        }
        if (element2 instanceof ContributedReferenceHost) {
            List<PsiReference> list2 = Arrays.asList(ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)element2, (PsiReferenceService.Hints)hints2));
            if (list2 == null) {
                PsiReferenceServiceImpl.$$$reportNull$$$0(5);
            }
            return list2;
        }
        if (element2 instanceof HintedReferenceHost) {
            List<PsiReference> list3 = Arrays.asList(((HintedReferenceHost)element2).getReferences(hints2));
            if (list3 == null) {
                PsiReferenceServiceImpl.$$$reportNull$$$0(6);
            }
            return list3;
        }
        List<PsiReference> list4 = Arrays.asList(element2.getReferences());
        if (list4 == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(7);
        }
        return list4;
    }

    private static void assertReferencesHaveSameElement(@NotNull PsiElement element2, @NotNull List<? extends PsiReference> references) {
        if (element2 == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(8);
        }
        if (references == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(9);
        }
        for (PsiReference psiReference : references) {
            Class<?> referenceClass;
            PsiElement referenceElement = psiReference.getElement();
            if (referenceElement == element2 || !ourReportedReferenceClasses.add((referenceClass = psiReference.getClass()).getName())) continue;
            PluginException.logPluginError((Logger)LOG, (String)"Reference element is not the same element for which references were queried", (Throwable)new RuntimeExceptionWithAttachments("Element: " + element2.getClass().getName() + "; reference: " + referenceClass.getName() + "; reference element: " + referenceElement.getClass().getName(), new Attachment[]{new Attachment("info.txt", "Element text: `" + element2.getText() + "`\nReference range: " + psiReference.getRangeInElement())}), referenceClass);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiReferenceServiceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiReferenceServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGetReferences";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assertReferencesHaveSameElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

