/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.psi.codeStyle.autodetect.IndentUsageInfo;
import com.intellij.psi.codeStyle.autodetect.IndentUsageStatistics;
import com.intellij.psi.codeStyle.autodetect.LineIndentInfo;
import com.intellij.util.containers.Stack;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class IndentUsageStatisticsImpl
implements IndentUsageStatistics {
    private final List<LineIndentInfo> myLineInfos;
    private int myPreviousLineIndent;
    private int myPreviousRelativeIndent;
    private int myTotalLinesWithTabs;
    private int myTotalLinesWithWhiteSpaces;
    private final Int2IntOpenHashMap myIndentToUsagesMap;
    private final List<IndentUsageInfo> myIndentUsages;
    private final Stack<IndentData> myParentIndents;

    public IndentUsageStatisticsImpl(@NotNull List<LineIndentInfo> lineInfos) {
        if (lineInfos == null) {
            IndentUsageStatisticsImpl.$$$reportNull$$$0(0);
        }
        this.myTotalLinesWithTabs = 0;
        this.myTotalLinesWithWhiteSpaces = 0;
        this.myIndentToUsagesMap = new Int2IntOpenHashMap();
        this.myParentIndents = new Stack((Object[])new IndentData[]{new IndentData(0, 0)});
        this.myLineInfos = lineInfos;
        this.buildIndentToUsagesMap();
        this.myIndentUsages = IndentUsageStatisticsImpl.toIndentUsageList((Int2IntMap)this.myIndentToUsagesMap);
        this.myIndentUsages.sort((o1, o2) -> {
            int diff = o2.getTimesUsed() - o1.getTimesUsed();
            return diff == 0 ? o2.getIndentSize() - o1.getIndentSize() : diff;
        });
    }

    @NotNull
    private static List<IndentUsageInfo> toIndentUsageList(@NotNull Int2IntMap indentToUsages) {
        if (indentToUsages == null) {
            IndentUsageStatisticsImpl.$$$reportNull$$$0(1);
        }
        ArrayList<IndentUsageInfo> indentUsageInfos = new ArrayList<IndentUsageInfo>(indentToUsages.size());
        for (Int2IntMap.Entry entry2 : indentToUsages.int2IntEntrySet()) {
            indentUsageInfos.add(new IndentUsageInfo(entry2.getIntKey(), entry2.getIntValue()));
        }
        ArrayList<IndentUsageInfo> arrayList = indentUsageInfos;
        if (arrayList == null) {
            IndentUsageStatisticsImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public void buildIndentToUsagesMap() {
        this.myPreviousLineIndent = 0;
        this.myPreviousRelativeIndent = 0;
        for (LineIndentInfo lineInfo : this.myLineInfos) {
            if (lineInfo.isLineWithTabs()) {
                ++this.myTotalLinesWithTabs;
                continue;
            }
            if (!lineInfo.isLineWithNormalIndent()) continue;
            this.handleNormalIndent(lineInfo.getIndentSize());
        }
    }

    @NotNull
    private IndentData findParentIndent(int indent) {
        while (this.myParentIndents.size() != 1 && ((IndentData)this.myParentIndents.peek()).indent > indent) {
            this.myParentIndents.pop();
        }
        IndentData indentData = (IndentData)this.myParentIndents.peek();
        if (indentData == null) {
            IndentUsageStatisticsImpl.$$$reportNull$$$0(3);
        }
        return indentData;
    }

    private void handleNormalIndent(int currentIndent) {
        int relativeIndent = currentIndent - this.myPreviousLineIndent;
        if (relativeIndent < 0) {
            IndentData indentData = this.findParentIndent(currentIndent);
            this.myPreviousLineIndent = indentData.indent;
            this.myPreviousRelativeIndent = indentData.relativeIndent;
            relativeIndent = currentIndent - this.myPreviousLineIndent;
        }
        if (relativeIndent == 0) {
            relativeIndent = this.myPreviousRelativeIndent;
        } else {
            this.myParentIndents.push((Object)new IndentData(currentIndent, relativeIndent));
        }
        this.myIndentToUsagesMap.addTo(relativeIndent, 1);
        this.myPreviousRelativeIndent = relativeIndent;
        this.myPreviousLineIndent = currentIndent;
        if (currentIndent > 0) {
            ++this.myTotalLinesWithWhiteSpaces;
        }
    }

    public int getTotalLinesWithLeadingTabs() {
        return this.myTotalLinesWithTabs;
    }

    public int getTotalLinesWithLeadingSpaces() {
        return this.myTotalLinesWithWhiteSpaces;
    }

    public IndentUsageInfo getKMostUsedIndentInfo(int k) {
        return this.myIndentUsages.get(k);
    }

    public int getTimesIndentUsed(int indent) {
        return this.myIndentToUsagesMap.get(indent);
    }

    public int getTotalIndentSizesDetected() {
        return this.myIndentToUsagesMap.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentToUsages";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/autodetect/IndentUsageStatisticsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/autodetect/IndentUsageStatisticsImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toIndentUsageList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findParentIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toIndentUsageList";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class IndentData {
        public final int indent;
        public final int relativeIndent;

        IndentData(int indent, int relativeIndent) {
            this.indent = indent;
            this.relativeIndent = relativeIndent;
        }
    }
}

