/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.ui;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.presentation.CodeStyleSelectSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettingsNameProvider
implements CodeStyleSettingsCustomizable {
    protected Map<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>> mySettings = new HashMap<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>>();
    private final Map<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>> standardSettings = new HashMap<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>>();

    public CodeStyleSettingsNameProvider() {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            this.standardSettings.put(settingsType, CodeStyleSettingPresentation.getStandardSettings((LanguageCodeStyleSettingsProvider.SettingsType)settingsType));
        }
    }

    protected void addSetting(@NotNull CodeStyleSettingPresentation.SettingsGroup group2, @NotNull CodeStyleSettingPresentation setting2, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable @Nls String anchorFieldName) {
        if (group2 == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(0);
        }
        if (setting2 == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(1);
        }
        for (Map.Entry<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>> entry2 : this.mySettings.entrySet()) {
            if (!entry2.getValue().containsKey(group2)) continue;
            this.addSetting(entry2.getKey(), group2, setting2, anchor2, anchorFieldName);
            return;
        }
        this.addSetting(LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC, group2, setting2, anchor2, anchorFieldName);
    }

    protected void addSetting(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType, @NotNull CodeStyleSettingPresentation.SettingsGroup group2, @NotNull CodeStyleSettingPresentation setting2, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable @Nls String anchorFieldName) {
        List<CodeStyleSettingPresentation> settingsList;
        Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> groups2;
        if (settingsType == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(2);
        }
        if (group2 == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(3);
        }
        if (setting2 == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(4);
        }
        if ((groups2 = this.mySettings.get(settingsType)) == null) {
            groups2 = new LinkedHashMap<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>();
        }
        if ((settingsList = groups2.get(group2)) == null) {
            settingsList = new LinkedList<CodeStyleSettingPresentation>();
        }
        if (settingsList.contains(setting2)) {
            return;
        }
        if (anchor2 != null && anchorFieldName != null) {
            CodeStyleSettingPresentation anchorSettingRepresentation = new CodeStyleSettingPresentation(anchorFieldName, anchorFieldName);
            int insertIndex = settingsList.indexOf(anchorSettingRepresentation);
            if (insertIndex < 0) {
                insertIndex = settingsList.size();
            } else {
                switch (anchor2) {
                    case BEFORE: {
                        break;
                    }
                    case AFTER: {
                        ++insertIndex;
                        break;
                    }
                    case NONE: {
                        insertIndex = settingsList.size();
                    }
                }
            }
            settingsList.add(insertIndex, setting2);
        } else {
            settingsList.add(setting2);
        }
        groups2.put(group2, settingsList);
    }

    public void showAllStandardOptions() {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> standardGroups = this.standardSettings.get(settingsType);
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry2 : standardGroups.entrySet()) {
                for (CodeStyleSettingPresentation setting2 : entry2.getValue()) {
                    this.addSetting(settingsType, entry2.getKey(), setting2, null, null);
                }
            }
        }
    }

    public void showStandardOptions(String ... optionNames) {
        List<String> options2 = Arrays.asList(optionNames);
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> standardGroups = this.standardSettings.get(settingsType);
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry2 : standardGroups.entrySet()) {
                for (CodeStyleSettingPresentation setting2 : entry2.getValue()) {
                    if (!options2.contains(setting2.getFieldName())) continue;
                    this.addSetting(settingsType, entry2.getKey(), setting2, null, null);
                }
            }
        }
    }

    public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NotNull @NonNls String fieldName, @NotNull @NlsContexts.Label String title2, @Nls @Nullable String groupName, Object ... options2) {
        if (settingsClass == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(5);
        }
        if (fieldName == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(6);
        }
        if (title2 == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(7);
        }
        this.showCustomOption(settingsClass, fieldName, title2, groupName, null, null, options2);
    }

    public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title2, @Nls @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nls @Nullable String anchorFieldName, Object ... options2) {
        if (settingsClass == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(8);
        }
        if (fieldName == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(9);
        }
        if (title2 == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(10);
        }
        if (options2.length == 2) {
            this.addSetting(new CodeStyleSettingPresentation.SettingsGroup(groupName), (CodeStyleSettingPresentation)new CodeStyleSelectSettingPresentation(fieldName, title2, (int[])options2[1], (String[])options2[0]), anchor2, anchorFieldName);
        } else {
            this.addSetting(new CodeStyleSettingPresentation.SettingsGroup(groupName), new CodeStyleSettingPresentation(fieldName, title2), anchor2, anchorFieldName);
        }
    }

    public void renameStandardOption(@NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String newTitle) {
        if (fieldName == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(11);
        }
        if (newTitle == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(12);
        }
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> standardGroups = this.mySettings.get(settingsType);
            if (standardGroups == null) continue;
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry2 : standardGroups.entrySet()) {
                for (CodeStyleSettingPresentation setting2 : entry2.getValue()) {
                    if (!setting2.getFieldName().equals(fieldName)) continue;
                    setting2.setUiName(newTitle);
                    return;
                }
            }
        }
    }

    public void moveStandardOption(@NonNls @NotNull String fieldName, @Nls @NotNull String newGroup) {
        if (fieldName == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(13);
        }
        if (newGroup == null) {
            CodeStyleSettingsNameProvider.$$$reportNull$$$0(14);
        }
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> standardGroups = this.mySettings.get(settingsType);
            if (standardGroups == null) {
                standardGroups = new LinkedHashMap<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>();
                this.mySettings.put(settingsType, standardGroups);
            }
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry2 : standardGroups.entrySet()) {
                CodeStyleSettingPresentation moveSetting = null;
                for (CodeStyleSettingPresentation setting2 : entry2.getValue()) {
                    if (!setting2.getFieldName().equals(fieldName)) continue;
                    moveSetting = setting2;
                    break;
                }
                if (moveSetting == null) continue;
                entry2.getValue().remove(moveSetting);
                this.addSetting(new CodeStyleSettingPresentation.SettingsGroup(newGroup), moveSetting, null, null);
            }
        }
    }

    @Nls
    public static String getSettingsTypeName(LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        switch (settingsType) {
            case BLANK_LINES_SETTINGS: {
                return ApplicationBundle.message((String)"title.blank.lines", (Object[])new Object[0]);
            }
            case SPACING_SETTINGS: {
                return ApplicationBundle.message((String)"title.spaces", (Object[])new Object[0]);
            }
            case WRAPPING_AND_BRACES_SETTINGS: {
                return ApplicationBundle.message((String)"settings.code.style.tab.title.wrapping.and.braces", (Object[])new Object[0]);
            }
            case INDENT_SETTINGS: {
                return ApplicationBundle.message((String)"title.tabs.and.indents", (Object[])new Object[0]);
            }
            case LANGUAGE_SPECIFIC: {
                return ApplicationBundle.message((String)"code.style.title.lang.specific", (Object[])new Object[0]);
            }
        }
        throw new IllegalArgumentException("Unknown settings type: " + settingsType);
    }

    public void addSettings(LanguageCodeStyleSettingsProvider provider2) {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            provider2.customizeSettings((CodeStyleSettingsCustomizable)this, settingsType);
        }
    }

    public static Value getValue(CodeStyleSettingPresentation representation, List<? extends Value> values2) {
        Value myValue = (Value)ContainerUtil.find(values2, value2 -> value2.state == Value.STATE.SELECTED && value2.name.equals(representation.getFieldName()));
        return myValue;
    }

    public String getSettings(List<? extends Value> values2) {
        StringBuilder builder2 = new StringBuilder();
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            builder2.append("<br><b><u>").append(CodeStyleSettingsNameProvider.getSettingsTypeName(settingsType)).append("</u></b>");
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> groups2 = this.mySettings.get(settingsType);
            if (groups2 == null) continue;
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry2 : groups2.entrySet()) {
                boolean firstSettingGroupTop = entry2.getKey().isNull();
                boolean groupReported = false;
                for (CodeStyleSettingPresentation setting2 : entry2.getValue()) {
                    Value myValue = (Value)ContainerUtil.find(values2, value2 -> value2.state == Value.STATE.SELECTED && value2.name.equals(setting2.getFieldName()));
                    if (myValue == null) continue;
                    if (!groupReported) {
                        if (firstSettingGroupTop) {
                            builder2.append("<b>");
                        } else {
                            builder2.append("<br><b>").append(entry2.getKey().name).append("</b>");
                        }
                    }
                    builder2.append("<br>");
                    String postNameSign = setting2.getUiName().endsWith(":") ? " " : ": ";
                    builder2.append(setting2.getUiName()).append(postNameSign).append(setting2.getValueUiName(myValue.value));
                    if (!groupReported && firstSettingGroupTop) {
                        builder2.append("</b>");
                    }
                    groupReported = true;
                }
            }
        }
        return builder2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setting";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTitle";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newGroup";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/extractor/ui/CodeStyleSettingsNameProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addSetting";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "showCustomOption";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "renameStandardOption";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "moveStandardOption";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

