/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostFormatProcessorHelper {
    private final CommonCodeStyleSettings mySettings;
    private int myDelta;
    private TextRange myResultTextRange;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public PostFormatProcessorHelper(CodeStyleSettings rootSettings) {
        this.mySettings = rootSettings.getCommonSettings("");
    }

    public PostFormatProcessorHelper(CommonCodeStyleSettings settings) {
        this.mySettings = settings;
    }

    public CommonCodeStyleSettings getSettings() {
        return this.mySettings;
    }

    public void updateResultRange(int oldTextLength, int newTextLength) {
        if (this.myResultTextRange == null) {
            return;
        }
        int thisChange = newTextLength - oldTextLength;
        this.myDelta += thisChange;
        this.myResultTextRange = new TextRange(this.myResultTextRange.getStartOffset(), this.myResultTextRange.getEndOffset() + thisChange);
    }

    public int mapOffset(int sourceOffset) {
        return this.myDelta + sourceOffset;
    }

    @NotNull
    public TextRange mapRange(@NotNull TextRange sourceRange) {
        if (sourceRange == null) {
            PostFormatProcessorHelper.$$$reportNull$$$0(0);
        }
        return new TextRange(this.myDelta + sourceRange.getStartOffset(), this.myDelta + sourceRange.getEndOffset());
    }

    public boolean isElementPartlyInRange(@NotNull PsiElement element2) {
        if (element2 == null) {
            PostFormatProcessorHelper.$$$reportNull$$$0(1);
        }
        if (this.myResultTextRange == null) {
            return true;
        }
        TextRange elementRange = element2.getTextRange();
        if (elementRange.getEndOffset() < this.myResultTextRange.getStartOffset()) {
            return false;
        }
        return elementRange.getStartOffset() <= this.myResultTextRange.getEndOffset();
    }

    public boolean isElementFullyInRange(PsiElement element2) {
        if (this.myResultTextRange == null) {
            return true;
        }
        TextRange elementRange = element2.getTextRange();
        return elementRange.getStartOffset() >= this.myResultTextRange.getStartOffset() && elementRange.getEndOffset() <= this.myResultTextRange.getEndOffset();
    }

    public static boolean isMultiline(@Nullable PsiElement statement) {
        if (statement == null) {
            return false;
        }
        return statement.textContains('\n');
    }

    public void setResultTextRange(TextRange resultTextRange) {
        this.myResultTextRange = resultTextRange;
        this.myDelta = 0;
    }

    public TextRange getResultTextRange() {
        return this.myResultTextRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/PostFormatProcessorHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mapRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isElementPartlyInRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

