/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.impl.source.parsing.xml.XmlParsing;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.annotations.NotNull;

public class XmlParser
implements PsiParser,
LightPsiParser {
    private static final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> REPARSE_XML_TAG_BY_NAME = (oldNode, newNode, structure) -> {
        if (oldNode instanceof XmlTag && newNode.getTokenType() == XmlElementType.XML_TAG) {
            String oldName = ((XmlTag)oldNode).getName();
            Ref childrenRef = Ref.create(null);
            int count = structure.getChildren(newNode, childrenRef);
            if (count < 3) {
                return ThreeState.UNSURE;
            }
            LighterASTNode[] children2 = (LighterASTNode[])childrenRef.get();
            if (children2[0].getTokenType() != XmlTokenType.XML_START_TAG_START) {
                return ThreeState.UNSURE;
            }
            if (children2[1].getTokenType() != XmlTokenType.XML_NAME) {
                return ThreeState.UNSURE;
            }
            if (children2[2].getTokenType() != XmlTokenType.XML_TAG_END) {
                return ThreeState.UNSURE;
            }
            LighterASTTokenNode name2 = (LighterASTTokenNode)children2[1];
            CharSequence newName2 = name2.getText();
            if (!Comparing.equal((CharSequence)oldName, (CharSequence)newName2)) {
                return ThreeState.NO;
            }
        }
        return ThreeState.UNSURE;
    };

    @NotNull
    public ASTNode parse(@NotNull IElementType root2, @NotNull PsiBuilder builder2) {
        if (root2 == null) {
            XmlParser.$$$reportNull$$$0(0);
        }
        if (builder2 == null) {
            XmlParser.$$$reportNull$$$0(1);
        }
        this.parseLight(root2, builder2);
        ASTNode aSTNode = builder2.getTreeBuilt();
        if (aSTNode == null) {
            XmlParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    public void parseLight(IElementType root2, PsiBuilder builder2) {
        builder2.enforceCommentTokens(TokenSet.EMPTY);
        builder2.putUserData(PsiBuilderImpl.CUSTOM_COMPARATOR, REPARSE_XML_TAG_BY_NAME);
        PsiBuilder.Marker file2 = builder2.mark();
        new XmlParsing(builder2).parseDocument();
        file2.done(root2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/parsing/xml/XmlParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/parsing/xml/XmlParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

