/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.xml;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.ICustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.Stack;
import com.intellij.xml.psi.XmlPsiBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlParsing {
    private static final int BALANCING_DEPTH_THRESHOLD = 1000;
    protected final PsiBuilder myBuilder;
    private final Stack<String> myTagNamesStack = new Stack();

    public XmlParsing(PsiBuilder builder2) {
        this.myBuilder = builder2;
    }

    public void parseDocument() {
        PsiBuilder.Marker document = this.mark();
        while (this.isCommentToken(this.token())) {
            this.parseComment();
        }
        this.parseProlog();
        int rootTagCount = 0;
        PsiBuilder.Marker error = null;
        while (!this.eof()) {
            IElementType tt = this.token();
            if (tt == XmlElementType.XML_START_TAG_START) {
                error = XmlParsing.flushError(error);
                this.parseTag(++rootTagCount > 1);
                continue;
            }
            if (this.isCommentToken(tt)) {
                error = XmlParsing.flushError(error);
                this.parseComment();
                continue;
            }
            if (tt == XmlElementType.XML_PI_START) {
                error = XmlParsing.flushError(error);
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlElementType.XML_REAL_WHITE_SPACE) {
                error = XmlParsing.flushError(error);
                this.advance();
                continue;
            }
            if (error == null) {
                error = this.mark();
            }
            this.advance();
        }
        if (error != null) {
            error.error(XmlPsiBundle.message((String)"xml.parsing.top.level.element.is.not.completed", (Object[])new Object[0]));
        }
        if (rootTagCount == 0) {
            PsiBuilder.Marker rootTag = this.mark();
            error = this.mark();
            error.error(XmlPsiBundle.message((String)"xml.parsing.absent.root.tag", (Object[])new Object[0]));
            rootTag.done(XmlElementType.XML_TAG);
        }
        document.done(XmlElementType.XML_DOCUMENT);
    }

    @Nullable
    private static PsiBuilder.Marker flushError(PsiBuilder.Marker error) {
        if (error != null) {
            error.error(XmlPsiBundle.message((String)"xml.parsing.unexpected.tokens", (Object[])new Object[0]));
        }
        return null;
    }

    private void parseDoctype() {
        assert (this.token() == XmlElementType.XML_DOCTYPE_START) : "Doctype start expected";
        PsiBuilder.Marker doctype = this.mark();
        this.advance();
        while (this.token() != XmlElementType.XML_DOCTYPE_END && !this.eof()) {
            this.advance();
        }
        if (this.eof()) {
            this.error(XmlPsiBundle.message((String)"xml.parsing.unexpected.end.of.file", (Object[])new Object[0]));
        } else {
            this.advance();
        }
        doctype.done(XmlElementType.XML_DOCTYPE);
    }

    protected void parseTag(boolean multipleRootTagError) {
        assert (this.token() == XmlElementType.XML_START_TAG_START) : "Tag start expected";
        PsiBuilder.Marker tag2 = this.mark();
        String tagName = this.parseTagHeader(multipleRootTagError, tag2);
        if (tagName == null) {
            return;
        }
        PsiBuilder.Marker content2 = this.mark();
        this.parseTagContent();
        if (this.token() == XmlElementType.XML_END_TAG_START) {
            PsiBuilder.Marker footer = this.mark();
            this.advance();
            if (this.token() == XmlElementType.XML_NAME) {
                String endName = this.myBuilder.getTokenText();
                if (!tagName.equals(endName) && this.myTagNamesStack.contains((Object)endName)) {
                    footer.rollbackTo();
                    this.myTagNamesStack.pop();
                    tag2.doneBefore(XmlElementType.XML_TAG, content2, XmlPsiBundle.message((String)"xml.parsing.named.element.is.not.closed", (Object[])new Object[]{tagName}));
                    content2.drop();
                    return;
                }
                this.advance();
            } else {
                this.error(XmlPsiBundle.message((String)"xml.parsing.closing.tag.name.missing", (Object[])new Object[0]));
            }
            footer.drop();
            while (this.token() != XmlTokenType.XML_TAG_END && this.token() != XmlTokenType.XML_START_TAG_START && this.token() != XmlTokenType.XML_END_TAG_START && !this.eof()) {
                this.error(XmlPsiBundle.message((String)"xml.parsing.unexpected.token", (Object[])new Object[0]));
                this.advance();
            }
            if (this.token() == XmlElementType.XML_TAG_END) {
                this.advance();
            } else {
                this.error(XmlPsiBundle.message((String)"xml.parsing.closing.tag.is.not.done", (Object[])new Object[0]));
            }
        } else {
            this.error(XmlPsiBundle.message((String)"xml.parsing.unexpected.end.of.file", (Object[])new Object[0]));
        }
        content2.drop();
        this.myTagNamesStack.pop();
        tag2.done(XmlElementType.XML_TAG);
    }

    @Nullable
    private String parseTagHeader(boolean multipleRootTagError, PsiBuilder.Marker tag2) {
        String tagName;
        if (multipleRootTagError) {
            PsiBuilder.Marker error = this.mark();
            this.advance();
            error.error(XmlPsiBundle.message((String)"xml.parsing.multiple.root.tags", (Object[])new Object[0]));
        } else {
            this.advance();
        }
        if (this.token() != XmlElementType.XML_NAME || this.myBuilder.rawLookup(-1) == TokenType.WHITE_SPACE) {
            this.error(XmlPsiBundle.message((String)"xml.parsing.tag.name.expected", (Object[])new Object[0]));
            tagName = "";
        } else {
            tagName = this.myBuilder.getTokenText();
            assert (tagName != null);
            this.advance();
        }
        this.myTagNamesStack.push((Object)tagName);
        while (true) {
            IElementType tt;
            if ((tt = this.token()) == XmlElementType.XML_NAME) {
                this.parseAttribute();
                continue;
            }
            if (tt != XmlElementType.XML_CHAR_ENTITY_REF && tt != XmlElementType.XML_ENTITY_REF_TOKEN) break;
            this.parseReference();
        }
        if (this.token() == XmlElementType.XML_EMPTY_ELEMENT_END) {
            this.advance();
            this.myTagNamesStack.pop();
            tag2.done(XmlElementType.XML_TAG);
            return null;
        }
        if (this.token() != XmlElementType.XML_TAG_END) {
            this.error(XmlPsiBundle.message((String)"xml.parsing.tag.start.is.not.closed", (Object[])new Object[0]));
            this.myTagNamesStack.pop();
            tag2.done(XmlElementType.XML_TAG);
            return null;
        }
        this.advance();
        if (this.myTagNamesStack.size() > 1000) {
            this.error(XmlPsiBundle.message((String)"xml.parsing.way.too.unbalanced", (Object[])new Object[0]));
            tag2.done(XmlElementType.XML_TAG);
            return null;
        }
        return tagName;
    }

    public void parseTagContent() {
        IElementType tt;
        PsiBuilder.Marker xmlText = null;
        while ((tt = this.token()) != null && tt != XmlElementType.XML_END_TAG_START) {
            if (tt == XmlElementType.XML_START_TAG_START) {
                xmlText = XmlParsing.terminateText(xmlText);
                this.parseTag(false);
                continue;
            }
            if (tt == XmlElementType.XML_PI_START) {
                xmlText = XmlParsing.terminateText(xmlText);
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlElementType.XML_ENTITY_REF_TOKEN) {
                xmlText = XmlParsing.terminateText(xmlText);
                this.parseReference();
                continue;
            }
            if (tt == XmlElementType.XML_CHAR_ENTITY_REF) {
                xmlText = this.startText(xmlText);
                this.parseReference();
                continue;
            }
            if (tt == XmlElementType.XML_CDATA_START) {
                xmlText = this.startText(xmlText);
                this.parseCData();
                continue;
            }
            if (this.isCommentToken(tt)) {
                xmlText = XmlParsing.terminateText(xmlText);
                this.parseComment();
                continue;
            }
            if (tt == XmlElementType.XML_BAD_CHARACTER) {
                xmlText = this.startText(xmlText);
                PsiBuilder.Marker error = this.mark();
                this.advance();
                error.error(XmlPsiBundle.message((String)"xml.parsing.unescaped.ampersand.or.nonterminated.character.entity.reference", (Object[])new Object[0]));
                continue;
            }
            if (tt instanceof ICustomParsingType || tt instanceof ILazyParseableElementType) {
                xmlText = XmlParsing.terminateText(xmlText);
                this.advance();
                continue;
            }
            xmlText = this.startText(xmlText);
            this.advance();
        }
        XmlParsing.terminateText(xmlText);
    }

    protected boolean isCommentToken(IElementType tt) {
        return tt == XmlElementType.XML_COMMENT_START;
    }

    @NotNull
    private PsiBuilder.Marker startText(@Nullable PsiBuilder.Marker xmlText) {
        if (xmlText == null) {
            xmlText = this.mark();
        }
        PsiBuilder.Marker marker = xmlText;
        if (marker == null) {
            XmlParsing.$$$reportNull$$$0(0);
        }
        return marker;
    }

    protected final PsiBuilder.Marker mark() {
        return this.myBuilder.mark();
    }

    @Nullable
    private static PsiBuilder.Marker terminateText(@Nullable PsiBuilder.Marker xmlText) {
        if (xmlText != null) {
            xmlText.done(XmlElementType.XML_TEXT);
        }
        return null;
    }

    private void parseCData() {
        assert (this.token() == XmlElementType.XML_CDATA_START);
        PsiBuilder.Marker cdata = this.mark();
        while (this.token() != XmlElementType.XML_CDATA_END && !this.eof()) {
            this.advance();
        }
        if (!this.eof()) {
            this.advance();
        }
        cdata.done(XmlElementType.XML_CDATA);
    }

    protected void parseComment() {
        IElementType tt;
        PsiBuilder.Marker comment = this.mark();
        this.advance();
        while (true) {
            if ((tt = this.token()) == XmlElementType.XML_COMMENT_CHARACTERS || tt == XmlElementType.XML_CONDITIONAL_COMMENT_START || tt == XmlElementType.XML_CONDITIONAL_COMMENT_START_END || tt == XmlElementType.XML_CONDITIONAL_COMMENT_END_START || tt == XmlElementType.XML_CONDITIONAL_COMMENT_END) {
                this.advance();
                continue;
            }
            if (tt != XmlElementType.XML_BAD_CHARACTER) break;
            PsiBuilder.Marker error = this.mark();
            this.advance();
            error.error(XmlPsiBundle.message((String)"xml.parsing.bad.character", (Object[])new Object[0]));
        }
        if (tt == XmlElementType.XML_COMMENT_END) {
            this.advance();
        }
        comment.done(XmlElementType.XML_COMMENT);
    }

    private void parseReference() {
        if (this.token() == XmlElementType.XML_CHAR_ENTITY_REF) {
            this.advance();
        } else if (this.token() == XmlElementType.XML_ENTITY_REF_TOKEN) {
            PsiBuilder.Marker ref = this.mark();
            this.advance();
            ref.done(XmlElementType.XML_ENTITY_REF);
        } else assert (false) : "Unexpected token";
    }

    private void parseAttribute() {
        assert (this.token() == XmlElementType.XML_NAME);
        PsiBuilder.Marker att = this.mark();
        this.advance();
        if (this.token() == XmlElementType.XML_EQ) {
            this.advance();
            this.parseAttributeValue();
        } else {
            this.error(XmlPsiBundle.message((String)"xml.parsing.expected.attribute.eq.sign", (Object[])new Object[0]));
        }
        att.done(XmlElementType.XML_ATTRIBUTE);
    }

    private void parseAttributeValue() {
        PsiBuilder.Marker attValue = this.mark();
        if (this.token() == XmlElementType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            IElementType tt;
            while ((tt = this.token()) != null && tt != XmlElementType.XML_ATTRIBUTE_VALUE_END_DELIMITER && tt != XmlElementType.XML_END_TAG_START && tt != XmlElementType.XML_EMPTY_ELEMENT_END && tt != XmlElementType.XML_START_TAG_START) {
                if (tt == XmlElementType.XML_BAD_CHARACTER) {
                    PsiBuilder.Marker error = this.mark();
                    this.advance();
                    error.error(XmlPsiBundle.message((String)"xml.parsing.unescaped.ampersand.or.nonterminated.character.entity.reference", (Object[])new Object[0]));
                    continue;
                }
                if (tt == XmlElementType.XML_ENTITY_REF_TOKEN) {
                    this.parseReference();
                    continue;
                }
                this.advance();
            }
            if (this.token() == XmlElementType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.advance();
            } else {
                this.error(XmlPsiBundle.message((String)"xml.parsing.unclosed.attribute.value", (Object[])new Object[0]));
            }
        } else {
            this.error(XmlPsiBundle.message((String)"xml.parsing.attribute.value.expected", (Object[])new Object[0]));
        }
        attValue.done(XmlElementType.XML_ATTRIBUTE_VALUE);
    }

    private void parseProlog() {
        PsiBuilder.Marker prolog = this.mark();
        while (true) {
            IElementType tt;
            if ((tt = this.token()) == XmlElementType.XML_PI_START) {
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlElementType.XML_DOCTYPE_START) {
                this.parseDoctype();
                continue;
            }
            if (this.isCommentToken(tt)) {
                this.parseComment();
                continue;
            }
            if (tt != XmlElementType.XML_REAL_WHITE_SPACE) break;
            this.advance();
        }
        prolog.done(XmlElementType.XML_PROLOG);
    }

    private void parseProcessingInstruction() {
        assert (this.token() == XmlElementType.XML_PI_START);
        PsiBuilder.Marker pi = this.mark();
        this.advance();
        if (this.token() != XmlElementType.XML_NAME) {
            this.error(XmlPsiBundle.message((String)"xml.parsing.processing.instruction.name.expected", (Object[])new Object[0]));
        } else {
            this.advance();
        }
        IElementType tokenType = this.token();
        if (tokenType == XmlElementType.XML_TAG_CHARACTERS) {
            while (this.token() == XmlElementType.XML_TAG_CHARACTERS) {
                this.advance();
            }
        } else {
            while (this.token() == XmlElementType.XML_NAME) {
                this.advance();
                if (this.token() == XmlElementType.XML_EQ) {
                    this.advance();
                } else {
                    this.error(XmlPsiBundle.message((String)"xml.parsing.expected.attribute.eq.sign", (Object[])new Object[0]));
                }
                this.parseAttributeValue();
            }
        }
        if (this.token() == XmlElementType.XML_PI_END) {
            this.advance();
        } else {
            this.error(XmlPsiBundle.message((String)"xml.parsing.unterminated.processing.instruction", (Object[])new Object[0]));
        }
        pi.done(XmlElementType.XML_PROCESSING_INSTRUCTION);
    }

    @Nullable
    protected final IElementType token() {
        return this.myBuilder.getTokenType();
    }

    protected final boolean eof() {
        return this.myBuilder.eof();
    }

    protected final void advance() {
        this.myBuilder.advanceLexer();
    }

    private void error(@NotNull @NlsContexts.ParsingError String message2) {
        if (message2 == null) {
            XmlParsing.$$$reportNull$$$0(1);
        }
        this.myBuilder.error(message2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/parsing/xml/XmlParsing";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "startText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/parsing/xml/XmlParsing";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

