/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class URLReference
implements PsiReference,
EmptyResolveMessageProvider {
    @NonNls
    public static final String TARGET_NAMESPACE_ATTR_NAME = "targetNamespace";
    private final PsiElement myElement;
    private final TextRange myRange;
    private final boolean mySoft;
    private boolean myIncorrectResourceMapped;

    public URLReference(PsiElement element2) {
        this(element2, null, false);
    }

    public URLReference(PsiElement element2, @Nullable TextRange range2, boolean soft) {
        this.myElement = element2;
        this.myRange = range2;
        this.mySoft = soft;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            URLReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange != null ? this.myRange : ElementManipulators.getValueTextRange((PsiElement)this.myElement);
        if (textRange == null) {
            URLReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        PsiFile file2;
        this.myIncorrectResourceMapped = false;
        String canonicalText = this.getCanonicalText();
        if (canonicalText.isEmpty()) {
            XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlAttribute.class);
            if (attr != null && attr.isNamespaceDeclaration() && attr.getNamespacePrefix().isEmpty() || ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(canonicalText)) {
                return this.myElement;
            }
            return null;
        }
        if (ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(canonicalText)) {
            return this.myElement;
        }
        XmlTag tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
        if (tag2 != null && canonicalText.equals(tag2.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME))) {
            return tag2;
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        if (tag2 != null && tag2.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance") == null && (file2 = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, containingFile, tag2.getAttributeValue("version"))) != null) {
            return file2;
        }
        if (containingFile instanceof XmlFile) {
            XmlDocument document = ((XmlFile)containingFile).getDocument();
            assert (document != null);
            XmlTag rootTag = document.getRootTag();
            if (rootTag == null) {
                return ExternalResourceManager.getInstance().getResourceLocation(canonicalText, containingFile, null);
            }
            XmlNSDescriptor nsDescriptor = rootTag.getNSDescriptor(canonicalText, true);
            if (nsDescriptor != null) {
                return nsDescriptor.getDescriptorFile();
            }
            String url = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, this.myElement.getProject());
            if (!url.equals(canonicalText)) {
                PsiFile file3 = XmlUtil.findRelativeFile(canonicalText, (PsiElement)this.myElement.getContainingFile());
                if (file3 == null) {
                    this.myIncorrectResourceMapped = true;
                }
                return file3;
            }
            if (tag2 == rootTag && (tag2.getNamespace().equals("http://www.w3.org/2001/XMLSchema") || tag2.getNamespace().equals("http://schemas.xmlsoap.org/wsdl/"))) {
                for (XmlTag t2 : tag2.getSubTags()) {
                    String name2 = t2.getLocalName();
                    if ("import".equals(name2)) {
                        if (!canonicalText.equals(t2.getAttributeValue("namespace"))) continue;
                        return t2;
                    }
                    if (!"include".equals(name2) && !"redefine".equals(name2) && !"annotation".equals(name2)) break;
                }
            }
            PsiElement[] result2 = new PsiElement[1];
            URLReference.processWsdlSchemas(rootTag, (Processor<? super XmlTag>)((Processor)t -> {
                if (canonicalText.equals(t.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME))) {
                    result2[0] = t;
                    return false;
                }
                for (XmlTag anImport : t.findSubTags("import", t.getNamespace())) {
                    XmlAttribute location;
                    if (!canonicalText.equals(anImport.getAttributeValue("namespace")) || (location = anImport.getAttribute("schemaLocation")) == null) continue;
                    result2[0] = FileReferenceUtil.findFile((PsiElement)location.getValueElement());
                }
                return true;
            }));
            return result2[0];
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String text2 = this.myElement.getText();
        if (text2.length() > 1) {
            String string = this.myRange == null ? text2.substring(1, text2.length() - 1) : this.myRange.substring(text2);
            if (string == null) {
                URLReference.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "";
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            URLReference.$$$reportNull$$$0(3);
        }
        TextRange textRangeInElement = this.getRangeInElement();
        PsiElement elementToChange = this.myElement.findElementAt(textRangeInElement.getStartOffset());
        assert (elementToChange != null);
        int offsetFromStart = this.myElement.getTextRange().getStartOffset() + textRangeInElement.getStartOffset() - elementToChange.getTextOffset();
        ElementManipulators.handleContentChange((PsiElement)elementToChange, (TextRange)new TextRange(offsetFromStart, offsetFromStart + textRangeInElement.getLength()), (String)newElementName);
        return this.myElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            URLReference.$$$reportNull$$$0(4);
        }
        assert (element2 instanceof PsiFile);
        if (!XmlUtil.isUrlText(this.getCanonicalText(), element2.getProject())) {
            VirtualFile virtualFile2 = ((PsiFile)element2).getVirtualFile();
            assert (virtualFile2 != null);
            this.handleElementRename(VfsUtilCore.fixIDEAUrl((String)virtualFile2.getPresentableUrl()));
        }
        return this.myElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement element2) {
        if (element2 == null) {
            URLReference.$$$reportNull$$$0(5);
        }
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), element2);
    }

    public boolean isSchemaLocation() {
        return false;
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = XmlPsiBundle.message((String)(this.myIncorrectResourceMapped ? "xml.inspections.registered.resource.is.not.recognized" : "xml.inspections.uri.is.not.registered"), (Object[])new Object[0]);
        if (string == null) {
            URLReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void processWsdlSchemas(XmlTag rootTag, Processor<? super XmlTag> processor2) {
        String nsPrefix;
        Object types;
        XmlTag subTag;
        if ("definitions".equals(rootTag.getLocalName()) && (subTag = rootTag.findFirstSubTag((String)(types = (nsPrefix = rootTag.getNamespacePrefix()).isEmpty() ? "types" : nsPrefix + ":types"))) != null) {
            for (int i2 = 0; i2 < XmlUtil.SCHEMA_URIS.length; ++i2) {
                XmlTag[] tags;
                for (XmlTag t : tags = subTag.findSubTags("schema", XmlUtil.SCHEMA_URIS[i2])) {
                    if (processor2.process((Object)t)) continue;
                    return;
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

