/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeReference
implements PsiPolyVariantReference {
    private final NullableLazyValue<XmlAttributeDescriptor> myDescriptor;
    private final XmlAttribute myAttribute;

    public XmlAttributeReference(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XmlAttributeReference.$$$reportNull$$$0(0);
        }
        this.myDescriptor = new NullableLazyValue<XmlAttributeDescriptor>(){

            protected XmlAttributeDescriptor compute() {
                return XmlAttributeReference.this.myAttribute.getDescriptor();
            }
        };
        this.myAttribute = attribute;
    }

    @NotNull
    public XmlAttribute getElement() {
        XmlAttribute xmlAttribute = this.myAttribute;
        if (xmlAttribute == null) {
            XmlAttributeReference.$$$reportNull$$$0(1);
        }
        return xmlAttribute;
    }

    @NotNull
    public TextRange getRangeInElement() {
        int parentOffset = this.myAttribute.getNameElement().getStartOffsetInParent();
        int nsLen = this.myAttribute.getNamespacePrefix().length();
        String realName = XmlAttributeImpl.getRealName(this.myAttribute);
        return new TextRange(parentOffset + (nsLen += nsLen > 0 && !realName.isEmpty() ? 1 : -nsLen), parentOffset + this.myAttribute.getNameElement().getTextLength());
    }

    public PsiElement resolve() {
        XmlAttributeDescriptor descriptor2 = this.getDescriptor();
        return descriptor2 != null ? descriptor2.getDeclaration() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myAttribute.getName();
        if (string == null) {
            XmlAttributeReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        XmlAttributeDescriptor descriptor2 = this.getDescriptor();
        ResolveResult[] resolveResultArray = descriptor2 != null ? PsiElementResolveResult.createResults((Collection)descriptor2.getDeclarations()) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            XmlAttributeReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        XmlAttributeDescriptorEx xmlAttributeDescriptorEx;
        String s;
        if (newElementName == null) {
            XmlAttributeReference.$$$reportNull$$$0(4);
        }
        String newName2 = newElementName;
        if (this.getDescriptor() instanceof XmlAttributeDescriptorEx && (s = (xmlAttributeDescriptorEx = (XmlAttributeDescriptorEx)this.getDescriptor()).handleTargetRename(newElementName)) != null) {
            String prefix = this.myAttribute.getNamespacePrefix();
            newName2 = StringUtil.isEmpty((String)prefix) ? s : prefix + ":" + s;
        }
        return this.myAttribute.setName(newName2);
    }

    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        PsiMetaOwner owner;
        if (element2 == null) {
            XmlAttributeReference.$$$reportNull$$$0(5);
        }
        if (element2 instanceof PsiMetaOwner && (owner = (PsiMetaOwner)element2).getMetaData() instanceof XmlElementDescriptor) {
            this.myAttribute.setName(owner.getMetaData().getName());
        }
        throw new IncorrectOperationException("Cant bind to not a xml element definition!");
    }

    public boolean isReferenceTo(@NotNull PsiElement element2) {
        if (element2 == null) {
            XmlAttributeReference.$$$reportNull$$$0(6);
        }
        PsiManager manager2 = this.getElement().getManager();
        return ContainerUtil.exists((Object[])this.multiResolve(false), result2 -> result2.isValidResult() && manager2.areElementsEquivalent(element2, result2.getElement()));
    }

    public Object @NotNull [] getVariants() {
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            XmlAttributeReference.$$$reportNull$$$0(7);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return this.getDescriptor() == null;
    }

    @Nullable
    protected XmlAttributeDescriptor getDescriptor() {
        return (XmlAttributeDescriptor)this.myDescriptor.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlAttributeReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlAttributeReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

