/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FileTypeNameEnumerator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UnindexedFilesUpdaterListener;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.storage.AbstractIntLog;
import com.intellij.util.indexing.impl.storage.IntLog;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import com.intellij.util.io.StorageLockContext;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LogFileTypeIndex
implements UpdatableIndex<FileType, Void, FileContent>,
FileTypeNameEnumerator {
    private static final Logger LOG = Logger.getInstance(LogFileTypeIndex.class);
    @NotNull
    private final SLRUMap<Integer, Integer> myForwardIndexCache;
    @NotNull
    private final SLRUMap<Integer, IntSeq> myInvertedIndexCache;
    @NotNull
    private final MemorySnapshotHandler myMemorySnapshotHandler;
    @NotNull
    private final Disposable myDisposable;
    @NotNull
    private final LogBasedIntIntIndex myPersistentLog;
    @NotNull
    private final SimpleStringPersistentEnumerator myFileTypeEnumerator;
    @NotNull
    private final ConcurrentIntObjectMap<Ref<FileType>> myId2FileTypeCache;
    @NotNull
    private final ConcurrentIntObjectMap<Ref<String>> myId2FileNameCache;
    @NotNull
    private final FileBasedIndexExtension<FileType, Void> myExtension;
    @NotNull
    private final ReadWriteLock myLock;
    @NotNull
    private final AtomicBoolean myInMemoryMode;
    @NotNull
    private final ID<FileType, Void> myIndexId;

    public LogFileTypeIndex(@NotNull FileBasedIndexExtension<FileType, Void> extension2) throws IOException {
        if (extension2 == null) {
            LogFileTypeIndex.$$$reportNull$$$0(0);
        }
        this.myId2FileTypeCache = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.myId2FileNameCache = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.myLock = new ReentrantReadWriteLock();
        this.myInMemoryMode = new AtomicBoolean();
        this.myExtension = extension2;
        this.myIndexId = extension2.getName();
        Path storageFile = IndexInfrastructure.getStorageFile(this.myIndexId);
        this.myPersistentLog = new LogBasedIntIntIndex(new IntLog(storageFile.resolveSibling(storageFile.getFileName().toString() + ".log.index"), true, new StorageLockContext(true, false, true)));
        this.myFileTypeEnumerator = new SimpleStringPersistentEnumerator(IndexInfrastructure.getStorageFile(this.myIndexId).resolveSibling("fileType.enum"));
        int cacheSize = extension2.getCacheSize();
        this.myForwardIndexCache = new SLRUMap(cacheSize, (int)Math.ceil((double)cacheSize * 0.25));
        this.myInvertedIndexCache = new SLRUMap(cacheSize, (int)Math.ceil((double)cacheSize * 0.25));
        if (this.myExtension.dependsOnFileContent()) {
            throw new IllegalArgumentException(this.myExtension.getName() + " should not depend on content");
        }
        this.myDisposable = Disposer.newDisposable();
        this.myMemorySnapshotHandler = new MemorySnapshotHandler();
    }

    @Override
    public boolean processAllKeys(@NotNull Processor<? super FileType> processor2, @NotNull GlobalSearchScope scope2, @Nullable IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            LogFileTypeIndex.$$$reportNull$$$0(1);
        }
        if (scope2 == null) {
            LogFileTypeIndex.$$$reportNull$$$0(2);
        }
        for (String fileTypeName : this.myFileTypeEnumerator.entries()) {
            FileType fileType = FileTypeManager.getInstance().findFileTypeByName(fileTypeName);
            if (fileType == null || processor2.process((Object)fileType)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ReadWriteLock getLock() {
        ReadWriteLock readWriteLock = this.myLock;
        if (readWriteLock == null) {
            LogFileTypeIndex.$$$reportNull$$$0(3);
        }
        return readWriteLock;
    }

    @Override
    @NotNull
    public Map<FileType, Void> getIndexedFileData(int fileId) throws StorageException {
        int foundData = this.getIndexedFileTypeId(fileId);
        if (foundData == 0) {
            Map<FileType, Void> map2 = Collections.emptyMap();
            if (map2 == null) {
                LogFileTypeIndex.$$$reportNull$$$0(4);
            }
            return map2;
        }
        Map<FileType, Object> map3 = Collections.singletonMap(this.getFileTypeById(foundData), null);
        if (map3 == null) {
            LogFileTypeIndex.$$$reportNull$$$0(5);
        }
        return map3;
    }

    @Override
    public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            LogFileTypeIndex.$$$reportNull$$$0(6);
        }
        IndexingStamp.setFileIndexedStateCurrent(fileId, this.myIndexId);
    }

    @Override
    public void invalidateIndexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateOutdated(fileId, this.myIndexId);
    }

    @Override
    public void setUnindexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateUnindexed(fileId, this.myIndexId);
    }

    @Override
    @NotNull
    public FileIndexingState getIndexingStateForFile(int fileId, @NotNull IndexedFile file2) {
        int indexedFileTypeId;
        block9: {
            FileIndexingState fileIndexingState;
            FileIndexingState isIndexed;
            if (file2 == null) {
                LogFileTypeIndex.$$$reportNull$$$0(7);
            }
            if ((isIndexed = IndexingStamp.isFileIndexedStateCurrent(fileId, this.myIndexId)) != FileIndexingState.UP_TO_DATE) {
                FileIndexingState fileIndexingState2 = isIndexed;
                if (fileIndexingState2 == null) {
                    LogFileTypeIndex.$$$reportNull$$$0(8);
                }
                return fileIndexingState2;
            }
            try {
                indexedFileTypeId = this.getIndexedFileTypeId(fileId);
                if (indexedFileTypeId != 0) break block9;
                fileIndexingState = isIndexed;
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
                FileIndexingState fileIndexingState3 = FileIndexingState.OUT_DATED;
                if (fileIndexingState3 == null) {
                    LogFileTypeIndex.$$$reportNull$$$0(11);
                }
                return fileIndexingState3;
            }
            if (fileIndexingState == null) {
                LogFileTypeIndex.$$$reportNull$$$0(9);
            }
            return fileIndexingState;
        }
        int actualFileTypeId = this.getFileTypeId(file2.getFileType());
        FileIndexingState fileIndexingState = indexedFileTypeId == actualFileTypeId ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        if (fileIndexingState == null) {
            LogFileTypeIndex.$$$reportNull$$$0(10);
        }
        return fileIndexingState;
    }

    @Override
    public long getModificationStamp() {
        return this.myPersistentLog.getModificationStamp();
    }

    @Override
    public void removeTransientDataForFile(int inputId) {
    }

    @Override
    @NotNull
    public IndexExtension<FileType, Void, FileContent> getExtension() {
        FileBasedIndexExtension<FileType, Void> fileBasedIndexExtension = this.myExtension;
        if (fileBasedIndexExtension == null) {
            LogFileTypeIndex.$$$reportNull$$$0(12);
        }
        return fileBasedIndexExtension;
    }

    @Override
    public void removeTransientDataForKeys(int inputId, @NotNull InputDataDiffBuilder<FileType, Void> diffBuilder) {
        if (diffBuilder == null) {
            LogFileTypeIndex.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateWithMap(@NotNull AbstractUpdateData<FileType, Void> updateData) throws StorageException {
        if (updateData == null) {
            LogFileTypeIndex.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBufferingEnabled(boolean enabled) {
        this.myInMemoryMode.set(enabled);
    }

    @Override
    public void cleanupMemoryStorage() {
    }

    @Override
    public void cleanupForNextTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ValueContainer<Void> getData(@NotNull FileType type) throws StorageException {
        if (type == null) {
            LogFileTypeIndex.$$$reportNull$$$0(15);
        }
        int fileTypeId = this.getFileTypeId(type);
        ValueContainerImpl result2 = new ValueContainerImpl();
        this.myLock.readLock().lock();
        try {
            IntSeq fileIds;
            IntSeq cachedFileIds = this.getInputIdsFromCache(fileTypeId);
            if (cachedFileIds == null) {
                MemorySnapshot snapshot = this.myMemorySnapshotHandler.getSnapshot();
                fileIds = snapshot != null ? snapshot.getFileIds(fileTypeId) : this.myPersistentLog.getFileIds(fileTypeId);
                this.cacheInputIds(fileTypeId, fileIds);
            } else {
                fileIds = cachedFileIds;
            }
            fileIds.forEach(id2 -> result2.addValue(id2, null));
        }
        finally {
            this.myLock.readLock().unlock();
        }
        ValueContainerImpl valueContainerImpl = result2;
        if (valueContainerImpl == null) {
            LogFileTypeIndex.$$$reportNull$$$0(16);
        }
        return valueContainerImpl;
    }

    @NotNull
    public Computable<Boolean> mapInputAndPrepareUpdate(int inputId, @Nullable FileContent content2) {
        Computable computable;
        try {
            int fileTypeId = this.getFileTypeId(content2 == null ? null : content2.getFileType());
            computable = () -> this.updateIndex(fileTypeId, inputId);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
        if (computable == null) {
            LogFileTypeIndex.$$$reportNull$$$0(17);
        }
        return computable;
    }

    private FileType getFileTypeById(int id2) {
        assert (id2 < Short.MAX_VALUE) : "file type id = " + id2;
        Ref fileType = (Ref)this.myId2FileTypeCache.get(id2);
        if (fileType == null) {
            String fileTypeName = this.myFileTypeEnumerator.valueOf((short)id2);
            FileType fileTypeByName = fileTypeName == null ? null : FileTypeManager.getInstance().findFileTypeByName(fileTypeName);
            fileType = Ref.create((Object)fileTypeByName);
            this.myId2FileTypeCache.put(id2, (Object)fileType);
        }
        return (FileType)fileType.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIndexedFileTypeId(int fileId) throws StorageException {
        this.myLock.readLock().lock();
        try {
            int data2 = this.getFileTypeIdFromCache(fileId);
            if (data2 != 0) {
                int n = data2;
                return n;
            }
            MemorySnapshot snapshot = this.myMemorySnapshotHandler.getSnapshot();
            data2 = snapshot != null ? snapshot.getIndexedData(fileId) : this.myPersistentLog.getIndexedData(fileId);
            this.updateForwardIndexCache(fileId, data2);
            int n = data2;
            return n;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    private int getFileTypeId(@Nullable FileType fileType) throws StorageException {
        if (fileType == null) {
            return 0;
        }
        try {
            return this.getFileTypeId(fileType.getName());
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Boolean updateIndex(int fileTypeId, int inputId) {
        this.myLock.writeLock().lock();
        try {
            boolean cacheModified;
            boolean snapshotModified;
            if (this.myInMemoryMode.get()) {
                throw new IllegalStateException("file type index should not be updated for unsaved changes");
            }
            boolean memoryDataUpdated = true;
            MemorySnapshot snapshot = this.myMemorySnapshotHandler.getSnapshot();
            if (snapshot != null && !(snapshotModified = snapshot.addData(fileTypeId, inputId))) {
                memoryDataUpdated = false;
            }
            if (!(cacheModified = this.updateForwardIndexCache(inputId, fileTypeId))) {
                memoryDataUpdated = false;
            }
            if (memoryDataUpdated) {
                this.myPersistentLog.addData(fileTypeId, inputId);
                this.clearInvertedIndexCache();
            }
        }
        catch (StorageException e) {
            LOG.error((Throwable)e);
            Boolean bl = Boolean.FALSE;
            Boolean bl2 = bl;
            if (bl2 == null) {
                LogFileTypeIndex.$$$reportNull$$$0(18);
            }
            return bl2;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
        Boolean bl = Boolean.TRUE;
        if (bl == null) {
            LogFileTypeIndex.$$$reportNull$$$0(19);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInvertedIndexCache() {
        SLRUMap<Integer, IntSeq> sLRUMap = this.myInvertedIndexCache;
        synchronized (sLRUMap) {
            this.myInvertedIndexCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheInputIds(int fileTypeId, IntSeq inputIds) {
        IntSeq copy2 = inputIds.copy();
        SLRUMap<Integer, IntSeq> sLRUMap = this.myInvertedIndexCache;
        synchronized (sLRUMap) {
            this.myInvertedIndexCache.put((Object)fileTypeId, (Object)copy2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private IntSeq getInputIdsFromCache(int fileTypeId) {
        SLRUMap<Integer, IntSeq> sLRUMap = this.myInvertedIndexCache;
        synchronized (sLRUMap) {
            return (IntSeq)this.myInvertedIndexCache.get((Object)fileTypeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFileTypeIdFromCache(int fileId) {
        SLRUMap<Integer, Integer> sLRUMap = this.myForwardIndexCache;
        synchronized (sLRUMap) {
            Integer data2 = (Integer)this.myForwardIndexCache.get((Object)fileId);
            if (data2 != null) {
                return data2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateForwardIndexCache(int inputId, int fileTypeId) {
        SLRUMap<Integer, Integer> sLRUMap = this.myForwardIndexCache;
        synchronized (sLRUMap) {
            Integer currentFileTypeId = (Integer)this.myForwardIndexCache.get((Object)inputId);
            if (currentFileTypeId != null && fileTypeId == currentFileTypeId) {
                return false;
            }
            this.myForwardIndexCache.put((Object)inputId, (Object)fileTypeId);
            return true;
        }
    }

    public void flush() throws StorageException {
        this.clearCache();
        try {
            this.myPersistentLog.flush();
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void clear() throws StorageException {
        this.clearCache();
        this.myMemorySnapshotHandler.mySnapshot = null;
        this.myPersistentLog.clear();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
        try {
            this.myPersistentLog.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getFileTypeId(String name2) throws IOException {
        return this.myFileTypeEnumerator.enumerate(name2);
    }

    @Override
    public String getFileTypeName(int id2) throws IOException {
        assert (id2 < Short.MAX_VALUE);
        Ref fileType = (Ref)this.myId2FileNameCache.get(id2);
        if (fileType == null) {
            String fileTypeName = this.myFileTypeEnumerator.valueOf((short)id2);
            fileType = Ref.create((Object)fileTypeName);
            this.myId2FileNameCache.put(id2, (Object)fileType);
        }
        return (String)fileType.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        SLRUMap<Integer, Integer> sLRUMap = this.myForwardIndexCache;
        synchronized (sLRUMap) {
            this.myForwardIndexCache.clear();
        }
        this.clearInvertedIndexCache();
    }

    private static boolean setForwardIndexData(@NotNull IntList forwardIndex, int data2, int inputId) {
        if (forwardIndex == null) {
            LogFileTypeIndex.$$$reportNull$$$0(20);
        }
        if (inputId >= forwardIndex.size()) {
            forwardIndex.size((inputId + 1) * 3 / 2);
        }
        return data2 != forwardIndex.set(inputId, data2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/LogFileTypeIndex";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffBuilder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingStateForFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInputAndPrepareUpdate";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "updateIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedStateForFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStateForFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateWithMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setForwardIndexData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface IntSeq {
        public static final IntSeq EMPTY = new IntSeq(){

            @Override
            public void forEach(@NotNull IntConsumer consumer2) {
                if (consumer2 == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @Override
            @NotNull
            public IntSeq copy() {
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return v0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/search/LogFileTypeIndex$IntSeq$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$IntSeq$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "copy";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "forEach";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        public void forEach(@NotNull IntConsumer var1);

        @NotNull
        public IntSeq copy();

        public static class FromIntSet
        implements IntSeq {
            private final IntSet myIntSet;

            private FromIntSet(@NotNull IntSet set2) {
                if (set2 == null) {
                    FromIntSet.$$$reportNull$$$0(0);
                }
                this.myIntSet = set2;
            }

            @Override
            public void forEach(@NotNull IntConsumer consumer2) {
                if (consumer2 == null) {
                    FromIntSet.$$$reportNull$$$0(1);
                }
                this.myIntSet.forEach(consumer2);
            }

            @Override
            @NotNull
            public IntSeq copy() {
                return new FromIntSet((IntSet)new IntOpenHashSet((IntCollection)this.myIntSet));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$IntSeq$FromIntSet";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "forEach";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        public static class FromBitSet
        implements IntSeq {
            private final BitSet myBitSet;

            private FromBitSet(@NotNull BitSet set2) {
                if (set2 == null) {
                    FromBitSet.$$$reportNull$$$0(0);
                }
                this.myBitSet = set2;
            }

            @Override
            public void forEach(@NotNull IntConsumer consumer2) {
                if (consumer2 == null) {
                    FromBitSet.$$$reportNull$$$0(1);
                }
                this.myBitSet.stream().forEach(consumer2);
            }

            @Override
            @NotNull
            public IntSeq copy() {
                return new FromBitSet((BitSet)this.myBitSet.clone());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$IntSeq$FromBitSet";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "forEach";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class MemorySnapshotHandler {
        @NotNull
        private final List<Project> myIndexBatchUpdatingProjects = new ArrayList<Project>();
        @Nullable
        private volatile MemorySnapshot mySnapshot;

        MemorySnapshotHandler() {
            UnindexedFilesUpdaterListener unindexedFilesUpdaterListener = new UnindexedFilesUpdaterListener(){

                @Override
                public void updateStarted(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MemorySnapshotHandler.this.loadMemorySnapshot(project);
                }

                @Override
                public void updateFinished(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    MemorySnapshotHandler.this.dropMemorySnapshot(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "project";
                    objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$MemorySnapshotHandler$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "updateStarted";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "updateFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            ApplicationManager.getApplication().getMessageBus().connect(LogFileTypeIndex.this.myDisposable).subscribe(UnindexedFilesUpdaterListener.TOPIC, (Object)unindexedFilesUpdaterListener);
        }

        synchronized void loadMemorySnapshot(@NotNull Project project) {
            if (project == null) {
                MemorySnapshotHandler.$$$reportNull$$$0(0);
            }
            this.myIndexBatchUpdatingProjects.add(project);
            if (this.mySnapshot == null) {
                try {
                    LOG.info("Loading file type index snapshot");
                    this.mySnapshot = this.loadIndexToMemory(LogFileTypeIndex.this.myPersistentLog);
                }
                catch (StorageException e) {
                    LOG.error((Throwable)e);
                    FileBasedIndex.getInstance().requestRebuild(FileTypeIndex.NAME);
                    this.mySnapshot = new MemorySnapshot((Int2ObjectMap<BitSet>)new Int2ObjectOpenHashMap(), (IntList)new IntArrayList());
                }
            }
        }

        synchronized void dropMemorySnapshot(@NotNull Project project) {
            if (project == null) {
                MemorySnapshotHandler.$$$reportNull$$$0(1);
            }
            this.myIndexBatchUpdatingProjects.remove(project);
            if (this.myIndexBatchUpdatingProjects.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
                this.mySnapshot = null;
                LOG.info("File type index snapshot dropped");
            }
        }

        @Nullable
        MemorySnapshot getSnapshot() {
            return this.mySnapshot;
        }

        @NotNull
        MemorySnapshot loadIndexToMemory(@NotNull LogBasedIntIntIndex intLogIndex) throws StorageException {
            if (intLogIndex == null) {
                MemorySnapshotHandler.$$$reportNull$$$0(2);
            }
            Int2ObjectOpenHashMap invertedIndex = new Int2ObjectOpenHashMap();
            IntArrayList forwardIndex = new IntArrayList();
            intLogIndex.processEntries((arg_0, arg_1) -> MemorySnapshotHandler.lambda$loadIndexToMemory$1((IntList)forwardIndex, (Int2ObjectMap)invertedIndex, arg_0, arg_1));
            return new MemorySnapshot((Int2ObjectMap<BitSet>)invertedIndex, (IntList)forwardIndex);
        }

        private static /* synthetic */ boolean lambda$loadIndexToMemory$1(IntList forwardIndex, Int2ObjectMap invertedIndex, int data2, int inputId) {
            if (data2 != 0) {
                LogFileTypeIndex.setForwardIndexData(forwardIndex, data2, inputId);
                ((BitSet)invertedIndex.computeIfAbsent(data2, __ -> new BitSet())).set(inputId);
            } else {
                int previousData = MemorySnapshot.getDataFromForwardIndex(forwardIndex, inputId);
                if (previousData != 0) {
                    forwardIndex.set(inputId, 0);
                    ((BitSet)invertedIndex.get(previousData)).clear(inputId);
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intLogIndex";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$MemorySnapshotHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadMemorySnapshot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dropMemorySnapshot";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadIndexToMemory";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MemorySnapshot
    implements IntIntIndex {
        @NotNull
        private final Int2ObjectMap<BitSet> myInvertedIndex;
        @NotNull
        private final IntList myForwardIndex;

        private MemorySnapshot(@NotNull Int2ObjectMap<BitSet> invertedIndex, @NotNull IntList forwardIndex) {
            if (invertedIndex == null) {
                MemorySnapshot.$$$reportNull$$$0(0);
            }
            if (forwardIndex == null) {
                MemorySnapshot.$$$reportNull$$$0(1);
            }
            this.myInvertedIndex = invertedIndex;
            this.myForwardIndex = forwardIndex;
        }

        @Override
        public synchronized boolean addData(int data2, int inputId) {
            int indexedData = this.getIndexedData(inputId);
            if (indexedData != 0) {
                BitSet indexedSet = (BitSet)this.myInvertedIndex.get(indexedData);
                assert (indexedSet != null);
                indexedSet.clear(inputId);
            }
            boolean updated = LogFileTypeIndex.setForwardIndexData(this.myForwardIndex, data2, inputId);
            if (data2 != 0) {
                ((BitSet)this.myInvertedIndex.computeIfAbsent(data2, __ -> new BitSet())).set(inputId);
            }
            return updated;
        }

        @Override
        @NotNull
        public synchronized IntSeq getFileIds(int data2) {
            BitSet fileIds = (BitSet)this.myInvertedIndex.get(data2);
            return fileIds == null ? IntSeq.EMPTY : new IntSeq.FromBitSet(fileIds);
        }

        @Override
        public synchronized int getIndexedData(int inputId) {
            return MemorySnapshot.getDataFromForwardIndex(this.myForwardIndex, inputId);
        }

        private static int getDataFromForwardIndex(@NotNull IntList forwardIndex, int inputId) {
            if (forwardIndex == null) {
                MemorySnapshot.$$$reportNull$$$0(2);
            }
            if (forwardIndex.size() <= inputId) {
                return 0;
            }
            return forwardIndex.getInt(inputId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invertedIndex";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forwardIndex";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$MemorySnapshot";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDataFromForwardIndex";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LogBasedIntIntIndex
    implements IntIntIndex {
        private final AbstractIntLog myLog;

        private LogBasedIntIntIndex(@NotNull AbstractIntLog log) {
            if (log == null) {
                LogBasedIntIntIndex.$$$reportNull$$$0(0);
            }
            this.myLog = log;
        }

        @Override
        public boolean addData(int data2, int inputId) throws StorageException {
            this.myLog.addData(data2, inputId);
            return true;
        }

        @Override
        @NotNull
        public IntSeq getFileIds(int dataKey) throws StorageException {
            IntOpenHashSet inputIds = new IntOpenHashSet();
            AbstractIntLog.IntLogEntryProcessor processor2 = (arg_0, arg_1) -> LogBasedIntIntIndex.lambda$getFileIds$0(dataKey, (IntSet)inputIds, arg_0, arg_1);
            this.myLog.processEntries(processor2);
            return new IntSeq.FromIntSet((IntSet)inputIds);
        }

        @Override
        public int getIndexedData(int fileId) throws StorageException {
            int[] foundData = new int[]{0};
            AbstractIntLog.IntLogEntryProcessor processor2 = (data2, inputId) -> {
                if (fileId == inputId) {
                    foundData[0] = data2;
                }
                return true;
            };
            this.myLog.processEntries(processor2);
            return foundData[0];
        }

        private void processEntries(@NotNull AbstractIntLog.IntLogEntryProcessor processor2) throws StorageException {
            if (processor2 == null) {
                LogBasedIntIntIndex.$$$reportNull$$$0(1);
            }
            this.myLog.processEntries(processor2);
        }

        public long getModificationStamp() {
            return this.myLog.getModificationStamp();
        }

        public void clear() {
            this.myLog.clear();
        }

        public void close() throws IOException {
            this.myLog.close();
        }

        public void flush() throws IOException {
            this.myLog.flush();
        }

        private static /* synthetic */ boolean lambda$getFileIds$0(int dataKey, IntSet inputIds, int data2, int inputId) {
            if (data2 == dataKey) {
                inputIds.add(inputId);
            } else {
                inputIds.remove(inputId);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "log";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$LogBasedIntIntIndex";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processEntries";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface IntIntIndex {
        public boolean addData(int var1, int var2) throws StorageException;

        @NotNull
        public IntSeq getFileIds(int var1) throws StorageException;

        public int getIndexedData(int var1) throws StorageException;
    }
}

