/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.stubs.StubFieldAccessor;
import com.intellij.psi.stubs.StubSerializationHelper;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.stubs.StubSerializerEnumerator;
import com.intellij.psi.stubs.StubTreeSerializer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.tree.StubFileElementType;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.InMemoryDataEnumerator;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SerializationManagerImpl
extends SerializationManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SerializationManagerImpl.class);
    private final AtomicBoolean myNameStorageCrashed = new AtomicBoolean(false);
    private final Path myFile;
    private final boolean myUnmodifiable;
    private final AtomicBoolean myShutdownPerformed = new AtomicBoolean(false);
    private volatile StubSerializationHelper myStubSerializationHelper;
    private volatile StubSerializerEnumerator mySerializerEnumerator;
    private volatile boolean mySerializersLoaded;

    public SerializationManagerImpl() {
        this(FileBasedIndex.USE_IN_MEMORY_INDEX ? null : PathManager.getIndexRoot().resolve("rep.names"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonInjectable
    public SerializationManagerImpl(@Nullable Path nameStorageFile, boolean unmodifiable) {
        this.myFile = nameStorageFile;
        this.myUnmodifiable = unmodifiable;
        try {
            StubSerializerEnumerator enumerator2;
            this.mySerializerEnumerator = enumerator2 = new StubSerializerEnumerator(this.openNameStorage(), unmodifiable);
            this.myStubSerializationHelper = new StubSerializationHelper(enumerator2);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info((Throwable)e);
        }
        finally {
            if (!unmodifiable) {
                ShutDownTracker.getInstance().registerShutdownTask(this::performShutdown, (Disposable)this);
            }
        }
        StubElementTypeHolderEP.EP_NAME.addChangeListener(this::dropSerializerData, (Disposable)this);
    }

    @NotNull
    private DataEnumeratorEx<String> openNameStorage() throws IOException {
        if (this.myFile == null) {
            return new InMemoryDataEnumerator();
        }
        Boolean lastValue = null;
        if (this.myUnmodifiable) {
            lastValue = (Boolean)PersistentHashMapValueStorage.CreationTimeOptions.READONLY.get();
            PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(Boolean.TRUE);
        }
        PersistentStringEnumerator persistentStringEnumerator = new PersistentStringEnumerator(this.myFile, true);
        PersistentStringEnumerator persistentStringEnumerator2 = persistentStringEnumerator;
        if (persistentStringEnumerator2 == null) {
            SerializationManagerImpl.$$$reportNull$$$0(0);
        }
        return persistentStringEnumerator2;
        finally {
            if (this.myUnmodifiable) {
                PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(lastValue);
            }
        }
    }

    @ApiStatus.Internal
    public Map<String, Integer> dumpNameStorage() {
        return this.mySerializerEnumerator.dump();
    }

    @Override
    public boolean isNameStorageCorrupted() {
        return this.myNameStorageCrashed.get();
    }

    @Override
    public void repairNameStorage(@NotNull Exception corruptionCause) {
        if (corruptionCause == null) {
            SerializationManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.myNameStorageCrashed.getAndSet(false)) {
            try {
                if (this.myUnmodifiable) {
                    LOG.error("Data provided by unmodifiable serialization manager can be invalid after repair");
                }
                LOG.info("Name storage is repaired");
                StubSerializerEnumerator enumerator2 = this.mySerializerEnumerator;
                if (enumerator2 != null) {
                    try {
                        enumerator2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.myFile != null) {
                    IOUtil.deleteAllFilesStartingWith((File)this.myFile.toFile());
                }
                this.mySerializerEnumerator = new StubSerializerEnumerator(this.openNameStorage(), this.myUnmodifiable);
                this.myStubSerializationHelper = new StubSerializationHelper(this.mySerializerEnumerator);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.nameStorageCrashed();
            }
        }
    }

    @Override
    public void flushNameStorage() throws IOException {
        this.mySerializerEnumerator.flush();
    }

    private void registerSerializer(ObjectStubSerializer<?, ? extends Stub> serializer2) {
        this.registerSerializer(serializer2.getExternalId(), () -> serializer2);
    }

    @Override
    public void reinitializeNameStorage() {
        this.nameStorageCrashed();
        this.repairNameStorage(new Exception("Indexes are requested to rebuild"));
    }

    private void nameStorageCrashed() {
        this.myNameStorageCrashed.set(true);
    }

    public void dispose() {
        this.performShutdown();
    }

    private void performShutdown() {
        String name2;
        if (!this.myShutdownPerformed.compareAndSet(false, true)) {
            return;
        }
        String string = name2 = this.myFile != null ? this.myFile.toString() : "in-memory storage";
        if (!this.myUnmodifiable) {
            LOG.info("Start shutting down " + name2);
        }
        try {
            this.mySerializerEnumerator.close();
            if (!this.myUnmodifiable) {
                LOG.info("Finished shutting down " + name2);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void registerSerializer(@NotNull String externalId, @NotNull Supplier<ObjectStubSerializer<?, ? extends Stub>> lazySerializer) {
        if (externalId == null) {
            SerializationManagerImpl.$$$reportNull$$$0(2);
        }
        if (lazySerializer == null) {
            SerializationManagerImpl.$$$reportNull$$$0(3);
        }
        try {
            this.mySerializerEnumerator.assignId(lazySerializer, externalId);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.nameStorageCrashed();
        }
    }

    @Override
    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) {
        if (rootStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(4);
        }
        if (stream == null) {
            SerializationManagerImpl.$$$reportNull$$$0(5);
        }
        this.initSerializers();
        try {
            this.myStubSerializationHelper.serialize(rootStub, stream);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.nameStorageCrashed();
        }
    }

    @Override
    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws SerializerNotFoundException {
        Stub stub;
        if (stream == null) {
            SerializationManagerImpl.$$$reportNull$$$0(6);
        }
        this.initSerializers();
        try {
            stub = this.myStubSerializationHelper.deserialize(stream);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info((Throwable)e);
            throw new RuntimeException(e);
        }
        if (stub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(7);
        }
        return stub;
    }

    @Override
    public void reSerialize(@NotNull InputStream inStub, @NotNull OutputStream outStub, @NotNull StubTreeSerializer newSerializationManager) throws IOException {
        if (inStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(8);
        }
        if (outStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(9);
        }
        if (newSerializationManager == null) {
            SerializationManagerImpl.$$$reportNull$$$0(10);
        }
        this.initSerializers();
        ((SerializationManagerEx)newSerializationManager).initSerializers();
        this.myStubSerializationHelper.reSerializeStub(new DataInputStream(inStub), new DataOutputStream(outStub), ((SerializationManagerImpl)newSerializationManager).myStubSerializationHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initSerializers() {
        SerializationManagerImpl serializationManagerImpl = this;
        synchronized (serializationManagerImpl) {
            if (this.mySerializersLoaded) {
                return;
            }
            this.registerSerializer((ObjectStubSerializer<?, ? extends Stub>)PsiFileStubImpl.TYPE);
            List lazySerializers = IStubElementType.loadRegisteredStubElementTypes();
            IElementType[] stubElementTypes = IElementType.enumerate(type -> type instanceof StubSerializer);
            for (IElementType type2 : stubElementTypes) {
                if (type2 instanceof StubFileElementType && "psi.file".equals(((StubFileElementType)type2).getExternalId())) continue;
                this.registerSerializer((ObjectStubSerializer<?, ? extends Stub>)((StubSerializer)type2));
            }
            for (StubFieldAccessor lazySerializer : lazySerializers) {
                this.registerSerializer(lazySerializer.externalId, (Supplier<ObjectStubSerializer<?, ? extends Stub>>)lazySerializer);
            }
            this.mySerializersLoaded = true;
        }
    }

    @NotNull
    ObjectStubSerializer<?, ? extends Stub> getSerializer(@NotNull String name2) throws SerializerNotFoundException {
        if (name2 == null) {
            SerializationManagerImpl.$$$reportNull$$$0(11);
        }
        ObjectStubSerializer<?, ? extends Stub> objectStubSerializer = this.mySerializerEnumerator.getSerializer(name2);
        if (objectStubSerializer == null) {
            SerializationManagerImpl.$$$reportNull$$$0(12);
        }
        return objectStubSerializer;
    }

    @Nullable
    public String getSerializerName(@NotNull ObjectStubSerializer<?, ? extends Stub> serializer2) {
        if (serializer2 == null) {
            SerializationManagerImpl.$$$reportNull$$$0(13);
        }
        return this.mySerializerEnumerator.getSerializerName(serializer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSerializerData() {
        SerializationManagerImpl serializationManagerImpl = this;
        synchronized (serializationManagerImpl) {
            IStubElementType.dropRegisteredTypes();
            IStubFileElementType.dropTemplateStubBaseVersion();
            StubSerializerEnumerator enumerator2 = this.mySerializerEnumerator;
            if (enumerator2 != null) {
                enumerator2.dropRegisteredSerializers();
            } else {
                this.nameStorageCrashed();
            }
            this.mySerializersLoaded = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/SerializationManagerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "corruptionCause";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazySerializer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inStub";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outStub";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializationManager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "openNameStorage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/SerializationManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "repairNameStorage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerSerializer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reSerialize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSerializer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSerializerName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

