/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubProcessingHelperBase;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.StorageException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class StubProcessingHelper
extends StubProcessingHelperBase {
    private static final boolean SKIP_INDEX_REPAIR_ON_ERROR = Boolean.getBoolean("skip.index.repair");
    static final boolean REPORT_SENSITIVE_DATA_ON_ERROR = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal();
    private final ThreadLocal<Set<VirtualFile>> myFilesHavingProblems = new ThreadLocal();

    @Nullable
    public <Key, Psi extends PsiElement> StubIdList retrieveStubIdList(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull VirtualFile file2, @NotNull Project project, boolean failOnMissedKeys) {
        if (indexKey == null) {
            StubProcessingHelper.$$$reportNull$$$0(0);
        }
        if (key == null) {
            StubProcessingHelper.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            StubProcessingHelper.$$$reportNull$$$0(2);
        }
        if (project == null) {
            StubProcessingHelper.$$$reportNull$$$0(3);
        }
        int id2 = ((VirtualFileWithId)file2).getId();
        try {
            Map<Integer, SerializedStubTree> data2 = StubIndexImpl.getStubUpdatingIndex().getIndexedFileData(id2);
            if (data2.size() != 1) {
                if (failOnMissedKeys) {
                    LOG.error("Stub index points to a file (" + StubProcessingHelper.getFileTypeInfo(file2, project) + ") without indexed stub tree; indexing stamp = " + StubTreeLoader.getInstance().getIndexingStampInfo(file2) + ", can have stubs = " + StubUpdatingIndex.canHaveStub(file2) + ", actual stub count = " + data2.size());
                    this.onInternalError(file2);
                }
                return null;
            }
            SerializedStubTree tree = data2.values().iterator().next();
            StubIdList stubIdList = tree.restoreIndexedStubs(indexKey, key);
            if (stubIdList == null && failOnMissedKeys) {
                Object additionalMessage;
                String mainMessage = "Stub ids not found for key in index = " + indexKey.getName() + ", " + StubProcessingHelper.getFileTypeInfo(file2, project);
                if (REPORT_SENSITIVE_DATA_ON_ERROR) {
                    Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map2 = null;
                    try {
                        tree.restoreIndexedStubs();
                        map2 = tree.getStubIndicesValueMap();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    additionalMessage = ", file " + file2.getPath() + ", for key " + key + " existing map " + map2;
                } else {
                    additionalMessage = "";
                }
                LOG.error(mainMessage + (String)additionalMessage);
                this.onInternalError(file2);
            }
            return stubIdList;
        }
        catch (StorageException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void onInternalError(VirtualFile file2) {
        if (SKIP_INDEX_REPAIR_ON_ERROR) {
            return;
        }
        Set<VirtualFile> set2 = this.myFilesHavingProblems.get();
        if (set2 == null) {
            set2 = new HashSet<VirtualFile>();
            this.myFilesHavingProblems.set(set2);
        }
        set2.add(file2);
        AppUIExecutor.onWriteThread((ModalityState)ModalityState.NON_MODAL).later().submit(() -> FileBasedIndex.getInstance().requestReindex(file2));
    }

    @Nullable
    Set<VirtualFile> takeAccumulatedFilesWithIndexProblems() {
        if (SKIP_INDEX_REPAIR_ON_ERROR) {
            return null;
        }
        Set<VirtualFile> filesWithProblems = this.myFilesHavingProblems.get();
        if (filesWithProblems != null) {
            this.myFilesHavingProblems.set(null);
        }
        return filesWithProblems;
    }

    @TestOnly
    boolean areAllProblemsProcessedInTheCurrentThread() {
        return ContainerUtil.isEmpty((Collection)this.myFilesHavingProblems.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "indexKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "key";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/stubs/StubProcessingHelper";
        objectArray[2] = "retrieveStubIdList";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

