/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.analysis.XmlUnusedNamespaceInspection;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlImportOptimizer
implements ImportOptimizer {
    private final XmlUnusedNamespaceInspection myInspection = new XmlUnusedNamespaceInspection();
    private final Condition<ProblemDescriptor> myCondition = descriptor2 -> {
        PsiElement element2 = descriptor2.getPsiElement();
        PsiElement parent = element2.getParent();
        return parent != null && !this.myInspection.isSuppressedFor(parent);
    };

    public boolean supports(@NotNull PsiFile file2) {
        if (file2 == null) {
            XmlImportOptimizer.$$$reportNull$$$0(0);
        }
        return file2 instanceof XmlFile;
    }

    @NotNull
    public ImportOptimizer.CollectingInfoRunnable processFile(final @NotNull PsiFile file2) {
        if (file2 == null) {
            XmlImportOptimizer.$$$reportNull$$$0(1);
        }
        return new ImportOptimizer.CollectingInfoRunnable(){
            int myRemovedNameSpaces = 0;

            public void run() {
                XmlFile xmlFile = (XmlFile)file2;
                Project project = xmlFile.getProject();
                HighlightDisplayKey key = HighlightDisplayKey.find((String)XmlImportOptimizer.this.myInspection.getShortName());
                if (!InspectionProjectProfileManager.getInstance(project).getCurrentProfile().isToolEnabled(key, (PsiElement)xmlFile)) {
                    return;
                }
                ProblemsHolder holder = new ProblemsHolder(InspectionManager.getInstance((Project)project), (PsiFile)xmlFile, false);
                final XmlElementVisitor visitor = (XmlElementVisitor)XmlImportOptimizer.this.myInspection.buildVisitor(holder, false);
                new PsiRecursiveElementVisitor(){

                    public void visitElement(@NotNull PsiElement element2) {
                        if (element2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element2 instanceof XmlAttribute) {
                            visitor.visitXmlAttribute((XmlAttribute)element2);
                        } else {
                            super.visitElement(element2);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/XmlImportOptimizer$1$1", "visitElement"));
                    }
                }.visitFile((PsiFile)xmlFile);
                Object[] results = holder.getResultsArray();
                List list2 = ContainerUtil.filter((Object[])results, XmlImportOptimizer.this.myCondition);
                LinkedHashMap<XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix, ProblemDescriptor> fixes = new LinkedHashMap<XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix, ProblemDescriptor>();
                for (ProblemDescriptor result2 : list2) {
                    for (QuickFix fix2 : result2.getFixes()) {
                        if (!(fix2 instanceof XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix)) continue;
                        fixes.put((XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix)fix2, result2);
                    }
                }
                SmartPsiElementPointer<XmlTag> pointer = null;
                for (Map.Entry fix3 : fixes.entrySet()) {
                    pointer = ((XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix)fix3.getKey()).doFix(project, (ProblemDescriptor)fix3.getValue(), false);
                    ++this.myRemovedNameSpaces;
                }
                if (pointer != null) {
                    XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix.reformatStartTag(project, pointer);
                }
            }

            @Nullable
            public String getUserNotificationInfo() {
                return this.myRemovedNameSpaces > 0 ? XmlBundle.message((String)"hint.text.removed.namespace", (Object[])new Object[]{this.myRemovedNameSpaces, this.myRemovedNameSpaces > 1 ? 0 : 1}) : null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/intellij/refactoring/XmlImportOptimizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "supports";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

