/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class StringTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private Document myDocument;
    private final Project myProject;
    private final List<DocumentListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public StringTableCellEditor(Project project) {
        this.myProject = project;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row2, int column2) {
        EditorTextField editorTextField2 = new EditorTextField((String)value2, this.myProject, (FileType)StdFileTypes.JAVA){

            @Override
            protected boolean shouldHaveBorder() {
                return false;
            }
        };
        this.myDocument = editorTextField2.getDocument();
        for (DocumentListener listener2 : this.myListeners) {
            editorTextField2.addDocumentListener(listener2);
        }
        return editorTextField2;
    }

    @Override
    public Object getCellEditorValue() {
        return this.myDocument.getText();
    }

    public void addDocumentListener(DocumentListener listener2) {
        this.myListeners.add(listener2);
    }

    public void clearListeners() {
        this.myListeners.clear();
    }
}

