/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteDev.RemoteDevUtilBundle;
import com.intellij.remoteDev.connection.CodeWithMeSessionInfoProvider;
import com.intellij.remoteDev.connection.StunTurnServerInfo;
import com.intellij.remoteDev.downloader.CodeWithMeClientDownloader;
import com.intellij.remoteDev.downloader.JetBrainsClientDownloaderConfigurationProvider;
import com.intellij.remoteDev.downloader.RemoteDevStatisticsCollector;
import com.intellij.remoteDev.util.FileManifestUtil;
import com.intellij.remoteDev.util.LifetimeExKt;
import com.intellij.remoteDev.util.SubProgressIndicatorBase;
import com.intellij.remoteDev.util.SubProgressIndicatorKt;
import com.intellij.remoteDev.util.UrlUtilKt;
import com.intellij.remoteDev.util.WindowsFileUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import com.intellij.util.system.CpuArch;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.infra.pgpVerifier.JetBrainsPgpConstants;
import com.jetbrains.infra.pgpVerifier.PgpSignaturesVerifier;
import com.jetbrains.infra.pgpVerifier.PgpSignaturesVerifierLogger;
import com.jetbrains.infra.pgpVerifier.Sha256ChecksumSignatureVerifier;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FileWalkDirection;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0003LMNB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0015J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0013H\u0002J\u0016\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0013J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0013H\u0002J$\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010-2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u000200J&\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010-2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010/\u001a\u000200H\u0007J,\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010-2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010/\u001a\u000200J \u00101\u001a\u00020$2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00132\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00105\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013H\u0002J\u001a\u00106\u001a\u0004\u0018\u00010\u00132\u0006\u0010(\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0013H\u0002J0\u00106\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0007080-2\u0006\u0010(\u001a\u00020\u00132\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000708H\u0002J\"\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0007080-2\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0010\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u00020\u0013H\u0002J\u0010\u0010A\u001a\u00020\u00152\u0006\u0010@\u001a\u00020\u0013H\u0002J\u000e\u0010B\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u0007J&\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020D2\u0006\u00102\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0013J\u0016\u0010F\u001a\u00020\u00152\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u0007J\u001c\u0010I\u001a\n J*\u0004\u0018\u00010\u00130\u0013*\u00020\u00132\u0006\u0010K\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00150\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00150\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SHA256_ASC_SUFFIX", "", "SHA256_SUFFIX", "buildNumberRegex", "Lkotlin/text/Regex;", "getBuildNumberRegex", "()Lkotlin/text/Regex;", "config", "Lcom/intellij/remoteDev/downloader/JetBrainsClientDownloaderConfigurationProvider;", "getConfig", "()Lcom/intellij/remoteDev/downloader/JetBrainsClientDownloaderConfigurationProvider;", "currentlyDownloading", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Ljava/util/concurrent/CompletableFuture;", "", "cwmGuestManifestFilter", "Lkotlin/Function1;", "getCwmGuestManifestFilter", "()Lkotlin/jvm/functions/Function1;", "cwmJbrManifestFilter", "getCwmJbrManifestFilter", "extractDirSuffix", "urlAllowedChars", "createSessionInfo", "Lcom/intellij/remoteDev/connection/CodeWithMeSessionInfoProvider;", "clientBuildVersion", "jreBuild", "unattendedMode", "createSymlink", "", "link", "target", "createSymlinkToJdkFromGuest", "guestRoot", "jdkRoot", "detectTrueJdkRoot", "jdkDownload", "downloadClientAndJdk", "Lkotlin/Pair;", "sessionInfoResponse", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadWithRetries", "url", "Ljava/net/URI;", "path", "findCwmGuestHome", "findLauncher", "launcherName", "", "launcherNames", "findLauncherUnderCwmGuestRoot", "getClientDistributionName", "isAlreadyDownloaded", "fileData", "Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileData;", "isJbrSymlink", "file", "isSymlink", "isValidDownloadUrl", "runCwmGuestProcessFromDownload", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lifetime", "versionsMatch", "hostBuildNumberString", "localBuildNumberString", "addSuffix", "kotlin.jvm.PlatformType", "suffix", "DownloadableFileData", "DownloadableFileState", "MultipleSubProgressIndicator", "intellij.remoteDev.util"})
@ApiStatus.Experimental
public final class CodeWithMeClientDownloader {
    private static final Logger LOG;
    private static final String extractDirSuffix = "-ide";
    @NotNull
    private static final Function1<Path, Boolean> cwmGuestManifestFilter;
    @NotNull
    private static final Function1<Path, Boolean> cwmJbrManifestFilter;
    @NotNull
    private static final Regex buildNumberRegex;
    private static final ConcurrentHashMap<Path, CompletableFuture<Boolean>> currentlyDownloading;
    private static final String SHA256_SUFFIX = ".sha256";
    private static final String SHA256_ASC_SUFFIX = ".sha256.asc";
    private static final Regex urlAllowedChars;
    @NotNull
    public static final CodeWithMeClientDownloader INSTANCE;

    private final JetBrainsClientDownloaderConfigurationProvider getConfig() {
        boolean $i$f$service = false;
        Class<JetBrainsClientDownloaderConfigurationProvider> serviceClass$iv = JetBrainsClientDownloaderConfigurationProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        return (JetBrainsClientDownloaderConfigurationProvider)object;
    }

    private final boolean isJbrSymlink(Path file2) {
        return Intrinsics.areEqual((Object)PathsKt.getName((Path)file2), (Object)"jbr") && this.isSymlink(file2);
    }

    private final boolean isSymlink(Path file2) {
        FileAttributes fileAttributes = FileSystemUtil.getAttributes((File)file2.toFile());
        return fileAttributes != null && fileAttributes.isSymLink();
    }

    @NotNull
    public final Function1<Path, Boolean> getCwmGuestManifestFilter() {
        return cwmGuestManifestFilter;
    }

    @NotNull
    public final Function1<Path, Boolean> getCwmJbrManifestFilter() {
        return cwmJbrManifestFilter;
    }

    @NotNull
    public final Regex getBuildNumberRegex() {
        return buildNumberRegex;
    }

    private final String getClientDistributionName(String clientBuildVersion) {
        return VersionComparatorUtil.compare((String)clientBuildVersion, (String)"211.6167") < 0 ? "IntelliJClient" : (VersionComparatorUtil.compare((String)clientBuildVersion, (String)"213.5318") < 0 ? "CodeWithMeGuest" : "JetBrainsClient");
    }

    @NotNull
    public final CodeWithMeSessionInfoProvider createSessionInfo(@NotNull String clientBuildVersion, @NotNull String jreBuild, boolean unattendedMode) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)clientBuildVersion, (String)"clientBuildVersion");
        Intrinsics.checkNotNullParameter((Object)jreBuild, (String)"jreBuild");
        if (StringsKt.contains$default((CharSequence)clientBuildVersion, (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null)) {
            LOG.warn("Thin client download from sources may result in failure due to different sources on host and client, don't forget to update your locally built archive");
        }
        MatchResult matchResult = Regex.find$default((Regex)buildNumberRegex, (CharSequence)clientBuildVersion, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        String hostBuildNumber = matchResult.getValue();
        if (SystemInfo.isLinux) {
            string2 = "-no-jbr.tar.gz";
        } else if (SystemInfo.isWindows) {
            string2 = ".win.zip";
        } else if (SystemInfo.isMac && CpuArch.isIntel64()) {
            string2 = "-no-jdk.sit";
        } else if (SystemInfo.isMac && CpuArch.isArm64()) {
            string2 = "-no-jdk-aarch64.sit";
        } else {
            String string3 = "Current platform is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        String platformSuffix = string2;
        String clientDistributionName = this.getClientDistributionName(clientBuildVersion);
        String clientDownloadUrl = this.getConfig().getClientDownloadLocation() + clientDistributionName + '-' + hostBuildNumber + platformSuffix;
        if (SystemInfo.isLinux) {
            string = "linux-x64";
        } else if (SystemInfo.isWindows) {
            string = "windows-x64";
        } else if (SystemInfo.isMac && CpuArch.isIntel64()) {
            string = "osx-x64";
        } else if (SystemInfo.isMac && CpuArch.isArm64()) {
            string = "osx-aarch64";
        } else {
            String string4 = "Current platform is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        String platformString = string;
        List jreBuildParts = StringsKt.split$default((CharSequence)jreBuild, (String[])new String[]{"b"}, (boolean)false, (int)0, (int)6, null);
        boolean bl = jreBuildParts.size() == 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string5 = "jreBuild format should be like 12_3_45b6789.0";
            throw (Throwable)new IllegalArgumentException(string5.toString());
        }
        CharSequence charSequence = (CharSequence)jreBuildParts.get(0);
        Regex regex = new Regex("^[0-9_]+$");
        bl3 = false;
        boolean bl5 = regex.matches(charSequence);
        boolean bl6 = false;
        bl3 = false;
        if (!bl5) {
            boolean bl7 = false;
            String string6 = "jreBuild format should be like 12_3_45b6789.0";
            throw (Throwable)new IllegalArgumentException(string6.toString());
        }
        CharSequence charSequence2 = (CharSequence)jreBuildParts.get(1);
        Regex regex2 = new Regex("^[0-9.]+$");
        bl3 = false;
        boolean bl8 = regex2.matches(charSequence2);
        boolean bl9 = false;
        bl3 = false;
        if (!bl8) {
            boolean bl10 = false;
            String string7 = "jreBuild format should be like 12_3_45b6789.0";
            throw (Throwable)new IllegalArgumentException(string7.toString());
        }
        String jdkVersion = (String)jreBuildParts.get(0);
        String jdkBuild = (String)jreBuildParts.get(1);
        String jreDownloadUrl = this.getConfig().getJreDownloadLocation() + "jbr_jcef-" + jdkVersion + '-' + platformString + "-b" + jdkBuild + ".tar.gz";
        String clientName = clientDistributionName + '-' + hostBuildNumber;
        String jreName = StringsKt.removeSuffix((String)StringsKt.substringAfterLast$default((String)jreDownloadUrl, (char)'/', null, (int)2, null), (CharSequence)".tar.gz");
        CodeWithMeSessionInfoProvider sessionInfo2 = new CodeWithMeSessionInfoProvider(hostBuildNumber, clientName, clientDownloadUrl, jreName, unattendedMode, jreDownloadUrl){
            @NotNull
            private final String hostBuildNumber;
            @NotNull
            private final String compatibleClientName;
            @NotNull
            private final String compatibleClientUrl;
            @NotNull
            private final String compatibleJreName;
            private final boolean isUnattendedMode;
            @NotNull
            private final String compatibleJreUrl;
            @Nullable
            private final Set<String> hostFeaturesToEnable;
            @Nullable
            private final List<StunTurnServerInfo> stunTurnServers;
            @Nullable
            private final String downloadPgpPublicKeyUrl;
            final /* synthetic */ String $hostBuildNumber;
            final /* synthetic */ String $clientName;
            final /* synthetic */ String $clientDownloadUrl;
            final /* synthetic */ String $jreName;
            final /* synthetic */ boolean $unattendedMode;
            final /* synthetic */ String $jreDownloadUrl;

            @NotNull
            public String getHostBuildNumber() {
                return this.hostBuildNumber;
            }

            @NotNull
            public String getCompatibleClientName() {
                return this.compatibleClientName;
            }

            @NotNull
            public String getCompatibleClientUrl() {
                return this.compatibleClientUrl;
            }

            @NotNull
            public String getCompatibleJreName() {
                return this.compatibleJreName;
            }

            public boolean isUnattendedMode() {
                return this.isUnattendedMode;
            }

            @NotNull
            public String getCompatibleJreUrl() {
                return this.compatibleJreUrl;
            }

            @Nullable
            public Set<String> getHostFeaturesToEnable() {
                return this.hostFeaturesToEnable;
            }

            @Nullable
            public List<StunTurnServerInfo> getStunTurnServers() {
                return this.stunTurnServers;
            }

            @Nullable
            public String getDownloadPgpPublicKeyUrl() {
                return this.downloadPgpPublicKeyUrl;
            }
            {
                this.$hostBuildNumber = $captured_local_variable$0;
                this.$clientName = $captured_local_variable$1;
                this.$clientDownloadUrl = $captured_local_variable$2;
                this.$jreName = $captured_local_variable$3;
                this.$unattendedMode = $captured_local_variable$4;
                this.$jreDownloadUrl = $captured_local_variable$5;
                this.hostBuildNumber = $captured_local_variable$0;
                this.compatibleClientName = $captured_local_variable$1;
                this.compatibleClientUrl = $captured_local_variable$2;
                this.compatibleJreName = $captured_local_variable$3;
                this.isUnattendedMode = $captured_local_variable$4;
                this.compatibleJreUrl = $captured_local_variable$5;
            }
        };
        LOG.info("Generated session info: " + sessionInfo2);
        return sessionInfo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Experimental
    @Nullable
    public final Pair<Path, Path> downloadClientAndJdk(@NotNull String clientBuildVersion, @NotNull ProgressIndicator progressIndicator) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)clientBuildVersion, (String)"clientBuildVersion");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        boolean bl = ApplicationKt.getApplication().isUnitTestMode() || !ApplicationKt.getApplication().isDispatchThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "This method should not be called on UI thread";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        LOG.info("Downloading Thin Client jdk-build.txt");
        ProgressIndicator jdkBuildProgressIndicator = SubProgressIndicatorKt.createSubProgress(progressIndicator, 0.1);
        jdkBuildProgressIndicator.setText(RemoteDevUtilBundle.INSTANCE.message("thinClientDownloader.checking", new Object[0]));
        String clientDistributionName = this.getClientDistributionName(clientBuildVersion);
        String clientJdkDownloadUrl = this.getConfig().getClientDownloadLocation() + clientDistributionName + '-' + clientBuildVersion + "-jdk-build.txt";
        LOG.info("Downloading from " + clientJdkDownloadUrl);
        Path tempFile = Files.createTempFile("jdk-build", "txt", new FileAttribute[0]);
        try {
            URI uRI = new URI(clientJdkDownloadUrl);
            Path path2 = tempFile;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"tempFile");
            this.downloadWithRetries(uRI, path2, (ProgressIndicator)new EmptyProgressIndicator());
            object = Unit.INSTANCE;
            boolean bl5 = false;
            boolean bl6 = false;
            Unit it = object;
            boolean bl7 = false;
            object = PathKt.readText((Path)tempFile);
        }
        finally {
            Files.delete(tempFile);
        }
        Object jdkBuild = object;
        CodeWithMeSessionInfoProvider sessionInfo2 = this.createSessionInfo(clientBuildVersion, (String)jdkBuild, true);
        return this.downloadClientAndJdk(sessionInfo2, SubProgressIndicatorKt.createSubProgress(progressIndicator, 0.9));
    }

    @Nullable
    public final Pair<Path, Path> downloadClientAndJdk(@NotNull String clientBuildVersion, @NotNull String jreBuild, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)clientBuildVersion, (String)"clientBuildVersion");
        Intrinsics.checkNotNullParameter((Object)jreBuild, (String)"jreBuild");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        boolean bl = ApplicationKt.getApplication().isUnitTestMode() || !ApplicationKt.getApplication().isDispatchThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "This method should not be called on UI thread";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        CodeWithMeSessionInfoProvider sessionInfo2 = this.createSessionInfo(clientBuildVersion, jreBuild, true);
        return this.downloadClientAndJdk(sessionInfo2, progressIndicator);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Pair<Path, Path> downloadClientAndJdk(@NotNull CodeWithMeSessionInfoProvider sessionInfoResponse, @NotNull ProgressIndicator progressIndicator) {
        DownloadableFileData[] dataList;
        Intrinsics.checkNotNullParameter((Object)sessionInfoResponse, (String)"sessionInfoResponse");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        boolean bl = ApplicationKt.getApplication().isUnitTestMode() || !ApplicationKt.getApplication().isDispatchThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "This method should not be called on UI thread";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Path tempDir = FileUtil.createTempDirectory((String)"jb-cwm-dl", null).toPath();
        LOG.info("Downloading Thin Client in " + tempDir + "...");
        downloadClientAndJdk.4 $fun$archiveExtensionFromUrl$4 = downloadClientAndJdk.4.INSTANCE;
        String guestName = sessionInfoResponse.getCompatibleClientName();
        String guestFileName = guestName + '.' + $fun$archiveExtensionFromUrl$4.invoke(sessionInfoResponse.getCompatibleClientUrl());
        URI uRI = new URI(sessionInfoResponse.getCompatibleClientUrl());
        Path path2 = tempDir.resolve(guestFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"tempDir.resolve(guestFileName)");
        Path path3 = this.getConfig().getClientCachesDir();
        String string = guestName + extractDirSuffix;
        boolean bl5 = false;
        Path path4 = path3.resolve(string);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this.resolve(other)");
        DownloadableFileData guestData = new DownloadableFileData(guestFileName, uRI, path2, path4, cwmGuestManifestFilter, null, null, 96, null);
        String jdkFullName = sessionInfoResponse.getCompatibleJreName();
        String jdkFileName = jdkFullName + '.' + $fun$archiveExtensionFromUrl$4.invoke(sessionInfoResponse.getCompatibleJreUrl());
        URI uRI2 = new URI(sessionInfoResponse.getCompatibleJreUrl());
        Path path5 = tempDir.resolve(jdkFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"tempDir.resolve(jdkFileName)");
        Path path6 = this.getConfig().getClientCachesDir();
        String string2 = jdkFullName + extractDirSuffix;
        boolean bl6 = false;
        Path path7 = path6.resolve(string2);
        Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"this.resolve(other)");
        DownloadableFileData jdkData = new DownloadableFileData(jdkFileName, uRI2, path5, path7, cwmJbrManifestFilter, null, null, 96, null);
        DownloadableFileData[] downloadableFileDataArray = dataList = new DownloadableFileData[]{jdkData, guestData};
        boolean bl7 = false;
        DownloadableFileData[] downloadableFileDataArray2 = downloadableFileDataArray;
        boolean bl8 = false;
        StructuredIdeActivity activity = !(downloadableFileDataArray2.length == 0) ? RemoteDevStatisticsCollector.INSTANCE.onGuestDownloadStarted() : null;
        Function0<Unit> $fun$updateStateText$5 = new Function0<Unit>(dataList, progressIndicator){
            final /* synthetic */ DownloadableFileData[] $dataList;
            final /* synthetic */ ProgressIndicator $progressIndicator;

            /*
             * Unable to fully structure code
             */
            public final void invoke() {
                $this$filter$iv = this.$dataList;
                $i$f$filter = false;
                var4_4 = $this$filter$iv;
                destination$iv$iv = (DownloadableFileData[])new ArrayList<E>();
                $i$f$filterTo = false;
                var7_9 = $this$filterTo$iv$iv;
                var8_11 = ((void)var7_9).length;
                for (var9_13 = 0; var9_13 < var8_11; ++var9_13) {
                    it = element$iv$iv = var7_9[var9_13];
                    $i$a$-filter-CodeWithMeClientDownloader$downloadClientAndJdk$5$downloadList$1 = false;
                    if (!(it.getStatus() == DownloadableFileState.Downloading)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                downloadList = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, (Function1)downloadClientAndJdk.downloadList.2.INSTANCE, (int)30, null);
                $this$filter$iv = this.$dataList;
                $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var8_12 = $this$filterTo$iv$iv;
                var9_13 = ((void)var8_12).length;
                for (var10_15 = 0; var10_15 < var9_13; ++var10_15) {
                    it = element$iv$iv = var8_12[var10_15];
                    $i$a$-filter-CodeWithMeClientDownloader$downloadClientAndJdk$5$extractList$1 = false;
                    if (!(it.getStatus() == DownloadableFileState.Extracting)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                extractList = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, (Function1)downloadClientAndJdk.extractList.2.INSTANCE, (int)30, null);
                var3_3 = downloadList;
                var4_5 = false;
                if (!(StringsKt.isBlank((CharSequence)var3_3) == false)) ** GOTO lbl-1000
                var3_3 = extractList;
                var4_5 = false;
                if (StringsKt.isBlank((CharSequence)var3_3) == false) {
                    v0 = RemoteDevUtilBundle.INSTANCE.message("thinClientDownloader.downloading.and.extracting", new Object[]{downloadList, extractList});
                } else lbl-1000:
                // 2 sources

                {
                    var3_3 = downloadList;
                    var4_5 = false;
                    if (StringsKt.isBlank((CharSequence)var3_3) == false) {
                        v0 = RemoteDevUtilBundle.INSTANCE.message("thinClientDownloader.downloading", new Object[]{downloadList});
                    } else {
                        var3_3 = extractList;
                        var4_5 = false;
                        v0 = StringsKt.isBlank((CharSequence)var3_3) == false != false ? RemoteDevUtilBundle.INSTANCE.message("thinClientDownloader.extracting", new Object[]{extractList}) : RemoteDevUtilBundle.INSTANCE.message("thinClientDownloader.ready", new Object[0]);
                    }
                }
                this.$progressIndicator.setText(v0);
            }
            {
                this.$dataList = downloadableFileDataArray;
                this.$progressIndicator = progressIndicator;
                super(0);
            }
        };
        $fun$updateStateText$5.invoke();
        List<MultipleSubProgressIndicator> dataProgressIndicators = MultipleSubProgressIndicator.Companion.create(progressIndicator, dataList.length);
        DownloadableFileData[] downloadableFileDataArray3 = dataList;
        int n = downloadableFileDataArray3.length;
        int n2 = 0;
        while (n2 < n) {
            void index2;
            DownloadableFileData data2 = downloadableFileDataArray3[n2];
            CompletableFuture<Boolean> future2 = data2.getDownloadFuture();
            MultipleSubProgressIndicator dataProgressIndicator = dataProgressIndicators.get((int)index2);
            AppExecutorUtil.getAppScheduledExecutorService().execute(new Runnable(data2, future2, dataProgressIndicator, $fun$updateStateText$5, tempDir, sessionInfoResponse){
                final /* synthetic */ DownloadableFileData $data;
                final /* synthetic */ CompletableFuture $future;
                final /* synthetic */ MultipleSubProgressIndicator $dataProgressIndicator;
                final /* synthetic */ downloadClientAndJdk.5 $updateStateText$5;
                final /* synthetic */ Path $tempDir;
                final /* synthetic */ CodeWithMeSessionInfoProvider $sessionInfoResponse;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    boolean bl;
                    ConcurrentHashMap concurrentHashMap;
                    try {
                        Object pgpKeyRingFile22;
                        CompletableFuture completableFuture;
                        concurrentHashMap = CodeWithMeClientDownloader.access$getCurrentlyDownloading$p(CodeWithMeClientDownloader.INSTANCE);
                        bl = false;
                        boolean bl2 = false;
                        synchronized (concurrentHashMap) {
                            CompletableFuture completableFuture2;
                            boolean bl3 = false;
                            CompletableFuture existingDownloadInnerFuture = (CompletableFuture)CodeWithMeClientDownloader.access$getCurrentlyDownloading$p(CodeWithMeClientDownloader.INSTANCE).get(this.$data.getTargetPath());
                            if (existingDownloadInnerFuture != null) {
                                completableFuture2 = existingDownloadInnerFuture;
                            } else {
                                ((Map)CodeWithMeClientDownloader.access$getCurrentlyDownloading$p(CodeWithMeClientDownloader.INSTANCE)).put(this.$data.getTargetPath(), this.$data.getDownloadFuture());
                                completableFuture2 = null;
                            }
                            completableFuture = completableFuture2;
                        }
                        CompletableFuture existingDownloadFuture = completableFuture;
                        if (existingDownloadFuture != null) {
                            CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).warn("Already downloading and extracting to " + this.$data.getTargetPath() + ", will wait until download finished");
                            existingDownloadFuture.whenComplete(new BiConsumer(this){
                                final /* synthetic */ downloadClientAndJdk.6 this$0;

                                public final void accept(Boolean res2, Throwable ex) {
                                    if (ex != null) {
                                        this.this$0.$future.completeExceptionally(ex);
                                    } else {
                                        this.this$0.$future.complete(res2);
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                            return;
                        }
                        if (CodeWithMeClientDownloader.access$isAlreadyDownloaded(CodeWithMeClientDownloader.INSTANCE, this.$data)) {
                            CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).info("Already downloaded and extracted " + this.$data.getFileName() + " to " + this.$data.getTargetPath());
                            this.$data.setStatus(DownloadableFileState.Done);
                            this.$dataProgressIndicator.setFraction(1.0);
                            this.$updateStateText$5.invoke();
                            this.$future.complete(true);
                            return;
                        }
                        ProgressIndicator downloadingDataProgressIndicator = SubProgressIndicatorKt.createSubProgress((ProgressIndicator)this.$dataProgressIndicator, 0.5);
                        try {
                            Function2<URI, Path, Unit> $fun$download$2 = new Function2<URI, Path, Unit>(downloadingDataProgressIndicator){
                                final /* synthetic */ ProgressIndicator $downloadingDataProgressIndicator;

                                public final void invoke(@NotNull URI url, @NotNull Path path2) {
                                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                                    Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                                    CodeWithMeClientDownloader.access$downloadWithRetries(CodeWithMeClientDownloader.INSTANCE, url, path2, this.$downloadingDataProgressIndicator);
                                }
                                {
                                    this.$downloadingDataProgressIndicator = progressIndicator;
                                    super(2);
                                }
                            };
                            $fun$download$2.invoke(this.$data.getUrl(), this.$data.getArchivePath());
                            CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).info("Signature verification is " + (CodeWithMeClientDownloader.access$getConfig$p(CodeWithMeClientDownloader.INSTANCE).getVerifySignature() ? "ON" : "OFF"));
                            if (CodeWithMeClientDownloader.access$getConfig$p(CodeWithMeClientDownloader.INSTANCE).getVerifySignature()) {
                                pgpKeyRingFile22 = Files.createTempFile(this.$tempDir, "KEYS", "", new FileAttribute[0]);
                                String string = this.$sessionInfoResponse.getDownloadPgpPublicKeyUrl();
                                if (string == null) {
                                    string = "https://download.jetbrains.com/KEYS";
                                }
                                URI uRI = new URI(string);
                                Object object = pgpKeyRingFile22;
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pgpKeyRingFile");
                                $fun$download$2.invoke(uRI, (Path)object);
                                Path checksumPath22 = CodeWithMeClientDownloader.access$addSuffix(CodeWithMeClientDownloader.INSTANCE, this.$data.getArchivePath(), ".sha256");
                                Path signaturePath = CodeWithMeClientDownloader.access$addSuffix(CodeWithMeClientDownloader.INSTANCE, this.$data.getArchivePath(), ".sha256.asc");
                                URI uRI2 = UrlUtilKt.addPathSuffix(this.$data.getUrl(), ".sha256");
                                Path path2 = checksumPath22;
                                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"checksumPath");
                                $fun$download$2.invoke(uRI2, path2);
                                URI uRI3 = UrlUtilKt.addPathSuffix(this.$data.getUrl(), ".sha256.asc");
                                Path path3 = signaturePath;
                                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"signaturePath");
                                $fun$download$2.invoke(uRI3, path3);
                                PgpSignaturesVerifier pgpVerifier2 = new PgpSignaturesVerifier(new PgpSignaturesVerifierLogger(this){
                                    final /* synthetic */ downloadClientAndJdk.6 this$0;

                                    public void info(@NotNull String message2) {
                                        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                                        CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).info("Verifying " + this.this$0.$data.getUrl() + " PGP signature: " + message2);
                                    }
                                    {
                                        this.this$0 = this$0;
                                    }
                                });
                                CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).info("Running checksum signature verifier for " + this.$data.getArchivePath());
                                Sha256ChecksumSignatureVerifier sha256ChecksumSignatureVerifier = new Sha256ChecksumSignatureVerifier(pgpVerifier2);
                                Path path4 = this.$data.getArchivePath();
                                String string2 = this.$data.getUrl().getPath();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"data.url.path");
                                String string3 = StringsKt.substringAfterLast$default((String)string2, (char)'/', null, (int)2, null);
                                InputStream inputStream2 = new ByteArrayInputStream(Files.readAllBytes((Path)pgpKeyRingFile22));
                                String string4 = JetBrainsPgpConstants.INSTANCE.getJETBRAINS_DOWNLOADS_PGP_MASTER_PUBLIC_KEY();
                                Charset charset = Charsets.UTF_8;
                                boolean bl4 = false;
                                String string5 = string4;
                                if (string5 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                }
                                byte[] byArray = string5.getBytes(charset);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                                sha256ChecksumSignatureVerifier.verifyChecksumAndSignature(path4, signaturePath, checksumPath22, string3, inputStream2, (InputStream)new ByteArrayInputStream(byArray));
                                CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).info("Signature verified for " + this.$data.getArchivePath());
                            }
                        }
                        catch (IOException ex) {
                            this.$future.complete(false);
                            CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).warn((Throwable)ex);
                            pgpKeyRingFile22 = CodeWithMeClientDownloader.access$getCurrentlyDownloading$p(CodeWithMeClientDownloader.INSTANCE);
                            boolean checksumPath22 = false;
                            boolean bl5 = false;
                            synchronized (pgpKeyRingFile22) {
                                boolean bl6 = false;
                                CompletableFuture completableFuture3 = (CompletableFuture)CodeWithMeClientDownloader.access$getCurrentlyDownloading$p(CodeWithMeClientDownloader.INSTANCE).remove(this.$data.getTargetPath());
                            }
                            return;
                        }
                        this.$dataProgressIndicator.setFraction(0.75);
                        this.$data.setStatus(DownloadableFileState.Extracting);
                        this.$updateStateText$5.invoke();
                        Path archivePath = this.$data.getArchivePath();
                        CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).info("Extracting " + archivePath + " to " + this.$data.getTargetPath() + "...");
                        FileUtil.delete((Path)this.$data.getTargetPath());
                        pgpKeyRingFile22 = this.$data.getTargetPath();
                        LinkOption[] checksumPath22 = new LinkOption[]{};
                        boolean bl7 = false;
                        boolean pgpKeyRingFile22 = Files.notExists((Path)pgpKeyRingFile22, Arrays.copyOf(checksumPath22, checksumPath22.length));
                        boolean checksumPath22 = false;
                        bl7 = false;
                        if (!pgpKeyRingFile22) {
                            boolean bl8 = false;
                            String string = "Target path \"" + this.$data.getTargetPath() + "\" for " + archivePath + " already exists";
                            throw (Throwable)new IllegalArgumentException(string.toString());
                        }
                        FileManifestUtil.INSTANCE.decompressWithManifest(archivePath, this.$data.getTargetPath(), this.$data.getIncludeInManifest());
                        pgpKeyRingFile22 = FileManifestUtil.INSTANCE.isUpToDate(this.$data.getTargetPath(), this.$data.getIncludeInManifest());
                        checksumPath22 = false;
                        bl7 = false;
                        if (!pgpKeyRingFile22) {
                            boolean bl9 = false;
                            String string = "Manifest verification failed for archive: " + archivePath + " -> " + this.$data.getTargetPath();
                            throw (Throwable)new IllegalArgumentException(string.toString());
                        }
                        this.$dataProgressIndicator.setFraction(1.0);
                        this.$data.setStatus(DownloadableFileState.Done);
                        this.$updateStateText$5.invoke();
                        Files.delete(archivePath);
                        this.$future.complete(true);
                    }
                    catch (Throwable e) {
                        this.$future.complete(false);
                        CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).warn(e);
                    }
                    finally {
                        concurrentHashMap = CodeWithMeClientDownloader.access$getCurrentlyDownloading$p(CodeWithMeClientDownloader.INSTANCE);
                        bl = false;
                        boolean bl10 = false;
                        synchronized (concurrentHashMap) {
                            boolean bl11 = false;
                            CompletableFuture completableFuture = (CompletableFuture)CodeWithMeClientDownloader.access$getCurrentlyDownloading$p(CodeWithMeClientDownloader.INSTANCE).remove(this.$data.getTargetPath());
                        }
                    }
                }
                {
                    this.$data = downloadableFileData;
                    this.$future = completableFuture;
                    this.$dataProgressIndicator = multipleSubProgressIndicator;
                    this.$updateStateText$5 = var4_4;
                    this.$tempDir = path2;
                    this.$sessionInfoResponse = codeWithMeSessionInfoProvider;
                }
            });
            ++index2;
        }
        try {
            Boolean guestSucceeded = guestData.getDownloadFuture().get();
            Boolean jdkSucceeded = jdkData.getDownloadFuture().get();
            Boolean bl9 = guestSucceeded;
            Intrinsics.checkNotNullExpressionValue((Object)bl9, (String)"guestSucceeded");
            if (bl9.booleanValue()) {
                Boolean bl10 = jdkSucceeded;
                Intrinsics.checkNotNullExpressionValue((Object)bl10, (String)"jdkSucceeded");
                if (bl10.booleanValue()) {
                    RemoteDevStatisticsCollector.INSTANCE.onGuestDownloadFinished(activity, true);
                    LOG.info("Download of guest and jdk succeeded");
                    return TuplesKt.to((Object)guestData.getTargetPath(), (Object)jdkData.getTargetPath());
                }
            }
            LOG.warn("Some of downloads failed: guestSucceeded=" + guestSucceeded + ", jdkSucceeded=" + jdkSucceeded);
            RemoteDevStatisticsCollector.INSTANCE.onGuestDownloadFinished(activity, false);
            return null;
        }
        catch (ProcessCanceledException e) {
            LOG.info("Download was canceled");
            return null;
        }
        catch (Throwable e) {
            LOG.warn(e);
            return null;
        }
    }

    private final boolean isAlreadyDownloaded(DownloadableFileData fileData) {
        FileManifestUtil.ExtractDirectory extractDirectory = FileManifestUtil.INSTANCE.getExtractDirectory(fileData.getTargetPath(), fileData.getIncludeInManifest());
        return extractDirectory.isUpToDate() && !StringsKt.contains$default((CharSequence)((Object)fileData.getTargetPath().getFileName()).toString(), (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadWithRetries(URI url, Path path2, ProgressIndicator progressIndicator) {
        long BACKOFF_INITIAL_DELAY_MS;
        boolean bl = ApplicationKt.getApplication().isUnitTestMode() || !ApplicationKt.getApplication().isDispatchThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "This method should not be called on UI thread";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int MAX_ATTEMPTS = 5;
        long delayMs = BACKOFF_INITIAL_DELAY_MS = 500L;
        boolean bl5 = true;
        int n = MAX_ATTEMPTS;
        while (true) {
            void i2;
            try {
                Path path3 = path2;
                boolean bl6 = false;
                LOG.info("Downloading from " + url + " to " + ((Object)path3.toAbsolutePath()).toString() + ", attempt " + (int)i2 + " of " + MAX_ATTEMPTS);
                HttpRequests.request((String)url.toString()).saveToFile(path2, progressIndicator);
                path3 = path2;
                bl6 = false;
                LOG.info("Download from " + url + " to " + ((Object)path3.toAbsolutePath()).toString() + " succeeded on attempt " + (int)i2 + " of " + MAX_ATTEMPTS);
                return;
            }
            catch (Throwable e) {
                boolean bl7;
                int n2;
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                if (e instanceof HttpRequests.HttpStatusException && 400 <= (n2 = ((HttpRequests.HttpStatusException)e).getStatusCode()) && 499 >= n2) {
                    LOG.warn("Received " + ((HttpRequests.HttpStatusException)e).getStatusCode() + " with message " + e.getMessage() + ", will not retry");
                    throw e;
                }
                if (i2 >= MAX_ATTEMPTS) {
                    Path path4 = path2;
                    bl7 = false;
                    LOG.warn("Failed to download from " + url + " to " + ((Object)path4.toAbsolutePath()).toString() + " in " + MAX_ATTEMPTS + " attempts", e);
                    throw e;
                }
                Path path5 = path2;
                bl7 = false;
                LOG.warn("Attempt " + (int)i2 + " of " + MAX_ATTEMPTS + " to download from " + url + " to " + ((Object)path5.toAbsolutePath()).toString() + " failed, retrying in " + delayMs + " ms", e);
                Thread.sleep(delayMs);
                delayMs = (long)((double)delayMs * 1.5);
                if (i2 != n) {
                    ++i2;
                    continue;
                }
                return;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path findCwmGuestHome(Path guestRoot) {
        Object object = Files.walk(guestRoot, 2, new FileVisitOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Stream it = (Stream)object;
            boolean bl3 = false;
            Iterator iterator2 = it.iterator();
            while (iterator2.hasNext()) {
                Path dir = (Path)iterator2.next();
                Path path2 = dir.resolve("bin");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dir.resolve(\"bin\")");
                if (!PathKt.exists((Path)path2)) continue;
                Path path3 = dir.resolve("lib");
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"dir.resolve(\"lib\")");
                if (!PathKt.exists((Path)path3)) continue;
                Path path4 = dir;
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"dir");
                Path path5 = path4;
                return path5;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        object = "JetBrains Client home is not found under " + guestRoot;
        bl = false;
        throw (Throwable)new IllegalStateException(object.toString());
    }

    private final Pair<Path, List<String>> findLauncher(Path guestRoot, List<String> launcherNames) {
        Pair launcher;
        Pair pair;
        boolean bl;
        Object object;
        block4: {
            object = launcherNames;
            bl = false;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Pair pair2;
                Pair pair3;
                Path launcherRelative;
                Object t = iterator2.next();
                String it = (String)t;
                boolean bl2 = false;
                Path path2 = launcherRelative = Path.of("bin", it);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"launcherRelative");
                Path launcher2 = INSTANCE.findLauncher(guestRoot, path2);
                if (launcher2 != null) {
                    Path path3;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Path it2 = path3;
                    boolean bl5 = false;
                    pair3 = TuplesKt.to((Object)launcher2, (Object)CollectionsKt.listOf((Object)((Object)launcher2).toString()));
                } else {
                    pair3 = null;
                }
                if ((pair2 = pair3) == null) continue;
                pair = pair2;
                break block4;
            }
            pair = null;
        }
        Pair pair4 = launcher = pair;
        if (pair4 == null) {
            object = "Could not find launchers (" + CollectionsKt.joinToString$default((Iterable)launcherNames, null, null, null, (int)0, null, (Function1)findLauncher.1.INSTANCE, (int)31, null) + ") under " + guestRoot;
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return pair4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path findLauncher(Path guestRoot, Path launcherName) {
        AutoCloseable autoCloseable = Files.walk(guestRoot, 2, new FileVisitOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl3 = false;
            Iterator iterator2 = it.iterator();
            while (iterator2.hasNext()) {
                Path candidate;
                Path dir = (Path)iterator2.next();
                Path path2 = candidate = dir.resolve(launcherName);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"candidate");
                if (!PathKt.exists((Path)path2)) continue;
                Path path3 = candidate;
                return path3;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return null;
    }

    private final Pair<Path, List<String>> findLauncherUnderCwmGuestRoot(Path guestRoot) {
        if (SystemInfo.isWindows) {
            List launcherNames = CollectionsKt.listOf((Object[])new String[]{"jetbrains_client64.exe", "cwm_guest64.exe", "intellij_client64.exe", "intellij_client.bat"});
            return this.findLauncher(guestRoot, launcherNames);
        }
        if (SystemInfo.isUnix) {
            if (SystemInfo.isMac) {
                Object[] objectArray = guestRoot.toFile().listFiles(findLauncherUnderCwmGuestRoot.app.1.INSTANCE);
                Intrinsics.checkNotNull((Object)objectArray);
                File app2 = (File)ArraysKt.singleOrNull((Object[])objectArray);
                if (app2 != null) {
                    Path path2 = app2.toPath();
                    Object[] objectArray2 = new String[5];
                    objectArray2[0] = "open";
                    objectArray2[1] = "-n";
                    objectArray2[2] = "-a";
                    String string = app2.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"app.toString()");
                    objectArray2[3] = string;
                    objectArray2[4] = "--args";
                    return TuplesKt.to((Object)path2, (Object)CollectionsKt.listOf((Object[])objectArray2));
                }
            }
            List shLauncherNames = CollectionsKt.listOf((Object[])new String[]{"jetbrains_client.sh", "cwm_guest.sh", "intellij_client.sh"});
            return this.findLauncher(guestRoot, shLauncherNames);
        }
        String string = "Unsupported OS: " + SystemInfo.OS_NAME;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Lifetime runCwmGuestProcessFromDownload(@NotNull Lifetime lifetime, @NotNull String url, @NotNull Path guestRoot, @NotNull Path jdkRoot) {
        void executable;
        Path path2;
        boolean bl;
        String string;
        Path path3;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)guestRoot, (String)"guestRoot");
        Intrinsics.checkNotNullParameter((Object)jdkRoot, (String)"jdkRoot");
        Pair<Path, List<String>> pair = this.findLauncherUnderCwmGuestRoot(guestRoot);
        Path path4 = (Path)pair.component1();
        List fullLauncherCmd = (List)pair.component2();
        Path guestHome = this.findCwmGuestHome(guestRoot);
        if (SystemInfo.isMac) {
            path3 = jdkRoot;
            string = "jbr";
            bl = false;
            Path path5 = path3.resolve(string);
            path2 = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"this.resolve(other)");
        } else {
            path2 = this.detectTrueJdkRoot(jdkRoot);
        }
        Path linkTarget = path2;
        path3 = guestHome;
        string = "jbr";
        bl = false;
        Path path6 = path3.resolve(string);
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"this.resolve(other)");
        this.createSymlink(path6, linkTarget);
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new Path[]{guestRoot, jdkRoot});
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path7 = (Path)element$iv;
            boolean bl2 = false;
            Files.setLastModifiedTime(path7, FileTime.fromMillis(System.currentTimeMillis()));
        }
        List parameters2 = CollectionsKt.listOf((Object[])new String[]{"thinClient", url});
        LifetimeDefinition processLifetimeDef = lifetime.createNested();
        Path vmOptionsFile = executable.resolveSibling("jetbrains_client64.vmoptions");
        boolean $i$f$service = false;
        Class<JetBrainsClientDownloaderConfigurationProvider> serviceClass$iv = JetBrainsClientDownloaderConfigurationProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        JetBrainsClientDownloaderConfigurationProvider jetBrainsClientDownloaderConfigurationProvider = (JetBrainsClientDownloaderConfigurationProvider)object;
        Path path8 = vmOptionsFile;
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"vmOptionsFile");
        jetBrainsClientDownloaderConfigurationProvider.patchVmOptions(path8);
        if (SystemInfo.isWindows) {
            WinNT.HANDLE hProcess = WindowsFileUtil.windowsShellExecute$default(WindowsFileUtil.INSTANCE, (Path)executable, guestRoot, parameters2, null, 8, null);
            int STILL_ACTIVE = 259;
            ApplicationKt.getApplication().executeOnPooledThread(new Runnable(STILL_ACTIVE, hProcess, processLifetimeDef){
                final /* synthetic */ int $STILL_ACTIVE;
                final /* synthetic */ WinNT.HANDLE $hProcess;
                final /* synthetic */ LifetimeDefinition $processLifetimeDef;

                public final void run() {
                    IntByReference exitCode = new IntByReference(this.$STILL_ACTIVE);
                    while (exitCode.getValue() == this.$STILL_ACTIVE) {
                        Kernel32.INSTANCE.GetExitCodeProcess(this.$hProcess, exitCode);
                        Thread.sleep(1000L);
                    }
                    LifetimeDefinition.terminate$default((LifetimeDefinition)this.$processLifetimeDef, (boolean)false, (int)1, null);
                }
                {
                    this.$STILL_ACTIVE = n;
                    this.$hProcess = hANDLE;
                    this.$processLifetimeDef = lifetimeDefinition;
                }
            });
            LifetimeExKt.onTerminationOrNow(lifetime, (Function0<Unit>)((Function0)new Function0<Unit>(hProcess, STILL_ACTIVE){
                final /* synthetic */ WinNT.HANDLE $hProcess;
                final /* synthetic */ int $STILL_ACTIVE;

                public final void invoke() {
                    IntByReference exitCode = new IntByReference(-1);
                    Kernel32.INSTANCE.GetExitCodeProcess(this.$hProcess, exitCode);
                    if (exitCode.getValue() != this.$STILL_ACTIVE) {
                        return;
                    }
                    CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).info("Terminating cwm guest process");
                    if (!Kernel32.INSTANCE.TerminateProcess(this.$hProcess, 1)) {
                        int error = Kernel32.INSTANCE.GetLastError();
                        WinNT.HRESULT hResult = new WinNT.HRESULT(error);
                        Logger logger = CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE);
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to terminate cwm guest process, HRESULT=");
                        String string = "0x%x";
                        Object[] objectArray = new Object[]{hResult};
                        boolean bl = false;
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
                        logger.error(stringBuilder.append(string2).toString());
                    }
                }
                {
                    this.$hProcess = hANDLE;
                    this.$STILL_ACTIVE = n;
                    super(0);
                }
            }));
        } else {
            void attemptCount;
            Ref.IntRef hProcess = new Ref.IntRef();
            hProcess.element = SystemInfo.isMac ? 5 : 1;
            Ref.LongRef lastProcessStartTime = new Ref.LongRef();
            Function0<Unit> $fun$doRunProcess$4 = new Function0<Unit>(fullLauncherCmd, parameters2, (Ref.IntRef)attemptCount, lastProcessStartTime, processLifetimeDef, lifetime){
                final /* synthetic */ List $fullLauncherCmd;
                final /* synthetic */ List $parameters;
                final /* synthetic */ Ref.IntRef $attemptCount;
                final /* synthetic */ Ref.LongRef $lastProcessStartTime;
                final /* synthetic */ LifetimeDefinition $processLifetimeDef;
                final /* synthetic */ Lifetime $lifetime;

                public final void invoke() {
                    GeneralCommandLine commandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)this.$fullLauncherCmd, (Iterable)this.$parameters));
                    CodeWithMeClientDownloader.access$getConfig$p(CodeWithMeClientDownloader.INSTANCE).modifyClientCommandLine(commandLine);
                    CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).info("Starting JetBrains Client process (attempts left: " + this.$attemptCount.element + "): " + commandLine);
                    int n = this.$attemptCount.element;
                    this.$attemptCount.element = n + -1;
                    this.$lastProcessStartTime.element = System.currentTimeMillis();
                    OSProcessHandler processHandler2 = new OSProcessHandler(commandLine, commandLine){
                        final /* synthetic */ GeneralCommandLine $commandLine;

                        @NotNull
                        protected BaseOutputReader.Options readerOptions() {
                            BaseOutputReader.Options options2 = BaseOutputReader.Options.forMostlySilentProcess();
                            Intrinsics.checkNotNullExpressionValue((Object)options2, (String)"BaseOutputReader.Options.forMostlySilentProcess()");
                            return options2;
                        }
                        {
                            this.$commandLine = $captured_local_variable$0;
                            super($super_call_param$1);
                        }
                    };
                    ProcessAdapter listener2 = new ProcessAdapter(this){
                        final /* synthetic */ runCwmGuestProcessFromDownload.4 this$0;

                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                            super.onTextAvailable(event, outputType);
                            CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).info("GUEST OUTPUT: " + event.getText());
                        }

                        public void processTerminated(@NotNull ProcessEvent event) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            super.processTerminated(event);
                            CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).info("Guest process terminated, exit code " + event.getExitCode());
                            if (event.getExitCode() != 0 && System.currentTimeMillis() - this.this$0.$lastProcessStartTime.element < (long)10000) {
                                if (this.this$0.$attemptCount.element > 0) {
                                    CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).info("Previous attempt to start guest process failed, will try again in one second");
                                    Intrinsics.checkNotNullExpressionValue((Object)EdtScheduledExecutorService.getInstance().schedule(new Runnable(this){
                                        final /* synthetic */ runCwmGuestProcessFromDownload.listener.1 this$0;

                                        public final void run() {
                                            this.this$0.this$0.invoke();
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    }, ModalityState.any(), 1L, TimeUnit.SECONDS), (String)"EdtScheduledExecutorServ\u2026y(), 1, TimeUnit.SECONDS)");
                                } else {
                                    CodeWithMeClientDownloader.access$getLOG$p(CodeWithMeClientDownloader.INSTANCE).warn("Running client process failed after specified number of attempts");
                                    ApplicationKt.getApplication().invokeLater(new Runnable(this){
                                        final /* synthetic */ runCwmGuestProcessFromDownload.listener.1 this$0;

                                        public final void run() {
                                            LifetimeDefinition.terminate$default((LifetimeDefinition)this.this$0.this$0.$processLifetimeDef, (boolean)false, (int)1, null);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    });
                                }
                            }
                        }
                        {
                            this.this$0 = this$0;
                        }
                    };
                    processHandler2.addProcessListener((ProcessListener)listener2);
                    processHandler2.startNotify();
                    InterfacesKt.fire((ISignal)((ISignal)CodeWithMeClientDownloader.access$getConfig$p(CodeWithMeClientDownloader.INSTANCE).getClientLaunched()));
                    LifetimeExKt.onTerminationOrNow(this.$lifetime, (Function0<Unit>)((Function0)new Function0<Unit>(processHandler2){
                        final /* synthetic */ runCwmGuestProcessFromDownload.processHandler.1 $processHandler;

                        public final void invoke() {
                            this.$processHandler.getProcess().children().forEach(runCwmGuestProcessFromDownload.1.INSTANCE);
                            this.$processHandler.getProcess().destroyForcibly();
                        }
                        {
                            this.$processHandler = var1_1;
                            super(0);
                        }
                    }));
                }
                {
                    this.$fullLauncherCmd = list2;
                    this.$parameters = list3;
                    this.$attemptCount = intRef;
                    this.$lastProcessStartTime = longRef;
                    this.$processLifetimeDef = lifetimeDefinition;
                    this.$lifetime = lifetime;
                    super(0);
                }
            };
            $fun$doRunProcess$4.invoke();
        }
        return processLifetimeDef.getLifetime();
    }

    public final void createSymlinkToJdkFromGuest(@NotNull Path guestRoot, @NotNull Path jdkRoot) {
        Path path2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)guestRoot, (String)"guestRoot");
        Intrinsics.checkNotNullParameter((Object)jdkRoot, (String)"jdkRoot");
        if (SystemInfo.isMac) {
            Path path3 = jdkRoot;
            object = "jbr";
            boolean bl = false;
            Path path4 = path3.resolve((String)object);
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this.resolve(other)");
        } else {
            path2 = this.detectTrueJdkRoot(jdkRoot);
        }
        Path linkTarget = path2;
        Path guestHome = this.findCwmGuestHome(guestRoot);
        object = guestHome;
        String string = "jbr";
        boolean bl = false;
        Path path5 = object.resolve(string);
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"this.resolve(other)");
        this.createSymlink(path5, linkTarget);
    }

    private final void createSymlink(Path link2, Path target2) {
        Path targetRealPath = target2.toRealPath(new LinkOption[0]);
        if (PathKt.exists((Path)link2) && Intrinsics.areEqual((Object)link2.toRealPath(new LinkOption[0]), (Object)targetRealPath)) {
            LOG.info("Symlink/junction '" + link2 + "' is UP-TO-DATE and points to '" + target2 + '\'');
        } else {
            Files.deleteIfExists(link2);
            LOG.info("Creating symlink/junction '" + link2 + "' -> '" + target2 + '\'');
            try {
                Path path2;
                if (SystemInfo.isWindows) {
                    path2 = target2;
                    boolean bl = false;
                    Path path3 = path2.toAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath()");
                    WindowsFileUtil.INSTANCE.createJunction(link2, path3);
                } else {
                    path2 = target2;
                    boolean bl = false;
                    Path path4 = path2.toAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toAbsolutePath()");
                    Files.createSymbolicLink(link2, path4, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                if (PathKt.exists((Path)link2) && Intrinsics.areEqual((Object)link2.toRealPath(new LinkOption[0]), (Object)targetRealPath)) {
                    LOG.warn("Creating symlink/junction to already existing target. '" + link2 + "' -> '" + target2 + '\'');
                }
                throw (Throwable)e;
            }
            try {
                Path linkRealPath = link2.toRealPath(new LinkOption[0]);
                if (Intrinsics.areEqual((Object)linkRealPath, (Object)targetRealPath) ^ true) {
                    LOG.error("Symlink/junction '" + link2 + "' should point to '" + targetRealPath + "', but points to '" + linkRealPath + "' instead");
                }
            }
            catch (Throwable e) {
                LOG.error(e);
                throw e;
            }
        }
    }

    private final Path detectTrueJdkRoot(Path jdkDownload) {
        File file2 = jdkDownload.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"jdkDownload.toFile()");
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk((File)file2, (FileWalkDirection)FileWalkDirection.TOP_DOWN);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (!new File(it, "bin").isDirectory() || !new File(it, "lib").isDirectory()) continue;
            Path path2 = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"it.toPath()");
            return path2;
        }
        String string = "JDK root (bin/lib directories) was not found under " + jdkDownload;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    public final boolean versionsMatch(@NotNull String hostBuildNumberString, @NotNull String localBuildNumberString) {
        Intrinsics.checkNotNullParameter((Object)hostBuildNumberString, (String)"hostBuildNumberString");
        Intrinsics.checkNotNullParameter((Object)localBuildNumberString, (String)"localBuildNumberString");
        try {
            BuildNumber buildNumber = BuildNumber.fromString((String)hostBuildNumberString);
            Intrinsics.checkNotNull((Object)buildNumber);
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"BuildNumber.fromString(hostBuildNumberString)!!");
            BuildNumber hostBuildNumber = buildNumber;
            BuildNumber buildNumber2 = BuildNumber.fromString((String)localBuildNumberString);
            Intrinsics.checkNotNull((Object)buildNumber2);
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"BuildNumber.fromString(localBuildNumberString)!!");
            BuildNumber localBuildNumber = buildNumber2;
            if ((localBuildNumber.isSnapshot() || hostBuildNumber.isSnapshot()) && hostBuildNumber.getBaselineVersion() == localBuildNumber.getBaselineVersion()) {
                return true;
            }
            return Intrinsics.areEqual((Object)hostBuildNumber.asStringWithoutProductCode(), (Object)localBuildNumber.asStringWithoutProductCode());
        }
        catch (Throwable t) {
            LOG.error("Error comparing versions " + hostBuildNumberString + " and " + localBuildNumberString + ": " + t.getMessage(), t);
            return false;
        }
    }

    private final Path addSuffix(Path $this$addSuffix, String suffix) {
        return $this$addSuffix.resolveSibling(((Object)$this$addSuffix.getFileName()).toString() + suffix);
    }

    public final boolean isValidDownloadUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return urlAllowedChars.matches((CharSequence)url) && !StringsKt.contains$default((CharSequence)url, (CharSequence)"..", (boolean)false, (int)2, null);
    }

    private CodeWithMeClientDownloader() {
    }

    static {
        CodeWithMeClientDownloader codeWithMeClientDownloader;
        INSTANCE = codeWithMeClientDownloader = new CodeWithMeClientDownloader();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeWithMeClientDownloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        cwmGuestManifestFilter = cwmGuestManifestFilter.1.INSTANCE;
        cwmJbrManifestFilter = cwmJbrManifestFilter.1.INSTANCE;
        buildNumberRegex = new Regex("[0-9]{3}\\.(([0-9]+(\\.[0-9]+)?)|SNAPSHOT)");
        currentlyDownloading = new ConcurrentHashMap();
        urlAllowedChars = new Regex("^[._\\-a-zA-Z0-9:/]+$");
    }

    public static final /* synthetic */ ConcurrentHashMap access$getCurrentlyDownloading$p(CodeWithMeClientDownloader $this) {
        CodeWithMeClientDownloader codeWithMeClientDownloader = $this;
        return currentlyDownloading;
    }

    public static final /* synthetic */ Logger access$getLOG$p(CodeWithMeClientDownloader $this) {
        CodeWithMeClientDownloader codeWithMeClientDownloader = $this;
        return LOG;
    }

    public static final /* synthetic */ boolean access$isAlreadyDownloaded(CodeWithMeClientDownloader $this, DownloadableFileData fileData) {
        return $this.isAlreadyDownloaded(fileData);
    }

    public static final /* synthetic */ void access$downloadWithRetries(CodeWithMeClientDownloader $this, URI url, Path path2, ProgressIndicator progressIndicator) {
        $this.downloadWithRetries(url, path2, progressIndicator);
    }

    public static final /* synthetic */ JetBrainsClientDownloaderConfigurationProvider access$getConfig$p(CodeWithMeClientDownloader $this) {
        return $this.getConfig();
    }

    public static final /* synthetic */ Path access$addSuffix(CodeWithMeClientDownloader $this, Path $this$access_u24addSuffix, String suffix) {
        return $this.addSuffix($this$access_u24addSuffix, suffix);
    }

    public static final /* synthetic */ boolean access$isJbrSymlink(CodeWithMeClientDownloader $this, Path file2) {
        return $this.isJbrSymlink(file2);
    }

    public static final /* synthetic */ boolean access$isSymlink(CodeWithMeClientDownloader $this, Path file2) {
        return $this.isSymlink(file2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u00c6\u0003J\t\u0010&\u001a\u00020\u000fH\u00c6\u0003Ja\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010(\u001a\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileData;", "", "fileName", "", "url", "Ljava/net/URI;", "archivePath", "Ljava/nio/file/Path;", "targetPath", "includeInManifest", "Lkotlin/Function1;", "", "downloadFuture", "Ljava/util/concurrent/CompletableFuture;", "status", "Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileState;", "(Ljava/lang/String;Ljava/net/URI;Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/CompletableFuture;Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileState;)V", "getArchivePath", "()Ljava/nio/file/Path;", "getDownloadFuture", "()Ljava/util/concurrent/CompletableFuture;", "getFileName", "()Ljava/lang/String;", "getIncludeInManifest", "()Lkotlin/jvm/functions/Function1;", "getStatus", "()Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileState;", "setStatus", "(Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileState;)V", "getTargetPath", "getUrl", "()Ljava/net/URI;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "intellij.remoteDev.util"})
    private static final class DownloadableFileData {
        @NotNull
        private final String fileName;
        @NotNull
        private final URI url;
        @NotNull
        private final Path archivePath;
        @NotNull
        private final Path targetPath;
        @NotNull
        private final Function1<Path, Boolean> includeInManifest;
        @NotNull
        private final CompletableFuture<Boolean> downloadFuture;
        @NotNull
        private DownloadableFileState status;

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final URI getUrl() {
            return this.url;
        }

        @NotNull
        public final Path getArchivePath() {
            return this.archivePath;
        }

        @NotNull
        public final Path getTargetPath() {
            return this.targetPath;
        }

        @NotNull
        public final Function1<Path, Boolean> getIncludeInManifest() {
            return this.includeInManifest;
        }

        @NotNull
        public final CompletableFuture<Boolean> getDownloadFuture() {
            return this.downloadFuture;
        }

        @NotNull
        public final DownloadableFileState getStatus() {
            return this.status;
        }

        public final void setStatus(@NotNull DownloadableFileState downloadableFileState) {
            Intrinsics.checkNotNullParameter((Object)((Object)downloadableFileState), (String)"<set-?>");
            this.status = downloadableFileState;
        }

        public DownloadableFileData(@NotNull String fileName, @NotNull URI url, @NotNull Path archivePath, @NotNull Path targetPath, @NotNull Function1<? super Path, Boolean> includeInManifest, @NotNull CompletableFuture<Boolean> downloadFuture, @NotNull DownloadableFileState status) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)archivePath, (String)"archivePath");
            Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
            Intrinsics.checkNotNullParameter(includeInManifest, (String)"includeInManifest");
            Intrinsics.checkNotNullParameter(downloadFuture, (String)"downloadFuture");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            this.fileName = fileName;
            this.url = url;
            this.archivePath = archivePath;
            this.targetPath = targetPath;
            this.includeInManifest = includeInManifest;
            this.downloadFuture = downloadFuture;
            this.status = status;
        }

        public /* synthetic */ DownloadableFileData(String string, URI uRI, Path path2, Path path3, Function1 function1, CompletableFuture completableFuture, DownloadableFileState downloadableFileState, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                completableFuture = new CompletableFuture<Boolean>();
            }
            if ((n & 0x40) != 0) {
                downloadableFileState = DownloadableFileState.Downloading;
            }
            this(string, uRI, path2, path3, (Function1<? super Path, Boolean>)function1, completableFuture, downloadableFileState);
        }

        @NotNull
        public final String component1() {
            return this.fileName;
        }

        @NotNull
        public final URI component2() {
            return this.url;
        }

        @NotNull
        public final Path component3() {
            return this.archivePath;
        }

        @NotNull
        public final Path component4() {
            return this.targetPath;
        }

        @NotNull
        public final Function1<Path, Boolean> component5() {
            return this.includeInManifest;
        }

        @NotNull
        public final CompletableFuture<Boolean> component6() {
            return this.downloadFuture;
        }

        @NotNull
        public final DownloadableFileState component7() {
            return this.status;
        }

        @NotNull
        public final DownloadableFileData copy(@NotNull String fileName, @NotNull URI url, @NotNull Path archivePath, @NotNull Path targetPath, @NotNull Function1<? super Path, Boolean> includeInManifest, @NotNull CompletableFuture<Boolean> downloadFuture, @NotNull DownloadableFileState status) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)archivePath, (String)"archivePath");
            Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
            Intrinsics.checkNotNullParameter(includeInManifest, (String)"includeInManifest");
            Intrinsics.checkNotNullParameter(downloadFuture, (String)"downloadFuture");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            return new DownloadableFileData(fileName, url, archivePath, targetPath, includeInManifest, downloadFuture, status);
        }

        public static /* synthetic */ DownloadableFileData copy$default(DownloadableFileData downloadableFileData, String string, URI uRI, Path path2, Path path3, Function1 function1, CompletableFuture completableFuture, DownloadableFileState downloadableFileState, int n, Object object) {
            if ((n & 1) != 0) {
                string = downloadableFileData.fileName;
            }
            if ((n & 2) != 0) {
                uRI = downloadableFileData.url;
            }
            if ((n & 4) != 0) {
                path2 = downloadableFileData.archivePath;
            }
            if ((n & 8) != 0) {
                path3 = downloadableFileData.targetPath;
            }
            if ((n & 0x10) != 0) {
                function1 = downloadableFileData.includeInManifest;
            }
            if ((n & 0x20) != 0) {
                completableFuture = downloadableFileData.downloadFuture;
            }
            if ((n & 0x40) != 0) {
                downloadableFileState = downloadableFileData.status;
            }
            return downloadableFileData.copy(string, uRI, path2, path3, function1, completableFuture, downloadableFileState);
        }

        @NotNull
        public String toString() {
            return "DownloadableFileData(fileName=" + this.fileName + ", url=" + this.url + ", archivePath=" + this.archivePath + ", targetPath=" + this.targetPath + ", includeInManifest=" + this.includeInManifest + ", downloadFuture=" + this.downloadFuture + ", status=" + (Object)((Object)this.status) + ")";
        }

        public int hashCode() {
            String string = this.fileName;
            URI uRI = this.url;
            Path path2 = this.archivePath;
            Path path3 = this.targetPath;
            Function1<Path, Boolean> function1 = this.includeInManifest;
            CompletableFuture<Boolean> completableFuture = this.downloadFuture;
            DownloadableFileState downloadableFileState = this.status;
            return ((((((string != null ? string.hashCode() : 0) * 31 + (uRI != null ? ((Object)uRI).hashCode() : 0)) * 31 + (path2 != null ? ((Object)path2).hashCode() : 0)) * 31 + (path3 != null ? ((Object)path3).hashCode() : 0)) * 31 + (function1 != null ? function1.hashCode() : 0)) * 31 + (completableFuture != null ? completableFuture.hashCode() : 0)) * 31 + (downloadableFileState != null ? ((Object)((Object)downloadableFileState)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DownloadableFileData)) break block3;
                    DownloadableFileData downloadableFileData = (DownloadableFileData)object;
                    if (!Intrinsics.areEqual((Object)this.fileName, (Object)downloadableFileData.fileName) || !Intrinsics.areEqual((Object)this.url, (Object)downloadableFileData.url) || !Intrinsics.areEqual((Object)this.archivePath, (Object)downloadableFileData.archivePath) || !Intrinsics.areEqual((Object)this.targetPath, (Object)downloadableFileData.targetPath) || !Intrinsics.areEqual(this.includeInManifest, downloadableFileData.includeInManifest) || !Intrinsics.areEqual(this.downloadFuture, downloadableFileData.downloadFuture) || !Intrinsics.areEqual((Object)((Object)this.status), (Object)((Object)downloadableFileData.status))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$DownloadableFileState;", "", "(Ljava/lang/String;I)V", "Downloading", "Extracting", "Done", "intellij.remoteDev.util"})
    private static final class DownloadableFileState
    extends Enum<DownloadableFileState> {
        public static final /* enum */ DownloadableFileState Downloading;
        public static final /* enum */ DownloadableFileState Extracting;
        public static final /* enum */ DownloadableFileState Done;
        private static final /* synthetic */ DownloadableFileState[] $VALUES;

        static {
            DownloadableFileState[] downloadableFileStateArray = new DownloadableFileState[3];
            DownloadableFileState[] downloadableFileStateArray2 = downloadableFileStateArray;
            downloadableFileStateArray[0] = Downloading = new DownloadableFileState();
            downloadableFileStateArray[1] = Extracting = new DownloadableFileState();
            downloadableFileStateArray[2] = Done = new DownloadableFileState();
            $VALUES = downloadableFileStateArray;
        }

        public static DownloadableFileState[] values() {
            return (DownloadableFileState[])$VALUES.clone();
        }

        public static DownloadableFileState valueOf(String string) {
            return Enum.valueOf(DownloadableFileState.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$MultipleSubProgressIndicator;", "Lcom/intellij/remoteDev/util/SubProgressIndicatorBase;", "parent", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onFractionChange", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function0;)V", "subFraction", "", "getFraction", "setFraction", "fraction", "Companion", "intellij.remoteDev.util"})
    private static final class MultipleSubProgressIndicator
    extends SubProgressIndicatorBase {
        private double subFraction;
        private final Function0<Unit> onFractionChange;
        @NotNull
        public static final Companion Companion = new Companion(null);

        public double getFraction() {
            return this.subFraction;
        }

        public void setFraction(double fraction) {
            this.subFraction = fraction;
            this.onFractionChange.invoke();
        }

        public MultipleSubProgressIndicator(@NotNull ProgressIndicator parent, @NotNull Function0<Unit> onFractionChange) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter(onFractionChange, (String)"onFractionChange");
            super(parent);
            this.onFractionChange = onFractionChange;
        }

        public static final /* synthetic */ double access$getSubFraction$p(MultipleSubProgressIndicator $this) {
            return $this.subFraction;
        }

        public static final /* synthetic */ void access$setSubFraction$p(MultipleSubProgressIndicator $this, double d) {
            $this.subFraction = d;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$MultipleSubProgressIndicator$Companion;", "", "()V", "create", "", "Lcom/intellij/remoteDev/downloader/CodeWithMeClientDownloader$MultipleSubProgressIndicator;", "parent", "Lcom/intellij/openapi/progress/ProgressIndicator;", "count", "", "intellij.remoteDev.util"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<MultipleSubProgressIndicator> create(@NotNull ProgressIndicator parent, int count) {
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                boolean bl = false;
                List result2 = new ArrayList();
                double parentBaseFraction = parent.getFraction();
                int n = 0;
                int n2 = count;
                if (n <= n2) {
                    while (true) {
                        void i2;
                        MultipleSubProgressIndicator element2 = new MultipleSubProgressIndicator(parent, (Function0<Unit>)((Function0)new Function0<Unit>(result2, parent, parentBaseFraction, count){
                            final /* synthetic */ List $result;
                            final /* synthetic */ ProgressIndicator $parent;
                            final /* synthetic */ double $parentBaseFraction;
                            final /* synthetic */ int $count;

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                Iterable iterable = this.$result;
                                boolean bl = false;
                                double d = 0.0;
                                for (T t : iterable) {
                                    void it;
                                    MultipleSubProgressIndicator multipleSubProgressIndicator = (MultipleSubProgressIndicator)((Object)t);
                                    double d2 = d;
                                    boolean bl2 = false;
                                    double d3 = MultipleSubProgressIndicator.access$getSubFraction$p((MultipleSubProgressIndicator)it);
                                    d = d2 + d3;
                                }
                                double subFraction = d;
                                double d4 = this.$parentBaseFraction + subFraction * (1.0 / (double)this.$count);
                                d = 1.0;
                                boolean bl3 = false;
                                this.$parent.setFraction(Math.min(d4, d));
                            }
                            {
                                this.$result = list2;
                                this.$parent = progressIndicator;
                                this.$parentBaseFraction = d;
                                this.$count = n;
                                super(0);
                            }
                        }));
                        result2.add(element2);
                        if (i2 == n2) break;
                        ++i2;
                    }
                }
                return result2;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

