/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.ui;

import com.intellij.remoteDev.ui.TextComponentHint;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006*\u0002\u000e\u0011\b\u0007\u0018\u00002\u00020\u0001:\u0001%B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u0016J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0014J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/intellij/remoteDev/ui/TextComponentHint;", "Ljavax/swing/JLabel;", "component", "Ljavax/swing/text/JTextComponent;", "text", "", "state", "Lcom/intellij/remoteDev/ui/TextComponentHint$State;", "(Ljavax/swing/text/JTextComponent;Ljava/lang/String;Lcom/intellij/remoteDev/ui/TextComponentHint$State;)V", "getComponent", "()Ljavax/swing/text/JTextComponent;", "document", "Ljavax/swing/text/Document;", "documentListener", "com/intellij/remoteDev/ui/TextComponentHint$documentListener$1", "Lcom/intellij/remoteDev/ui/TextComponentHint$documentListener$1;", "focusListener", "com/intellij/remoteDev/ui/TextComponentHint$focusListener$1", "Lcom/intellij/remoteDev/ui/TextComponentHint$focusListener$1;", "focusLost", "", "showHintOnce", "", "getState", "()Lcom/intellij/remoteDev/ui/TextComponentHint$State;", "setState", "(Lcom/intellij/remoteDev/ui/TextComponentHint$State;)V", "checkForHint", "", "getShowHintOnce", "setAlpha", "alpha", "", "value", "setShowHintOnce", "setStyle", "style", "State", "intellij.remoteDev.util"})
@ApiStatus.Experimental
public final class TextComponentHint
extends JLabel {
    private final Document document;
    private boolean showHintOnce;
    private int focusLost;
    private final documentListener.1 documentListener;
    private final focusListener.1 focusListener;
    @NotNull
    private final JTextComponent component;
    @NotNull
    private State state;

    public final void setAlpha(float alpha) {
        this.setAlpha((int)(alpha * (float)255));
    }

    public final void setAlpha(int value2) {
        Color foreground;
        int alpha = value2;
        alpha = alpha > 255 ? 255 : (alpha < 0 ? 0 : alpha);
        Color color = foreground = this.getForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground");
        int red = color.getRed();
        int green = foreground.getGreen();
        int blue = foreground.getBlue();
        Color withAlpha = new Color(red, green, blue, alpha);
        super.setForeground(withAlpha);
    }

    public final void setStyle(int style) {
        this.setFont(this.getFont().deriveFont(style));
    }

    public final boolean getShowHintOnce() {
        return this.showHintOnce;
    }

    public final void setShowHintOnce(boolean showHintOnce) {
        this.showHintOnce = showHintOnce;
    }

    private final void checkForHint() {
        if (this.document.getLength() > 0) {
            this.setVisible(false);
            return;
        }
        if (this.showHintOnce && this.focusLost > 0) {
            this.setVisible(false);
            return;
        }
        this.setVisible(this.component.hasFocus() ? this.state == State.ALWAYS || this.state == State.FOCUS_GAINED : this.state == State.ALWAYS || this.state == State.FOCUS_LOST);
    }

    @NotNull
    public final JTextComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    public TextComponentHint(@NotNull JTextComponent component2, @Nls @NotNull String text2, @NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        super(text2);
        this.component = component2;
        this.state = state;
        Document document = this.component.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"component.document");
        this.document = document;
        this.documentListener = new DocumentListener(this){
            final /* synthetic */ TextComponentHint this$0;

            public void insertUpdate(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TextComponentHint.access$checkForHint(this.this$0);
            }

            public void removeUpdate(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TextComponentHint.access$checkForHint(this.this$0);
            }

            public void changedUpdate(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
            {
                this.this$0 = this$0;
            }
        };
        this.focusListener = new FocusListener(this){
            final /* synthetic */ TextComponentHint this$0;

            public void focusGained(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TextComponentHint.access$checkForHint(this.this$0);
            }

            public void focusLost(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TextComponentHint textComponentHint = this.this$0;
                int n = TextComponentHint.access$getFocusLost$p(textComponentHint);
                TextComponentHint.access$setFocusLost$p(textComponentHint, n + 1);
                TextComponentHint.access$checkForHint(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.setFont(this.component.getFont());
        this.setForeground(this.component.getForeground());
        this.setBorder(new EmptyBorder(this.component.getInsets()));
        this.setHorizontalAlignment(10);
        this.setAlpha(0.5f);
        this.setStyle(2);
        this.component.addFocusListener(this.focusListener);
        this.document.addDocumentListener(this.documentListener);
        this.component.setLayout(new BorderLayout());
        this.component.add(this);
        this.checkForHint();
    }

    public /* synthetic */ TextComponentHint(JTextComponent jTextComponent, String string, State state, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            state = State.FOCUS_LOST;
        }
        this(jTextComponent, string, state);
    }

    public static final /* synthetic */ void access$checkForHint(TextComponentHint $this) {
        $this.checkForHint();
    }

    public static final /* synthetic */ int access$getFocusLost$p(TextComponentHint $this) {
        return $this.focusLost;
    }

    public static final /* synthetic */ void access$setFocusLost$p(TextComponentHint $this, int n) {
        $this.focusLost = n;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/remoteDev/ui/TextComponentHint$State;", "", "(Ljava/lang/String;I)V", "ALWAYS", "FOCUS_GAINED", "FOCUS_LOST", "intellij.remoteDev.util"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State ALWAYS;
        public static final /* enum */ State FOCUS_GAINED;
        public static final /* enum */ State FOCUS_LOST;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = ALWAYS = new State();
            stateArray[1] = FOCUS_GAINED = new State();
            stateArray[2] = FOCUS_LOST = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

