/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteDev.util.FileManifestUtil;
import com.intellij.remoteDev.util.FileManifestUtil$ManifestGenerator$WhenMappings;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fJ\"\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fJ\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fJ\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\fH\u0002J\"\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/remoteDev/util/FileManifestUtil;", "", "()V", "HashSeed", "", "ManifestFileName", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "decompressWithManifest", "", "archiveFile", "Ljava/nio/file/Path;", "targetDir", "includeInManifest", "Lkotlin/Function1;", "", "generateDirectoryManifest", "root", "getExtractDirectory", "Lcom/intellij/remoteDev/util/FileManifestUtil$ExtractDirectory;", "path", "filterPaths", "isSymlink", "file", "isUpToDate", "ExtractDirectory", "ManifestGenerator", "intellij.remoteDev.util"})
@ApiStatus.Experimental
public final class FileManifestUtil {
    private static final Logger logger;
    @NotNull
    public static final String ManifestFileName = ".manifest.txt";
    @NotNull
    public static final String HashSeed = "e69b0a64-b91a-4da6-bc80-35828c9a97d1";
    @NotNull
    public static final FileManifestUtil INSTANCE;

    private final boolean isSymlink(Path file2) {
        FileAttributes fileAttributes = FileSystemUtil.getAttributes((File)file2.toFile());
        return fileAttributes != null && fileAttributes.isSymLink();
    }

    public final void decompressWithManifest(@NotNull Path archiveFile, @NotNull Path targetDir, @NotNull Function1<? super Path, Boolean> includeInManifest) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter(includeInManifest, (String)"includeInManifest");
        if (PathKt.exists((Path)targetDir)) {
            String string = targetDir + " already exists, refusing to extract to it";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ManifestGenerator manifestor = new ManifestGenerator(targetDir, includeInManifest);
        if (StringsKt.equals((String)PathsKt.getExtension((Path)archiveFile), (String)"zip", (boolean)true) || StringsKt.equals((String)PathsKt.getExtension((Path)archiveFile), (String)"sit", (boolean)true)) {
            new Decompressor.Zip(archiveFile).withZipExtensions().allowEscapingSymlinks(false).postProcessor((BiConsumer)manifestor).extract(targetDir);
        } else if (StringsKt.endsWith((String)PathsKt.getName((Path)archiveFile), (String)".tar.gz", (boolean)true)) {
            new Decompressor.Tar(archiveFile).allowEscapingSymlinks(false).postProcessor((BiConsumer)manifestor).extract(targetDir);
        } else {
            String string = "Unknown archive extension in file name: " + PathsKt.getName((Path)archiveFile);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        manifestor.writeToDisk(targetDir);
    }

    @NotNull
    public final String generateDirectoryManifest(@NotNull Path root2, @NotNull Function1<? super Path, Boolean> includeInManifest) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter(includeInManifest, (String)"includeInManifest");
        ManifestGenerator manifestor = new ManifestGenerator(root2, includeInManifest);
        manifestor.calculateForExistingDirectory();
        return manifestor.generate();
    }

    public final boolean isUpToDate(@NotNull Path root2, @NotNull Function1<? super Path, Boolean> includeInManifest) {
        Path manifestFile;
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter(includeInManifest, (String)"includeInManifest");
        Path path2 = manifestFile = root2.resolve(ManifestFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"manifestFile");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = false;
        if (Files.notExists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger.info("isUpToDate false for '" + root2 + "': manifest file " + manifestFile + " does not exist");
            return false;
        }
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
        String manifestFileContent = PathsKt.readText((Path)manifestFile, (Charset)charset);
        String actualOnDiskContent = this.generateDirectoryManifest(root2, includeInManifest);
        if (Intrinsics.areEqual((Object)manifestFileContent, (Object)actualOnDiskContent)) {
            logger.info("isUpToDate true for '" + root2 + "': manifest file " + manifestFile + " contains actual information");
            return true;
        }
        logger.info("isUpToDate false for '" + root2 + "': manifest file " + manifestFile + " differs from on disk content\n" + "on disk content:\n" + actualOnDiskContent + '\n' + "saved manifest in " + manifestFile + " content:\n" + manifestFileContent);
        HashSet onDiskLines = CollectionsKt.toHashSet((Iterable)StringsKt.lines((CharSequence)actualOnDiskContent));
        HashSet manifestLines = CollectionsKt.toHashSet((Iterable)StringsKt.lines((CharSequence)manifestFileContent));
        Set commonLines = CollectionsKt.intersect((Iterable)onDiskLines, (Iterable)manifestLines);
        Set onDiskOnly = SetsKt.minus((Set)onDiskLines, (Iterable)commonLines);
        Set manifestOnly = SetsKt.minus((Set)manifestLines, (Iterable)commonLines);
        logger.info(onDiskOnly.size() + " elements are present only on disk and not found in the manifest: " + CollectionsKt.joinToString$default((Iterable)onDiskOnly, null, null, null, (int)0, null, (Function1)isUpToDate.1.INSTANCE, (int)31, null));
        logger.info(manifestOnly.size() + " elements are present only in the manifest and not found on disk: " + CollectionsKt.joinToString$default((Iterable)manifestOnly, null, null, null, (int)0, null, (Function1)isUpToDate.2.INSTANCE, (int)31, null));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ExtractDirectory getExtractDirectory(@NotNull Path path2, @NotNull Function1<? super Path, Boolean> filterPaths) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(filterPaths, (String)"filterPaths");
        String suffix = "" + '.' + ProcessHandle.current().pid() + '.' + System.currentTimeMillis();
        int retriesCount = 100;
        int n = 1;
        Iterable $this$forEach$iv = (Iterable)new IntRange(n, retriesCount);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Path destinationPath;
            int element$iv;
            int attempt = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Path path3 = destinationPath = attempt <= 1 ? path2 : Path.of("" + path2 + '-' + attempt, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"destinationPath");
            boolean isUpToDate2 = INSTANCE.isUpToDate(path3, filterPaths);
            if (isUpToDate2) {
                logger.info("All files inside extract directory '" + destinationPath + "' are up-to-date");
                return new ExtractDirectory(destinationPath, true);
            }
            if (!PathKt.exists((Path)destinationPath)) {
                logger.info("Destination does not exist, returning " + destinationPath);
                return new ExtractDirectory(destinationPath, false);
            }
            Path renamedPath = new File(destinationPath + suffix).toPath();
            try {
                Files.move(destinationPath, renamedPath, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (Throwable t) {
                logger.debug("Rename '" + destinationPath + "' to '" + renamedPath + "' has failed. Probably file is locked by another process. Trying the next one.");
                continue;
            }
            finally {
                try {
                    FileUtil.delete((Path)renamedPath);
                }
                catch (Throwable t) {
                    logger.warn("Unable to delete renamed destination (generally should not happen): " + renamedPath, t);
                }
                continue;
            }
            logger.info("Destination was deleted, returning path '" + destinationPath + '\'');
            return new ExtractDirectory(destinationPath, false);
        }
        throw (Throwable)new IllegalStateException("Exceeded " + retriesCount + " retries to get safe destination based on '" + path2 + "'.");
    }

    private FileManifestUtil() {
    }

    static {
        FileManifestUtil fileManifestUtil;
        INSTANCE = fileManifestUtil = new FileManifestUtil();
        Logger logger = Logger.getInstance(fileManifestUtil.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(javaClass)");
        FileManifestUtil.logger = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u001f B!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J0\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\rJ\u0006\u0010\u001b\u001a\u00020\u000bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u000e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0003R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/remoteDev/util/FileManifestUtil$ManifestGenerator;", "Ljava/util/function/BiConsumer;", "Lcom/intellij/util/io/Decompressor$Entry;", "Ljava/nio/file/Path;", "targetDir", "includeInManifest", "Lkotlin/Function1;", "", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)V", "list", "", "", "accept", "", "entry", "path", "addManifestEntry", "name", "type", "Lcom/intellij/util/io/Decompressor$Entry$Type;", "mode", "", "size", "", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "calculateForExistingDirectory", "generate", "readAttributesNoFollowLinks", "Lcom/intellij/remoteDev/util/FileManifestUtil$ManifestGenerator$FileAttributes;", "writeToDisk", "FileAttributes", "ManifestFileVisitor", "intellij.remoteDev.util"})
    public static final class ManifestGenerator
    implements BiConsumer<Decompressor.Entry, Path> {
        private final List<String> list;
        private final Path targetDir;
        private final Function1<Path, Boolean> includeInManifest;

        /*
         * Unable to fully structure code
         */
        @Override
        public void accept(@NotNull Decompressor.Entry entry, @NotNull Path path) {
            block14: {
                block13: {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    if (!((Boolean)this.includeInManifest.invoke((Object)path)).booleanValue()) {
                        return;
                    }
                    var3_3 = Intrinsics.areEqual((Object)entry.name, (Object)".manifest.txt") ^ true;
                    var4_6 = false;
                    var5_9 = false;
                    if (!var3_3) {
                        $i$a$-require-FileManifestUtil$ManifestGenerator$accept$1 = false;
                        var5_10 = "There already is a manifest file in archive.";
                        throw (Throwable)new IllegalArgumentException(var5_10.toString());
                    }
                    v0 = PathsKt.relativeToOrNull((Path)path, (Path)this.targetDir);
                    if (v0 != null) {
                        (Comparable)v0;
                    } else {
                        var3_4 = path;
                        var4_6 = false;
                        v1 = new StringBuilder().append("Extraction path ").append(var3_4.toAbsolutePath().toString()).append(" is not relative to ").append(this.targetDir).append(": ");
                        var3_4 = path;
                        var4_6 = false;
                        (Comparable)v1.append(var3_4.toAbsolutePath().toString()).toString();
                    }
                    var4_7 = entry.name;
                    var5_9 = false;
                    $i$a$-require-FileManifestUtil$ManifestGenerator$accept$1 = false;
                    it = var4_7;
                    $i$a$-let-FileManifestUtil$ManifestGenerator$accept$name$1 = false;
                    name = entry.type == Decompressor.Entry.Type.DIR ? it + '/' : it;
                    if (!SystemInfo.isWindows) break block13;
                    v2 = 0;
                    break block14;
                }
                v3 = entry.type;
                if (v3 == null) ** GOTO lbl-1000
                switch (FileManifestUtil$ManifestGenerator$WhenMappings.$EnumSwitchMapping$0[v3.ordinal()]) {
                    case 1: {
                        v4 = isOriginallyExecutable = (entry.mode & 73) > 0;
                        if (isOriginallyExecutable) {
                            v5 = 33261;
                            break;
                        }
                        v5 = 33188;
                        break;
                    }
                    case 2: {
                        v5 = -1;
                        break;
                    }
                    case 3: {
                        v5 = 16877;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        var6_14 = "Unknown entry type for " + entry.name;
                        var7_19 = false;
                        throw (Throwable)new IllegalStateException(var6_14.toString());
                    }
                }
                normalizedMode = v5;
                if (entry.type != Decompressor.Entry.Type.SYMLINK) {
                    var6_15 = path;
                    var7_18 = "unix:mode";
                    var8_22 = normalizedMode;
                    var9_24 = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                    var10_26 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)Files.setAttribute(var6_15, var7_18, var8_22, Arrays.copyOf(var9_24, var9_24.length)), (String)"Files.setAttribute(this,\u2026tribute, value, *options)");
                }
                v2 = normalizedMode;
            }
            mode = v2;
            attributes = this.readAttributesNoFollowLinks(path);
            if (entry.type != Decompressor.Entry.Type.SYMLINK) {
                var6_17 = attributes.getMode() == mode;
                var7_20 = false;
                var8_21 = false;
                if (!var6_17) {
                    $i$a$-require-FileManifestUtil$ManifestGenerator$accept$2 = false;
                    var8_23 = name + ": expected mode: " + mode + ", on disk: " + attributes.getMode();
                    throw (Throwable)new IllegalArgumentException(var8_23.toString());
                }
            }
            v6 = name;
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"name");
            v7 = entry.type;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"entry.type");
            this.addManifestEntry(v6, v7, mode, attributes.getSize(), attributes.getLastModifiedTime());
        }

        private final void addManifestEntry(String name2, Decompressor.Entry.Type type, int mode, long size, FileTime lastModifiedTime) {
            switch (FileManifestUtil$ManifestGenerator$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                case 1: {
                    this.list.add(name2 + " L " + size + ' ' + lastModifiedTime.toMillis() / (long)1000);
                    break;
                }
                case 2: {
                    this.list.add(name2 + " F " + Integer.toOctalString(mode) + ' ' + size + ' ' + lastModifiedTime.toMillis() / (long)1000);
                    break;
                }
                case 3: {
                    this.list.add(name2 + " D " + Integer.toOctalString(mode));
                    break;
                }
            }
        }

        private final FileAttributes readAttributesNoFollowLinks(Path path2) {
            Map<String, Object> attrs;
            Object object;
            List attributeList = CollectionsKt.mutableListOf((Object[])new String[]{"lastModifiedTime", "size"});
            if (!SystemInfo.isWindows) {
                attributeList.add(0, "unix:mode");
            }
            if (!((object = (attrs = Files.readAttributes(path2, CollectionsKt.joinToString$default((Iterable)attributeList, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), LinkOption.NOFOLLOW_LINKS)).get("mode")) instanceof Integer)) {
                object = null;
            }
            Integer n = (Integer)object;
            Object object2 = attrs.get("lastModifiedTime");
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.nio.file.attribute.FileTime");
            }
            Object object3 = attrs.get("size");
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
            }
            return new FileAttributes(n != null ? n : 0, (FileTime)object2, (Long)object3);
        }

        public final void calculateForExistingDirectory() {
            boolean bl = PathKt.isDirectory((Path)this.targetDir);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = this.targetDir + " is not a directory";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = this.list.isEmpty();
            bl2 = false;
            bl3 = false;
            bl3 = false;
            boolean bl5 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Files.walkFileTree(this.targetDir, new ManifestFileVisitor());
        }

        @NotNull
        public final String generate() {
            String contentPart = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)this.list), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            StringBuilder stringBuilder = new StringBuilder();
            String string = FileManifestUtil.HashSeed + contentPart;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            return stringBuilder.append(DigestUtil.sha256Hex((byte[])byArray)).append('\n').append(contentPart).toString();
        }

        public final void writeToDisk(@NotNull Path targetDir) {
            Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
            Path path2 = targetDir.resolve(FileManifestUtil.ManifestFileName);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"targetDir.resolve(ManifestFileName)");
            CharSequence charSequence = this.generate();
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
            PathsKt.writeText((Path)path2, (CharSequence)charSequence, (Charset)charset, (OpenOption[])new OpenOption[0]);
        }

        public ManifestGenerator(@NotNull Path targetDir, @NotNull Function1<? super Path, Boolean> includeInManifest) {
            Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
            Intrinsics.checkNotNullParameter(includeInManifest, (String)"includeInManifest");
            this.targetDir = targetDir;
            this.includeInManifest = includeInManifest;
            boolean bl = false;
            this.list = new ArrayList();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/remoteDev/util/FileManifestUtil$ManifestGenerator$FileAttributes;", "", "mode", "", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "size", "", "(ILjava/nio/file/attribute/FileTime;J)V", "getLastModifiedTime", "()Ljava/nio/file/attribute/FileTime;", "getMode", "()I", "getSize", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.remoteDev.util"})
        private static final class FileAttributes {
            private final int mode;
            @NotNull
            private final FileTime lastModifiedTime;
            private final long size;

            public final int getMode() {
                return this.mode;
            }

            @NotNull
            public final FileTime getLastModifiedTime() {
                return this.lastModifiedTime;
            }

            public final long getSize() {
                return this.size;
            }

            public FileAttributes(int mode, @NotNull FileTime lastModifiedTime, long size) {
                Intrinsics.checkNotNullParameter((Object)lastModifiedTime, (String)"lastModifiedTime");
                this.mode = mode;
                this.lastModifiedTime = lastModifiedTime;
                this.size = size;
            }

            public final int component1() {
                return this.mode;
            }

            @NotNull
            public final FileTime component2() {
                return this.lastModifiedTime;
            }

            public final long component3() {
                return this.size;
            }

            @NotNull
            public final FileAttributes copy(int mode, @NotNull FileTime lastModifiedTime, long size) {
                Intrinsics.checkNotNullParameter((Object)lastModifiedTime, (String)"lastModifiedTime");
                return new FileAttributes(mode, lastModifiedTime, size);
            }

            public static /* synthetic */ FileAttributes copy$default(FileAttributes fileAttributes, int n, FileTime fileTime, long l, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = fileAttributes.mode;
                }
                if ((n2 & 2) != 0) {
                    fileTime = fileAttributes.lastModifiedTime;
                }
                if ((n2 & 4) != 0) {
                    l = fileAttributes.size;
                }
                return fileAttributes.copy(n, fileTime, l);
            }

            @NotNull
            public String toString() {
                return "FileAttributes(mode=" + this.mode + ", lastModifiedTime=" + this.lastModifiedTime + ", size=" + this.size + ")";
            }

            public int hashCode() {
                FileTime fileTime = this.lastModifiedTime;
                return (Integer.hashCode(this.mode) * 31 + (fileTime != null ? ((Object)fileTime).hashCode() : 0)) * 31 + Long.hashCode(this.size);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof FileAttributes)) break block3;
                        FileAttributes fileAttributes = (FileAttributes)object;
                        if (this.mode != fileAttributes.mode || !Intrinsics.areEqual((Object)this.lastModifiedTime, (Object)fileAttributes.lastModifiedTime) || this.size != fileAttributes.size) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u000b\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/remoteDev/util/FileManifestUtil$ManifestGenerator$ManifestFileVisitor;", "Ljava/nio/file/SimpleFileVisitor;", "Ljava/nio/file/Path;", "(Lcom/intellij/remoteDev/util/FileManifestUtil$ManifestGenerator;)V", "preVisitDirectory", "Ljava/nio/file/FileVisitResult;", "dir", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "visitFile", "file", "visitFileFailed", "exc", "Ljava/io/IOException;", "intellij.remoteDev.util"})
        public final class ManifestFileVisitor
        extends SimpleFileVisitor<Path> {
            @Override
            @NotNull
            public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) {
                Decompressor.Entry.Type type;
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!((Boolean)ManifestGenerator.this.includeInManifest.invoke((Object)file2)).booleanValue()) {
                    return FileVisitResult.CONTINUE;
                }
                if (Intrinsics.areEqual((Object)PathsKt.getName((Path)file2), (Object)FileManifestUtil.ManifestFileName)) {
                    return FileVisitResult.CONTINUE;
                }
                String name2 = StringsKt.replace$default((String)((Object)PathsKt.relativeTo((Path)file2, (Path)ManifestGenerator.this.targetDir)).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null);
                Object object = file2;
                boolean bl = false;
                if (Files.isSymbolicLink((Path)object)) {
                    type = Decompressor.Entry.Type.SYMLINK;
                } else {
                    object = file2;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    boolean bl2 = false;
                    if (Files.isRegularFile((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        type = Decompressor.Entry.Type.FILE;
                    } else {
                        object = file2;
                        boolean bl3 = false;
                        object = "Unknown file for " + ((Object)object.toAbsolutePath()).toString();
                        bl3 = false;
                        throw (Throwable)new IllegalStateException(object.toString());
                    }
                }
                Decompressor.Entry.Type type2 = type;
                FileAttributes attributes2 = ManifestGenerator.this.readAttributesNoFollowLinks(file2);
                ManifestGenerator.this.addManifestEntry(name2, type2, attributes2.getMode(), attributes2.getSize(), attributes2.getLastModifiedTime());
                return FileVisitResult.CONTINUE;
            }

            @Override
            @NotNull
            public FileVisitResult visitFileFailed(@Nullable Path file2, @Nullable IOException exc) {
                if (exc instanceof NoSuchFileException && file2 != null) {
                    try {
                        boolean isBrokenSymlink;
                        boolean bl = isBrokenSymlink = INSTANCE.isSymlink(file2) && !PathKt.exists((Path)file2);
                        if (isBrokenSymlink) {
                            Path path2 = file2;
                            LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                            boolean bl2 = false;
                            if (Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                return FileVisitResult.CONTINUE;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                FileVisitResult fileVisitResult = super.visitFileFailed(file2, exc);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)fileVisitResult), (String)"super.visitFileFailed(file, exc)");
                return fileVisitResult;
            }

            @Override
            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dir, @Nullable BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                if (Intrinsics.areEqual((Object)dir, (Object)ManifestGenerator.this.targetDir)) {
                    return FileVisitResult.CONTINUE;
                }
                if (((Boolean)ManifestGenerator.this.includeInManifest.invoke((Object)dir)).booleanValue()) {
                    String name2 = StringsKt.replace$default((String)((Object)PathsKt.relativeTo((Path)dir, (Path)ManifestGenerator.this.targetDir)).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null) + "/";
                    Decompressor.Entry.Type type = Decompressor.Entry.Type.DIR;
                    FileAttributes attributes2 = ManifestGenerator.this.readAttributesNoFollowLinks(dir);
                    ManifestGenerator.this.addManifestEntry(name2, type, attributes2.getMode(), attributes2.getSize(), attributes2.getLastModifiedTime());
                }
                return INSTANCE.isSymlink(dir) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/remoteDev/util/FileManifestUtil$ExtractDirectory;", "", "path", "Ljava/nio/file/Path;", "isUpToDate", "", "(Ljava/nio/file/Path;Z)V", "()Z", "getPath", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.remoteDev.util"})
    public static final class ExtractDirectory {
        @NotNull
        private final Path path;
        private final boolean isUpToDate;

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public final boolean isUpToDate() {
            return this.isUpToDate;
        }

        public ExtractDirectory(@NotNull Path path2, boolean isUpToDate2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.path = path2;
            this.isUpToDate = isUpToDate2;
        }

        @NotNull
        public final Path component1() {
            return this.path;
        }

        public final boolean component2() {
            return this.isUpToDate;
        }

        @NotNull
        public final ExtractDirectory copy(@NotNull Path path2, boolean isUpToDate2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return new ExtractDirectory(path2, isUpToDate2);
        }

        public static /* synthetic */ ExtractDirectory copy$default(ExtractDirectory extractDirectory, Path path2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                path2 = extractDirectory.path;
            }
            if ((n & 2) != 0) {
                bl = extractDirectory.isUpToDate;
            }
            return extractDirectory.copy(path2, bl);
        }

        @NotNull
        public String toString() {
            return "ExtractDirectory(path=" + this.path + ", isUpToDate=" + this.isUpToDate + ")";
        }

        public int hashCode() {
            Path path2 = this.path;
            int n = (path2 != null ? ((Object)path2).hashCode() : 0) * 31;
            int n2 = this.isUpToDate ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ExtractDirectory)) break block3;
                    ExtractDirectory extractDirectory = (ExtractDirectory)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)extractDirectory.path) || this.isUpToDate != extractDirectory.isUpToDate) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

