/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.util;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.execution.ParametersListUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.ShellAPI;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ!\u0010\r\u001a\u00020\t2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/remoteDev/util/WindowsFileUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SEE_MASK_NO_CLOSE_PROCESS", "", "createJunction", "", "junctionFile", "Ljava/nio/file/Path;", "targetFile", "runCommand", "command", "", "", "([Ljava/lang/String;)V", "windowsShellExecute", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "executable", "workingDirectory", "parameters", "", "waitForProcess", "Ljava/time/Duration;", "intellij.remoteDev.util"})
@ApiStatus.Experimental
public final class WindowsFileUtil {
    private static final Logger LOG;
    private static final int SEE_MASK_NO_CLOSE_PROCESS = 64;
    @NotNull
    public static final WindowsFileUtil INSTANCE;

    @NotNull
    public final WinNT.HANDLE windowsShellExecute(@NotNull Path executable, @NotNull Path workingDirectory, @NotNull List<String> parameters2, @Nullable Duration waitForProcess) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        ShellAPI.SHELLEXECUTEINFO info2 = new ShellAPI.SHELLEXECUTEINFO();
        info2.cbSize = info2.size();
        info2.lpFile = ((Object)executable).toString();
        info2.lpVerb = "open";
        info2.lpParameters = ParametersListUtil.join(parameters2);
        info2.lpDirectory = ((Object)workingDirectory).toString();
        info2.nShow = 1;
        info2.fMask = 64;
        String shellExecuteDebugParams = "ShellExecuteEx(" + "lpFile='" + info2.lpFile + "', " + "lpVerb='" + info2.lpVerb + "', " + "lpParameters='" + info2.lpParameters + "', " + "lpDirectory='" + info2.lpDirectory + "', " + "nShow='" + info2.nShow + "', " + "fMask='0x" + Integer.toHexString(info2.fMask) + "')";
        LOG.info("Calling " + shellExecuteDebugParams);
        if (!Shell32.INSTANCE.ShellExecuteEx(info2)) {
            throw (Throwable)new IOException(shellExecuteDebugParams + " returned 0x" + Integer.toHexString(Kernel32.INSTANCE.GetLastError()));
        }
        boolean bl = info2.hProcess != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "hProcess should not be null in our case";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (waitForProcess != null) {
            IntByReference exitCode = new IntByReference(-1);
            int waitRc = Kernel32.INSTANCE.WaitForSingleObject(info2.hProcess, -1);
            if (waitRc == 258) {
                throw (Throwable)new IOException(shellExecuteDebugParams + ": timeout waiting for process to exit");
            }
            Kernel32.INSTANCE.GetExitCodeProcess(info2.hProcess, exitCode);
            Kernel32.INSTANCE.CloseHandle(info2.hProcess);
            if (exitCode.getValue() == -1) {
                throw (Throwable)new IOException(shellExecuteDebugParams + ": could not read exit code");
            }
            if (exitCode.getValue() != 0) {
                throw (Throwable)new IOException(shellExecuteDebugParams + ": non-zero exit code: " + exitCode.getValue());
            }
        }
        WinNT.HANDLE hANDLE = info2.hProcess;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)"info.hProcess");
        return hANDLE;
    }

    public static /* synthetic */ WinNT.HANDLE windowsShellExecute$default(WindowsFileUtil windowsFileUtil, Path path2, Path path3, List list2, Duration duration, int n, Object object) {
        if ((n & 8) != 0) {
            duration = null;
        }
        return windowsFileUtil.windowsShellExecute(path2, path3, list2, duration);
    }

    public final void createJunction(@NotNull Path junctionFile, @NotNull Path targetFile) {
        Intrinsics.checkNotNullParameter((Object)junctionFile, (String)"junctionFile");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        if (!SystemInfo.isWindows) {
            throw (Throwable)new UnsupportedOperationException("Requires Windows OS");
        }
        this.runCommand("cmd", "/C", "mklink", "/J", ((Object)junctionFile).toString(), ((Object)targetFile).toString());
    }

    private final void runCommand(String ... command) {
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(Arrays.copyOf(command, command.length)).withRedirectErrorStream(true);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"GeneralCommandLine(*comm\u2026RedirectErrorStream(true)");
        GeneralCommandLine cmd = generalCommandLine;
        int timeoutMs = 30000;
        ProcessOutput output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (int)timeoutMs);
        if (output2.getExitCode() != 0) {
            StringBuilder stringBuilder = new StringBuilder().append("Could not create a windows junction with mklink: exit code ").append(output2.getExitCode()).append("; mklink output: ");
            String string = output2.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.stdout");
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            throw (Throwable)new IOException(stringBuilder.append(((Object)StringsKt.trim((CharSequence)string3)).toString()).toString());
        }
        if (output2.isTimeout()) {
            throw (Throwable)new IllegalStateException("Failed to create junction in " + timeoutMs + " ms, cmd: '" + cmd + '\'');
        }
    }

    private WindowsFileUtil() {
    }

    static {
        WindowsFileUtil windowsFileUtil;
        INSTANCE = windowsFileUtil = new WindowsFileUtil();
        Logger logger = Logger.getInstance(windowsFileUtil.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(javaClass)");
        LOG = logger;
    }
}

