/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reporting;

import com.google.gson.Gson;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.reporting.ReporterKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.zip.GZIPOutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a)\u0010\u000b\u001a\u00020\n\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\b\u001a\u0002H\f\u00a2\u0006\u0002\u0010\u000f\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0010"}, d2={"gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "Lkotlin/Lazy;", "compressBase64Gzip", "", "data", "text", "", "createReportLine", "T", "recorderId", "sessionId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;", "intellij.platform.ide.impl"})
public final class ReporterKt {
    private static final Lazy gson$delegate = LazyKt.lazy((Function0)gson.2.INSTANCE);

    private static final Gson getGson() {
        Lazy lazy = gson$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (Gson)lazy.getValue();
    }

    private static final byte[] compressBase64Gzip(String text2) {
        String string = text2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return ReporterKt.compressBase64Gzip(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] compressBase64Gzip(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Closeable closeable = new GZIPOutputStream(outputStream);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            GZIPOutputStream it = (GZIPOutputStream)closeable;
            boolean bl3 = false;
            it.write(data2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = Base64.getEncoder().encode(outputStream.toByteArray());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.getEncoder().enco\u2026tputStream.toByteArray())");
        return byArray;
    }

    @NotNull
    public static final <T> String createReportLine(@NotNull String recorderId, @NotNull String sessionId, T data2) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        String json = ReporterKt.getGson().toJson(data2);
        String string = PermanentInstallationID.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PermanentInstallationID.get()");
        String userUid = string;
        long stamp = System.currentTimeMillis();
        return "" + stamp + '\t' + recorderId + '\t' + userUid + '\t' + sessionId + '\t' + json;
    }

    public static final /* synthetic */ Gson access$getGson$p() {
        return ReporterKt.getGson();
    }

    public static final /* synthetic */ byte[] access$compressBase64Gzip(String text2) {
        return ReporterKt.compressBase64Gzip(text2);
    }
}

