/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie;

import ai.grazie.spell.GrazieSpeller;
import ai.grazie.spell.GrazieSplittingSpeller;
import ai.grazie.spell.Speller;
import ai.grazie.spell.language.English;
import ai.grazie.spell.lists.WordList;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.spell.utils.DictionaryResources;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.Transformation;
import com.intellij.spellchecker.grazie.GrazieSpellCheckerEngine;
import com.intellij.spellchecker.grazie.async.GrazieAsyncSpeller;
import com.intellij.spellchecker.grazie.async.WordListLoader;
import com.intellij.spellchecker.grazie.dictionary.ExtendedWordListWithFrequency;
import com.intellij.spellchecker.grazie.dictionary.WordListAdapter;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.SLRUCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.analysis.hunspell.TimeoutPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0010H\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0010H\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0010H\u0016J\b\u0010)\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000b\u001a*\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0010 \u000e*\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f0\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/spellchecker/grazie/GrazieSpellCheckerEngine;", "Lcom/intellij/spellchecker/engine/SpellCheckerEngine;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "adapter", "Lcom/intellij/spellchecker/grazie/dictionary/WordListAdapter;", "loader", "Lcom/intellij/spellchecker/grazie/async/WordListLoader;", "mySpeller", "Lcom/intellij/spellchecker/grazie/async/GrazieAsyncSpeller;", "suggestionsCache", "Lcom/intellij/util/containers/SLRUCache;", "Lcom/intellij/spellchecker/grazie/GrazieSpellCheckerEngine$SuggestionsRequest;", "kotlin.jvm.PlatformType", "", "", "addDictionary", "", "dictionary", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "addModifiableDictionary", "Lcom/intellij/spellchecker/dictionary/EditableDictionary;", "getSuggestions", "word", "maxSuggestions", "", "maxMetrics", "getTransformation", "Lcom/intellij/spellchecker/engine/Transformation;", "getVariants", "prefix", "isCorrect", "", "isDictionaryLoad", "name", "loadDictionary", "Lcom/intellij/spellchecker/dictionary/Loader;", "removeDictionariesRecursively", "directory", "removeDictionary", "reset", "SuggestionsRequest", "intellij.spellchecker"})
public final class GrazieSpellCheckerEngine
implements SpellCheckerEngine {
    private final WordListLoader loader;
    private final WordListAdapter adapter;
    private final GrazieAsyncSpeller mySpeller;
    private final SLRUCache<SuggestionsRequest, List<String>> suggestionsCache;

    @Override
    @NotNull
    public Transformation getTransformation() {
        return new Transformation();
    }

    @Override
    public boolean isDictionaryLoad(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.adapter.containsSource(name2);
    }

    @Override
    public void loadDictionary(@NotNull Loader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        this.loader.loadWordList(loader, (Function2<? super String, ? super WordList, Unit>)((Function2)new Function2<String, WordList, Unit>(this){
            final /* synthetic */ GrazieSpellCheckerEngine this$0;

            public final void invoke(@NotNull String name2, @NotNull WordList list2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
                GrazieSpellCheckerEngine.access$getAdapter$p(this.this$0).addList(name2, list2);
            }
            {
                this.this$0 = grazieSpellCheckerEngine;
                super(2);
            }
        }));
    }

    @Override
    public void addDictionary(@NotNull Dictionary dictionary) {
        Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
        this.adapter.addDictionary(dictionary);
    }

    @Override
    public void addModifiableDictionary(@NotNull EditableDictionary dictionary) {
        Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
        this.addDictionary(dictionary);
    }

    @Override
    public boolean isCorrect(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (this.mySpeller.isAlien(word)) {
            return true;
        }
        return !this.mySpeller.isMisspelled(word, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> getSuggestions(@NotNull String word, int maxSuggestions, int maxMetrics) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (this.mySpeller.isCreated()) {
            List list2;
            GrazieAsyncSpeller grazieAsyncSpeller = this.mySpeller;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (grazieAsyncSpeller) {
                boolean bl3 = false;
                List list3 = (List)this.suggestionsCache.get((Object)new SuggestionsRequest(word, maxSuggestions));
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
                list2 = list3;
            }
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"synchronized(mySpeller) \u2026 maxSuggestions))\n      }");
            return list2;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void reset() {
        this.adapter.reset();
    }

    @Override
    public void removeDictionary(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.adapter.removeSource(name2);
    }

    @Override
    @NotNull
    public List<String> getVariants(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeDictionariesRecursively(@NotNull String directory) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Iterable $this$filter$iv = this.adapter.getNames();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String name2 = (String)element$iv$iv;
            boolean bl = false;
            if (!(FileUtil.isAncestor((String)directory, (String)name2, (boolean)false) && this.isDictionaryLoad(name2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toRemove2 = (List)destination$iv$iv;
        for (String name3 : toRemove2) {
            this.adapter.removeSource(name3);
        }
    }

    public GrazieSpellCheckerEngine(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.loader = new WordListLoader(project);
        this.adapter = new WordListAdapter();
        this.mySpeller = new GrazieAsyncSpeller(project, (Function0<? extends Speller>)((Function0)new Function0<Speller>(this){
            final /* synthetic */ GrazieSpellCheckerEngine this$0;

            @NotNull
            public final Speller invoke() {
                return (Speller)new GrazieSplittingSpeller((Speller)new GrazieSpeller(new GrazieSpeller.UserConfig(new GrazieSpeller.UserConfig.Dictionary(null, (WordListWithFrequency)new ExtendedWordListWithFrequency((WordListWithFrequency)DictionaryResources.INSTANCE.getHunspellDict("/dictionary/en", TimeoutPolicy.NO_TIMEOUT, (Runnable)mySpeller.1.INSTANCE), GrazieSpellCheckerEngine.access$getAdapter$p(this.this$0)), (Function1)new Function1<String, Boolean>(this){
                    final /* synthetic */ mySpeller.1 this$0;

                    public final boolean invoke(@NotNull String word) {
                        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
                        return (Boolean)English.INSTANCE.isAlien().invoke((Object)word) != false && GrazieSpellCheckerEngine.access$getAdapter$p(this.this$0.this$0).isAlien(word);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, null, 9, null), null, 2, null)), new GrazieSplittingSpeller.UserConfig(null, 0, null, null, 15, null));
            }
            {
                this.this$0 = grazieSpellCheckerEngine;
                super(0);
            }
        }));
        SLRUCache sLRUCache = SLRUCache.create((int)1024, (int)1024, (NotNullFunction)new NotNullFunction(this){
            final /* synthetic */ GrazieSpellCheckerEngine this$0;

            @NotNull
            public final List<String> fun(SuggestionsRequest request2) {
                return CollectionsKt.take((Iterable)GrazieSpellCheckerEngine.access$getMySpeller$p(this.this$0).suggest(request2.getWord(), request2.getMaxSuggestions()), (int)request2.getMaxSuggestions());
            }
            {
                this.this$0 = grazieSpellCheckerEngine;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)sLRUCache, (String)"SLRUCache.create<Suggest\u2026quest.maxSuggestions)\n  }");
        this.suggestionsCache = sLRUCache;
    }

    public static final /* synthetic */ WordListAdapter access$getAdapter$p(GrazieSpellCheckerEngine $this) {
        return $this.adapter;
    }

    public static final /* synthetic */ GrazieAsyncSpeller access$getMySpeller$p(GrazieSpellCheckerEngine $this) {
        return $this.mySpeller;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/spellchecker/grazie/GrazieSpellCheckerEngine$SuggestionsRequest;", "", "word", "", "maxSuggestions", "", "(Ljava/lang/String;I)V", "getMaxSuggestions", "()I", "getWord", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.spellchecker"})
    private static final class SuggestionsRequest {
        @NotNull
        private final String word;
        private final int maxSuggestions;

        @NotNull
        public final String getWord() {
            return this.word;
        }

        public final int getMaxSuggestions() {
            return this.maxSuggestions;
        }

        public SuggestionsRequest(@NotNull String word, int maxSuggestions) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            this.word = word;
            this.maxSuggestions = maxSuggestions;
        }

        @NotNull
        public final String component1() {
            return this.word;
        }

        public final int component2() {
            return this.maxSuggestions;
        }

        @NotNull
        public final SuggestionsRequest copy(@NotNull String word, int maxSuggestions) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            return new SuggestionsRequest(word, maxSuggestions);
        }

        public static /* synthetic */ SuggestionsRequest copy$default(SuggestionsRequest suggestionsRequest, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = suggestionsRequest.word;
            }
            if ((n2 & 2) != 0) {
                n = suggestionsRequest.maxSuggestions;
            }
            return suggestionsRequest.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "SuggestionsRequest(word=" + this.word + ", maxSuggestions=" + this.maxSuggestions + ")";
        }

        public int hashCode() {
            String string = this.word;
            return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.maxSuggestions);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SuggestionsRequest)) break block3;
                    SuggestionsRequest suggestionsRequest = (SuggestionsRequest)object;
                    if (!Intrinsics.areEqual((Object)this.word, (Object)suggestionsRequest.word) || this.maxSuggestions != suggestionsRequest.maxSuggestions) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

