/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie.async;

import ai.grazie.spell.Speller;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.engine.SpellCheckerEngineListener;
import com.intellij.spellchecker.grazie.async.AsyncUtils;
import com.intellij.util.ThrowableRunnable;
import java.util.LinkedHashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\bH\u0016J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/spellchecker/grazie/async/GrazieAsyncSpeller;", "Lai/grazie/spell/Speller;", "project", "Lcom/intellij/openapi/project/Project;", "create", "Lkotlin/Function0;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "isCreated", "", "()Z", "speller", "isAlien", "word", "", "isMisspelled", "caseSensitive", "suggestAndRank", "", "", "max", "", "intellij.spellchecker"})
public final class GrazieAsyncSpeller
implements Speller {
    private Speller speller;
    private final Function0<Speller> create;

    public final boolean isCreated() {
        return this.speller != null;
    }

    public boolean isAlien(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Speller speller = this.speller;
        return speller != null ? speller.isAlien(word) : true;
    }

    public boolean isMisspelled(@NotNull String word, boolean caseSensitive) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Speller speller = this.speller;
        return speller != null ? speller.isMisspelled(word, caseSensitive) : false;
    }

    @NotNull
    public Map<String, Double> suggestAndRank(@NotNull String word, int max) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Object object = this.speller;
        if (object == null || (object = object.suggestAndRank(word, max)) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    public GrazieAsyncSpeller(final @NotNull Project project, @NotNull Function0<? extends Speller> create2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(create2, (String)"create");
        this.create = create2;
        AsyncUtils.INSTANCE.run(project, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                speller = (Speller)create.invoke();
                ReadAction.run((ThrowableRunnable)new ThrowableRunnable(){

                    public final void run() {
                        if (!project.isDisposed()) {
                            ((SpellCheckerEngineListener)project.getMessageBus().syncPublisher(SpellCheckerEngineListener.TOPIC)).onSpellerInitialized();
                        }
                    }
                });
            }
        }));
    }

    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word, int max) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return Speller.DefaultImpls.suggest((Speller)this, (String)word, (int)max);
    }

    public static final /* synthetic */ Speller access$getSpeller$p(GrazieAsyncSpeller $this) {
        return $this.speller;
    }
}

