/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.util.Consumer;
import com.intellij.util.io.URLUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainTextSplitter
extends BaseSplitter {
    private static final PlainTextSplitter INSTANCE = new PlainTextSplitter();
    @NonNls
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(\\s|\b)");
    @NonNls
    private static final Pattern MAIL = Pattern.compile("([\\p{L}0-9\\.\\-\\_\\+]+@([\\p{L}0-9\\-\\_]+(\\.)?)+(com|net|[a-z]{2})?)");
    @NonNls
    private static final Pattern UUID_PATTERN = Pattern.compile("[a-fA-F0-9]{8}(-[a-fA-F0-9]{4}){3}-[a-fA-F0-9]{12}");

    public static PlainTextSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text2, @NotNull TextRange range2, Consumer<TextRange> consumer2) {
        if (range2 == null) {
            PlainTextSplitter.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)text2)) {
            return;
        }
        Splitter ws = this.getTextSplitter();
        int from2 = range2.getStartOffset();
        try {
            String substring = range2.substring(text2).replace('\b', '\n').replace('\f', '\n');
            if (Verifier.checkCharacterData((String)SPLIT_PATTERN.matcher(PlainTextSplitter.newBombedCharSequence(substring)).replaceAll("")) != null) {
                return;
            }
            Matcher matcher = SPLIT_PATTERN.matcher(PlainTextSplitter.newBombedCharSequence(text2, range2));
            while (true) {
                String word;
                TextRange wRange;
                PlainTextSplitter.checkCancelled();
                if (matcher.find()) {
                    TextRange found = PlainTextSplitter.matcherRange(range2, matcher);
                    int till = found.getStartOffset();
                    if (PlainTextSplitter.badSize(from2, till)) {
                        from2 = found.getEndOffset();
                        continue;
                    }
                    wRange = new TextRange(from2, till);
                    word = wRange.substring(text2);
                    from2 = found.getEndOffset();
                } else {
                    wRange = new TextRange(from2, range2.getEndOffset());
                    word = wRange.substring(text2);
                }
                List<TextRange> toCheck = word.contains("@") ? PlainTextSplitter.excludeByPattern(text2, wRange, MAIL, 0) : (word.contains("://") ? PlainTextSplitter.excludeByPattern(text2, wRange, URLUtil.URL_PATTERN, 0) : (word.contains("-") ? PlainTextSplitter.excludeByPattern(text2, wRange, UUID_PATTERN, 0) : Collections.singletonList(wRange)));
                for (TextRange r : toCheck) {
                    ws.split(text2, r, consumer2);
                }
                if (matcher.hitEnd()) break;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    @NotNull
    protected Splitter getTextSplitter() {
        TextSplitter textSplitter = TextSplitter.getInstance();
        if (textSplitter == null) {
            PlainTextSplitter.$$$reportNull$$$0(1);
        }
        return textSplitter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/inspections/PlainTextSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/inspections/PlainTextSplitter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

