/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.refactoring.rename.PreferrableNameSuggestionProvider;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DictionarySuggestionProvider
extends PreferrableNameSuggestionProvider {
    private boolean active;

    public void setActive(boolean active2) {
        this.active = active2;
    }

    public boolean shouldCheckOthers() {
        return !this.active;
    }

    public SuggestedNameInfo getSuggestedNames(@NotNull PsiElement element2, PsiElement nameSuggestionContext, @NotNull Set<String> result2) {
        if (element2 == null) {
            DictionarySuggestionProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            DictionarySuggestionProvider.$$$reportNull$$$0(1);
        }
        if (!this.active || nameSuggestionContext == null) {
            return null;
        }
        String initial = DictionarySuggestionProvider.getText(nameSuggestionContext);
        if (initial == null) {
            return null;
        }
        String normalized = DictionarySuggestionProvider.normalize(initial);
        Project project = element2.getProject();
        SpellCheckerManager manager2 = SpellCheckerManager.getInstance(project);
        DictionarySuggestionProvider.denormalize(initial, manager2.getSuggestions(normalized)).stream().filter(newName2 -> RenameUtil.isValidName(project, element2, newName2)).forEach(result2::add);
        return SuggestedNameInfo.NULL_INFO;
    }

    @Nullable
    private static String getText(@NotNull PsiElement textElement) {
        if (textElement == null) {
            DictionarySuggestionProvider.$$$reportNull$$$0(2);
        }
        String text2 = textElement.getText();
        if (textElement instanceof PsiNamedElement) {
            text2 = ((PsiNamedElement)textElement).getName();
        }
        return text2;
    }

    @NotNull
    private static String normalize(@NotNull String text2) {
        if (text2 == null) {
            DictionarySuggestionProvider.$$$reportNull$$$0(3);
        }
        String string = StringUtil.unquoteString((String)text2);
        if (string == null) {
            DictionarySuggestionProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static Collection<String> denormalize(@NotNull String initial, @NotNull Collection<String> suggestions) {
        if (initial == null) {
            DictionarySuggestionProvider.$$$reportNull$$$0(5);
        }
        if (suggestions == null) {
            DictionarySuggestionProvider.$$$reportNull$$$0(6);
        }
        if (!StringUtil.isQuotedString((String)initial)) {
            Collection<String> collection = suggestions;
            if (collection == null) {
                DictionarySuggestionProvider.$$$reportNull$$$0(7);
            }
            return collection;
        }
        char quote = initial.charAt(0);
        StringBuilder tmp = new StringBuilder();
        ArrayList<String> result2 = new ArrayList<String>(suggestions.size());
        for (String suggestion : suggestions) {
            tmp.append(suggestion);
            StringUtil.quote((StringBuilder)tmp, (char)quote);
            result2.add(tmp.toString());
            tmp.setLength(0);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            DictionarySuggestionProvider.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/DictionarySuggestionProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/DictionarySuggestionProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "denormalize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedNames";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "denormalize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

