/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.quickfixes.ChangeTo;
import com.intellij.spellchecker.quickfixes.RenameTo;
import com.intellij.spellchecker.quickfixes.SaveTo;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.tokenizer.CommentTokenizer;
import com.intellij.spellchecker.tokenizer.CustomFileTypeTokenizer;
import com.intellij.spellchecker.tokenizer.PsiIdentifierOwnerTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import com.intellij.util.KeyedLazyInstance;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellcheckingStrategy {
    protected final Tokenizer<PsiComment> myCommentTokenizer = new CommentTokenizer();
    protected final Tokenizer<XmlAttributeValue> myXmlAttributeTokenizer = new XmlAttributeValueTokenizer();
    public static final ExtensionPointName<KeyedLazyInstance<SpellcheckingStrategy>> EP_NAME = new ExtensionPointName("com.intellij.spellchecker.support");
    public static final Tokenizer EMPTY_TOKENIZER = new Tokenizer(){

        public void tokenize(@NotNull PsiElement element2, TokenConsumer consumer2) {
            if (element2 == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        public String toString() {
            return "EMPTY_TOKENIZER";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy$1", "tokenize"));
        }
    };
    public static final Tokenizer<PsiElement> TEXT_TOKENIZER = new TokenizerBase<PsiElement>(PlainTextSplitter.getInstance());
    private static final SpellCheckerQuickFix[] BATCH_FIXES = new SpellCheckerQuickFix[]{SaveTo.getSaveToLevelFix(SpellCheckerManager.DictionaryLevel.APP), SaveTo.getSaveToLevelFix(SpellCheckerManager.DictionaryLevel.PROJECT)};

    @NotNull
    public Tokenizer getTokenizer(PsiElement element2) {
        if (element2 instanceof PsiWhiteSpace) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (element2 instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)element2)) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        if (element2 instanceof PsiNameIdentifierOwner) {
            PsiIdentifierOwnerTokenizer psiIdentifierOwnerTokenizer = PsiIdentifierOwnerTokenizer.INSTANCE;
            if (psiIdentifierOwnerTokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(2);
            }
            return psiIdentifierOwnerTokenizer;
        }
        if (element2 instanceof PsiComment) {
            if (SuppressionUtil.isSuppressionComment(element2)) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    SpellcheckingStrategy.$$$reportNull$$$0(3);
                }
                return tokenizer;
            }
            if (element2.getTextOffset() == 0 && element2.getText().startsWith("#!")) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    SpellcheckingStrategy.$$$reportNull$$$0(4);
                }
                return tokenizer;
            }
            Tokenizer<PsiComment> tokenizer = this.myCommentTokenizer;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(5);
            }
            return tokenizer;
        }
        if (element2 instanceof XmlAttributeValue) {
            Tokenizer<XmlAttributeValue> tokenizer = this.myXmlAttributeTokenizer;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(6);
            }
            return tokenizer;
        }
        if (element2 instanceof PsiPlainText) {
            FileType fileType;
            PsiFile file2 = element2.getContainingFile();
            FileType fileType2 = fileType = file2 == null ? null : file2.getFileType();
            if (fileType instanceof CustomSyntaxTableFileType) {
                return new CustomFileTypeTokenizer(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
            }
            Tokenizer<PsiElement> tokenizer = TEXT_TOKENIZER;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(7);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = EMPTY_TOKENIZER;
        if (tokenizer == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(8);
        }
        return tokenizer;
    }

    public LocalQuickFix[] getRegularFixes(PsiElement element2, @NotNull TextRange textRange, boolean useRename, String typo) {
        if (textRange == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(9);
        }
        return SpellcheckingStrategy.getDefaultRegularFixes(useRename, typo, element2, textRange);
    }

    public static LocalQuickFix[] getDefaultRegularFixes(boolean useRename, String typo, @Nullable PsiElement element2, @NotNull TextRange range2) {
        if (range2 == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(10);
        }
        ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
        if (useRename) {
            result2.add(new RenameTo(typo));
        } else if (element2 != null) {
            result2.addAll(new ChangeTo(typo, element2, range2).getAllAsFixes());
        }
        if (element2 == null) {
            result2.add(new SaveTo(typo));
            return result2.toArray(LocalQuickFix.EMPTY_ARRAY);
        }
        SpellCheckerSettings settings = SpellCheckerSettings.getInstance(element2.getProject());
        if (settings.isUseSingleDictionaryToSave()) {
            result2.add(new SaveTo(typo, SpellCheckerManager.DictionaryLevel.getLevelByName(settings.getDictionaryToSave())));
            return result2.toArray(LocalQuickFix.EMPTY_ARRAY);
        }
        result2.add(new SaveTo(typo));
        return result2.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public static SpellCheckerQuickFix[] getDefaultBatchFixes() {
        return BATCH_FIXES;
    }

    public boolean isMyContext(@NotNull PsiElement element2) {
        if (element2 == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(11);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRegularFixes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRegularFixes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMyContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class XmlAttributeValueTokenizer
    extends Tokenizer<XmlAttributeValue> {
        protected XmlAttributeValueTokenizer() {
        }

        @Override
        public void tokenize(@NotNull XmlAttributeValue element2, TokenConsumer consumer2) {
            if (element2 == null) {
                XmlAttributeValueTokenizer.$$$reportNull$$$0(0);
            }
            if (element2 instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)element2)) {
                return;
            }
            String valueTextTrimmed = element2.getValue().trim();
            if (valueTextTrimmed.startsWith("#") && valueTextTrimmed.length() <= 9 && XmlAttributeValueTokenizer.isHexString(valueTextTrimmed.substring(1))) {
                return;
            }
            consumer2.consumeToken((PsiElement)element2, PlainTextSplitter.getInstance());
        }

        private static boolean isHexString(String s) {
            for (int i2 = 0; i2 < s.length(); ++i2) {
                if (StringUtil.isHexDigit((char)s.charAt(i2))) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy$XmlAttributeValueTokenizer", "tokenize"));
        }
    }
}

