/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.PtyBasedProcess;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.terminal.AppendableTerminalDataStream;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ProcessHandlerTtyConnector;
import com.intellij.terminal.TerminalConsoleContentHelper;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.pty4j.PtyProcess;
import java.awt.Color;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalExecutionConsole
implements ConsoleView,
ObservableConsoleView {
    private static final Logger LOG = Logger.getInstance(TerminalExecutionConsole.class);
    private static final String CLEAR_SCREEN = "\u001b[2J";
    private final JBTerminalWidget myTerminalWidget;
    private final Project myProject;
    private final AppendableTerminalDataStream myDataStream;
    private final AtomicBoolean myAttachedToProcess;
    private volatile boolean myLastCR;
    private final TerminalConsoleContentHelper myContentHelper;
    private boolean myEnterKeyDefaultCodeEnabled;
    private boolean myConvertLfToCrlfForNonPtyProcess;
    private final AtomicBoolean myFirstOutput;

    public TerminalExecutionConsole(@NotNull Project project, @Nullable ProcessHandler processHandler2) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(0);
        }
        this(project, processHandler2, TerminalExecutionConsole.getProvider());
    }

    public TerminalExecutionConsole(@NotNull Project project, @Nullable ProcessHandler processHandler2, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(1);
        }
        if (settingsProvider == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(2);
        }
        this(project, 200, 24, processHandler2, settingsProvider);
    }

    public TerminalExecutionConsole(@NotNull Project project, int columns, int lines2, @Nullable ProcessHandler processHandler2) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(3);
        }
        this(project, columns, lines2, processHandler2, TerminalExecutionConsole.getProvider());
    }

    public TerminalExecutionConsole(@NotNull Project project, int columns, int lines2, @Nullable ProcessHandler processHandler2, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(4);
        }
        if (settingsProvider == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(5);
        }
        this.myAttachedToProcess = new AtomicBoolean(false);
        this.myLastCR = false;
        this.myContentHelper = new TerminalConsoleContentHelper(this);
        this.myEnterKeyDefaultCodeEnabled = true;
        this.myConvertLfToCrlfForNonPtyProcess = false;
        this.myFirstOutput = new AtomicBoolean(false);
        this.myProject = project;
        this.myDataStream = new AppendableTerminalDataStream();
        this.myTerminalWidget = new ConsoleTerminalWidget(project, columns, lines2, settingsProvider);
        if (processHandler2 != null) {
            this.attachToProcess(processHandler2);
        }
    }

    @NotNull
    private static JBTerminalSystemSettingsProviderBase getProvider() {
        return new JBTerminalSystemSettingsProviderBase(){

            public HyperlinkStyle.HighlightMode getHyperlinkHighlightingMode() {
                return HyperlinkStyle.HighlightMode.ALWAYS;
            }
        };
    }

    @NotNull
    public JBTerminalWidget getTerminalWidget() {
        JBTerminalWidget jBTerminalWidget = this.myTerminalWidget;
        if (jBTerminalWidget == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(6);
        }
        return jBTerminalWidget;
    }

    private void printText(@NotNull String text2, @Nullable ConsoleViewContentType contentType) throws IOException {
        Color foregroundColor;
        if (text2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(7);
        }
        Color color = foregroundColor = contentType != null ? contentType.getAttributes().getForegroundColor() : null;
        if (foregroundColor != null) {
            this.myDataStream.append(TerminalExecutionConsole.encodeColor(foregroundColor));
        }
        if (contentType != ConsoleViewContentType.SYSTEM_OUTPUT && this.myFirstOutput.compareAndSet(false, true) && text2.startsWith(CLEAR_SCREEN)) {
            final BoundedRangeModel verticalScrollModel = this.myTerminalWidget.getTerminalPanel().getVerticalScrollModel();
            verticalScrollModel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    verticalScrollModel.removeChangeListener(this);
                    UiNotifyConnector.doWhenFirstShown((JComponent)((Object)TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel()), () -> TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().scrollToShowAllOutput());
                }
            });
        }
        this.myDataStream.append(text2);
        if (foregroundColor != null) {
            this.myDataStream.append("\u001b[39m");
        }
        this.myContentHelper.onContentTypePrinted(text2, (ConsoleViewContentType)ObjectUtils.notNull((Object)contentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT));
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(8);
        }
        if (parent == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(9);
        }
        this.myContentHelper.addChangeListener(listener2, parent);
    }

    @NotNull
    private static String encodeColor(@NotNull Color color) {
        if (color == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(10);
        }
        String string = "\u001b[38;2;" + color.getRed() + ";" + color.getGreen() + ";" + color.getBlue() + "m";
        if (string == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public TerminalExecutionConsole withEnterKeyDefaultCodeEnabled(boolean enterKeyDefaultCodeEnabled) {
        this.myEnterKeyDefaultCodeEnabled = enterKeyDefaultCodeEnabled;
        TerminalExecutionConsole terminalExecutionConsole = this;
        if (terminalExecutionConsole == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(12);
        }
        return terminalExecutionConsole;
    }

    @NotNull
    public TerminalExecutionConsole withConvertLfToCrlfForNonPtyProcess(boolean convertLfToCrlfForNonPtyProcess) {
        this.myConvertLfToCrlfForNonPtyProcess = convertLfToCrlfForNonPtyProcess;
        TerminalExecutionConsole terminalExecutionConsole = this;
        if (terminalExecutionConsole == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(13);
        }
        return terminalExecutionConsole;
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(14);
        }
        if (contentType == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(15);
        }
        String textCRLF = this.convertTextToCRLF(text2);
        try {
            this.printText(textCRLF, contentType);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    private String convertTextToCRLF(@NotNull String text2) {
        boolean preserveLastCR;
        if (text2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(16);
        }
        if (text2.isEmpty()) {
            String string = text2;
            if (string == null) {
                TerminalExecutionConsole.$$$reportNull$$$0(17);
            }
            return string;
        }
        boolean preserveFirstLF = text2.startsWith(LineSeparator.LF.getSeparatorString()) && this.myLastCR;
        this.myLastCR = preserveLastCR = text2.endsWith(LineSeparator.CR.getSeparatorString());
        String textToConvert = text2.substring(preserveFirstLF ? 1 : 0, preserveLastCR ? text2.length() - 1 : text2.length());
        Object textCRLF = StringUtil.convertLineSeparators((String)textToConvert, (String)LineSeparator.CRLF.getSeparatorString());
        if (preserveFirstLF) {
            textCRLF = LineSeparator.LF.getSeparatorString() + (String)textCRLF;
        }
        if (preserveLastCR) {
            textCRLF = (String)textCRLF + LineSeparator.CR.getSeparatorString();
        }
        String string = textCRLF;
        if (string == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(18);
        }
        return string;
    }

    public void clear() {
        this.myLastCR = false;
        this.myTerminalWidget.getTerminalPanel().clearBuffer();
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(19);
        }
        this.attachToProcess(processHandler2, true);
    }

    protected final void attachToProcess(final @NotNull ProcessHandler processHandler2, final boolean attachToProcessOutput) {
        if (processHandler2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(20);
        }
        if (!this.myAttachedToProcess.compareAndSet(false, true)) {
            return;
        }
        this.myTerminalWidget.createTerminalSession(new ProcessHandlerTtyConnector(processHandler2, EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset()));
        this.myTerminalWidget.start();
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (attachToProcessOutput) {
                    try {
                        ConsoleViewContentType contentType = null;
                        if (outputType != ProcessOutputTypes.STDOUT) {
                            contentType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                        }
                        String text2 = event.getText();
                        if (outputType == ProcessOutputTypes.SYSTEM) {
                            text2 = StringUtil.convertLineSeparators((String)text2, (String)LineSeparator.CRLF.getSeparatorString());
                        } else if (TerminalExecutionConsole.this.shouldConvertLfToCrlf(processHandler2)) {
                            text2 = TerminalExecutionConsole.this.convertTextToCRLF(text2);
                        }
                        TerminalExecutionConsole.this.printText(text2, contentType);
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                TerminalExecutionConsole.this.myAttachedToProcess.set(false);
                ApplicationManager.getApplication().invokeLater(() -> TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().setCursorVisible(false), ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private boolean shouldConvertLfToCrlf(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(21);
        }
        return this.myConvertLfToCrlfForNonPtyProcess && TerminalExecutionConsole.isNonPtyProcess(processHandler2);
    }

    private static boolean isNonPtyProcess(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(22);
        }
        if (processHandler2 instanceof BaseProcessHandler) {
            Process process2 = ((BaseProcessHandler)processHandler2).getProcess();
            return !(process2 instanceof PtyProcess);
        }
        return true;
    }

    public void setOutputPaused(boolean value2) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(23);
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(24);
        }
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(25);
        }
        this.myTerminalWidget.addMessageFilter(filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info2) {
        if (hyperlinkText == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(26);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    public AnAction @NotNull [] createConsoleActions() {
        AnAction[] anActionArray = new AnAction[]{new ScrollToTheEndAction(), new ClearAction()};
        if (anActionArray == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(27);
        }
        return anActionArray;
    }

    public void allowHeavyFilters() {
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myTerminalWidget.getComponent();
        if (jComponent == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(28);
        }
        return jComponent;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public void dispose() {
    }

    public static boolean isAcceptable(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(29);
        }
        if (!(processHandler2 instanceof OSProcessHandler) || processHandler2 instanceof ColoredProcessHandler) {
            return false;
        }
        Process process2 = ((OSProcessHandler)processHandler2).getProcess();
        return process2 instanceof PtyProcess || process2 instanceof PtyBasedProcess && ((PtyBasedProcess)process2).hasPty();
    }

    @Nullable
    private PtyProcess getPtyProcess() {
        ProcessHandlerTtyConnector phc = (ProcessHandlerTtyConnector)ObjectUtils.tryCast((Object)this.myTerminalWidget.getTtyConnector(), ProcessHandlerTtyConnector.class);
        return phc != null ? phc.getPtyProcess() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/TerminalExecutionConsole";
                break;
            }
            case 7: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalWidget";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeColor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnterKeyDefaultCodeEnabled";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withConvertLfToCrlfForNonPtyProcess";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTextToCRLF";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 27: 
            case 28: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "printText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "encodeColor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "convertTextToCRLF";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldConvertLfToCrlf";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isNonPtyProcess";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ScrollToTheEndAction
    extends DumbAwareAction {
        private ScrollToTheEndAction() {
            super(ActionsBundle.messagePointer((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]), ActionsBundle.messagePointer((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]), AllIcons.RunConfigurations.Scroll_down);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ScrollToTheEndAction.$$$reportNull$$$0(0);
            }
            BoundedRangeModel verticalScrollModel = TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().getVerticalScrollModel();
            e.getPresentation().setEnabled(verticalScrollModel.getValue() != 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ScrollToTheEndAction.$$$reportNull$$$0(1);
            }
            TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().getVerticalScrollModel().setValue(0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$ScrollToTheEndAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ClearAction
    extends DumbAwareAction {
        private ClearAction() {
            super(ExecutionBundle.messagePointer((String)"clear.all.from.console.action.name", (Object[])new Object[0]), ExecutionBundle.messagePointer((String)"clear.all.from.console.action.text", (Object[])new Object[0]), AllIcons.Actions.GC);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(1);
            }
            TerminalExecutionConsole.this.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$ClearAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ConsoleTerminalWidget
    extends JBTerminalWidget
    implements DataProvider {
        private ConsoleTerminalWidget(Project project, int columns, @NotNull int lines2, JBTerminalSystemSettingsProviderBase provider2) {
            if (project == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(0);
            }
            if (provider2 == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(1);
            }
            super(project, columns, lines2, provider2, TerminalExecutionConsole.this, (Disposable)TerminalExecutionConsole.this);
        }

        @Override
        protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
            if (settingsProvider == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(2);
            }
            if (styleState == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(3);
            }
            if (textBuffer == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(4);
            }
            JBTerminalPanel panel2 = new JBTerminalPanel((JBTerminalSystemSettingsProviderBase)settingsProvider, textBuffer, styleState){

                public void clearBuffer() {
                    super.clearBuffer(false);
                }
            };
            Disposer.register((Disposable)this, (Disposable)panel2);
            return panel2;
        }

        protected TerminalStarter createTerminalStarter(@NotNull JediTerminal terminal, @NotNull TtyConnector connector) {
            if (terminal == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(5);
            }
            if (connector == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(6);
            }
            return new TerminalStarter((Terminal)terminal, connector, TerminalExecutionConsole.this.myDataStream, TerminalExecutionConsole.this.myTerminalWidget.getTypeAheadManager()){

                public byte[] getCode(int key, int modifiers) {
                    if (key == 10 && modifiers == 0 && TerminalExecutionConsole.this.myEnterKeyDefaultCodeEnabled) {
                        byte[] byArray;
                        PtyProcess process2 = TerminalExecutionConsole.this.getPtyProcess();
                        if (process2 != null) {
                            byte[] byArray2 = new byte[1];
                            byArray = byArray2;
                            byArray2[0] = process2.getEnterKeyCode();
                        } else {
                            byArray = LineSeparator.CR.getSeparatorBytes();
                        }
                        return byArray;
                    }
                    return super.getCode(key, modifiers);
                }
            };
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(7);
            }
            if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
                return TerminalExecutionConsole.this;
            }
            return super.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingsProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "styleState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textBuffer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "terminal";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connector";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$ConsoleTerminalWidget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTerminalPanel";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTerminalStarter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

