/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.LanguageTestCreators;
import com.intellij.testIntegration.TestCreator;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoTestOrCodeHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.testOrCode";
    }

    @Override
    @Nullable
    protected GotoTargetHandler.GotoData getSourceAndTargetElements(final Editor editor2, final PsiFile file2) {
        PsiElement selectedElement = GotoTestOrCodeHandler.getSelectedElement(editor2, file2);
        PsiElement sourceElement = TestFinderHelper.findSourceElement(selectedElement);
        if (sourceElement == null) {
            return null;
        }
        SmartList actions2 = new SmartList();
        List candidates = Collections.synchronizedList(new ArrayList());
        if (TestFinderHelper.isTest(selectedElement)) {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                Collection classes = (Collection)ReadAction.compute(() -> TestFinderHelper.findClassesForTest(selectedElement));
                candidates.addAll(classes);
            }, LangBundle.message((String)"progress.title.searching.for.classes.for.test", (Object[])new Object[0]), true, file2.getProject())) {
                return null;
            }
        } else {
            Ref navigateToTestImmediatelyRef = new Ref((Object)false);
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                Collection tests = (Collection)ReadAction.compute(() -> TestFinderHelper.findTestsForClass(selectedElement));
                candidates.addAll(tests);
                navigateToTestImmediatelyRef.set((Object)(candidates.size() == 1 && TestFinderHelper.navigateToTestImmediately((PsiElement)candidates.get(0)) ? 1 : 0));
            }, LangBundle.message((String)"progress.title.searching.for.tests.for.class", (Object[])new Object[0]), true, file2.getProject())) {
                return null;
            }
            if (!((Boolean)navigateToTestImmediatelyRef.get()).booleanValue()) {
                for (final TestCreator creator : LanguageTestCreators.INSTANCE.allForLanguage(file2.getLanguage())) {
                    if (!creator.isAvailable(file2.getProject(), editor2, file2)) continue;
                    actions2.add(new GotoTargetHandler.AdditionalAction(){

                        @Override
                        @NotNull
                        public String getText() {
                            String text2 = creator instanceof ItemPresentation ? ((ItemPresentation)creator).getPresentableText() : null;
                            String string = (String)ObjectUtils.notNull((Object)text2, (Object)LangBundle.message((String)"action.create.new.test.text", (Object[])new Object[0]));
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        @Override
                        public Icon getIcon() {
                            Icon icon2 = creator instanceof ItemPresentation ? ((ItemPresentation)creator).getIcon(false) : null;
                            return (Icon)ObjectUtils.notNull((Object)icon2, (Object)AllIcons.Actions.IntentionBulb);
                        }

                        @Override
                        public void execute() {
                            creator.createTest(file2.getProject(), editor2, file2);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler$1", "getText"));
                        }
                    });
                }
            }
        }
        return new GotoTargetHandler.GotoData(sourceElement, PsiUtilCore.toPsiElementArray(candidates), (List<GotoTargetHandler.AdditionalAction>)actions2);
    }

    @NotNull
    public static PsiElement getSelectedElement(Editor editor2, PsiFile file2) {
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file2, (int)editor2.getCaretModel().getOffset());
        if (psiElement == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @Override
    protected boolean shouldSortTargets() {
        return false;
    }

    @Override
    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name2, int length, boolean finished2) {
        String suffix;
        if (sourceElement == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(1);
        }
        String string = suffix = finished2 ? "" : " so far";
        if (TestFinderHelper.isTest(sourceElement)) {
            String string2 = CodeInsightBundle.message((String)"goto.test.chooserTitle.subject", (Object[])new Object[]{name2, length, suffix});
            if (string2 == null) {
                GotoTestOrCodeHandler.$$$reportNull$$$0(2);
            }
            return string2;
        }
        String string3 = CodeInsightBundle.message((String)"goto.test.chooserTitle.test", (Object[])new Object[]{name2, length, suffix});
        if (string3 == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(3);
        }
        return string3;
    }

    @Override
    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name2, int length) {
        if (sourceElement == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(4);
        }
        if (TestFinderHelper.isTest(sourceElement)) {
            String string = CodeInsightBundle.message((String)"goto.test.findUsages.subject.title", (Object[])new Object[]{name2});
            if (string == null) {
                GotoTestOrCodeHandler.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = CodeInsightBundle.message((String)"goto.test.findUsages.test.title", (Object[])new Object[]{name2});
        if (string == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNotFoundMessage(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(7);
        }
        if (editor2 == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(9);
        }
        String string = CodeInsightBundle.message((String)"goto.test.notFound", (Object[])new Object[0]);
        if (string == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getAdText(PsiElement source, int length) {
        Shortcut shortcut;
        if (length > 0 && !TestFinderHelper.isTest(source) && (shortcut = KeymapUtil.getPrimaryShortcut((String)DefaultRunExecutor.getRunExecutorInstance().getContextActionId())) != null) {
            return LangBundle.message((String)"popup.advertisement.press.to.run.selected.tests", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)shortcut)});
        }
        return null;
    }

    @Override
    protected boolean useEditorFont() {
        return false;
    }

    @Override
    protected void navigateToElement(@NotNull Navigatable element2) {
        if (element2 == null) {
            GotoTestOrCodeHandler.$$$reportNull$$$0(11);
        }
        if (element2 instanceof PsiElement) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)element2, true);
        } else {
            element2.navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testIntegration/GotoTestOrCodeHandler";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElement";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testIntegration/GotoTestOrCodeHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChooserTitle";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChooserTitle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsagesTitle";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoundMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "navigateToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

