/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolsBundle;
import com.intellij.ui.AbstractTitledSeparatorWithIcon;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolEditorDialog
extends DialogWrapper {
    private static final String ADVANCED_OPTIONS_EXPANDED_KEY = "ExternalToolDialog.advanced.expanded";
    private static final boolean ADVANCED_OPTIONS_EXPANDED_DEFAULT = false;
    private static final Function<String, List<String>> OUTPUT_FILTERS_SPLITTER = s -> StringUtil.split((String)s, (String)"\u23ce");
    private static final Function<List<String>, String> OUTPUT_FILTERS_JOINER = strings -> StringUtil.join((Collection)strings, (String)"\u23ce");
    private final Project myProject;
    private boolean myEnabled;
    private JPanel myMainPanel;
    private JTextField myNameField;
    private ComboBox<String> myGroupCombo;
    private JTextField myDescriptionField;
    private TextFieldWithBrowseButton myProgramField;
    private RawCommandLineEditor myArgumentsField;
    private TextFieldWithBrowseButton myWorkingDirField;
    private JPanel myAdditionalOptionsPanel;
    private AbstractTitledSeparatorWithIcon myAdvancedOptionsSeparator;
    private JPanel myAdvancedOptionsPanel;
    private JBCheckBox mySynchronizedAfterRunCheckbox;
    private JBCheckBox myUseConsoleCheckbox;
    private JBCheckBox myShowConsoleOnStdOutCheckbox;
    private JBCheckBox myShowConsoleOnStdErrCheckbox;
    private RawCommandLineEditor myOutputFilterField;

    protected ToolEditorDialog(JComponent parent, @NlsContexts.DialogTitle String title2) {
        super((Component)parent, true);
        this.$$$setupUI$$$();
        this.myArgumentsField.setDialogCaption("Program Arguments");
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)parent);
        this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        MacroManager.getInstance().cacheMacrosPreview(dataContext);
        this.setTitle(title2);
        this.myAdvancedOptionsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)20));
        boolean on = PropertiesComponent.getInstance().getBoolean(ADVANCED_OPTIONS_EXPANDED_KEY, false);
        if (on) {
            this.myAdvancedOptionsSeparator.on();
        } else {
            this.myAdvancedOptionsSeparator.off();
        }
        this.init();
        this.addListeners();
    }

    protected String getHelpId() {
        return "preferences.externalToolsEdit";
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    protected JPanel createCenterPanel() {
        this.fillAdditionalOptionsPanel(this.myAdditionalOptionsPanel);
        JPanel jPanel2 = this.myMainPanel;
        if (jPanel2 == null) {
            ToolEditorDialog.$$$reportNull$$$0(0);
        }
        return jPanel2;
    }

    protected void fillAdditionalOptionsPanel(@NotNull JPanel panel2) {
        if (panel2 == null) {
            ToolEditorDialog.$$$reportNull$$$0(1);
        }
    }

    protected void addWorkingDirectoryBrowseAction(@NotNull TextFieldWithBrowseButton workingDirField) {
        if (workingDirField == null) {
            ToolEditorDialog.$$$reportNull$$$0(2);
        }
        workingDirField.addBrowseFolderListener(null, null, this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
    }

    protected void addProgramBrowseAction(@NotNull TextFieldWithBrowseButton programField) {
        if (programField == null) {
            ToolEditorDialog.$$$reportNull$$$0(3);
        }
        programField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor(), this.myProject){

            protected void onFileChosen(@NotNull VirtualFile file2) {
                VirtualFile parent;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.onFileChosen(file2);
                String workingDirectory = ToolEditorDialog.this.myWorkingDirField.getText();
                if (workingDirectory.isEmpty() && (parent = file2.getParent()) != null && parent.isDirectory()) {
                    ToolEditorDialog.this.myWorkingDirField.setText(parent.getPresentableUrl());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/tools/ToolEditorDialog$1", "onFileChosen"));
            }
        });
    }

    private void createUIComponents() {
        this.myOutputFilterField = new RawCommandLineEditor(OUTPUT_FILTERS_SPLITTER, OUTPUT_FILTERS_JOINER);
        this.myAdvancedOptionsSeparator = new AbstractTitledSeparatorWithIcon(AllIcons.General.ArrowRight, AllIcons.General.ArrowDown, ToolsBundle.message("dialog.separator.advanced.options", new Object[0])){

            @Override
            protected RefreshablePanel createPanel() {
                return new RefreshablePanel(){

                    @Override
                    public void refresh() {
                    }

                    @Override
                    public JPanel getPanel() {
                        return new JPanel();
                    }
                };
            }

            @Override
            protected void initOnImpl() {
            }

            @Override
            protected void onImpl() {
                ToolEditorDialog.this.myAdvancedOptionsPanel.setVisible(true);
                PropertiesComponent.getInstance().setValue(ToolEditorDialog.ADVANCED_OPTIONS_EXPANDED_KEY, true, false);
            }

            @Override
            protected void offImpl() {
                ToolEditorDialog.this.myAdvancedOptionsPanel.setVisible(false);
                PropertiesComponent.getInstance().setValue(ToolEditorDialog.ADVANCED_OPTIONS_EXPANDED_KEY, false, false);
                int extraHeight = ToolEditorDialog.this.myAdvancedOptionsPanel.getHeight();
                ApplicationManager.getApplication().invokeLater(() -> {
                    Dimension size = ToolEditorDialog.this.getSize();
                    ToolEditorDialog.this.setSize(size.width, size.height - extraHeight);
                    ToolEditorDialog.this.repaint();
                }, ModalityState.current(), o -> !ToolEditorDialog.this.isShowing());
            }
        };
    }

    private void addListeners() {
        this.addProgramBrowseAction(this.myProgramField);
        this.addWorkingDirectoryBrowseAction(this.myWorkingDirField);
        MacrosDialog.addTextFieldExtension((ExtendableTextField)this.myProgramField.getTextField());
        MacrosDialog.addTextFieldExtension((ExtendableTextField)this.myArgumentsField.getTextField());
        MacrosDialog.addTextFieldExtension((ExtendableTextField)this.myWorkingDirField.getTextField());
        this.myUseConsoleCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ToolEditorDialog.this.myShowConsoleOnStdOutCheckbox.setEnabled(ToolEditorDialog.this.myUseConsoleCheckbox.isSelected());
                ToolEditorDialog.this.myShowConsoleOnStdErrCheckbox.setEnabled(ToolEditorDialog.this.myUseConsoleCheckbox.isSelected());
            }
        });
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myNameField.getText().trim().isEmpty()) {
            return new ValidationInfo(ToolsBundle.message("dialog.message.specify.the.tool.name", new Object[0]), (JComponent)this.myNameField);
        }
        for (String s : (List)OUTPUT_FILTERS_SPLITTER.fun((Object)this.myOutputFilterField.getText())) {
            if (s.contains("$FILE_PATH$")) continue;
            return new ValidationInfo(ToolsBundle.message("dialog.message.each.output.filter.must.contain.0.macro", "$FILE_PATH$"), (JComponent)this.myOutputFilterField);
        }
        return null;
    }

    public Tool getData() {
        Tool tool = this.createTool();
        tool.setName(ToolEditorDialog.convertString(this.myNameField.getText()));
        tool.setDescription(ToolEditorDialog.convertString(this.myDescriptionField.getText()));
        Object selectedItem = this.myGroupCombo.getSelectedItem();
        tool.setGroup(StringUtil.notNullize((String)(selectedItem != null ? ToolEditorDialog.convertString(selectedItem.toString()) : "")));
        tool.setUseConsole(this.myUseConsoleCheckbox.isSelected());
        tool.setShowConsoleOnStdOut(this.myShowConsoleOnStdOutCheckbox.isSelected());
        tool.setShowConsoleOnStdErr(this.myShowConsoleOnStdErrCheckbox.isSelected());
        tool.setFilesSynchronizedAfterRun(this.mySynchronizedAfterRunCheckbox.isSelected());
        tool.setEnabled(this.myEnabled);
        tool.setWorkingDirectory(StringUtil.nullize((String)FileUtil.toSystemIndependentName((String)this.myWorkingDirField.getText())));
        tool.setProgram(ToolEditorDialog.convertString(this.myProgramField.getText()));
        tool.setParameters(ToolEditorDialog.convertString(this.myArgumentsField.getText()));
        List filterStrings = (List)OUTPUT_FILTERS_SPLITTER.fun((Object)this.myOutputFilterField.getText().trim());
        FilterInfo[] filters = (FilterInfo[])ContainerUtil.map2Array((Collection)filterStrings, FilterInfo.class, s -> new FilterInfo((String)s, "", ""));
        tool.setOutputFilters(filters);
        return tool;
    }

    protected Tool createTool() {
        return new Tool();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.tools.ToolEditorDialog";
    }

    protected void setData(Tool tool, String @Nls [] existingGroups) {
        this.myNameField.setText(tool.getName());
        this.myDescriptionField.setText(tool.getDescription());
        if (this.myGroupCombo.getItemCount() > 0) {
            this.myGroupCombo.removeAllItems();
        }
        for (String existingGroup : existingGroups) {
            if (existingGroup == null) continue;
            this.myGroupCombo.addItem((Object)existingGroup);
        }
        this.myGroupCombo.setSelectedItem((Object)tool.getGroup());
        this.myUseConsoleCheckbox.setSelected(tool.isUseConsole());
        this.myShowConsoleOnStdOutCheckbox.setEnabled(this.myUseConsoleCheckbox.isSelected());
        this.myShowConsoleOnStdOutCheckbox.setSelected(tool.isShowConsoleOnStdOut());
        this.myShowConsoleOnStdErrCheckbox.setEnabled(this.myUseConsoleCheckbox.isSelected());
        this.myShowConsoleOnStdErrCheckbox.setSelected(tool.isShowConsoleOnStdErr());
        this.mySynchronizedAfterRunCheckbox.setSelected(tool.synchronizeAfterExecution());
        this.myEnabled = tool.isEnabled();
        this.myWorkingDirField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)tool.getWorkingDirectory())));
        this.myProgramField.setText(tool.getProgram());
        this.myArgumentsField.setText(tool.getParameters());
        this.myOutputFilterField.setText((String)OUTPUT_FILTERS_JOINER.fun((Object)ContainerUtil.map((Object[])tool.getOutputFilters(), info2 -> info2.getRegExp())));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private static String convertString(String s) {
        if (s != null && s.trim().isEmpty()) {
            return null;
        }
        return s;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/ToolEditorDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "programField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/ToolEditorDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fillAdditionalOptionsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addWorkingDirectoryBrowseAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addProgramBrowseAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JPanel jPanel2;
        JTextField jTextField;
        ComboBox comboBox2;
        JTextField jTextField2;
        JPanel jPanel3;
        RawCommandLineEditor rawCommandLineEditor;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("border.title.tool.settings"), (int)0, (int)0, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("label.tool.program"));
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProgramField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("label.tool.arguments"));
        jPanel5.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkingDirField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("label.tool.working.directory"));
        jPanel5.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myArgumentsField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel5.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myAdditionalOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        AbstractTitledSeparatorWithIcon abstractTitledSeparatorWithIcon = this.myAdvancedOptionsSeparator;
        jPanel4.add((Component)abstractTitledSeparatorWithIcon, new GridConstraints(3, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("label.tool.name"));
        jPanel6.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField2 = new JTextField();
        jPanel6.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("label.tool.group"));
        jPanel6.add((Component)jBLabel5, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myGroupCombo = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        jPanel6.add((Component)comboBox2, new GridConstraints(0, 3, 1, 1, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("label.tool.description"));
        jPanel6.add((Component)jBLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDescriptionField = jTextField = new JTextField();
        jPanel6.add((Component)jTextField, new GridConstraints(1, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAdvancedOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySynchronizedAfterRunCheckbox = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("checkbox.synchronize.files.after.execution"));
        jPanel2.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myUseConsoleCheckbox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("checkbox.open.console.for.tool.output"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myShowConsoleOnStdOutCheckbox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("checkbox.make.console.active.on.message.in.stdout"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2));
        this.myShowConsoleOnStdErrCheckbox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("checkbox.make.console.active.on.message.in.stderr"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2));
        JBLabel jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("label.output.filters"));
        jPanel2.add((Component)jBLabel7, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor2 = this.myOutputFilterField;
        jPanel2.add((Component)rawCommandLineEditor2, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel8.setForeground(new Color(-8882056));
        this.$$$loadLabelText$$$((JLabel)jBLabel8, DynamicBundle.getBundle((String)"messages/ToolsBundle", ToolEditorDialog.class).getString("label.each.line.is.a.regex.available.macros.file.path.line.and.column"));
        jPanel2.add((Component)jBLabel8, new GridConstraints(5, 1, 1, 1, 8, 0, 7, 0, new Dimension(0, -1), null, null));
        jBLabel.setLabelFor((Component)textFieldWithBrowseButton3);
        jBLabel2.setLabelFor((Component)rawCommandLineEditor);
        jBLabel3.setLabelFor((Component)textFieldWithBrowseButton2);
        jBLabel4.setLabelFor(jTextField2);
        jBLabel5.setLabelFor((Component)comboBox2);
        jBLabel6.setLabelFor(jTextField);
        jBLabel7.setLabelFor((Component)rawCommandLineEditor2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

