/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredText;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SimpleColoredText
implements ColoredTextContainer {
    private final ArrayList<@Nls String> myTexts;
    private final ArrayList<SimpleTextAttributes> myAttributes;
    @NlsSafe
    private String myCachedToString;

    public SimpleColoredText() {
        this.myCachedToString = null;
        this.myTexts = new ArrayList(3);
        this.myAttributes = new ArrayList(3);
    }

    public SimpleColoredText(@NotNull @NlsContexts.Label String fragment2, @NotNull SimpleTextAttributes attributes2) {
        if (fragment2 == null) {
            SimpleColoredText.$$$reportNull$$$0(0);
        }
        if (attributes2 == null) {
            SimpleColoredText.$$$reportNull$$$0(1);
        }
        this();
        this.append(fragment2, attributes2);
    }

    @Override
    public void append(@NotNull @Nls String fragment2, @NotNull SimpleTextAttributes attributes2) {
        if (fragment2 == null) {
            SimpleColoredText.$$$reportNull$$$0(2);
        }
        if (attributes2 == null) {
            SimpleColoredText.$$$reportNull$$$0(3);
        }
        this.myTexts.add(fragment2);
        this.myCachedToString = null;
        this.myAttributes.add(attributes2);
    }

    public void insert(int index2, @NotNull @Nls String fragment2, @NotNull SimpleTextAttributes attributes2) {
        if (fragment2 == null) {
            SimpleColoredText.$$$reportNull$$$0(4);
        }
        if (attributes2 == null) {
            SimpleColoredText.$$$reportNull$$$0(5);
        }
        this.myTexts.add(index2, fragment2);
        this.myCachedToString = null;
        this.myAttributes.add(index2, attributes2);
    }

    public void clear() {
        this.myTexts.clear();
        this.myCachedToString = null;
        this.myAttributes.clear();
    }

    public void appendToComponent(@NotNull ColoredTextContainer component2) {
        if (component2 == null) {
            SimpleColoredText.$$$reportNull$$$0(6);
        }
        int size = this.myTexts.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String text2 = this.myTexts.get(i2);
            SimpleTextAttributes attribute = this.myAttributes.get(i2);
            component2.append(text2, attribute);
        }
    }

    @Nls
    public String toString() {
        if (this.myCachedToString == null) {
            this.myCachedToString = String.join((CharSequence)"", this.myTexts);
        }
        return this.myCachedToString;
    }

    public ArrayList<@Nls String> getTexts() {
        return this.myTexts;
    }

    public ArrayList<SimpleTextAttributes> getAttributes() {
        return this.myAttributes;
    }

    public SimpleColoredText derive(SimpleTextAttributes attributes2, boolean override) {
        SimpleColoredText result2 = new SimpleColoredText();
        for (int i2 = 0; i2 < this.myTexts.size(); ++i2) {
            SimpleTextAttributes overridden = override ? SimpleTextAttributes.merge(this.myAttributes.get(i2), attributes2) : SimpleTextAttributes.merge(attributes2, this.myAttributes.get(i2));
            result2.append(this.myTexts.get(i2), overridden);
        }
        return result2;
    }

    @NotNull
    public ColoredText toColoredText() {
        if (this.myTexts.isEmpty()) {
            ColoredText coloredText = ColoredText.empty();
            if (coloredText == null) {
                SimpleColoredText.$$$reportNull$$$0(7);
            }
            return coloredText;
        }
        if (this.myTexts.size() == 1) {
            ColoredText coloredText = ColoredText.singleFragment(this.myTexts.get(0), this.myAttributes.get(0));
            if (coloredText == null) {
                SimpleColoredText.$$$reportNull$$$0(8);
            }
            return coloredText;
        }
        ColoredText.Builder builder2 = ColoredText.builder();
        for (int i2 = 0; i2 < this.myTexts.size(); ++i2) {
            builder2.append(this.myTexts.get(i2), this.myAttributes.get(i2));
        }
        ColoredText coloredText = builder2.build();
        if (coloredText == null) {
            SimpleColoredText.$$$reportNull$$$0(9);
        }
        return coloredText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/SimpleColoredText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/SimpleColoredText";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toColoredText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendToComponent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

