/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.charts;

import com.intellij.ui.charts.BarChart;
import com.intellij.ui.charts.BarDataset;
import com.intellij.ui.charts.ChartWrapperKt;
import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.GridLine;
import com.intellij.ui.charts.MinMax;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J(\u0010\f\u001a\u00020\u00072\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\t2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J)\u0010\u0010\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0014J>\u0010\u0015\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\u0012H\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ui/charts/HorizontalBarChart;", "T", "", "Lcom/intellij/ui/charts/BarChart;", "()V", "findGridLabelOffset", "Lcom/intellij/ui/charts/Coordinates;", "", "line", "Lcom/intellij/ui/charts/GridLine;", "g", "Ljava/awt/Graphics2D;", "findGridLineX", "gl", "", "x", "findY", "xy", "Lcom/intellij/ui/charts/MinMax;", "y", "(Lcom/intellij/ui/charts/MinMax;Ljava/lang/Number;)D", "paintDataset", "", "Lcom/intellij/ui/charts/BarDataset;", "datasetIndex", "datasetCount", "intellij.platform.ide.impl"})
public final class HorizontalBarChart<T extends Number>
extends BarChart<T> {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void paintDataset(@NotNull BarDataset<T> $this$paintDataset, int datasetIndex, int datasetCount, @NotNull Graphics2D g, @NotNull MinMax<Integer, T> xy) {
        double min;
        Intrinsics.checkNotNullParameter($this$paintDataset, (String)"$this$paintDataset");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        boolean bl = xy.getXMin() == 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Int value must start with 0";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int columns = xy.getXMax() + 1;
        double d = ((Number)xy.getYMax()).doubleValue();
        double d2 = 0.0;
        boolean bl4 = false;
        double max = Math.max(d, d2);
        if (max == (min = Double.min(((Number)xy.getYMin()).doubleValue(), 0.0))) {
            return;
        }
        Rectangle cb2 = g.getClipBounds();
        double z = (double)cb2.height / (max - min);
        boolean bl5 = false;
        int axis = (int)(z * Math.abs(min));
        Iterable $this$forEachIndexed$iv = $this$paintDataset.getData();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Rectangle2D bounds2;
            Function1<T, String> function1;
            Paint it;
            boolean bl6;
            int n;
            int n2;
            int n3;
            void value2;
            int n4 = index$iv++;
            boolean bl7 = false;
            if (n4 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Number number = (Number)item$iv;
            int column2 = n4;
            boolean bl8 = false;
            int h = (int)(value2.doubleValue() * z);
            int y = cb2.height - h - axis;
            int groupW = cb2.width / columns - this.getGap();
            int groupX = column2 * cb2.width / columns + this.getGap() / 2;
            if (this.getSpace() < 0) {
                int n5 = 1;
                n3 = groupW / 10;
                n2 = 0;
                n = Math.max(n5, n3);
            } else {
                n = this.getSpace();
            }
            int space = n;
            n3 = 1;
            n2 = (groupW - space * (datasetCount - 1)) / datasetCount;
            boolean bl9 = false;
            int w = Math.max(n3, n2);
            int x = groupX + datasetIndex * w + space * datasetIndex;
            if (h < 0) {
                y += h;
                n2 = h;
                bl9 = false;
                h = Math.abs(n2);
            }
            if ($this$paintDataset.getLineColor() != null) {
                Paint paint2;
                bl9 = false;
                bl6 = false;
                it = paint2;
                boolean bl10 = false;
                g.setPaint($this$paintDataset.getLineColor());
                g.drawRect(x, y, w, h);
            }
            if ($this$paintDataset.getFillColor() != null) {
                Paint paint3;
                bl9 = false;
                bl6 = false;
                it = paint3;
                boolean bl11 = false;
                g.setPaint(it);
                g.fillRect(x, y, w, h);
            }
            if ($this$paintDataset.getStacked()) {
                Area area = new Area(g.getClip());
                area.subtract(new Area(new Rectangle(x, y, w, h)));
                g.setClip(area);
            }
            if ($this$paintDataset.getShowValues() == null) continue;
            bl9 = false;
            bl6 = false;
            Function1<T, String> toString2 = function1;
            boolean bl12 = false;
            String str = (String)toString2.invoke((Object)value2);
            Rectangle2D rectangle2D = bounds2 = g.getFontMetrics().getStringBounds(str, g);
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"bounds");
            g.drawString(str, x + (w - (int)rectangle2D.getWidth()) / 2, y - 5);
        }
    }

    @Override
    protected double findGridLineX(@NotNull GridLine<Integer, T, ?> gl, int x) {
        Intrinsics.checkNotNullParameter(gl, (String)"gl");
        return (double)this.getGridWidth() * ((double)(x + 1) - (double)((Number)gl.getXY().getXMin()).intValue()) / ((double)((Number)gl.getXY().getXMax()).intValue() - (double)((Number)gl.getXY().getXMin()).intValue() + 1.0);
    }

    @Override
    protected double findY(@NotNull MinMax<Integer, T> xy, @NotNull T y) {
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        boolean isRanged = ((Number)xy.getYMin()).doubleValue() <= 0.0 && 0.0 <= ((Number)xy.getYMax()).doubleValue();
        double yMin = isRanged || ((Number)xy.getYMin()).doubleValue() < 0.0 ? ((Number)xy.getYMin()).doubleValue() : 0.0;
        double yMax = isRanged || ((Number)xy.getYMax()).doubleValue() > 0.0 ? ((Number)xy.getYMax()).doubleValue() : 0.0;
        int height = this.getHeight() - (this.getMargins().top + this.getMargins().bottom);
        return (double)height - (double)height * (((Number)y).doubleValue() - yMin) / (yMax - yMin);
    }

    @Override
    @NotNull
    protected Coordinates<Double, Double> findGridLabelOffset(@NotNull GridLine<?, ?, ?> line, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Coordinates<Double, Double> onLineAlignment = super.findGridLabelOffset(line, g);
        if (line.getOrientation() == 1) {
            int width = this.getWidth() - (this.getMargins().left + this.getMargins().right);
            double columnWidth = (double)width / (((Number)line.getXY().getXMax()).doubleValue() - ((Number)line.getXY().getXMin()).doubleValue() + 1.0);
            return ChartWrapperKt.to(onLineAlignment.getX() + columnWidth / (double)2, onLineAlignment.getY());
        }
        return onLineAlignment;
    }
}

