/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.DefaultLinkButtonUIKt;
import com.intellij.ui.components.DynamicColor;
import com.intellij.ui.components.Layout;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\"\u0010\u0010\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ui/components/DefaultLinkButtonUI;", "Ljavax/swing/plaf/basic/BasicButtonUI;", "()V", "cached", "Ljavax/swing/text/View;", "contains", "", "c", "Ljavax/swing/JComponent;", "x", "", "y", "createButtonListener", "Ljavax/swing/plaf/basic/BasicButtonListener;", "button", "Ljavax/swing/AbstractButton;", "getBaseline", "width", "height", "getPreferredSize", "Ljava/awt/Dimension;", "installDefaults", "", "paint", "g", "Ljava/awt/Graphics;", "Companion", "intellij.platform.ide.impl"})
public final class DefaultLinkButtonUI
extends BasicButtonUI {
    private View cached;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    protected void installDefaults(@NotNull AbstractButton button4) {
        Intrinsics.checkNotNullParameter((Object)button4, (String)"button");
        LookAndFeel.installProperty(button4, "opaque", false);
        LookAndFeel.installProperty(button4, "contentAreaFilled", false);
        LookAndFeel.installProperty(button4, "borderPainted", false);
        LookAndFeel.installProperty(button4, "rolloverEnabled", true);
        LookAndFeel.installProperty(button4, "iconTextGap", 4);
        this.defaultTextShiftOffset = UIManager.getInt("Button.textShiftOffset");
        if (!button4.isFontSet() || button4.getFont() instanceof UIResource) {
            Font font = UIManager.getFont("Label.font");
            Intrinsics.checkNotNull((Object)font);
            button4.setFont(font);
        }
        if (!button4.isBackgroundSet() || button4.getBackground() instanceof UIResource) {
            button4.setBackground(UIManager.getColor("Label.background"));
        }
        if (!button4.isForegroundSet() || button4.getForeground() instanceof UIResource) {
            button4.setForeground((Color)((Object)new DynamicColor(button4)));
        }
        button4.setHorizontalAlignment(10);
        button4.setRequestFocusEnabled(false);
    }

    @Override
    public int getBaseline(@Nullable JComponent c, int width, int height) {
        if (width < 0 || height < 0) {
            return -1;
        }
        JComponent jComponent = c;
        if (!(jComponent instanceof AbstractButton)) {
            jComponent = null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton == null) {
            return -1;
        }
        AbstractButton button4 = abstractButton;
        String string = button4.getText();
        if (string == null) {
            return -1;
        }
        String text2 = string;
        CharSequence charSequence = text2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return -1;
        }
        Layout layout = new Layout(button4, new Rectangle(width, height), null, 4, null);
        View view = DefaultLinkButtonUIKt.access$htmlView(button4);
        if (view == null) {
            return layout.getBaseline();
        }
        View view2 = view;
        int baseline = BasicHTML.getHTMLBaseline(view2, layout.getTextBounds().width, layout.getTextBounds().height);
        return baseline < 0 ? baseline : baseline + layout.getTextBounds().y;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@Nullable JComponent c) {
        JComponent jComponent = c;
        if (!(jComponent instanceof AbstractButton)) {
            jComponent = null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton == null) {
            return new Dimension();
        }
        AbstractButton button4 = abstractButton;
        int max = Short.MAX_VALUE;
        Layout layout = new Layout(button4, new Rectangle(max, max), null, 4, null);
        Dimension dimension = layout.getBounds().getSize();
        boolean bl = false;
        boolean bl2 = false;
        Dimension it = dimension;
        boolean bl3 = false;
        JBInsets.addTo((Dimension)it, (Insets)button4.getInsets());
        JBInsets.addTo((Dimension)it, (Insets)DefaultLinkButtonUIKt.access$focusInsets(button4));
        Dimension dimension2 = dimension;
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"layout.bounds.size.also \u2026tton.focusInsets())\n    }");
        return dimension2;
    }

    @Override
    public boolean contains(@Nullable JComponent c, int x, int y) {
        JComponent jComponent = c;
        if (!(jComponent instanceof AbstractButton)) {
            jComponent = null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton == null) {
            return false;
        }
        AbstractButton button4 = abstractButton;
        Layout layout = new Layout(button4, DefaultLinkButtonUIKt.access$viewBounds(button4), null, 4, null);
        return layout.getIconBounds().contains(x, y) || layout.getTextBounds().contains(x, y) || layout.getBounds().contains(x, y);
    }

    @Override
    public void paint(@NotNull Graphics g, @Nullable JComponent c) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        JComponent jComponent = c;
        if (!(jComponent instanceof AbstractButton)) {
            jComponent = null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton == null) {
            return;
        }
        AbstractButton button4 = abstractButton;
        g.setFont(button4.getFont());
        Rectangle rectangle = DefaultLinkButtonUIKt.access$viewBounds(button4);
        FontMetrics fontMetrics = UIUtilities.getFontMetrics((JComponent)button4, (Graphics)g);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"UIUtilities.getFontMetrics(button, g)");
        Layout layout = new Layout(button4, rectangle, fontMetrics);
        if (DefaultLinkButtonUIKt.access$isPressed(button4)) {
            this.setTextShiftOffset();
        } else {
            this.clearTextShiftOffset();
        }
        this.paintIcon(g, button4, layout.getIconBounds());
        CharSequence charSequence = layout.getText();
        boolean bl = false;
        if (charSequence.length() > 0) {
            int offset = this.getTextShiftOffset();
            layout.getTextBounds().x += offset;
            layout.getTextBounds().y += offset;
            boolean hovered2 = DefaultLinkButtonUIKt.access$isHovered(button4);
            View view = DefaultLinkButtonUIKt.access$htmlView(button4);
            if (view == null) {
                g.setColor(DefaultLinkButtonUIKt.access$getTextColor(button4));
                int index2 = DefaultLinkButtonUIKt.access$isEnabled(button4) && DarculaLaf.isAltPressed() ? button4.getDisplayedMnemonicIndex() : -1;
                UIUtilities.drawStringUnderlineCharAt((JComponent)button4, (Graphics)g, (String)layout.getText(), (int)index2, (int)layout.getTextBounds().x, (int)layout.getBaseline());
                if (hovered2) {
                    g.fillRect(layout.getTextBounds().x, layout.getBaseline() + 1, layout.getTextBounds().width, 1);
                }
            } else if (hovered2) {
                if (this.cached == null) {
                    this.cached = DefaultLinkButtonUIKt.access$createUnderlinedView(button4, layout.getText());
                }
                View view2 = this.cached;
                Intrinsics.checkNotNull((Object)view2);
                view2.paint(g, layout.getTextBounds());
            } else {
                view.paint(g, layout.getTextBounds());
            }
        }
        if (g instanceof Graphics2D && DefaultLinkButtonUIKt.access$isFocused(button4)) {
            ((Graphics2D)g).setColor(JBUI.CurrentTheme.Link.FOCUSED_BORDER_COLOR);
            Rectangle hovered2 = layout.getBounds();
            boolean bl2 = false;
            boolean bl3 = false;
            Rectangle it = hovered2;
            boolean bl4 = false;
            JBInsets.addTo((Rectangle)it, (Insets)DefaultLinkButtonUIKt.access$focusInsets(button4));
            Rectangle bounds2 = hovered2;
            int round = Registry.intValue((String)"ide.link.button.focus.round.arc", (int)4);
            RectanglePainter.DRAW.paint((Graphics2D)g, bounds2.x, bounds2.y, bounds2.width, bounds2.height, (Object)JBUIScale.scale((int)round));
        }
    }

    @Override
    @NotNull
    protected BasicButtonListener createButtonListener(@NotNull AbstractButton button4) {
        Intrinsics.checkNotNullParameter((Object)button4, (String)"button");
        return new BasicButtonListener(this, button4, button4){
            final /* synthetic */ DefaultLinkButtonUI this$0;
            final /* synthetic */ AbstractButton $button;

            public void propertyChange(@NotNull PropertyChangeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DefaultLinkButtonUI.access$setCached$p(this.this$0, null);
                super.propertyChange(event);
            }

            public void stateChanged(@NotNull ChangeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Object object = event.getSource();
                if (!(object instanceof AbstractButton)) {
                    object = null;
                }
                AbstractButton abstractButton = (AbstractButton)object;
                if (abstractButton == null) {
                    return;
                }
                AbstractButton source = abstractButton;
                if (source.isRolloverEnabled()) {
                    source.setCursor(DefaultLinkButtonUIKt.access$isHovered(source) ? Cursor.getPredefinedCursor(12) : null);
                }
                source.repaint();
            }
            {
                this.this$0 = this$0;
                this.$button = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    public static final /* synthetic */ View access$getCached$p(DefaultLinkButtonUI $this) {
        return $this.cached;
    }

    public static final /* synthetic */ void access$setCached$p(DefaultLinkButtonUI $this, View view) {
        $this.cached = view;
    }

    @JvmStatic
    @NotNull
    public static final DefaultLinkButtonUI createUI(@Nullable JComponent c) {
        return Companion.createUI(c);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ui/components/DefaultLinkButtonUI$Companion;", "", "()V", "createUI", "Lcom/intellij/ui/components/DefaultLinkButtonUI;", "c", "Ljavax/swing/JComponent;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DefaultLinkButtonUI createUI(@Nullable JComponent c) {
            return new DefaultLinkButtonUI();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

