/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.builder.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.components.DslLabel;
import com.intellij.ui.dsl.builder.components.DslLabelType;
import com.intellij.ui.dsl.builder.impl.CellBaseImpl;
import com.intellij.ui.dsl.builder.impl.CellImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0016\u0010\u0015\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0017H\u0000\u001a\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0017H\u0000\u001a\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0010H\u0000\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\t\u001a\u00020\n*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"ALLOWED_LABEL_COMPONENTS", "", "Lkotlin/reflect/KClass;", "", "FAIL_ON_WARN", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "origin", "Ljavax/swing/JComponent;", "getOrigin", "(Ljavax/swing/JComponent;)Ljavax/swing/JComponent;", "createComment", "Lcom/intellij/ui/dsl/builder/components/DslLabel;", "text", "", "maxLineLength", "", "action", "Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "isAllowedLabel", "cell", "Lcom/intellij/ui/dsl/builder/impl/CellBaseImpl;", "labelCell", "", "label", "Ljavax/swing/JLabel;", "warn", "message", "intellij.platform.ide.impl"})
public final class UtilsKt {
    private static final boolean FAIL_ON_WARN = false;
    private static final Logger LOG;
    private static final List<KClass<? extends Object>> ALLOWED_LABEL_COMPONENTS;

    @NotNull
    public static final JComponent getOrigin(@NotNull JComponent $this$origin) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)$this$origin, (String)"$this$origin");
        JComponent jComponent2 = $this$origin;
        if (jComponent2 instanceof TextFieldWithBrowseButton) {
            JTextField jTextField = ((TextFieldWithBrowseButton)$this$origin).getTextField();
            Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"textField");
            jComponent = jTextField;
        } else {
            jComponent = $this$origin;
        }
        return jComponent;
    }

    @NotNull
    public static final DslLabel createComment(@NlsContexts.Label @NotNull String text2, int maxLineLength, @NotNull HyperlinkEventAction action2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        DslLabel result2 = new DslLabel(DslLabelType.COMMENT);
        result2.setAction(action2);
        result2.setHtmlText(text2, maxLineLength);
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAllowedLabel(@Nullable CellBaseImpl<?> cell2) {
        KClass clazz;
        if (!(cell2 instanceof CellImpl)) return false;
        Iterable $this$any$iv = ALLOWED_LABEL_COMPONENTS;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            clazz = (KClass)element$iv;
            boolean bl = false;
        } while (!clazz.isInstance((Object)UtilsKt.getOrigin(((CellImpl)cell2).getComponent())));
        return true;
    }

    public static final void labelCell(@NotNull JLabel label2, @Nullable CellBaseImpl<?> cell2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        if (UtilsKt.isAllowedLabel(cell2)) {
            CellBaseImpl<?> cellBaseImpl = cell2;
            if (cellBaseImpl == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.dsl.builder.impl.CellImpl<*>");
            }
            label2.setLabelFor(UtilsKt.getOrigin(((CellImpl)cellBaseImpl).getComponent()));
        }
    }

    public static final void warn(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        LOG.warn(message2);
    }

    static {
        Logger logger = Logger.getInstance((String)"Jetbrains UI DSL");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"Jetbrains UI DSL\")");
        LOG = logger;
        ALLOWED_LABEL_COMPONENTS = CollectionsKt.listOf((Object[])new KClass[]{Reflection.getOrCreateKotlinClass(JComboBox.class), Reflection.getOrCreateKotlinClass(JSlider.class), Reflection.getOrCreateKotlinClass(JSpinner.class), Reflection.getOrCreateKotlinClass(JTextComponent.class)});
    }
}

