/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.impl;

import com.intellij.ui.dsl.UiDslExceptionKt;
import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import com.intellij.ui.dsl.gridLayout.impl.GridImplKt;
import com.intellij.ui.dsl.gridLayout.impl.LayoutCellData;
import com.intellij.ui.dsl.gridLayout.impl.RowBaselineData;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u000eR&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/BaselineData;", "", "()V", "rowBaselineData", "", "", "Lcom/intellij/ui/dsl/gridLayout/VerticalAlign;", "Lcom/intellij/ui/dsl/gridLayout/impl/RowBaselineData;", "get", "verticalAlign", "layoutCellData", "Lcom/intellij/ui/dsl/gridLayout/impl/LayoutCellData;", "getOrCreate", "registerBaseline", "", "baseline", "reset", "intellij.platform.ide.impl"})
final class BaselineData {
    private final Map<Integer, Map<VerticalAlign, RowBaselineData>> rowBaselineData;

    public final void reset() {
        this.rowBaselineData.clear();
    }

    public final void registerBaseline(@NotNull LayoutCellData layoutCellData, int baseline) {
        Intrinsics.checkNotNullParameter((Object)layoutCellData, (String)"layoutCellData");
        Constraints constraints2 = layoutCellData.getCell().getConstraints();
        UiDslExceptionKt.checkTrue(GridImplKt.access$isSupportedBaseline(constraints2));
        RowBaselineData rowBaselineData = this.getOrCreate(layoutCellData);
        int n = rowBaselineData.getMaxAboveBaseline();
        int n2 = baseline + layoutCellData.getRowGaps().getTop() + constraints2.getGaps().getTop() - constraints2.getVisualPaddings().getTop();
        boolean bl = false;
        rowBaselineData.setMaxAboveBaseline(Math.max(n, n2));
        n = rowBaselineData.getMaxBelowBaseline();
        n2 = layoutCellData.getPreferredSize().height - baseline + layoutCellData.getRowGaps().getBottom() + constraints2.getGaps().getBottom() - constraints2.getVisualPaddings().getBottom();
        bl = false;
        rowBaselineData.setMaxBelowBaseline(Math.max(n, n2));
    }

    @Nullable
    public final RowBaselineData get(@NotNull VerticalAlign verticalAlign) {
        Map<Object, Object> map2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)verticalAlign), (String)"verticalAlign");
            UiDslExceptionKt.checkTrue(this.rowBaselineData.size() <= 1);
            Map<Integer, Map<VerticalAlign, RowBaselineData>> map3 = this.rowBaselineData;
            boolean bl = false;
            Map<Object, Object> map4 = map3;
            boolean bl2 = false;
            Iterator<Map.Entry<Integer, Map<VerticalAlign, RowBaselineData>>> iterator2 = map4.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Integer, Map<VerticalAlign, RowBaselineData>> entry2;
                Map.Entry<Integer, Map<VerticalAlign, RowBaselineData>> it = entry2 = iterator2.next();
                boolean bl3 = false;
                map4 = it.getValue();
                if (map4 == null) continue;
                map2 = map4;
                break block1;
            }
            map2 = null;
        }
        return map2 != null ? (RowBaselineData)map2.get((Object)verticalAlign) : null;
    }

    @Nullable
    public final RowBaselineData get(@NotNull LayoutCellData layoutCellData) {
        Intrinsics.checkNotNullParameter((Object)layoutCellData, (String)"layoutCellData");
        Constraints constraints2 = layoutCellData.getCell().getConstraints();
        Map<VerticalAlign, RowBaselineData> map2 = this.rowBaselineData.get(constraints2.getY());
        return map2 != null ? map2.get((Object)constraints2.getVerticalAlign()) : null;
    }

    private final RowBaselineData getOrCreate(LayoutCellData layoutCellData) {
        Object object;
        Map mapByAlign;
        Object object2;
        Map $this$getOrPut$iv;
        Constraints constraints2 = layoutCellData.getCell().getConstraints();
        Map<Integer, Map<VerticalAlign, RowBaselineData>> map2 = this.rowBaselineData;
        Object key$iv = constraints2.getY();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new EnumMap(VerticalAlign.class);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = mapByAlign = (Map)object2;
        key$iv = constraints2.getVerticalAlign();
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            RowBaselineData answer$iv = new RowBaselineData(0, 0, 3, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (RowBaselineData)object;
    }

    public BaselineData() {
        boolean bl = false;
        this.rowBaselineData = new LinkedHashMap();
    }
}

