/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.impl;

import com.intellij.ui.dsl.UiDslException;
import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.Gaps;
import com.intellij.ui.dsl.gridLayout.Grid;
import com.intellij.ui.dsl.gridLayout.GridLayout;
import com.intellij.ui.dsl.gridLayout.HorizontalGaps;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import com.intellij.ui.dsl.gridLayout.VerticalGaps;
import com.intellij.ui.dsl.gridLayout.impl.Cell;
import com.intellij.ui.dsl.gridLayout.impl.ComponentCell;
import com.intellij.ui.dsl.gridLayout.impl.GridCell;
import com.intellij.ui.dsl.gridLayout.impl.GridImpl$WhenMappings;
import com.intellij.ui.dsl.gridLayout.impl.GridImplKt;
import com.intellij.ui.dsl.gridLayout.impl.LayoutCellData;
import com.intellij.ui.dsl.gridLayout.impl.LayoutData;
import com.intellij.ui.dsl.gridLayout.impl.PreferredSizeData;
import com.intellij.ui.dsl.gridLayout.impl.RowBaselineData;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000eH\u0002J\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u000eJ\u0006\u0010*\u001a\u00020'J\u000e\u0010+\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u000eJ\u0016\u0010,\u001a\u00020'2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eJ\b\u0010-\u001a\u00020'H\u0002J\u0010\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u00020/H\u0002J\u0016\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u000eJ\u001e\u00108\u001a\u00020'2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u00104\u001a\u000205J\u0016\u0010;\u001a\u00020'2\u0006\u00100\u001a\u0002012\u0006\u00107\u001a\u00020/J\u000e\u0010<\u001a\u00020\u00012\u0006\u00107\u001a\u00020/J\u000e\u0010=\u001a\u00020\u00172\u0006\u00100\u001a\u000201R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006>"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/GridImpl;", "Lcom/intellij/ui/dsl/gridLayout/Grid;", "()V", "cells", "", "Lcom/intellij/ui/dsl/gridLayout/impl/Cell;", "columnsGaps", "Lcom/intellij/ui/dsl/gridLayout/HorizontalGaps;", "getColumnsGaps", "()Ljava/util/List;", "layoutData", "Lcom/intellij/ui/dsl/gridLayout/impl/LayoutData;", "resizableColumns", "", "", "getResizableColumns", "()Ljava/util/Set;", "resizableRows", "getResizableRows", "rowsGaps", "Lcom/intellij/ui/dsl/gridLayout/VerticalGaps;", "getRowsGaps", "visible", "", "getVisible", "()Z", "calculateBaseline", "height", "verticalAlign", "Lcom/intellij/ui/dsl/gridLayout/VerticalAlign;", "rowBaselineData", "Lcom/intellij/ui/dsl/gridLayout/impl/RowBaselineData;", "calculateBounds", "Ljava/awt/Rectangle;", "layoutCellData", "Lcom/intellij/ui/dsl/gridLayout/impl/LayoutCellData;", "offsetX", "offsetY", "calculateLayoutDataStep1", "", "calculateLayoutDataStep2", "width", "calculateLayoutDataStep3", "calculateLayoutDataStep4", "calculateOutsideGaps", "calculatePreferredLayoutData", "getConstraints", "Lcom/intellij/ui/dsl/gridLayout/Constraints;", "component", "Ljavax/swing/JComponent;", "getPreferredSizeData", "Lcom/intellij/ui/dsl/gridLayout/impl/PreferredSizeData;", "parentInsets", "Ljava/awt/Insets;", "isEmpty", "constraints", "layout", "x", "y", "register", "registerSubGrid", "unregister", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class GridImpl
implements Grid {
    @NotNull
    private final Set<Integer> resizableColumns;
    @NotNull
    private final Set<Integer> resizableRows;
    @NotNull
    private final List<HorizontalGaps> columnsGaps;
    @NotNull
    private final List<VerticalGaps> rowsGaps;
    private final LayoutData layoutData;
    private final List<Cell> cells;

    @Override
    @NotNull
    public Set<Integer> getResizableColumns() {
        return this.resizableColumns;
    }

    @Override
    @NotNull
    public Set<Integer> getResizableRows() {
        return this.resizableRows;
    }

    @Override
    @NotNull
    public List<HorizontalGaps> getColumnsGaps() {
        return this.columnsGaps;
    }

    @Override
    @NotNull
    public List<VerticalGaps> getRowsGaps() {
        return this.rowsGaps;
    }

    public final boolean getVisible() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.cells;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Cell it = (Cell)element$iv;
                    boolean bl2 = false;
                    if (!it.getVisible()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void register(@NotNull JComponent component2, @NotNull Constraints constraints2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)constraints2, (String)"constraints");
        if (!this.isEmpty(constraints2)) {
            throw (Throwable)new UiDslException("Some cells are occupied already: " + constraints2, null, 2, null);
        }
        this.cells.add(new ComponentCell(constraints2, component2));
    }

    @NotNull
    public final Grid registerSubGrid(@NotNull Constraints constraints2) {
        Intrinsics.checkNotNullParameter((Object)constraints2, (String)"constraints");
        if (!this.isEmpty(constraints2)) {
            throw (Throwable)new UiDslException("Some cells are occupied already: " + constraints2, null, 2, null);
        }
        GridImpl result2 = new GridImpl();
        this.cells.add(new GridCell(constraints2, result2));
        return result2;
    }

    public final boolean unregister(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Iterator<Cell> iterator2 = this.cells.iterator();
        Object object = iterator2;
        boolean bl = false;
        Iterator<Cell> iterator3 = object;
        while (iterator3.hasNext()) {
            Cell cell2 = iterator3.next();
            object = cell2;
            if (object instanceof ComponentCell) {
                if (!Intrinsics.areEqual((Object)((ComponentCell)cell2).getComponent(), (Object)component2)) continue;
                iterator2.remove();
                return true;
            }
            if (!(object instanceof GridCell) || !((GridCell)cell2).getContent().unregister(component2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final PreferredSizeData getPreferredSizeData(@NotNull Insets parentInsets) {
        Intrinsics.checkNotNullParameter((Object)parentInsets, (String)"parentInsets");
        this.calculatePreferredLayoutData();
        Gaps outsideGaps = this.layoutData.getOutsideGaps(parentInsets);
        return new PreferredSizeData(new Dimension(this.layoutData.getPreferredWidth() + outsideGaps.getWidth(), this.layoutData.getPreferredHeight() + outsideGaps.getHeight()), outsideGaps);
    }

    public final void layout(int width, int height, @NotNull Insets parentInsets) {
        Intrinsics.checkNotNullParameter((Object)parentInsets, (String)"parentInsets");
        this.calculatePreferredLayoutData();
        Gaps outsideGaps = this.layoutData.getOutsideGaps(parentInsets);
        this.calculateLayoutDataStep2(width - outsideGaps.getWidth());
        this.calculateLayoutDataStep3();
        this.calculateLayoutDataStep4(height - outsideGaps.getHeight());
        this.layout(outsideGaps.getLeft(), outsideGaps.getTop());
    }

    public final void layout(int x, int y) {
        for (LayoutCellData layoutCellData : this.layoutData.getVisibleCellsData()) {
            Rectangle bounds2 = this.calculateBounds(layoutCellData, x, y);
            Cell cell2 = layoutCellData.getCell();
            if (cell2 instanceof ComponentCell) {
                ((ComponentCell)cell2).getComponent().setBounds(bounds2);
                continue;
            }
            if (!(cell2 instanceof GridCell)) continue;
            ((GridCell)cell2).getContent().layout(bounds2.x, bounds2.y);
        }
    }

    private final void calculatePreferredLayoutData() {
        this.calculateLayoutDataStep1();
        this.calculateLayoutDataStep2(this.layoutData.getPreferredWidth());
        this.calculateLayoutDataStep3();
        this.calculateLayoutDataStep4(this.layoutData.getPreferredHeight());
        this.calculateOutsideGaps(this.layoutData.getPreferredWidth(), this.layoutData.getPreferredHeight());
    }

    public final void calculateLayoutDataStep1() {
        this.layoutData.getColumnsSizeCalculator().reset();
        boolean bl = false;
        List visibleCellsData = new ArrayList();
        int columnsCount = 0;
        int rowsCount = 0;
        for (Cell cell2 : this.cells) {
            int n;
            Dimension preferredSize = null;
            Cell cell3 = cell2;
            if (cell3 instanceof ComponentCell) {
                JComponent component2 = ((ComponentCell)cell2).getComponent();
                if (!component2.isVisible()) continue;
                Dimension componentMinimumSize = component2.getMinimumSize();
                Dimension componentPreferredSize = component2.getPreferredSize();
                int n2 = componentMinimumSize.width;
                int n3 = componentPreferredSize.width;
                n = 0;
                int n4 = Math.max(n2, n3);
                n2 = componentMinimumSize.height;
                n3 = componentPreferredSize.height;
                n = 0;
                preferredSize = new Dimension(n4, Math.max(n2, n3));
            } else if (cell3 instanceof GridCell) {
                GridImpl grid = ((GridCell)cell2).getContent();
                if (!grid.getVisible()) continue;
                grid.calculateLayoutDataStep1();
                preferredSize = new Dimension(grid.layoutData.getPreferredWidth(), 0);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            LayoutCellData layoutCellData = null;
            Constraints constraints2 = cell2.getConstraints();
            boolean bl2 = false;
            boolean bl3 = false;
            Constraints $this$with = constraints2;
            boolean bl4 = false;
            HorizontalGaps horizontalGaps = (HorizontalGaps)CollectionsKt.getOrNull(this.getColumnsGaps(), (int)$this$with.getX());
            HorizontalGaps horizontalGaps2 = (HorizontalGaps)CollectionsKt.getOrNull(this.getColumnsGaps(), (int)($this$with.getX() + $this$with.getWidth() - 1));
            VerticalGaps verticalGaps = (VerticalGaps)CollectionsKt.getOrNull(this.getRowsGaps(), (int)$this$with.getY());
            VerticalGaps verticalGaps2 = (VerticalGaps)CollectionsKt.getOrNull(this.getRowsGaps(), (int)($this$with.getY() + $this$with.getHeight() - 1));
            layoutCellData = new LayoutCellData(cell2, preferredSize, new HorizontalGaps(horizontalGaps != null ? horizontalGaps.getLeft() : 0, horizontalGaps2 != null ? horizontalGaps2.getRight() : 0), new VerticalGaps(verticalGaps != null ? verticalGaps.getTop() : 0, verticalGaps2 != null ? verticalGaps2.getBottom() : 0));
            n = columnsCount;
            int n5 = $this$with.getX() + $this$with.getWidth();
            boolean bl5 = false;
            columnsCount = Math.max(n, n5);
            n = rowsCount;
            n5 = $this$with.getY() + $this$with.getHeight();
            bl5 = false;
            rowsCount = Math.max(n, n5);
            visibleCellsData.add(layoutCellData);
            this.layoutData.getColumnsSizeCalculator().addConstraint(cell2.getConstraints().getX(), cell2.getConstraints().getWidth(), layoutCellData.getCellPaddedWidth());
        }
        this.layoutData.setVisibleCellsData(visibleCellsData);
        this.layoutData.setPreferredWidth(this.layoutData.getColumnsSizeCalculator().calculatePreferredSize());
        this.layoutData.getDimension().setSize(columnsCount, rowsCount);
    }

    public final void calculateLayoutDataStep2(int width) {
        this.layoutData.setColumnsCoord(this.layoutData.getColumnsSizeCalculator().calculateCoords(width, this.getResizableColumns()));
        for (LayoutCellData layoutCellData : this.layoutData.getVisibleCellsData()) {
            Cell cell2 = layoutCellData.getCell();
            if (!(cell2 instanceof GridCell)) continue;
            ((GridCell)cell2).getContent().calculateLayoutDataStep2(this.layoutData.getFullPaddedWidth(layoutCellData));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void calculateLayoutDataStep3() {
        Constraints constraints2;
        this.layoutData.getRowsSizeCalculator().reset();
        this.layoutData.getBaselineData().reset();
        for (LayoutCellData layoutCellData : this.layoutData.getVisibleCellsData()) {
            void verticalAlign;
            Pair $this$mapNotNullTo$iv$iv;
            VerticalAlign $this$mapNotNull$iv;
            constraints2 = layoutCellData.getCell().getConstraints();
            layoutCellData.setBaseline(null);
            Cell cell2 = layoutCellData.getCell();
            if (cell2 instanceof ComponentCell) {
                if (!GridImplKt.access$isSupportedBaseline(constraints2)) continue;
                int componentWidth = this.layoutData.getPaddedWidth(layoutCellData) + constraints2.getVisualPaddings().getWidth();
                int baseline = 0;
                if (componentWidth >= 0) {
                    Object object = cell2.getConstraints().getComponentHelper();
                    baseline = object != null && (object = object.getBaseline(componentWidth, layoutCellData.getPreferredSize().height)) != null ? ((Integer)object).intValue() : ((ComponentCell)cell2).getComponent().getBaseline(componentWidth, layoutCellData.getPreferredSize().height);
                    layoutCellData.getPreferredSize().height = ((ComponentCell)cell2).getComponent().getPreferredSize().height;
                } else {
                    baseline = -1;
                }
                if (baseline < 0) continue;
                layoutCellData.setBaseline(baseline);
                this.layoutData.getBaselineData().registerBaseline(layoutCellData, baseline);
                continue;
            }
            if (!(cell2 instanceof GridCell)) continue;
            GridImpl grid = ((GridCell)cell2).getContent();
            grid.calculateLayoutDataStep3();
            layoutCellData.getPreferredSize().height = grid.layoutData.getPreferredHeight();
            if (grid.layoutData.getDimension().height != 1 || !GridImplKt.access$isSupportedBaseline(constraints2)) continue;
            VerticalAlign[] verticalAlignArray = VerticalAlign.values();
            boolean $i$f$mapNotNull = false;
            void var9_14 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var14_20 = $this$forEach$iv$iv$iv;
            int n = ((void)var14_20).length;
            for (int j = 0; j < n; ++j) {
                Pair pair;
                RowBaselineData baselineData;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var14_20[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                Pair result2 = null;
                if (it != VerticalAlign.FILL && (baselineData = grid.layoutData.getBaselineData().get((VerticalAlign)it)) != null) {
                    result2 = new Pair((Object)it, (Object)baselineData);
                }
                if (result2 == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                Pair it$iv$iv = pair;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List gridBaselines = (List)destination$iv$iv;
            if (gridBaselines.size() != 1) continue;
            $this$mapNotNullTo$iv$iv = (Pair)gridBaselines.get(0);
            $this$mapNotNull$iv = (VerticalAlign)((Object)$this$mapNotNullTo$iv$iv.component1());
            RowBaselineData gridBaselineData = (RowBaselineData)$this$mapNotNullTo$iv$iv.component2();
            int baseline = this.calculateBaseline(layoutCellData.getPreferredSize().height, (VerticalAlign)verticalAlign, gridBaselineData);
            layoutCellData.setBaseline(baseline);
            this.layoutData.getBaselineData().registerBaseline(layoutCellData, baseline);
        }
        for (LayoutCellData layoutCellData : this.layoutData.getVisibleCellsData()) {
            int n;
            constraints2 = layoutCellData.getCell().getConstraints();
            if (layoutCellData.getBaseline() == null) {
                n = layoutCellData.getGapHeight() - layoutCellData.getCell().getConstraints().getVisualPaddings().getHeight() + layoutCellData.getPreferredSize().height;
            } else {
                RowBaselineData rowBaselineData;
                RowBaselineData rowBaselineData2 = rowBaselineData = this.layoutData.getBaselineData().get(layoutCellData);
                Intrinsics.checkNotNull((Object)rowBaselineData2);
                n = rowBaselineData2.getHeight();
            }
            int height = n;
            this.layoutData.getRowsSizeCalculator().addConstraint(constraints2.getY(), constraints2.getHeight(), height);
        }
        this.layoutData.setPreferredHeight(this.layoutData.getRowsSizeCalculator().calculatePreferredSize());
    }

    public final void calculateLayoutDataStep4(int height) {
        this.layoutData.setRowsCoord(this.layoutData.getRowsSizeCalculator().calculateCoords(height, this.getResizableRows()));
        for (LayoutCellData layoutCellData : this.layoutData.getVisibleCellsData()) {
            Cell cell2 = layoutCellData.getCell();
            if (!(cell2 instanceof GridCell)) continue;
            int subGridHeight = cell2.getConstraints().getVerticalAlign() == VerticalAlign.FILL ? this.layoutData.getFullPaddedHeight(layoutCellData) : ((GridCell)cell2).getContent().layoutData.getPreferredHeight();
            ((GridCell)cell2).getContent().calculateLayoutDataStep4(subGridHeight);
        }
    }

    public final void calculateOutsideGaps(int width, int height) {
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        for (LayoutCellData layoutCellData : this.layoutData.getVisibleCellsData()) {
            int n;
            GridLayout layout;
            JComponent component2;
            Cell cell2 = layoutCellData.getCell();
            Cell cell3 = cell2;
            if (!(cell3 instanceof ComponentCell)) {
                cell3 = null;
            }
            ComponentCell componentCell = (ComponentCell)cell3;
            JComponent jComponent = component2 = componentCell != null ? componentCell.getComponent() : null;
            LayoutManager layoutManager = jComponent != null ? jComponent.getLayout() : null;
            if (!(layoutManager instanceof GridLayout)) {
                layoutManager = null;
            }
            if ((layout = (GridLayout)layoutManager) != null) {
                PreferredSizeData preferredSizeData = layout.getPreferredSizeData$intellij_platform_ide_impl(component2);
                cell2.getConstraints().setVisualPaddings(preferredSizeData.getOutsideGaps());
            }
            Rectangle bounds2 = this.calculateBounds(layoutCellData, 0, 0);
            Cell cell4 = cell2;
            if (cell4 instanceof ComponentCell) {
                int n2 = bounds2.x;
                n = 0;
                left = Math.min(left, n2);
                n2 = bounds2.y;
                n = 0;
                top = Math.min(top, n2);
                n2 = bounds2.x + bounds2.width - width;
                n = 0;
                right = Math.max(right, n2);
                n2 = bounds2.y + bounds2.height - height;
                n = 0;
                bottom = Math.max(bottom, n2);
                continue;
            }
            if (!(cell4 instanceof GridCell)) continue;
            ((GridCell)cell2).getContent().calculateOutsideGaps(bounds2.width, bounds2.height);
            Gaps outsideGaps = ((GridCell)cell2).getContent().layoutData.getOutsideGaps();
            n = bounds2.x - outsideGaps.getLeft();
            boolean bl = false;
            left = Math.min(left, n);
            n = bounds2.y - outsideGaps.getTop();
            bl = false;
            top = Math.min(top, n);
            n = bounds2.x + bounds2.width + outsideGaps.getRight() - width;
            bl = false;
            right = Math.max(right, n);
            n = bounds2.y + bounds2.height + outsideGaps.getBottom() - height;
            bl = false;
            bottom = Math.max(bottom, n);
        }
        this.layoutData.setOutsideGaps(new Gaps(-top, -left, bottom, right));
    }

    @Nullable
    public final Constraints getConstraints(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        for (Cell cell2 : this.cells) {
            Constraints constraints2;
            Cell cell3 = cell2;
            if (cell3 instanceof ComponentCell) {
                if (!Intrinsics.areEqual((Object)((ComponentCell)cell2).getComponent(), (Object)component2)) continue;
                return cell2.getConstraints();
            }
            if (!(cell3 instanceof GridCell) || (constraints2 = ((GridCell)cell2).getContent().getConstraints(component2)) == null) continue;
            return constraints2;
        }
        return null;
    }

    private final Rectangle calculateBounds(LayoutCellData layoutCellData, int offsetX, int offsetY) {
        int n;
        int n2;
        Cell cell2 = layoutCellData.getCell();
        Constraints constraints2 = cell2.getConstraints();
        Gaps visualPaddings = constraints2.getVisualPaddings();
        int paddedWidth = this.layoutData.getPaddedWidth(layoutCellData);
        int fullPaddedWidth = this.layoutData.getFullPaddedWidth(layoutCellData);
        int n3 = this.layoutData.getColumnsCoord()[constraints2.getX()] + constraints2.getGaps().getLeft() + layoutCellData.getColumnGaps().getLeft() - visualPaddings.getLeft();
        switch (GridImpl$WhenMappings.$EnumSwitchMapping$0[constraints2.getHorizontalAlign().ordinal()]) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = (fullPaddedWidth - paddedWidth) / 2;
                break;
            }
            case 3: {
                n2 = fullPaddedWidth - paddedWidth;
                break;
            }
            case 4: {
                n2 = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int x = n3 + n2;
        int fullPaddedHeight = this.layoutData.getFullPaddedHeight(layoutCellData);
        if (constraints2.getVerticalAlign() == VerticalAlign.FILL) {
            n = fullPaddedHeight;
        } else {
            int n4 = layoutCellData.getPreferredSize().height - visualPaddings.getHeight();
            boolean bl = false;
            n = Math.min(fullPaddedHeight, n4);
        }
        int paddedHeight = n;
        int y = 0;
        Integer baseline = layoutCellData.getBaseline();
        if (baseline == null) {
            int n5;
            int n6 = this.layoutData.getRowsCoord()[constraints2.getY()] + layoutCellData.getRowGaps().getTop() + constraints2.getGaps().getTop() - visualPaddings.getTop();
            switch (GridImpl$WhenMappings.$EnumSwitchMapping$1[constraints2.getVerticalAlign().ordinal()]) {
                case 1: {
                    n5 = 0;
                    break;
                }
                case 2: {
                    n5 = (fullPaddedHeight - paddedHeight) / 2;
                    break;
                }
                case 3: {
                    n5 = fullPaddedHeight - paddedHeight;
                    break;
                }
                case 4: {
                    n5 = 0;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            y = n6 + n5;
        } else {
            RowBaselineData rowBaselineData = this.layoutData.getBaselineData().get(layoutCellData);
            Intrinsics.checkNotNull((Object)rowBaselineData);
            RowBaselineData rowBaselineData2 = rowBaselineData;
            int rowHeight = this.layoutData.getHeight(layoutCellData);
            y = this.layoutData.getRowsCoord()[constraints2.getY()] + this.calculateBaseline(rowHeight, constraints2.getVerticalAlign(), rowBaselineData2) - baseline;
        }
        return new Rectangle(offsetX + x, offsetY + y, paddedWidth + visualPaddings.getWidth(), paddedHeight + visualPaddings.getHeight());
    }

    private final int calculateBaseline(int height, VerticalAlign verticalAlign, RowBaselineData rowBaselineData) {
        int n;
        int n2 = rowBaselineData.getMaxAboveBaseline();
        switch (GridImpl$WhenMappings.$EnumSwitchMapping$2[verticalAlign.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = (height - rowBaselineData.getHeight()) / 2;
                break;
            }
            case 3: {
                n = height - rowBaselineData.getHeight();
                break;
            }
            case 4: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n2 + n;
    }

    private final boolean isEmpty(Constraints constraints2) {
        for (Cell cell2 : this.cells) {
            Constraints constraints3 = cell2.getConstraints();
            boolean bl = false;
            boolean bl2 = false;
            Constraints $this$with = constraints3;
            boolean bl3 = false;
            if (constraints2.getX() + constraints2.getWidth() <= $this$with.getX() || $this$with.getX() + $this$with.getWidth() <= constraints2.getX() || constraints2.getY() + constraints2.getHeight() <= $this$with.getY() || $this$with.getY() + $this$with.getHeight() <= constraints2.getY()) continue;
            return false;
        }
        return true;
    }

    public GridImpl() {
        boolean bl = false;
        this.resizableColumns = new LinkedHashSet();
        bl = false;
        this.resizableRows = new LinkedHashSet();
        bl = false;
        this.columnsGaps = new ArrayList();
        bl = false;
        this.rowsGaps = new ArrayList();
        this.layoutData = new LayoutData();
        bl = false;
        this.cells = new ArrayList();
    }
}

