/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.CommandLineProcessor;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.AboutAction;
import com.intellij.ide.actions.ShowSettingsAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.idea.IdeStarter;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.desktop.OpenURIEvent;
import java.awt.desktop.OpenURIHandler;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MacOSApplicationProvider {
    private static final Logger LOG = Logger.getInstance(MacOSApplicationProvider.class);

    private MacOSApplicationProvider() {
    }

    public static void initApplication() {
        try {
            Worker.initMacApplication();
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    private static final class Worker {
        private static final AtomicBoolean ENABLED = new AtomicBoolean(true);
        private static Object UPDATE_CALLBACK_REF;

        private Worker() {
        }

        static void initMacApplication() {
            Desktop desktop = Desktop.getDesktop();
            desktop.setAboutHandler(event -> {
                if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
                    AboutAction.perform(Worker.getProject(false));
                }
            });
            desktop.setPreferencesHandler(event -> {
                if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
                    Project project = Objects.requireNonNull(Worker.getProject(true));
                    Worker.submit("Preferences", () -> ShowSettingsAction.perform(project));
                }
            });
            desktop.setQuitHandler((event, response) -> {
                if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
                    Worker.submit("Quit", () -> ApplicationManager.getApplication().exit());
                    response.cancelQuit();
                } else {
                    response.performQuit();
                }
            });
            desktop.setOpenFileHandler(event -> {
                List<File> files2 = event.getFiles();
                if (files2.isEmpty()) {
                    return;
                }
                List list2 = ContainerUtil.map(files2, file2 -> file2.toPath());
                if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
                    Project project = Worker.getProject(false);
                    Worker.submit("OpenFile", () -> ProjectUtil.tryOpenFiles(project, list2, "MacMenu"));
                } else {
                    IdeStarter.openFilesOnLoading(list2);
                }
            });
            if (JnaLoader.isLoaded()) {
                Worker.installAutoUpdateMenu();
                Worker.installProtocolHandler();
            }
        }

        private static void installAutoUpdateMenu() {
            ID pool = Foundation.invoke((String)"NSAutoreleasePool", (String)"new", (Object[])new Object[0]);
            ID app2 = Foundation.invoke((String)"NSApplication", (String)"sharedApplication", (Object[])new Object[0]);
            ID menu = Foundation.invoke((ID)app2, (Pointer)Foundation.createSelector((String)"menu"), (Object[])new Object[0]);
            ID item = Foundation.invoke((ID)menu, (Pointer)Foundation.createSelector((String)"itemAtIndex:"), (Object[])new Object[]{0});
            ID appMenu = Foundation.invoke((ID)item, (Pointer)Foundation.createSelector((String)"submenu"), (Object[])new Object[0]);
            ID checkForUpdatesClass = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSMenuItem"), (String)"NSCheckForUpdates");
            Callback impl = new Callback(){

                public void callback(ID self, String selector) {
                    SwingUtilities.invokeLater(() -> {
                        ActionManager actionManager = ActionManager.getInstance();
                        MouseEvent mouseEvent = new MouseEvent(JOptionPane.getRootFrame(), 500, System.currentTimeMillis(), 0, 0, 0, 1, false);
                        actionManager.tryToExecute(actionManager.getAction("CheckForUpdate"), (InputEvent)mouseEvent, null, null, false);
                    });
                }
            };
            UPDATE_CALLBACK_REF = impl;
            Foundation.addMethod((ID)checkForUpdatesClass, (Pointer)Foundation.createSelector((String)"checkForUpdates"), (Callback)impl, (String)"v");
            Foundation.registerObjcClassPair((ID)checkForUpdatesClass);
            ID checkForUpdates2 = Foundation.invoke((String)"NSCheckForUpdates", (String)"alloc", (Object[])new Object[0]);
            Foundation.invoke((ID)checkForUpdates2, (Pointer)Foundation.createSelector((String)"initWithTitle:action:keyEquivalent:"), (Object[])new Object[]{Foundation.nsString((String)"Check for Updates..."), Foundation.createSelector((String)"checkForUpdates"), Foundation.nsString((String)"")});
            Foundation.invoke((ID)checkForUpdates2, (Pointer)Foundation.createSelector((String)"setTarget:"), (Object[])new Object[]{checkForUpdates2});
            Foundation.invoke((ID)appMenu, (Pointer)Foundation.createSelector((String)"insertItem:atIndex:"), (Object[])new Object[]{checkForUpdates2, 1});
            Foundation.invoke((ID)checkForUpdates2, (Pointer)Foundation.createSelector((String)"release"), (Object[])new Object[0]);
            Foundation.invoke((ID)pool, (Pointer)Foundation.createSelector((String)"release"), (Object[])new Object[0]);
        }

        @Nullable
        private static Project getProject(boolean useDefault) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
            if (project == null) {
                LOG.debug("MacMenu: no project in data context");
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                Project project2 = project = projects.length > 0 ? projects[0] : null;
                if (project == null && useDefault) {
                    LOG.debug("MacMenu: use default project instead");
                    project = ProjectManager.getInstance().getDefaultProject();
                }
            }
            LOG.debug("MacMenu: project = ", new Object[]{project});
            return project;
        }

        private static void submit(String name2, Runnable task2) {
            LOG.debug("MacMenu: on EDT = ", new Object[]{SwingUtilities.isEventDispatchThread(), "; ENABLED = ", ENABLED.get()});
            if (!ENABLED.get()) {
                LOG.debug("MacMenu: disabled");
            } else {
                Component component2 = IdeFocusManager.getGlobalInstance().getFocusOwner();
                if (component2 != null && IdeKeyEventDispatcher.isModalContext(component2)) {
                    LOG.debug("MacMenu: component in modal context");
                } else {
                    ENABLED.set(false);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        try {
                            LOG.debug("MacMenu: init ", new Object[]{name2});
                            task2.run();
                        }
                        catch (Throwable throwable) {
                            LOG.debug("MacMenu: done ", new Object[]{name2});
                            ENABLED.set(true);
                            throw throwable;
                        }
                        LOG.debug("MacMenu: done ", new Object[]{name2});
                        ENABLED.set(true);
                    }, ModalityState.NON_MODAL);
                }
            }
        }

        private static void installProtocolHandler() {
            ID mainBundle = Foundation.invoke((String)"NSBundle", (String)"mainBundle", (Object[])new Object[0]);
            ID urlTypes = Foundation.invoke((ID)mainBundle, (String)"objectForInfoDictionaryKey:", (Object[])new Object[]{Foundation.nsString((String)"CFBundleURLTypes")});
            if (urlTypes.equals((Object)ID.NIL)) {
                BuildNumber build2 = ApplicationInfoImpl.getShadowInstance().getBuild();
                if (!build2.isSnapshot()) {
                    LOG.warn("No URL bundle (CFBundleURLTypes) is defined in the main bundle.\nTo be able to open external links, specify protocols in the app layout section of the build file.\nExample: args.urlSchemes = [\"your-protocol\"] will handle following links: your-protocol://open?file=file&line=line");
                }
                return;
            }
            Desktop.getDesktop().setOpenURIHandler(new OpenURIHandler(){

                @Override
                public void openURI(OpenURIEvent event) {
                    URI uri = event.getURI();
                    Object uriString = uri.toString();
                    if ("open".equals(uri.getHost()) && new QueryStringDecoder(uri).parameters().get("file") != null) {
                        uriString = "!!!internal!!!" + (String)uriString;
                    }
                    if (LoadingState.APP_STARTED.isOccurred()) {
                        CommandLineProcessor.processProtocolCommand((String)uriString);
                    } else {
                        IdeStarter.openUriOnLoading((String)uriString);
                    }
                }
            });
        }
    }
}

