/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacWinTabsHandler {
    private static final String WIN_TAB_FILLER = "WIN_TAB_FILLER_KEY";
    private final JFrame myFrame;
    private final boolean myFrameAllowed;
    private boolean myShowFrame;
    private boolean myInitFrame;
    private static Callback myObserverCallback;
    private static ID myObserverDelegate;

    @NotNull
    public static JComponent wrapRootPaneNorthSide(@NotNull JRootPane rootPane, @NotNull JComponent northComponent) {
        if (rootPane == null) {
            MacWinTabsHandler.$$$reportNull$$$0(0);
        }
        if (northComponent == null) {
            MacWinTabsHandler.$$$reportNull$$$0(1);
        }
        if (!JdkEx.isTabbingModeAvailable()) {
            JComponent jComponent = northComponent;
            if (jComponent == null) {
                MacWinTabsHandler.$$$reportNull$$$0(2);
            }
            return jComponent;
        }
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        OpaquePanel filler = new OpaquePanel();
        filler.setBorder(JBUI.Borders.customLineBottom((Color)UIUtil.getTooltipSeparatorColor()));
        filler.setVisible(false);
        panel2.add((Component)filler, "North");
        panel2.add(northComponent);
        rootPane.putClientProperty(WIN_TAB_FILLER, filler);
        rootPane.putClientProperty("Window.transparentTitleBarHeight", 28);
        NonOpaquePanel nonOpaquePanel = panel2;
        if (nonOpaquePanel == null) {
            MacWinTabsHandler.$$$reportNull$$$0(3);
        }
        return nonOpaquePanel;
    }

    public MacWinTabsHandler(@NotNull JFrame frame, @NotNull Disposable parentDisposable) {
        if (frame == null) {
            MacWinTabsHandler.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            MacWinTabsHandler.$$$reportNull$$$0(5);
        }
        this.myFrame = frame;
        boolean bl = this.myFrameAllowed = MacWinTabsHandler.isAllowedFrame(frame) && JdkEx.setTabbingMode(frame, () -> MacWinTabsHandler.updateTabBars(null));
        if (this.myFrameAllowed) {
            Foundation.invoke((String)"NSWindow", (String)"setAllowsAutomaticWindowTabbing:", (Object[])new Object[]{true});
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    MacWinTabsHandler.updateTabBars(null);
                }
            });
        }
    }

    private static boolean isAllowedFrame(@Nullable JFrame frame) {
        return frame == null || frame instanceof IdeFrameImpl;
    }

    public void frameInit() {
        if (!this.myFrameAllowed || !MacWinTabsHandler.isTransparentTitleBar()) {
            return;
        }
        Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
            ID window = MacUtil.getWindowFromJavaWindow((Window)this.myFrame);
            String windowId = ApplicationNamesInfo.getInstance().getProductName() + (PluginManagerCore.isRunningFromSources() ? "-Snapshot" : "") + "-AwtWindow-WithTabs";
            Foundation.invoke((ID)window, (String)"setTabbingIdentifier:", (Object[])new Object[]{Foundation.nsString((String)windowId)});
        });
    }

    public void frameShow() {
        this.myShowFrame = true;
        if (this.myInitFrame) {
            this.initUpdateTabBars();
        }
    }

    public void setProject() {
        this.myInitFrame = true;
        if (this.myShowFrame) {
            this.initUpdateTabBars();
        }
    }

    public void enteringFullScreen() {
        this.enterFullScreen();
    }

    public void enterFullScreen() {
        if (!this.myFrameAllowed) {
            return;
        }
        if (MacWinTabsHandler.isTransparentTitleBar()) {
            this.updateTabBar();
        } else {
            MacWinTabsHandler.updateTabBar(this.myFrame, 0);
        }
    }

    public void exitFullScreen() {
        if (this.myFrameAllowed) {
            this.updateTabBar();
        }
    }

    private void updateTabBar() {
        Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
            ID window = MacUtil.getWindowFromJavaWindow((Window)this.myFrame);
            int visibleAndHeight = (int)Foundation.invoke_fpret((ID)window, (String)"getTabBarVisibleAndHeight", (Object[])new Object[0]);
            ApplicationManager.getApplication().invokeLater(() -> MacWinTabsHandler.updateTabBar(this.myFrame, visibleAndHeight == -1 ? MacWinTabsHandler.DEFAULT_WIN_TAB_HEIGHT() : visibleAndHeight));
        });
    }

    private void initUpdateTabBars() {
        ApplicationManager.getApplication().invokeLater(() -> MacWinTabsHandler.updateTabBars(this.myFrame));
    }

    private static void updateTabBars(@Nullable JFrame newFrame) {
        if (!MacWinTabsHandler.isAllowedFrame(newFrame) || !JdkEx.isTabbingModeAvailable()) {
            return;
        }
        IdeFrame[] frames = WindowManager.getInstance().getAllProjectFrames();
        if (frames.length < 2) {
            if (frames.length == 1) {
                MacWinTabsHandler.updateTabBar(frames[0], 0);
                if (newFrame == null) {
                    IdeFrameImpl frame;
                    ProjectFrameHelper helper2 = (ProjectFrameHelper)frames[0];
                    if (helper2.isInFullScreen() && (frame = helper2.getFrame()) != null) {
                        MacWinTabsHandler.handleFullScreenResize(frame);
                    }
                } else {
                    Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> MacWinTabsHandler.addTabObserver(MacUtil.getWindowFromJavaWindow((Window)newFrame)));
                }
            }
            return;
        }
        boolean isTransparentTitleBar = MacWinTabsHandler.isTransparentTitleBar();
        ApplicationManager.getApplication().invokeLater(() -> {
            int i2;
            Integer[] visibleAndHeights = new Integer[frames.length];
            boolean callInAppkit = false;
            int newIndex = -1;
            for (i2 = 0; i2 < frames.length; ++i2) {
                ProjectFrameHelper helper2 = (ProjectFrameHelper)frames[i2];
                if (Disposer.isDisposed((Disposable)helper2)) {
                    visibleAndHeights[i2] = 0;
                    continue;
                }
                if (newFrame == helper2.getFrame()) {
                    newIndex = i2;
                }
                if (!isTransparentTitleBar && helper2.isInFullScreen()) {
                    visibleAndHeights[i2] = 0;
                    continue;
                }
                callInAppkit = true;
            }
            if (callInAppkit) {
                Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
                    if (newFrame != null) {
                        MacWinTabsHandler.addTabObserver(MacUtil.getWindowFromJavaWindow((Window)newFrame));
                    }
                    for (int i2 = 0; i2 < frames.length; ++i2) {
                        int styleMask;
                        if (visibleAndHeights[i2] != null) continue;
                        ID window = MacUtil.getWindowFromJavaWindow((Window)((ProjectFrameHelper)frames[i2]).getFrame());
                        int n = styleMask = isTransparentTitleBar ? 0 : Foundation.invoke((ID)window, (String)"styleMask", (Object[])new Object[0]).intValue();
                        if ((styleMask & 0x4000) != 0) {
                            visibleAndHeights[i2] = 0;
                            continue;
                        }
                        visibleAndHeights[i2] = (int)Foundation.invoke_fpret((ID)window, (String)"getTabBarVisibleAndHeight", (Object[])new Object[0]);
                        if (visibleAndHeights[i2] != -1) continue;
                        visibleAndHeights[i2] = MacWinTabsHandler.DEFAULT_WIN_TAB_HEIGHT();
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        for (int i2 = 0; i2 < frames.length; ++i2) {
                            MacWinTabsHandler.updateTabBar(frames[i2], visibleAndHeights[i2]);
                        }
                    });
                });
            } else {
                if (newFrame != null) {
                    Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> MacWinTabsHandler.addTabObserver(MacUtil.getWindowFromJavaWindow((Window)newFrame)));
                }
                if (newIndex != -1) {
                    visibleAndHeights[newIndex] = 0;
                }
                for (i2 = 0; i2 < frames.length; ++i2) {
                    MacWinTabsHandler.updateTabBar(frames[i2], visibleAndHeights[i2]);
                }
            }
        });
    }

    private static void updateTabBar(@NotNull Object frameObject, int height) {
        if (frameObject == null) {
            MacWinTabsHandler.$$$reportNull$$$0(6);
        }
        JFrame frame = null;
        if (frameObject instanceof JFrame) {
            frame = (JFrame)frameObject;
        } else if (frameObject instanceof ProjectFrameHelper) {
            if (Disposer.isDisposed((Disposable)((Disposable)frameObject))) {
                return;
            }
            frame = ((ProjectFrameHelper)frameObject).getFrame();
        }
        if (frame == null) {
            return;
        }
        JComponent filler = (JComponent)frame.getRootPane().getClientProperty(WIN_TAB_FILLER);
        if (filler == null) {
            return;
        }
        if (height > 0 && MacWinTabsHandler.isTransparentTitleBar()) {
            ++height;
        }
        boolean visible = height > 0;
        boolean oldVisible = filler.isVisible();
        filler.setVisible(visible);
        filler.setPreferredSize((Dimension)new JBDimension(-1, height));
        Container parent = filler.getParent();
        if (parent == null || oldVisible == visible) {
            return;
        }
        parent.doLayout();
        parent.revalidate();
        parent.repaint();
    }

    private static void handleFullScreenResize(@NotNull Window window) {
        if (window == null) {
            MacWinTabsHandler.$$$reportNull$$$0(7);
        }
        try {
            Object cPlatformWindow = MacUtil.getPlatformWindow((Window)window);
            if (cPlatformWindow != null) {
                Class<?> windowClass = cPlatformWindow.getClass();
                Method deliverMoveResize = ReflectionUtil.getDeclaredMethod(windowClass, (String)"deliverMoveResizeEvent", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE});
                if (deliverMoveResize == null) {
                    return;
                }
                Rectangle rect = window.getGraphicsConfiguration().getBounds();
                Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
                    try {
                        deliverMoveResize.invoke(cPlatformWindow, rect.x, rect.y, rect.width, rect.height, true);
                    }
                    catch (Throwable e) {
                        Logger.getInstance(MacWinTabsHandler.class).error(e);
                    }
                });
            }
        }
        catch (Throwable e) {
            Logger.getInstance(MacWinTabsHandler.class).error(e);
        }
    }

    private static boolean isTransparentTitleBar() {
        return Registry.is((String)"ide.mac.transparentTitleBarAppearance", (boolean)false);
    }

    private static int DEFAULT_WIN_TAB_HEIGHT() {
        return Registry.intValue((String)"ide.mac.bigsur.window.with.tabs.height", (int)28);
    }

    private static void addTabObserver(@NotNull ID window) {
        ID tabGroup;
        if (window == null) {
            MacWinTabsHandler.$$$reportNull$$$0(8);
        }
        if (!ID.NIL.equals((Object)Foundation.invoke((ID)(tabGroup = Foundation.invoke((ID)window, (String)"tabGroup", (Object[])new Object[0])), (String)"observationInfo", (Object[])new Object[0]))) {
            return;
        }
        if (myObserverDelegate == null) {
            myObserverCallback = new Callback(){

                public void callback(ID self, Pointer selector, ID keyPath, ID ofObject, ID change, Pointer context2) {
                    ApplicationManager.getApplication().invokeLater(() -> MacWinTabsHandler.updateTabBars(null));
                }
            };
            ID delegateClass = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSObject"), (String)"MyWindowTabGroupObserver");
            Foundation.addMethod((ID)delegateClass, (Pointer)Foundation.createSelector((String)"observeValueForKeyPath:ofObject:change:context:"), (Callback)myObserverCallback, (String)"v*");
            Foundation.registerObjcClassPair((ID)delegateClass);
            myObserverDelegate = Foundation.invoke((String)"MyWindowTabGroupObserver", (String)"new", (Object[])new Object[0]);
        }
        Foundation.invoke((ID)tabGroup, (String)"addObserver:forKeyPath:options:context:", (Object[])new Object[]{myObserverDelegate, Foundation.nsString((String)"windows"), 0, ID.NIL});
    }

    public static void switchFrameIfPossible(@NotNull JFrame frame, boolean next) {
        if (frame == null) {
            MacWinTabsHandler.$$$reportNull$$$0(9);
        }
        if (JdkEx.isTabbingModeAvailable()) {
            Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> Foundation.invoke((ID)MacUtil.getWindowFromJavaWindow((Window)frame), (String)(next ? "selectNextTab:" : "selectPreviousTab:"), (Object[])new Object[]{ID.NIL}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "northComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/MacWinTabsHandler";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameObject";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/MacWinTabsHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapRootPaneNorthSide";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapRootPaneNorthSide";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateTabBar";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleFullScreenResize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTabObserver";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "switchFrameIfPossible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

