/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TouchBarStats;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TBItemScrubber
extends TBItem
implements NSTLibrary.ScrubberDelegate {
    private final int myWidth;
    @Nullable
    private final TouchBarStats myStats;
    private final NSTLibrary.ScrubberCacheUpdater myUpdater;
    private final List<ItemData> myItems = new ArrayList<ItemData>();
    private int myNativeItemsCount;

    TBItemScrubber(@Nullable ItemListener listener2, @Nullable TouchBarStats stats, int scrubWidth) {
        super("scrubber", listener2);
        this.myWidth = scrubWidth;
        this.myStats = stats;
        this.myUpdater = () -> {
            if (this.myItems.isEmpty()) {
                return 0;
            }
            if (this.myNativeItemsCount >= this.myItems.size()) {
                return 0;
            }
            int chunkSize = 25;
            int newItemsCount = Math.min(25, this.myItems.size() - this.myNativeItemsCount);
            int fromPosition = this.myNativeItemsCount;
            NST.updateScrubberItems(this, fromPosition, newItemsCount, false, true);
            @NotNull Application app2 = ApplicationManager.getApplication();
            app2.executeOnPooledThread(() -> NST.updateScrubberItems(this, fromPosition, newItemsCount, true, false));
            this.myNativeItemsCount += newItemsCount;
            return newItemsCount;
        };
    }

    @NotNull
    List<ItemData> getItems() {
        List<ItemData> list2 = this.myItems;
        if (list2 == null) {
            TBItemScrubber.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Nullable
    TouchBarStats getStats() {
        return this.myStats;
    }

    TBItemScrubber addItem(Icon icon2, String text2, Runnable action2) {
        Runnable nativeAction = action2 == null && this.myListener == null ? null : () -> {
            if (action2 != null) {
                action2.run();
            }
            if (this.myListener != null) {
                this.myListener.onItemEvent(this, 0);
            }
            ActivityTracker.getInstance().inc();
        };
        this.myItems.add(new ItemData(icon2, text2, nativeAction));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableItems(Collection<Integer> indices, boolean enabled) {
        if (indices == null || indices.isEmpty()) {
            return;
        }
        for (int c = 0; c < this.myItems.size(); ++c) {
            if (!indices.contains(c)) continue;
            ItemData id2 = this.myItems.get(c);
            id2.myEnabled = enabled;
        }
        TBItemScrubber tBItemScrubber = this;
        synchronized (tBItemScrubber) {
            NST.enableScrubberItems(this.myNativePeer, indices, enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showItems(Collection<Integer> indices, boolean visible, boolean inverseOthers) {
        TBItemScrubber tBItemScrubber = this;
        synchronized (tBItemScrubber) {
            NST.showScrubberItem(this.myNativePeer, indices, visible, inverseOthers);
        }
    }

    @Override
    protected ID _createNativePeer() {
        this.myNativeItemsCount = this.myItems.isEmpty() ? 0 : Math.min(30, this.myItems.size());
        ID result2 = NST.createScrubber(this.getUid(), this.myWidth, this, this.myUpdater, this.myItems, this.myNativeItemsCount, this.myStats);
        NST.enableScrubberItems(result2, this._getDisabledIndices(), false);
        if (this.myNativeItemsCount > 0 && result2 != ID.NIL) {
            @NotNull Application app2 = ApplicationManager.getApplication();
            app2.executeOnPooledThread(() -> NST.updateScrubberItems(this, 0, this.myNativeItemsCount, true, false));
        }
        return result2;
    }

    @Override
    public void execute(int itemIndex) {
        if (this.myItems.isEmpty() || itemIndex < 0 || itemIndex >= this.myItems.size()) {
            return;
        }
        ItemData id2 = this.myItems.get(itemIndex);
        if (id2 != null && id2.myAction != null) {
            id2.myAction.run();
        }
    }

    private List<Integer> _getDisabledIndices() {
        ArrayList<Integer> disabled = new ArrayList<Integer>();
        for (int c = 0; c < this.myItems.size(); ++c) {
            if (this.myItems.get((int)c).myEnabled) continue;
            disabled.add(c);
        }
        return disabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/mac/touchbar/TBItemScrubber", "getItems"));
    }

    static class ItemData {
        private byte[] myTextBytes;
        private final Icon myIcon;
        private final String myText;
        private final Runnable myAction;
        private boolean myEnabled = true;
        float fMulX = 0.0f;
        Icon darkIcon = null;
        int scaledWidth = 0;
        int scaledHeight = 0;

        ItemData(Icon icon2, String text2, Runnable action2) {
            this.myIcon = icon2;
            this.myText = text2;
            this.myAction = action2;
        }

        Icon getIcon() {
            return this.myIcon;
        }

        String getText() {
            return this.myText;
        }

        byte[] getTextBytes() {
            if (this.myTextBytes == null && this.myText != null) {
                this.myTextBytes = this.myText.getBytes(StandardCharsets.UTF_8);
            }
            return this.myTextBytes;
        }
    }
}

