/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.mac.touchbar.Helpers;
import com.intellij.ui.mac.touchbar.StatsCounters;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

final class TouchBarStats {
    private static final Map<String, TouchBarStats> ourStats = new HashMap<String, TouchBarStats>();
    private final String name;
    private final Map<String, AnActionStats> actionStats = new ConcurrentHashMap<String, AnActionStats>();
    private final AtomicLong[] myCounters = new AtomicLong[StatsCounters.values().length];

    private TouchBarStats(String name2) {
        this.name = name2;
        Arrays.setAll(this.myCounters, i2 -> new AtomicLong(0L));
    }

    @NotNull
    static TouchBarStats getStats(@NotNull String touchbarName) {
        if (touchbarName == null) {
            TouchBarStats.$$$reportNull$$$0(0);
        }
        TouchBarStats touchBarStats = ourStats.computeIfAbsent(touchbarName, s -> new TouchBarStats(touchbarName));
        if (touchBarStats == null) {
            TouchBarStats.$$$reportNull$$$0(1);
        }
        return touchBarStats;
    }

    static void printAll(@NotNull PrintStream out) {
        if (out == null) {
            TouchBarStats.$$$reportNull$$$0(2);
        }
        for (TouchBarStats tbs : ourStats.values()) {
            tbs.print(out);
        }
    }

    void print(@NotNull PrintStream out) {
        if (out == null) {
            TouchBarStats.$$$reportNull$$$0(3);
        }
        out.printf("========================= %s =========================", this.name);
        out.println();
        for (StatsCounters sc : StatsCounters.values()) {
            String name2 = sc.name();
            long val = this.myCounters[sc.ordinal()].get();
            if (val == 0L) continue;
            if (name2.endsWith("DurationNs")) {
                if (val < 1000L) continue;
                name2 = name2.replace("DurationNs", "DurationMs");
                val /= 1000000L;
            }
            out.printf("%s=%d\n", name2, val);
        }
        if (!this.actionStats.isEmpty()) {
            AnActionStats total = new AnActionStats("total");
            for (AnActionStats as : this.actionStats.values()) {
                total.accumulate(as);
            }
            total.print(out);
        }
    }

    void incrementCounter(@NotNull StatsCounters cnt) {
        if (cnt == null) {
            TouchBarStats.$$$reportNull$$$0(4);
        }
        this.myCounters[cnt.ordinal()].incrementAndGet();
    }

    void incrementCounter(@NotNull StatsCounters cnt, long value2) {
        if (cnt == null) {
            TouchBarStats.$$$reportNull$$$0(5);
        }
        this.myCounters[cnt.ordinal()].addAndGet(value2);
    }

    @NotNull
    AnActionStats getActionStats(@NotNull String actionId) {
        if (actionId == null) {
            TouchBarStats.$$$reportNull$$$0(6);
        }
        AnActionStats anActionStats = this.actionStats.computeIfAbsent(actionId, s -> new AnActionStats((String)s));
        if (anActionStats == null) {
            TouchBarStats.$$$reportNull$$$0(7);
        }
        return anActionStats;
    }

    @NotNull
    AnActionStats getActionStats(@NotNull AnAction action2) {
        if (action2 == null) {
            TouchBarStats.$$$reportNull$$$0(8);
        }
        String actId = Helpers.getActionId(action2);
        AnActionStats anActionStats = this.actionStats.computeIfAbsent(actId, s -> new AnActionStats((String)s));
        if (anActionStats == null) {
            TouchBarStats.$$$reportNull$$$0(9);
        }
        return anActionStats;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "touchbarName";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/TouchBarStats";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cnt";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchBarStats";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStats";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionStats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStats";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "printAll";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "incrementCounter";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActionStats";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AnActionStats {
        @NotNull
        final String actionId;
        long totalUpdateDurationNs;
        long maxUpdateDurationNs;
        boolean isBackgroundThread;
        long updateViewNs;
        int iconUpdateIconRasterCount;
        long iconUpdateNativePeerDurationNs;
        long iconGetDarkDurationNs;
        long iconRenderingDurationNs;
        long iconLoadingDurationNs;

        AnActionStats(@NotNull String actionId) {
            if (actionId == null) {
                AnActionStats.$$$reportNull$$$0(0);
            }
            this.isBackgroundThread = false;
            this.actionId = actionId;
        }

        void onUpdate(long updateDurationNs) {
            this.isBackgroundThread |= !ApplicationManager.getApplication().isDispatchThread();
            this.totalUpdateDurationNs += updateDurationNs;
            this.maxUpdateDurationNs = Math.max(this.maxUpdateDurationNs, updateDurationNs);
        }

        void accumulate(AnActionStats other) {
            this.totalUpdateDurationNs += other.totalUpdateDurationNs;
            this.maxUpdateDurationNs = Math.max(this.maxUpdateDurationNs, other.maxUpdateDurationNs);
            this.updateViewNs += other.updateViewNs;
            this.iconUpdateIconRasterCount += other.iconUpdateIconRasterCount;
            this.iconUpdateNativePeerDurationNs += other.iconUpdateNativePeerDurationNs;
            this.iconGetDarkDurationNs += other.iconGetDarkDurationNs;
            this.iconRenderingDurationNs += other.iconRenderingDurationNs;
            this.iconLoadingDurationNs += other.iconLoadingDurationNs;
        }

        void print(@NotNull PrintStream out) {
            if (out == null) {
                AnActionStats.$$$reportNull$$$0(1);
            }
            out.printf("act '%s':\n", this.actionId);
            AnActionStats.printSignificantValue(out, "iconUpdateIconRasterCount", this.iconUpdateIconRasterCount);
            AnActionStats.printSignificantValue(out, "totalUpdateDurationNs", this.totalUpdateDurationNs);
            AnActionStats.printSignificantValue(out, "updateViewNs", this.updateViewNs);
            AnActionStats.printSignificantValue(out, "iconUpdateNativePeerDurationNs", this.iconUpdateNativePeerDurationNs);
            AnActionStats.printSignificantValue(out, "iconGetDarkDurationNs", this.iconGetDarkDurationNs);
            AnActionStats.printSignificantValue(out, "iconRenderingDurationNs", this.iconRenderingDurationNs);
        }

        private static void printSignificantValue(@NotNull PrintStream out, @NotNull String name2, long val) {
            if (out == null) {
                AnActionStats.$$$reportNull$$$0(2);
            }
            if (name2 == null) {
                AnActionStats.$$$reportNull$$$0(3);
            }
            if (val == 0L) {
                return;
            }
            if (name2.endsWith("DurationNs") || name2.endsWith("Ns")) {
                if (val < 1000L) {
                    return;
                }
                name2 = name2.replace("Ns", "Ms");
                val /= 1000000L;
            }
            out.printf("\t%s=%d\n", name2, val);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchBarStats$AnActionStats";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "printSignificantValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

