/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.ui.mac.touchbar.CtxDefault;
import com.intellij.ui.mac.touchbar.CtxDialogs;
import com.intellij.ui.mac.touchbar.CtxEditors;
import com.intellij.ui.mac.touchbar.CtxPopup;
import com.intellij.ui.mac.touchbar.CtxToolWindows;
import com.intellij.ui.mac.touchbar.Helpers;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TouchbarSupport {
    private static final String IS_ENABLED_KEY = "ide.mac.touchbar.enabled";
    private static final Logger LOG = Logger.getInstance(TouchbarSupport.class);
    @NotNull
    private static final AWTEventListener ourAWTEventListener = e -> TouchBarsManager.processAWTEvent(e);
    private static final long ourEventMask = 12L;
    private static volatile boolean isInitialized;
    private static volatile boolean isEnabled;
    private static MessageBusConnection ourConnection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        if (isInitialized) {
            return;
        }
        Class<TouchbarSupport> clazz = TouchbarSupport.class;
        synchronized (TouchbarSupport.class) {
            if (isInitialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            NST.loadLibrary();
            if (!Registry.is((String)IS_ENABLED_KEY)) {
                LOG.info("touchbar disabled: registry");
                isEnabled = false;
            } else {
                String appId = Helpers.getAppId();
                if (appId == null || appId.isEmpty()) {
                    LOG.info("can't obtain application id from NSBundle (touchbar enabled)");
                } else if (NSDefaults.isShowFnKeysEnabled((String)appId)) {
                    if (NSDefaults.isFnShowsAppControls()) {
                        LOG.info("touchbar enabled: show FN-keys but pressing fn-key toggle to show app-controls");
                        isEnabled = true;
                    } else {
                        LOG.info("touchbar disabled: show fn-keys");
                        isEnabled = false;
                    }
                } else {
                    LOG.info("touchbar support is enabled");
                }
            }
            isInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void enableSupport() {
        isEnabled = true;
        Toolkit.getDefaultToolkit().addAWTEventListener(ourAWTEventListener, 12L);
        CtxDefault.initialize();
        CtxToolWindows.initialize();
        ourConnection = ApplicationManager.getApplication().getMessageBus().connect();
        ourConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                TouchbarSupport.reloadAllActions();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ui/mac/touchbar/TouchbarSupport$1", "pluginUnloaded"));
            }
        });
        CustomActionsSchema.addSettingsGroup("TouchBar", IdeBundle.message((String)"settings.menus.group.touch.bar", (Object[])new Object[0]));
    }

    public static void enable(boolean enable) {
        if (!isInitialized || !TouchbarSupport.isAvailable()) {
            return;
        }
        if (!enable) {
            if (isEnabled) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(ourAWTEventListener);
                TouchBarsManager.clearAll();
                CtxDefault.disable();
                CtxToolWindows.disable();
                if (ourConnection != null) {
                    ourConnection.disconnect();
                }
                ourConnection = null;
                CustomActionsSchema.removeSettingsGroup("TouchBar");
                isEnabled = false;
            }
            return;
        }
        if (!isEnabled && Registry.is((String)IS_ENABLED_KEY)) {
            TouchbarSupport.enableSupport();
        }
    }

    public static void onApplicationLoaded() {
        TouchbarSupport.initialize();
        if (!isInitialized || !TouchbarSupport.isEnabled()) {
            return;
        }
        TouchbarSupport.enableSupport();
    }

    public static boolean isAvailable() {
        return SystemInfoRt.isMac && NST.isAvailable();
    }

    public static boolean isEnabled() {
        return TouchbarSupport.isAvailable() && isEnabled && Registry.is((String)IS_ENABLED_KEY);
    }

    public static void onUpdateEditorHeader(@NotNull Editor editor2) {
        if (editor2 == null) {
            TouchbarSupport.$$$reportNull$$$0(0);
        }
        if (!isInitialized || !TouchbarSupport.isEnabled()) {
            return;
        }
        CtxEditors.onUpdateEditorHeader(editor2);
    }

    public static void showPopupItems(@NotNull JBPopup popup2, @NotNull JComponent popupComponent) {
        if (popup2 == null) {
            TouchbarSupport.$$$reportNull$$$0(1);
        }
        if (popupComponent == null) {
            TouchbarSupport.$$$reportNull$$$0(2);
        }
        if (!isInitialized || !TouchbarSupport.isEnabled()) {
            return;
        }
        Disposable tb = CtxPopup.showPopupItems(popup2, popupComponent);
        if (tb != null) {
            Disposer.register((Disposable)popup2, (Disposable)tb);
        }
    }

    @Nullable
    public static Disposable showWindowActions(@NotNull Component contentPane) {
        if (contentPane == null) {
            TouchbarSupport.$$$reportNull$$$0(3);
        }
        if (!isInitialized || !TouchbarSupport.isEnabled()) {
            return null;
        }
        return CtxDialogs.showWindowActions(contentPane);
    }

    public static void showWindowActions(@NotNull Disposable parent, @NotNull Component contentPane) {
        Disposable tb;
        if (parent == null) {
            TouchbarSupport.$$$reportNull$$$0(4);
        }
        if (contentPane == null) {
            TouchbarSupport.$$$reportNull$$$0(5);
        }
        if ((tb = TouchbarSupport.showWindowActions(contentPane)) != null) {
            Disposer.register((Disposable)parent, (Disposable)tb);
        }
    }

    public static void reloadAllActions() {
        if (!isInitialized || !TouchbarSupport.isEnabled()) {
            return;
        }
        CtxDefault.reloadAllActions();
        CtxToolWindows.reloadAllActions();
    }

    static {
        isEnabled = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupComponent";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPane";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchbarSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onUpdateEditorHeader";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showPopupItems";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showWindowActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

