/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.LafIconLookup;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ActionStepBuilder {
    private static final Logger LOG = Logger.getInstance(ActionStepBuilder.class);
    private final List<PopupFactoryImpl.ActionItem> myListModel;
    private final DataContext myDataContext;
    private final boolean myShowNumbers;
    private final boolean myUseAlphaAsNumbers;
    private final PresentationFactory myPresentationFactory;
    private final boolean myShowDisabled;
    private int myCurrentNumber;
    private boolean myPrependWithSeparator;
    private @NlsContexts.Separator String mySeparatorText;
    private final boolean myHonorActionMnemonics;
    private final String myActionPlace;
    private Icon myEmptyIcon;
    private int myMaxIconWidth;
    private int myMaxIconHeight;

    ActionStepBuilder(@NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabled, boolean honorActionMnemonics, @Nullable String actionPlace, @Nullable PresentationFactory presentationFactory) {
        if (dataContext == null) {
            ActionStepBuilder.$$$reportNull$$$0(0);
        }
        this.myMaxIconWidth = -1;
        this.myMaxIconHeight = -1;
        this.myUseAlphaAsNumbers = useAlphaAsNumbers;
        this.myPresentationFactory = presentationFactory == null ? new PresentationFactory() : Objects.requireNonNull(presentationFactory);
        this.myListModel = new ArrayList<PopupFactoryImpl.ActionItem>();
        this.myDataContext = Utils.wrapDataContext(dataContext);
        this.myShowNumbers = showNumbers;
        this.myShowDisabled = showDisabled;
        this.myCurrentNumber = 0;
        this.myPrependWithSeparator = false;
        this.mySeparatorText = null;
        this.myHonorActionMnemonics = honorActionMnemonics;
        this.myActionPlace = (String)ObjectUtils.notNull((Object)actionPlace, (Object)"popup");
    }

    @NotNull
    public List<PopupFactoryImpl.ActionItem> getItems() {
        List<PopupFactoryImpl.ActionItem> list2 = this.myListModel;
        if (list2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public void buildGroup(@NotNull ActionGroup actionGroup2) {
        if (actionGroup2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(2);
        }
        this.appendActionsFromGroup(actionGroup2);
        if (this.myListModel.isEmpty()) {
            this.myListModel.add(new PopupFactoryImpl.ActionItem(Utils.EMPTY_MENU_FILLER, Objects.requireNonNull(Utils.EMPTY_MENU_FILLER.getTemplateText()), null, this.myShowNumbers, null, null, false, null, null, false, null, null));
        }
    }

    private void calcMaxIconSize(@NotNull List<AnAction> actions2) {
        if (actions2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(3);
        }
        for (AnAction action2 : actions2) {
            if (action2 instanceof Separator) continue;
            Presentation presentation2 = this.myPresentationFactory.getPresentation(action2);
            Couple<Icon> icons = ActionStepBuilder.calcRawIcons(action2, presentation2);
            Icon icon2 = (Icon)ObjectUtils.chooseNotNull((Object)((Icon)icons.first), (Object)((Icon)icons.second));
            if (icon2 == null) continue;
            int width = icon2.getIconWidth();
            int height = icon2.getIconHeight();
            if (this.myMaxIconWidth < width) {
                this.myMaxIconWidth = width;
            }
            if (this.myMaxIconHeight >= height) continue;
            this.myMaxIconHeight = height;
        }
    }

    private void appendActionsFromGroup(@NotNull ActionGroup actionGroup2) {
        if (actionGroup2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(4);
        }
        List newVisibleActions = Utils.expandActionGroup(false, actionGroup2, this.myPresentationFactory, this.myDataContext, this.myActionPlace);
        List filtered2 = this.myShowDisabled ? newVisibleActions : ContainerUtil.filter(newVisibleActions, o -> o instanceof Separator || this.myPresentationFactory.getPresentation((AnAction)o).isEnabled());
        this.calcMaxIconSize(filtered2);
        this.myEmptyIcon = this.myMaxIconHeight != -1 && this.myMaxIconWidth != -1 ? EmptyIcon.create((int)this.myMaxIconWidth, (int)this.myMaxIconHeight) : null;
        for (AnAction action2 : filtered2) {
            if (action2 instanceof Separator) {
                this.myPrependWithSeparator = true;
                this.mySeparatorText = ((Separator)action2).getText();
                continue;
            }
            this.appendAction(action2);
        }
    }

    private void appendAction(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(5);
        }
        Presentation presentation2 = this.myPresentationFactory.getPresentation(action2);
        String text2 = presentation2.getText();
        Character mnemonic = null;
        if (this.myShowNumbers) {
            if (this.myCurrentNumber < 9) {
                mnemonic = Character.valueOf(Character.forDigit(this.myCurrentNumber + 1, 10));
            } else if (this.myCurrentNumber == 9) {
                mnemonic = Character.valueOf('0');
            } else if (this.myUseAlphaAsNumbers) {
                mnemonic = Character.valueOf((char)(65 + this.myCurrentNumber - 10));
            }
            ++this.myCurrentNumber;
        } else if (this.myHonorActionMnemonics && text2 != null) {
            text2 = TextWithMnemonic.fromPlainText((String)text2, (char)((char)action2.getTemplatePresentation().getMnemonic())).toString();
        }
        Couple<Icon> icons = ActionStepBuilder.calcRawIcons(action2, presentation2);
        Icon icon2 = (Icon)icons.first;
        Icon selectedIcon = (Icon)icons.second;
        if (this.myMaxIconWidth != -1 && this.myMaxIconHeight != -1) {
            if (icon2 != null) {
                icon2 = new SizedIcon(icon2, this.myMaxIconWidth, this.myMaxIconHeight);
            }
            if (selectedIcon != null) {
                selectedIcon = new SizedIcon(selectedIcon, this.myMaxIconWidth, this.myMaxIconHeight);
            }
        }
        if (icon2 == null) {
            icon2 = selectedIcon != null ? selectedIcon : this.myEmptyIcon;
        }
        boolean prependSeparator = (!this.myListModel.isEmpty() || this.mySeparatorText != null) && this.myPrependWithSeparator;
        LOG.assertTrue(text2 != null, (Object)("Action in `" + this.myActionPlace + "` has no presentation: " + action2.getClass().getName()));
        this.myListModel.add(new PopupFactoryImpl.ActionItem(action2, text2, mnemonic, this.myShowNumbers, presentation2.getDescription(), (String)presentation2.getClientProperty("ToolTipText"), presentation2.isEnabled(), icon2, selectedIcon, prependSeparator, this.mySeparatorText, (String)presentation2.getClientProperty(Presentation.PROP_VALUE)));
        this.myPrependWithSeparator = false;
        this.mySeparatorText = null;
    }

    @NotNull
    private static Couple<Icon> calcRawIcons(@NotNull AnAction action2, @NotNull Presentation presentation2) {
        String actionId;
        Icon disabledIcon;
        boolean hideIcon;
        if (action2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(6);
        }
        if (presentation2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(7);
        }
        Icon icon2 = (hideIcon = Boolean.TRUE.equals(presentation2.getClientProperty("HIDE_ICON"))) ? null : presentation2.getIcon();
        Icon selectedIcon = hideIcon ? null : presentation2.getSelectedIcon();
        Icon icon3 = disabledIcon = hideIcon ? null : presentation2.getDisabledIcon();
        if (icon2 == null && selectedIcon == null && ((actionId = ActionManager.getInstance().getId(action2)) == null || !actionId.startsWith("QuickList.")) && action2 instanceof Toggleable && Toggleable.isSelected((Presentation)presentation2)) {
            icon2 = LafIconLookup.getIcon((String)"checkmark");
            selectedIcon = LafIconLookup.getSelectedIcon((String)"checkmark");
            disabledIcon = LafIconLookup.getDisabledIcon((String)"checkmark");
        }
        if (!presentation2.isEnabled()) {
            icon2 = disabledIcon != null || icon2 == null ? disabledIcon : IconLoader.getDisabledIcon((Icon)icon2);
            selectedIcon = disabledIcon != null || selectedIcon == null ? disabledIcon : IconLoader.getDisabledIcon((Icon)selectedIcon);
        }
        Couple couple = Couple.of((Object)icon2, (Object)selectedIcon);
        if (couple == null) {
            ActionStepBuilder.$$$reportNull$$$0(8);
        }
        return couple;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/ActionStepBuilder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/ActionStepBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRawIcons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildGroup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcMaxIconSize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendActionsFromGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcRawIcons";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

