/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.ui.FileColorManager;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\bH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ui/tabs/FileColorsUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "EDITOR_TABS", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "FILE_COLORS", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "PROJECT_VIEW", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lang.impl"})
public final class FileColorsUsagesCollector
extends ProjectUsagesCollector {
    private final EventLogGroup GROUP = new EventLogGroup("appearance.file.colors", 2);
    private final EventId1<Boolean> FILE_COLORS = this.GROUP.registerEvent("file.colors", (EventField)EventFields.Enabled);
    private final EventId1<Boolean> EDITOR_TABS = this.GROUP.registerEvent("editor.tabs", (EventField)EventFields.Enabled);
    private final EventId1<Boolean> PROJECT_VIEW = this.GROUP.registerEvent("project.view", (EventField)EventFields.Enabled);

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        boolean useInProjectView2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = false;
        Set set2 = new LinkedHashSet();
        FileColorManager fileColorManager = FileColorManager.getInstance((Project)project);
        if (fileColorManager == null) {
            return set2;
        }
        FileColorManager manager2 = fileColorManager;
        boolean enabledFileColors2 = manager2.isEnabled();
        boolean useInEditorTabs2 = enabledFileColors2 && manager2.isEnabledForTabs();
        boolean bl2 = useInProjectView2 = enabledFileColors2 && manager2.isEnabledForProjectView();
        if (!enabledFileColors2) {
            set2.add(this.FILE_COLORS.metric((Object)false));
        }
        if (!useInEditorTabs2) {
            set2.add(this.EDITOR_TABS.metric((Object)false));
        }
        if (!useInProjectView2) {
            set2.add(this.PROJECT_VIEW.metric((Object)false));
        }
        return set2;
    }
}

