/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.ide.SmartSelectProvider;
import com.intellij.ui.tree.TreePathUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeSmartSelectProvider
implements SmartSelectProvider<JTree> {
    public void increaseSelection(JTree tree) {
        TreePath anchor2 = TreeSmartSelectProvider.getAnchor(tree);
        if (anchor2 == null) {
            return;
        }
        for (TreePath parent = anchor2; parent != null; parent = parent.getParentPath()) {
            if (TreeSmartSelectProvider.acceptDescendants(tree, parent, path2 -> !tree.isPathSelected((TreePath)path2), tree::addSelectionPaths)) {
                TreeSmartSelectProvider.setAnchor(tree, anchor2);
                return;
            }
            if (tree.isPathSelected(parent)) continue;
            if (!tree.isRootVisible() && parent.getParentPath() == null) {
                return;
            }
            tree.addSelectionPath(parent);
            TreeSmartSelectProvider.setAnchor(tree, anchor2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void decreaseSelection(JTree tree) {
        TreePath lower;
        TreePath anchor2;
        block7: {
            anchor2 = TreeSmartSelectProvider.getAnchor(tree);
            if (anchor2 == null) {
                return;
            }
            if (!tree.isPathSelected(anchor2)) {
                return;
            }
            lower = anchor2;
            TreePath upper = anchor2.getParentPath();
            while (true) {
                if (upper == null) {
                    return;
                }
                if (!TreeSmartSelectProvider.testDescendants(tree, upper, tree::isPathSelected)) break block7;
                if (!tree.isPathSelected(upper)) break;
                lower = upper;
                upper = upper.getParentPath();
            }
            TreePath except = lower;
            if (TreeSmartSelectProvider.acceptDescendants(tree, upper, path2 -> tree.isPathSelected((TreePath)path2) && !except.isDescendant((TreePath)path2), tree::removeSelectionPaths)) {
                TreeSmartSelectProvider.setAnchor(tree, anchor2);
                return;
            }
        }
        if (lower != anchor2) {
            tree.removeSelectionPath(lower);
            TreeSmartSelectProvider.setAnchor(tree, anchor2);
            return;
        }
        if (TreeSmartSelectProvider.acceptDescendants(tree, lower, tree::isPathSelected, tree::removeSelectionPaths)) {
            TreeSmartSelectProvider.setAnchor(tree, anchor2);
        }
    }

    @Nullable
    public JTree getSource(DataContext context2) {
        Component component2 = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context2);
        JTree tree = component2 instanceof JTree ? (JTree)component2 : null;
        return tree == null || 1 == tree.getSelectionModel().getSelectionMode() ? null : tree;
    }

    public boolean canIncreaseSelection(JTree tree) {
        return tree != null && 1 != tree.getSelectionModel().getSelectionMode();
    }

    public boolean canDecreaseSelection(JTree tree) {
        return tree != null && tree.getSelectionModel().getSelectionCount() > 1;
    }

    @Nullable
    private static TreePath getAnchor(@Nullable JTree tree) {
        TreePath anchor2;
        if (tree == null || 1 == tree.getSelectionModel().getSelectionMode()) {
            return null;
        }
        for (anchor2 = tree.getAnchorSelectionPath(); anchor2 != null && tree.getRowForPath(anchor2) < 0; anchor2 = anchor2.getParentPath()) {
        }
        return anchor2;
    }

    private static void setAnchor(@NotNull JTree tree, @NotNull TreePath path2) {
        if (tree == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(1);
        }
        tree.setAnchorSelectionPath(path2);
    }

    private static boolean testDescendants(@NotNull JTree tree, @NotNull TreePath parent, @NotNull Predicate<? super TreePath> predicate2) {
        TreePath path2;
        if (tree == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(3);
        }
        if (predicate2 == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(4);
        }
        boolean tested = false;
        for (int row2 = Math.max(0, 1 + tree.getRowForPath(parent)); row2 < tree.getRowCount() && parent.isDescendant(path2 = tree.getPathForRow(row2)); ++row2) {
            if (!predicate2.test(path2)) {
                return false;
            }
            tested = true;
        }
        return tested;
    }

    private static boolean acceptDescendants(@NotNull JTree tree, @NotNull TreePath parent, @NotNull Predicate<? super TreePath> predicate2, @NotNull Consumer<TreePath[]> consumer2) {
        if (tree == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(6);
        }
        if (predicate2 == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(7);
        }
        if (consumer2 == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(8);
        }
        ArrayList<TreePath> list2 = new ArrayList<TreePath>();
        TreeSmartSelectProvider.testDescendants(tree, parent, child2 -> {
            if (predicate2.test((TreePath)child2)) {
                list2.add((TreePath)child2);
            }
            return true;
        });
        if (list2.isEmpty()) {
            return false;
        }
        consumer2.accept(TreePathUtil.toTreePathArray(list2));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tree/TreeSmartSelectProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setAnchor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "testDescendants";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptDescendants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

