/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.ui.ClassicPainter;
import com.intellij.ui.tree.ui.Control;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CompactPainter
implements Control.Painter {
    static final Control.Painter DEFAULT = new CompactPainter(null, 2, 2, null);
    private final Boolean myPaintLines;
    private final Integer myLeftIndent;
    private final Integer myRightIndent;
    private final Integer myLeafIndent;

    CompactPainter(@Nullable Boolean paintLines, @Nullable Integer leftIndent, @Nullable Integer rightIndent, @Nullable Integer leafIndent) {
        this.myPaintLines = paintLines;
        this.myLeftIndent = leftIndent;
        this.myRightIndent = rightIndent;
        this.myLeafIndent = leafIndent;
    }

    @Override
    public int getRendererOffset(@NotNull Control control2, int depth, boolean leaf) {
        if (control2 == null) {
            CompactPainter.$$$reportNull$$$0(0);
        }
        if (depth < 0) {
            return -1;
        }
        if (depth == 0) {
            return 0;
        }
        int left = this.getLeftIndent();
        int offset = this.getLeafIndent(leaf);
        if (offset < 0) {
            offset = left + control2.getWidth() + this.getRightIndent();
        }
        return depth > 1 ? (depth - 1) * (left + JBUIScale.scale((int)2)) + offset : offset;
    }

    @Override
    public int getControlOffset(@NotNull Control control2, int depth, boolean leaf) {
        if (control2 == null) {
            CompactPainter.$$$reportNull$$$0(1);
        }
        if (depth <= 0 || leaf) {
            return -1;
        }
        int left = this.getLeftIndent();
        return depth > 1 ? (depth - 1) * (left + JBUIScale.scale((int)2)) + left : left;
    }

    @Override
    public void paint(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height, @NotNull Control control2, int depth, boolean leaf, boolean expanded2, boolean selected2) {
        int controlX;
        if (c == null) {
            CompactPainter.$$$reportNull$$$0(2);
        }
        if (g == null) {
            CompactPainter.$$$reportNull$$$0(3);
        }
        if (control2 == null) {
            CompactPainter.$$$reportNull$$$0(4);
        }
        if (depth <= 0) {
            return;
        }
        boolean paintLines = this.getPaintLines();
        if (!paintLines && leaf) {
            return;
        }
        int controlWidth = control2.getWidth();
        int left = this.getLeftIndent();
        int indent = left + JBUIScale.scale((int)2);
        int n = controlX = !leaf && depth > 1 ? (depth - 1) * indent + x : (x += left);
        if (paintLines && (depth != 1 || !leaf && expanded2)) {
            int offset;
            g.setColor((Color)LINE_COLOR);
            x += JBUIScale.scale((int)1);
            while (--depth > 0) {
                g.drawLine(x, y, x, y + height);
                x += indent;
            }
            if (!leaf && expanded2 && (offset = height / 2 - control2.getIcon(expanded2, selected2).getIconHeight() / 4) > 0) {
                g.drawLine(x, y + height - offset, x, y + height);
            }
        }
        if (leaf) {
            return;
        }
        control2.paint(c, g, controlX, y, controlWidth, height, expanded2, selected2);
    }

    private boolean getPaintLines() {
        return ClassicPainter.getPaintLines(this.myPaintLines);
    }

    private int getLeftIndent() {
        return this.myLeftIndent == null ? 0 : Math.max(0, JBUIScale.scale((int)this.myLeftIndent));
    }

    private int getRightIndent() {
        return this.myRightIndent == null ? 0 : Math.max(0, JBUIScale.scale((int)this.myRightIndent));
    }

    private int getLeafIndent(boolean leaf) {
        return !leaf || this.myLeafIndent == null ? -1 : JBUIScale.scale((int)this.myLeafIndent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tree/ui/CompactPainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRendererOffset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getControlOffset";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

